/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSpliterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.IntConsumer;

public class IntArraySet
extends AbstractIntSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected transient int[] a;
    protected int size;

    /*
     * WARNING - void declaration
     */
    public IntArraySet(int[] a2) {
        void var1_1;
        this.a = a2;
        this.size = ((void)var1_1).length;
    }

    public IntArraySet() {
        this.a = IntArrays.EMPTY_ARRAY;
    }

    /*
     * WARNING - void declaration
     */
    public IntArraySet(int capacity) {
        void var1_1;
        this.a = new int[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public IntArraySet(IntCollection c2) {
        this(c2.size());
        void var1_1;
        this.addAll((IntCollection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public IntArraySet(Collection<? extends Integer> c2) {
        this(c2.size());
        void var1_1;
        ((AbstractCollection)this).addAll(var1_1);
    }

    public IntArraySet(IntSet c2) {
        this(c2.size());
        IntIterator intIterator;
        int n2 = 0;
        intIterator = intIterator.iterator();
        while (intIterator.hasNext()) {
            int n3;
            this.a[n2] = n3 = ((Number)((Integer)intIterator.next())).intValue();
            ++n2;
        }
        this.size = n2;
    }

    public IntArraySet(Set<? extends Integer> c2) {
        this(c2.size());
        Iterator iterator2;
        int n2 = 0;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            Integer n3 = (Integer)iterator2.next();
            this.a[n2] = n3;
            ++n2;
        }
        this.size = n2;
    }

    /*
     * WARNING - void declaration
     */
    public IntArraySet(int[] a2, int size) {
        this.a = a2;
        this.size = size;
        if (size > a2.length) {
            void var1_1;
            void var2_2;
            throw new IllegalArgumentException("The provided size (" + (int)var2_2 + ") is larger than or equal to the array size (" + ((void)var1_1).length + ")");
        }
    }

    public static IntArraySet of() {
        return IntArraySet.ofUnchecked();
    }

    public static IntArraySet of(int e2) {
        int n2;
        return IntArraySet.ofUnchecked(n2);
    }

    public static IntArraySet of(int ... a2) {
        int[] nArray;
        if (a2.length == 2) {
            if (a2[0] == a2[1]) {
                throw new IllegalArgumentException("Duplicate element: " + a2[1]);
            }
        } else if (a2.length > 2) {
            IntOpenHashSet.of(a2);
        }
        return IntArraySet.ofUnchecked(nArray);
    }

    public static IntArraySet ofUnchecked() {
        return new IntArraySet();
    }

    public static IntArraySet ofUnchecked(int ... a2) {
        int[] nArray;
        return new IntArraySet(nArray);
    }

    private int a(int n2) {
        int n3 = this.size;
        while (n3-- != 0) {
            if (this.a[n3] != n2) continue;
            return n3;
        }
        return -1;
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(this){
            private int a = 0;
            private /* synthetic */ IntArraySet b;
            {
                this.b = intArraySet;
            }

            @Override
            public final boolean hasNext() {
                return this.a < this.b.size;
            }

            @Override
            public final int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.b.a[this.a++];
            }

            @Override
            public final void remove() {
                int n2 = this.b.size-- - this.a--;
                System.arraycopy(this.b.a, this.a + 1, this.b.a, this.a, n2);
            }
        };
    }

    @Override
    public IntSpliterator spliterator() {
        return new a(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(int k2) {
        void var1_1;
        return this.a((int)var1_1) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(int k2) {
        int n2;
        if ((n2 = this.a(n2)) == -1) {
            return false;
        }
        int n3 = this.size - n2 - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.a[n2 + i2] = this.a[n2 + i2 + 1];
        }
        --this.size;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(int k2) {
        void var1_1;
        if (this.a(k2) != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            int[] nArray = new int[this.size == 0 ? 2 : this.size << 1];
            int n2 = this.size;
            while (n2-- != 0) {
                nArray[n2] = this.a[n2];
            }
            this.a = nArray;
        }
        this.a[this.size++] = var1_1;
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int[] toIntArray() {
        if (this.size == 0) {
            return IntArrays.EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.a, this.size);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray(int[] a2) {
        void var1_1;
        if (a2 == null || a2.length < this.size) {
            a2 = new int[this.size];
        }
        System.arraycopy(this.a, 0, a2, 0, this.size);
        return var1_1;
    }

    public IntArraySet clone() {
        IntArraySet intArraySet;
        try {
            intArraySet = (IntArraySet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        intArraySet.a = (int[])this.a.clone();
        return intArraySet;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeInt(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = new int[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s2.readInt();
        }
    }

    final class a
    implements IntSpliterator {
        private boolean a = false;
        private int b;
        private int c;
        private /* synthetic */ IntArraySet e;

        public a(IntArraySet intArraySet) {
            this(intArraySet, 0, intArraySet.size, false);
        }

        private a(IntArraySet intArraySet, int n2, int n3, boolean bl2) {
            this.e = intArraySet;
            assert (n2 <= n3) : "pos " + n2 + " must be <= max " + n3;
            this.b = n2;
            this.c = n3;
            this.a = bl2;
        }

        private int c() {
            if (this.a) {
                return this.c;
            }
            return this.e.size;
        }

        @Override
        public final int characteristics() {
            return 16721;
        }

        @Override
        public final long estimateSize() {
            return this.c() - this.b;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean tryAdvance(IntConsumer action) {
            void var1_1;
            if (this.b >= this.c()) {
                return false;
            }
            var1_1.accept(this.e.a[this.b++]);
            return true;
        }

        @Override
        public final void forEachRemaining(IntConsumer action) {
            int n2 = this.c();
            while (this.b < n2) {
                action.accept(this.e.a[this.b]);
                ++this.b;
            }
        }

        @Override
        public final IntSpliterator m_() {
            int n2 = this.c();
            int n3 = n2 - this.b >> 1;
            if (n3 <= 1) {
                return null;
            }
            this.c = n2;
            n3 = n2 = this.b + n3;
            int n4 = this.b;
            this.b = n2;
            this.a = true;
            return new a(this.e, n4, n3, true);
        }

        @Override
        public final /* synthetic */ Spliterator.OfInt trySplit() {
            return this.m_();
        }

        @Override
        public final /* synthetic */ Spliterator.OfPrimitive trySplit() {
            return this.m_();
        }

        @Override
        public final /* synthetic */ Spliterator trySplit() {
            return this.m_();
        }
    }
}

