/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.util.List;
import org.jdom.Content;
import org.jdom.Verifier;
import org.jdom.output.AbstractFormattedWalker;
import org.jdom.output.FormatStack;

final class WalkerNORMALIZE
extends AbstractFormattedWalker {
    WalkerNORMALIZE(List<? extends Content> content, FormatStack fstack, boolean escape) {
        super(content, fstack, escape);
    }

    private static boolean isSpaceFirst(String text) {
        if (!text.isEmpty()) {
            return Verifier.isXMLWhitespace(text.charAt(0));
        }
        return false;
    }

    private static boolean isSpaceLast(String text) {
        int tlen = text.length();
        return tlen > 0 && Verifier.isXMLWhitespace(text.charAt(tlen - 1));
    }

    @Override
    protected void analyzeMultiText(AbstractFormattedWalker.MultiText mtext, int offset, int len) {
        boolean needspace = false;
        boolean between = false;
        block4: for (int i2 = 0; i2 < len; ++i2) {
            Content c2 = this.get(offset + i2);
            switch (c2.getCType()) {
                case Text: {
                    String ttext = c2.getValue();
                    if (Verifier.isAllXMLWhitespace(ttext)) {
                        if (!between || ttext.isEmpty()) continue block4;
                        needspace = true;
                        continue block4;
                    }
                    if (between && (needspace || WalkerNORMALIZE.isSpaceFirst(ttext))) {
                        mtext.appendText(AbstractFormattedWalker.Trim.NONE, " ");
                    }
                    mtext.appendText(AbstractFormattedWalker.Trim.COMPACT, ttext);
                    between = true;
                    needspace = WalkerNORMALIZE.isSpaceLast(ttext);
                    continue block4;
                }
                case CDATA: {
                    String ttext = c2.getValue();
                    if (Verifier.isAllXMLWhitespace(ttext)) {
                        if (!between || ttext.isEmpty()) continue block4;
                        needspace = true;
                        continue block4;
                    }
                    if (between && (needspace || WalkerNORMALIZE.isSpaceFirst(ttext))) {
                        mtext.appendText(AbstractFormattedWalker.Trim.NONE, " ");
                    }
                    mtext.appendCDATA(AbstractFormattedWalker.Trim.COMPACT, ttext);
                    between = true;
                    needspace = WalkerNORMALIZE.isSpaceLast(ttext);
                    continue block4;
                }
                default: {
                    if (between && needspace) {
                        mtext.appendText(AbstractFormattedWalker.Trim.NONE, " ");
                    }
                    mtext.appendRaw(c2);
                    between = true;
                    needspace = false;
                }
            }
        }
    }
}

