/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.network.service;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.stats.completion.logger.LineStorage;
import com.intellij.stats.completion.network.service.RequestService;
import com.intellij.stats.completion.network.service.ResponseData;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001d\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\u000f\u001a\u00020\r*\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/stats/completion/network/service/SimpleRequestService;", "Lcom/intellij/stats/completion/network/service/RequestService;", "()V", "get", "Lcom/intellij/stats/completion/network/service/ResponseData;", "url", "", "postZipped", "file", "Ljava/io/File;", "asResponseData", "Ljava/net/URLConnection;", "sentDataSize", "", "(Ljava/net/URLConnection;Ljava/lang/Integer;)Lcom/intellij/stats/completion/network/service/ResponseData;", "getResponseCode", "Lcom/intellij/util/io/HttpRequests$Request;", "Companion", "intellij.statsCollector"})
@SourceDebugExtension(value={"SMAP\nSimpleRequestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleRequestService.kt\ncom/intellij/stats/completion/network/service/SimpleRequestService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,84:1\n11#2:85\n*S KotlinDebug\n*F\n+ 1 SimpleRequestService.kt\ncom/intellij/stats/completion/network/service/SimpleRequestService\n*L\n18#1:85\n*E\n"})
public final class SimpleRequestService
extends RequestService {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    @Nullable
    public ResponseData postZipped(@NotNull String url, @NotNull File file) {
        ResponseData responseData;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            byte[] zippedArray = LineStorage.Companion.readAsZipArray(file);
            return (ResponseData)HttpRequests.post((String)url, (String)"application/json").tuner(arg_0 -> SimpleRequestService.postZipped$lambda$0(zippedArray, arg_0)).connect(arg_0 -> SimpleRequestService.postZipped$lambda$1(zippedArray, this, arg_0));
        }
        catch (HttpRequests.HttpStatusException e) {
            int n = e.getStatusCode();
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            responseData = new ResponseData(n, string, null, 4, null);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            responseData = null;
        }
        return responseData;
    }

    @Override
    @Nullable
    public ResponseData get(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            RequestBuilder requestBuilder = HttpRequests.request((String)url);
            return (ResponseData)requestBuilder.connect(arg_0 -> SimpleRequestService.get$lambda$2(this, arg_0));
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            ResponseData responseData = null;
            return responseData;
        }
    }

    private final ResponseData asResponseData(URLConnection $this$asResponseData, Integer sentDataSize) {
        if ($this$asResponseData instanceof HttpURLConnection) {
            int n = ((HttpURLConnection)$this$asResponseData).getResponseCode();
            String string = StringUtil.notNullize((String)((HttpURLConnection)$this$asResponseData).getResponseMessage(), (String)"");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"notNullize(...)");
            return new ResponseData(n, string, sentDataSize);
        }
        LOG.error("Could not get code and message from http response");
        return null;
    }

    private final int getResponseCode(HttpRequests.Request $this$getResponseCode) {
        URLConnection uRLConnection = $this$getResponseCode.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"getConnection(...)");
        URLConnection connection = uRLConnection;
        if (connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)connection).getResponseCode();
        }
        if (Intrinsics.areEqual((Object)connection.getURL().getProtocol(), (Object)"file")) {
            return 200;
        }
        LOG.error("Could not get code from http response");
        return -1;
    }

    private static final void postZipped$lambda$0(byte[] $zippedArray, URLConnection it) {
        Intrinsics.checkNotNullParameter((Object)$zippedArray, (String)"$zippedArray");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setRequestProperty("Content-Encoding", "gzip");
        it.setRequestProperty("Content-Length", String.valueOf($zippedArray.length));
        it.setRequestProperty("User-Agent", ApplicationInfo.getInstance().getFullApplicationName());
    }

    private static final ResponseData postZipped$lambda$1(byte[] $zippedArray, SimpleRequestService this$0, HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)$zippedArray, (String)"$zippedArray");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        request.write($zippedArray);
        URLConnection uRLConnection = request.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"getConnection(...)");
        return this$0.asResponseData(uRLConnection, $zippedArray.length);
    }

    private static final ResponseData get$lambda$2(SimpleRequestService this$0, HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        int responseCode = this$0.getResponseCode(request);
        String string = request.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String responseText = string;
        return new ResponseData(responseCode, responseText, null, 4, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SimpleRequestService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/stats/completion/network/service/SimpleRequestService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.statsCollector"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

