/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.network.status;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.stats.completion.network.UtilsKt;
import com.intellij.stats.completion.network.service.RequestService;
import com.intellij.stats.completion.network.service.ResponseData;
import com.intellij.stats.completion.network.status.WebServiceStatus;
import com.intellij.stats.completion.network.status.bean.JetStatSettings;
import com.intellij.stats.completion.network.status.bean.JetStatSettingsDeserializer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/stats/completion/network/status/JetStatServiceStatus;", "Lcom/intellij/stats/completion/network/status/WebServiceStatus;", "()V", "dataServerUrl", "", "id", "getId", "()Ljava/lang/String;", "requestService", "Lcom/intellij/stats/completion/network/service/RequestService;", "serverStatus", "isServerOk", "", "update", "", "Companion", "intellij.statsCollector"})
@SourceDebugExtension(value={"SMAP\nJetStatServiceStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetStatServiceStatus.kt\ncom/intellij/stats/completion/network/status/JetStatServiceStatus\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,40:1\n43#2,3:41\n*S KotlinDebug\n*F\n+ 1 JetStatServiceStatus.kt\ncom/intellij/stats/completion/network/status/JetStatServiceStatus\n*L\n19#1:41,3\n*E\n"})
public class JetStatServiceStatus
implements WebServiceStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile String serverStatus = "";
    @NotNull
    private volatile String dataServerUrl = "";
    @NotNull
    private final RequestService requestService;
    @NotNull
    private final String id;
    @NotNull
    private static final String STATUS_URL = "https://www.jetbrains.com/config/features-service-status.json";

    public JetStatServiceStatus() {
        boolean $i$f$service = false;
        Class<RequestService> serviceClass$iv = RequestService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        this.requestService = (RequestService)object;
        this.id = "JetStat";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String dataServerUrl() {
        return this.dataServerUrl;
    }

    @Override
    public boolean isServerOk() {
        return StringsKt.equals((String)this.serverStatus, (String)"ok", (boolean)true);
    }

    @Override
    public void update() {
        this.serverStatus = "";
        this.dataServerUrl = "";
        UtilsKt.assertNotEDT();
        ResponseData response = this.requestService.get(STATUS_URL);
        if (response != null && response.isOK()) {
            JetStatSettings jetStatSettings = JetStatSettingsDeserializer.INSTANCE.deserialize(response.getText());
            if (jetStatSettings == null) {
                return;
            }
            JetStatSettings settings = jetStatSettings;
            this.serverStatus = settings.getStatus();
            this.dataServerUrl = settings.getUrlForZipBase64Content();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/stats/completion/network/status/JetStatServiceStatus$Companion;", "", "()V", "STATUS_URL", "", "intellij.statsCollector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

