/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.tracker;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupUsageTracker;
import com.intellij.completion.ml.experiment.ExperimentInfo;
import com.intellij.completion.ml.storage.LookupStorage;
import com.intellij.completion.ml.util.LookupExtensionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.stats.completion.tracker.CompletionActionsListener;
import com.intellij.stats.completion.tracker.CompletionLogger;
import com.intellij.stats.completion.tracker.DeferredLog;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u0013H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/stats/completion/tracker/CompletionActionsTracker;", "Lcom/intellij/stats/completion/tracker/CompletionActionsListener;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "lookupStorage", "Lcom/intellij/completion/ml/storage/LookupStorage;", "logger", "Lcom/intellij/stats/completion/tracker/CompletionLogger;", "experimentInfo", "Lcom/intellij/completion/ml/experiment/ExperimentInfo;", "(Lcom/intellij/codeInsight/lookup/impl/LookupImpl;Lcom/intellij/completion/ml/storage/LookupStorage;Lcom/intellij/stats/completion/tracker/CompletionLogger;Lcom/intellij/completion/ml/experiment/ExperimentInfo;)V", "completionStarted", "", "deferredLog", "Lcom/intellij/stats/completion/tracker/DeferredLog;", "prefixLength", "", "selectedByDotTyping", "afterAppend", "", "c", "", "afterBackspacePressed", "beforeBackspacePressed", "beforeCharTyped", "beforeDownPressed", "beforeUpPressed", "currentItemChanged", "event", "Lcom/intellij/codeInsight/lookup/LookupEvent;", "downPressed", "isCompletionActive", "itemSelected", "lookupCanceled", "upPressed", "intellij.statsCollector"})
public final class CompletionActionsTracker
implements CompletionActionsListener {
    @NotNull
    private final LookupImpl lookup;
    @NotNull
    private final LookupStorage lookupStorage;
    @NotNull
    private final CompletionLogger logger;
    @NotNull
    private final ExperimentInfo experimentInfo;
    private boolean completionStarted;
    private boolean selectedByDotTyping;
    private int prefixLength;
    @NotNull
    private final DeferredLog deferredLog;

    public CompletionActionsTracker(@NotNull LookupImpl lookup, @NotNull LookupStorage lookupStorage, @NotNull CompletionLogger logger, @NotNull ExperimentInfo experimentInfo) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)experimentInfo, (String)"experimentInfo");
        this.lookup = lookup;
        this.lookupStorage = lookupStorage;
        this.logger = logger;
        this.experimentInfo = experimentInfo;
        this.deferredLog = new DeferredLog();
    }

    private final boolean isCompletionActive() {
        return this.completionStarted && !this.lookup.isLookupDisposed() || ApplicationManager.getApplication().isUnitTestMode();
    }

    public void lookupCanceled(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.completionStarted) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        LookupElement currentItem = this.lookup.getCurrentItem();
        Map performance = this.lookupStorage.getPerformanceTracker().measurements();
        if (currentItem != null && LookupUsageTracker.isSelectedByTyping((LookupImpl)this.lookup, (LookupElement)currentItem) || this.selectedByDotTyping) {
            this.logger.itemSelectedByTyping(this.lookup, performance, timestamp);
        } else {
            this.logger.completionCancelled(event.isCanceledExplicitly(), performance, timestamp);
        }
    }

    public void currentItemChanged(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.completionStarted) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.completionStarted = true;
        this.prefixLength = LookupExtensionsKt.prefix((Lookup)((Lookup)this.lookup)).length();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ long $timestamp;
            {
                this.this$0 = $receiver;
                this.$timestamp = $timestamp;
                super(0);
            }

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).completionStarted(CompletionActionsTracker.access$getLookup$p(this.this$0), CompletionActionsTracker.access$getPrefixLength$p(this.this$0), CompletionActionsTracker.access$getExperimentInfo$p(this.this$0).getInExperiment(), CompletionActionsTracker.access$getExperimentInfo$p(this.this$0).getVersion(), this.$timestamp);
            }
        }));
    }

    public void itemSelected(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.completionStarted) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        LookupElement currentItem = this.lookup.getCurrentItem();
        Map performance = this.lookupStorage.getPerformanceTracker().measurements();
        if (currentItem != null && LookupUsageTracker.isSelectedByTyping((LookupImpl)this.lookup, (LookupElement)currentItem)) {
            this.logger.itemSelectedByTyping(this.lookup, performance, timestamp);
        } else {
            this.logger.itemSelectedCompletionFinished(this.lookup, event.getCompletionChar(), performance, timestamp);
        }
    }

    @Override
    public void beforeDownPressed() {
        this.deferredLog.log();
    }

    @Override
    public void downPressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ long $timestamp;
            {
                this.this$0 = $receiver;
                this.$timestamp = $timestamp;
                super(0);
            }

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).downPressed(CompletionActionsTracker.access$getLookup$p(this.this$0), this.$timestamp);
            }
        }));
    }

    @Override
    public void beforeUpPressed() {
        this.deferredLog.log();
    }

    @Override
    public void upPressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ long $timestamp;
            {
                this.this$0 = $receiver;
                this.$timestamp = $timestamp;
                super(0);
            }

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).upPressed(CompletionActionsTracker.access$getLookup$p(this.this$0), this.$timestamp);
            }
        }));
    }

    @Override
    public void beforeBackspacePressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        this.deferredLog.log();
    }

    @Override
    public void afterBackspacePressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        int n = this.prefixLength;
        this.prefixLength = n + -1;
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ long $timestamp;
            {
                this.this$0 = $receiver;
                this.$timestamp = $timestamp;
                super(0);
            }

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).afterBackspacePressed(CompletionActionsTracker.access$getLookup$p(this.this$0), CompletionActionsTracker.access$getPrefixLength$p(this.this$0), this.$timestamp);
            }
        }));
    }

    @Override
    public void beforeCharTyped(char c) {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        if (c == '.') {
            LookupElement item = this.lookup.getCurrentItem();
            if (item == null) {
                this.logger.customMessage("Before typed " + c + " lookup.currentItem is null; lookup size: " + this.lookup.getItems().size(), timestamp);
                return;
            }
            String string = this.lookup.itemPattern(item);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemPattern(...)");
            String text = string;
            if (Intrinsics.areEqual((Object)item.getLookupString(), (Object)text)) {
                this.selectedByDotTyping = true;
            }
        }
    }

    public void afterAppend(char c) {
        if (!this.isCompletionActive() || !Character.isJavaIdentifierPart(c)) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        int n = this.prefixLength;
        this.prefixLength = n + 1;
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, c, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ char $c;
            final /* synthetic */ long $timestamp;
            {
                this.this$0 = $receiver;
                this.$c = $c;
                this.$timestamp = $timestamp;
                super(0);
            }

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).afterCharTyped(this.$c, CompletionActionsTracker.access$getLookup$p(this.this$0), CompletionActionsTracker.access$getPrefixLength$p(this.this$0), this.$timestamp);
            }
        }));
    }

    public static final /* synthetic */ CompletionLogger access$getLogger$p(CompletionActionsTracker $this) {
        return $this.logger;
    }

    public static final /* synthetic */ LookupImpl access$getLookup$p(CompletionActionsTracker $this) {
        return $this.lookup;
    }

    public static final /* synthetic */ int access$getPrefixLength$p(CompletionActionsTracker $this) {
        return $this.prefixLength;
    }

    public static final /* synthetic */ ExperimentInfo access$getExperimentInfo$p(CompletionActionsTracker $this) {
        return $this.experimentInfo;
    }
}

