/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.tracker;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.settings.CompletionMLRankingSettings;
import com.intellij.completion.ml.storage.LookupStorage;
import com.intellij.completion.ml.util.CompletionUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.stats.completion.LookupState;
import com.intellij.stats.completion.events.BackspaceEvent;
import com.intellij.stats.completion.events.CompletionCancelledEvent;
import com.intellij.stats.completion.events.CompletionStartedEvent;
import com.intellij.stats.completion.events.CustomMessageEvent;
import com.intellij.stats.completion.events.DownPressedEvent;
import com.intellij.stats.completion.events.ExplicitSelectEvent;
import com.intellij.stats.completion.events.TypeEvent;
import com.intellij.stats.completion.events.TypedSelectEvent;
import com.intellij.stats.completion.events.UpPressedEvent;
import com.intellij.stats.completion.tracker.CompletionEventLogger;
import com.intellij.stats.completion.tracker.CompletionFileLogger;
import com.intellij.stats.completion.tracker.CompletionLogger;
import com.intellij.stats.completion.tracker.CompletionLoggerImplKt;
import com.intellij.stats.completion.tracker.LookupStateManager;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u000b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J(\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J,\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\b2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J0\u0010$\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010)\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J,\u0010*\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J4\u0010+\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010-\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\f\u001a\f0\u0003\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/stats/completion/tracker/CompletionFileLogger;", "Lcom/intellij/stats/completion/tracker/CompletionLogger;", "installationUID", "", "completionUID", "bucket", "languageName", "shouldLogElementFeatures", "", "eventLogger", "Lcom/intellij/stats/completion/tracker/CompletionEventLogger;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/intellij/stats/completion/tracker/CompletionEventLogger;)V", "ideVersion", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getIdeVersion", "()Ljava/lang/String;", "ideVersion$delegate", "Lkotlin/Lazy;", "stateManager", "Lcom/intellij/stats/completion/tracker/LookupStateManager;", "afterBackspacePressed", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "prefixLength", "", "timestamp", "", "afterCharTyped", "c", "", "completionCancelled", "explicitly", "performance", "", "completionStarted", "isExperimentPerformed", "experimentVersion", "customMessage", "message", "downPressed", "itemSelectedByTyping", "itemSelectedCompletionFinished", "completionChar", "upPressed", "intellij.statsCollector"})
public final class CompletionFileLogger
extends CompletionLogger {
    @NotNull
    private final String installationUID;
    @NotNull
    private final String completionUID;
    @NotNull
    private final String bucket;
    @NotNull
    private final String languageName;
    private final boolean shouldLogElementFeatures;
    @NotNull
    private final CompletionEventLogger eventLogger;
    @NotNull
    private final LookupStateManager stateManager;
    @NotNull
    private final Lazy ideVersion$delegate;

    public CompletionFileLogger(@NotNull String installationUID, @NotNull String completionUID, @NotNull String bucket, @NotNull String languageName, boolean shouldLogElementFeatures, @NotNull CompletionEventLogger eventLogger) {
        Intrinsics.checkNotNullParameter((Object)installationUID, (String)"installationUID");
        Intrinsics.checkNotNullParameter((Object)completionUID, (String)"completionUID");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)languageName, (String)"languageName");
        Intrinsics.checkNotNullParameter((Object)eventLogger, (String)"eventLogger");
        this.installationUID = installationUID;
        this.completionUID = completionUID;
        this.bucket = bucket;
        this.languageName = languageName;
        this.shouldLogElementFeatures = shouldLogElementFeatures;
        this.eventLogger = eventLogger;
        this.stateManager = new LookupStateManager(this.shouldLogElementFeatures);
        this.ideVersion$delegate = LazyKt.lazy((Function0)ideVersion.2.INSTANCE);
    }

    private final String getIdeVersion() {
        Lazy lazy = this.ideVersion$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public void completionStarted(@NotNull LookupImpl lookup, int prefixLength, boolean isExperimentPerformed, int experimentVersion, long timestamp) {
        Object object;
        Object userFactors;
        Object object2;
        Object mlRankingVersion;
        Object object3;
        String pluginVersion;
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, false);
        LookupStorage lookupStorage = LookupStorage.Companion.get(lookup);
        String string = CompletionLoggerImplKt.access$calcPluginVersion();
        if (string == null) {
            string = pluginVersion = "pluginVersion";
        }
        if ((object3 = lookupStorage) == null || (object3 = object3.getModel()) == null || (object3 = object3.version()) == null) {
            object3 = mlRankingVersion = "NONE";
        }
        if ((object2 = lookupStorage) == null || (object2 = object2.getUserFactors()) == null) {
            object2 = userFactors = MapsKt.emptyMap();
        }
        if ((object = lookupStorage) == null || (object = object.getContextFactors()) == null) {
            object = MapsKt.emptyMap();
        }
        Object contextFactors = object;
        String string2 = this.getIdeVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ideVersion>(...)");
        LookupStorage lookupStorage2 = lookupStorage;
        CompletionStartedEvent event = new CompletionStartedEvent(string2, pluginVersion, (String)mlRankingVersion, this.installationUID, this.completionUID, this.languageName, isExperimentPerformed, experimentVersion, state, (Map<String, String>)userFactors, (Map<String, String>)contextFactors, prefixLength, this.bucket, lookupStorage2 != null ? lookupStorage2.getStartedTimestamp() : timestamp);
        Long shownTimestamp = CompletionUtil.INSTANCE.getShownTimestamp(lookup);
        if (shownTimestamp != null) {
            event.lookupShownTime = shownTimestamp;
        }
        event.isOneLineMode = lookup.getEditor().isOneLineMode();
        CompletionParameters completionParameters = CompletionUtil.INSTANCE.getCurrentCompletionParameters();
        event.isAutoPopup = completionParameters != null ? Boolean.valueOf(completionParameters.isAutoPopup()) : null;
        CompletionLoggerImplKt.access$fillCompletionParameters(event);
        event.additionalDetails.put("alphabetical", String.valueOf(UISettings.Companion.getInstance().getSortLookupElementsLexicographically()));
        event.additionalDetails.put("all_features_logged", String.valueOf(this.shouldLogElementFeatures));
        if (lookupStorage != null && lookupStorage.mlUsed() && CompletionMLRankingSettings.getInstance().isShowDiffEnabled()) {
            event.additionalDetails.put("diff", "1");
        }
        this.eventLogger.log(event);
    }

    @Override
    public void customMessage(@NotNull String message, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CustomMessageEvent event = new CustomMessageEvent(this.installationUID, this.completionUID, message, this.bucket, timestamp, this.languageName);
        this.eventLogger.log(event);
    }

    @Override
    public void afterCharTyped(char c, @NotNull LookupImpl lookup, int prefixLength, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, true);
        TypeEvent event = new TypeEvent(this.installationUID, this.completionUID, state, prefixLength, this.bucket, timestamp, this.languageName);
        CompletionLoggerImplKt.access$fillCompletionParameters(event);
        this.eventLogger.log(event);
    }

    @Override
    public void downPressed(@NotNull LookupImpl lookup, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, false);
        DownPressedEvent event = new DownPressedEvent(this.installationUID, this.completionUID, state, this.bucket, timestamp, this.languageName);
        CompletionLoggerImplKt.access$fillCompletionParameters(event);
        this.eventLogger.log(event);
    }

    @Override
    public void upPressed(@NotNull LookupImpl lookup, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, false);
        UpPressedEvent event = new UpPressedEvent(this.installationUID, this.completionUID, state, this.bucket, timestamp, this.languageName);
        CompletionLoggerImplKt.access$fillCompletionParameters(event);
        this.eventLogger.log(event);
    }

    @Override
    public void completionCancelled(boolean explicitly, @NotNull Map<String, Long> performance, long timestamp) {
        Intrinsics.checkNotNullParameter(performance, (String)"performance");
        CompletionCancelledEvent event = new CompletionCancelledEvent(this.installationUID, this.completionUID, performance, explicitly, this.bucket, timestamp, this.languageName);
        this.eventLogger.log(event);
    }

    @Override
    public void itemSelectedByTyping(@NotNull LookupImpl lookup, @NotNull Map<String, Long> performance, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter(performance, (String)"performance");
        LookupState state = this.stateManager.update(lookup, true);
        TypedSelectEvent event = new TypedSelectEvent(this.installationUID, this.completionUID, state, CompletionLoggerImplKt.access$getSelectedId(state), performance, this.bucket, timestamp, this.languageName);
        CompletionLoggerImplKt.access$fillCompletionParameters(event);
        if (state.getIds().isEmpty()) {
            CompletionLoggerImplKt.access$getLOG$p().error("Invalid state of lookup. Selected item [exists: " + (lookup.getCurrentItem() != null) + "], but items list is empty.");
        }
        this.eventLogger.log(event);
    }

    @Override
    public void itemSelectedCompletionFinished(@NotNull LookupImpl lookup, char completionChar, @NotNull Map<String, Long> performance, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter(performance, (String)"performance");
        LookupState state = this.stateManager.update(lookup, true);
        ExplicitSelectEvent event = new ExplicitSelectEvent(this.installationUID, this.completionUID, state, CompletionLoggerImplKt.access$getSelectedId(state), performance, completionChar, this.bucket, timestamp, this.languageName);
        CompletionLoggerImplKt.access$fillCompletionParameters(event);
        this.eventLogger.log(event);
    }

    @Override
    public void afterBackspacePressed(@NotNull LookupImpl lookup, int prefixLength, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, true);
        BackspaceEvent event = new BackspaceEvent(this.installationUID, this.completionUID, state, prefixLength, this.bucket, timestamp, this.languageName);
        CompletionLoggerImplKt.access$fillCompletionParameters(event);
        this.eventLogger.log(event);
    }
}

