/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ComponentDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.util.IteratorUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.java.JavaLibraryDependency;
import com.intellij.packageChecker.java.JavaPackageUtilKt;
import com.intellij.packageChecker.model.LibraryDependency;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.PackageType;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u001a \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000e0\u000b2\u0006\u0010\u0014\u001a\u00020\u0015\u001a^\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000e0\u000b\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u000e2\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u0002H\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00192\u001a\u0010\u001a\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u000e0\u0019\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u0013*\u00020\u001c\u001a\f\u0010\u001d\u001a\u0004\u0018\u00010\u0013*\u00020\u001e\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020!2\u0006\u0010\"\u001a\u00020\t\u001a\u0014\u0010#\u001a\u0004\u0018\u00010 *\u00020!2\u0006\u0010$\u001a\u00020\t\u001a\u000e\u0010%\u001a\u0004\u0018\u00010\u0013*\u00020\u001eH\u0002\u001a\u000e\u0010&\u001a\u0004\u0018\u00010\u0013*\u00020\u001eH\u0002\u001a\u000e\u0010'\u001a\u0004\u0018\u00010\u0013*\u00020\u001eH\u0002\u001a\u0014\u0010(\u001a\u0004\u0018\u00010!*\u00020)2\u0006\u0010*\u001a\u00020\u0013\u001a\f\u0010+\u001a\u0004\u0018\u00010\u0013*\u00020,\u001a\f\u0010-\u001a\u0004\u0018\u00010.*\u00020/\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"BUNDLE_NAME", "Ljava/util/jar/Attributes$Name;", "getBUNDLE_NAME", "()Ljava/util/jar/Attributes$Name;", "BUNDLE_SYMBOLIC_NAME", "getBUNDLE_SYMBOLIC_NAME", "BUNDLE_VERSION", "getBUNDLE_VERSION", "loggerCategory", "", "packageTypes", "", "Lorg/jetbrains/security/package/PackageType;", "javaLibraryDependencies", "", "Lcom/intellij/packageChecker/model/LibraryDependency;", "module", "Lcom/intellij/openapi/module/Module;", "rootDependencies", "Lorg/jetbrains/security/package/Package;", "projectDependencies", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/ProjectDependencies;", "T", "rootNodes", "pkgMapper", "Lkotlin/Function1;", "getChildren", "createMavenPackage", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/DependencyNode;", "createPackage", "Lcom/intellij/openapi/roots/libraries/Library;", "findByFqn", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/openapi/module/impl/scopes/LibraryScope;", "fqnName", "findByShortName", "shortName", "getPackageFromLibraryDescriptor", "getPackageFromLibraryManifest", "getPackageFromLibraryName", "libraryScope", "Lcom/intellij/openapi/project/Project;", "pkg", "toPackage", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "toPackageDeclaration", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "Lcom/intellij/buildsystem/model/DeclaredDependency;", "intellij.packageChecker.java"})
@SourceDebugExtension(value={"SMAP\njavaPackageUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 javaPackageUtil.kt\ncom/intellij/packageChecker/java/JavaPackageUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,224:1\n1360#2:225\n1446#2,5:226\n372#3,7:231\n*S KotlinDebug\n*F\n+ 1 javaPackageUtil.kt\ncom/intellij/packageChecker/java/JavaPackageUtilKt\n*L\n60#1:225\n60#1:226,5\n91#1:231,7\n*E\n"})
public final class JavaPackageUtilKt {
    @NotNull
    private static final String loggerCategory = "org.jetbrains.security.dependencies.calculator";
    @NotNull
    private static final Map<String, PackageType> packageTypes;

    @Nullable
    public static final Package toPackage(@NotNull UnifiedDependency $this$toPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$toPackage, (String)"<this>");
        String string = $this$toPackage.getCoordinates().getArtifactId();
        if (string == null) {
            return null;
        }
        String name = string;
        String string2 = $this$toPackage.getCoordinates().getVersion();
        if (string2 == null) {
            return null;
        }
        String version = string2;
        return new Package(PackageType.maven, $this$toPackage.getCoordinates().getGroupId(), name, version, null, null, null, 112, null);
    }

    @Nullable
    public static final PackageDeclaration toPackageDeclaration(@NotNull DeclaredDependency $this$toPackageDeclaration) {
        Intrinsics.checkNotNullParameter((Object)$this$toPackageDeclaration, (String)"<this>");
        Package package_ = JavaPackageUtilKt.toPackage($this$toPackageDeclaration.getUnifiedDependency());
        if (package_ == null) {
            return null;
        }
        Package pkg = package_;
        return new PackageDeclaration(pkg, $this$toPackageDeclaration.getPsiElement(), null, 4, null);
    }

    @Nullable
    public static final PsiClass findByFqn(@NotNull LibraryScope $this$findByFqn, @NotNull String fqnName) {
        Intrinsics.checkNotNullParameter((Object)$this$findByFqn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fqnName, (String)"fqnName");
        Project project = $this$findByFqn.getProject();
        Intrinsics.checkNotNull((Object)project);
        return JavaPsiFacade.getInstance((Project)project).findClass(fqnName, (GlobalSearchScope)$this$findByFqn);
    }

    @Nullable
    public static final PsiClass findByShortName(@NotNull LibraryScope $this$findByShortName, @NotNull String shortName) {
        Intrinsics.checkNotNullParameter((Object)$this$findByShortName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        Project project = $this$findByShortName.getProject();
        Intrinsics.checkNotNull((Object)project);
        PsiClass[] psiClassArray = PsiShortNamesCache.getInstance((Project)project).getClassesByName(shortName, (GlobalSearchScope)$this$findByShortName);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClassesByName(...)");
        return (PsiClass)ArraysKt.getOrNull((Object[])psiClassArray, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Package, List<Package>> rootDependencies(@NotNull ProjectDependencies projectDependencies) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)projectDependencies, (String)"projectDependencies");
        List list = projectDependencies.getComponentsDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getComponentsDependencies(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ComponentDependencies it = (ComponentDependencies)element$iv$iv;
            boolean bl = false;
            List list2 = it.getCompileDependenciesGraph().getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDependencies(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return JavaPackageUtilKt.rootDependencies((List)destination$iv$iv, rootDependencies.2.INSTANCE, rootDependencies.3.INSTANCE);
    }

    @NotNull
    public static final <T> Map<Package, List<Package>> rootDependencies(@NotNull List<? extends T> rootNodes, @NotNull Function1<? super T, Package> pkgMapper, @NotNull Function1<? super T, ? extends List<? extends T>> getChildren) {
        Intrinsics.checkNotNullParameter(rootNodes, (String)"rootNodes");
        Intrinsics.checkNotNullParameter(pkgMapper, (String)"pkgMapper");
        Intrinsics.checkNotNullParameter(getChildren, (String)"getChildren");
        Logger logger = Logger.getInstance((String)loggerCategory);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        HashMap result = new HashMap();
        for (T dependency : rootNodes) {
            Package rootPackage = (Package)pkgMapper.invoke(dependency);
            if (rootPackage == null) {
                logger2.debug("Fail to parse package from " + dependency);
                continue;
            }
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00062\b\u0010\u0007\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"com/intellij/packageChecker/java/JavaPackageUtilKt$rootDependencies$GraphIterator", "Lcom/intellij/openapi/externalSystem/util/IteratorUtils$AbstractObjectGraphIterator;", "dependencies", "", "(Lkotlin/jvm/functions/Function1;Ljava/util/List;)V", "getChildren", "", "t", "(Ljava/lang/Object;)Ljava/util/Collection;", "intellij.packageChecker.java"})
            public final class GraphIterator
            extends IteratorUtils.AbstractObjectGraphIterator<T> {
                final /* synthetic */ Function1<T, List<T>> $getChildren;

                public GraphIterator(@NotNull Function1<? super T, ? extends List<? extends T>> $getChildren, @NotNull List<? extends T> dependencies2) {
                    Intrinsics.checkNotNullParameter($getChildren, (String)"$getChildren");
                    Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
                    this.$getChildren = $getChildren;
                    super((Collection)dependencies2);
                }

                @NotNull
                public Collection<? extends T> getChildren(@Nullable T t) {
                    return CollectionsKt.toMutableList((Collection)((Collection)this.$getChildren.invoke(t)));
                }
            }
            List children = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)((Iterator)((Object)new GraphIterator(getChildren, (List)getChildren.invoke(dependency))))));
            for (Object child : children) {
                Object object;
                Package childPackage = (Package)pkgMapper.invoke(child);
                if (childPackage == null) {
                    logger2.debug("Fail to parse package from " + child);
                    continue;
                }
                Map $this$getOrPut$iv = result;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(childPackage);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new LinkedList();
                    $this$getOrPut$iv.put(childPackage, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(rootPackage);
            }
        }
        return result;
    }

    @Nullable
    public static final Package createPackage(@NotNull Library $this$createPackage) {
        Library library;
        Object $this$createPackage_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)$this$createPackage, (String)"<this>");
        Logger logger = Logger.getInstance((String)loggerCategory);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        Library library2 = $this$createPackage;
        try {
            $this$createPackage_u24lambda_u242 = library2;
            boolean bl = false;
            Package pkg = JavaPackageUtilKt.getPackageFromLibraryName($this$createPackage_u24lambda_u242);
            if (pkg == null) {
                pkg = JavaPackageUtilKt.getPackageFromLibraryDescriptor($this$createPackage_u24lambda_u242);
            }
            if (pkg == null) {
                pkg = JavaPackageUtilKt.getPackageFromLibraryManifest($this$createPackage_u24lambda_u242);
            }
            if (logger2.isDebugEnabled() && pkg == null) {
                logger2.debug("cannot create package from library with presentableName: " + $this$createPackage_u24lambda_u242.getPresentableName());
            }
            $this$createPackage_u24lambda_u242 = Result.constructor-impl((Object)pkg);
        }
        catch (Throwable bl) {
            $this$createPackage_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        library2 = $this$createPackage_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)library2);
        if (throwable == null) {
            library = library2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            logger2.warn(e);
            library = null;
        }
        return (Package)library;
    }

    private static final Package getPackageFromLibraryName(Library $this$getPackageFromLibraryName) {
        Package package_;
        String[] stringArray = $this$getPackageFromLibraryName.getName();
        if (stringArray == null) {
            stringArray = $this$getPackageFromLibraryName.getPresentableName();
        }
        String[] stringArray2 = stringArray;
        Intrinsics.checkNotNull((Object)stringArray2);
        CharSequence charSequence = (CharSequence)stringArray2;
        stringArray2 = new String[]{":"};
        List splitLibName = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        if (splitLibName.size() == 4) {
            String type = (String)splitLibName.get(0);
            String namespace = (String)splitLibName.get(1);
            String name = (String)splitLibName.get(2);
            String version = (String)splitLibName.get(3);
            PackageType packageType = packageTypes.get(type);
            if (packageType != null) {
                PackageType packageType2 = packageType;
                boolean bl = false;
                package_ = new Package(packageType2, ((Object)StringsKt.trim((CharSequence)namespace)).toString(), ((Object)StringsKt.trim((CharSequence)name)).toString(), ((Object)StringsKt.trim((CharSequence)version)).toString(), null, null, null, 112, null);
            } else {
                package_ = null;
            }
        } else {
            package_ = null;
        }
        return package_;
    }

    private static final Package getPackageFromLibraryDescriptor(Library $this$getPackageFromLibraryDescriptor) {
        Package package_;
        RepositoryLibraryProperties repositoryLibraryProperties;
        LibraryEx libraryEx = $this$getPackageFromLibraryDescriptor instanceof LibraryEx ? (LibraryEx)$this$getPackageFromLibraryDescriptor : null;
        if (libraryEx == null) {
            return null;
        }
        LibraryEx libraryEx2 = libraryEx;
        if (libraryEx2.isDisposed()) {
            return null;
        }
        LibraryProperties libraryProperties = libraryEx2.getProperties();
        RepositoryLibraryProperties repositoryLibraryProperties2 = repositoryLibraryProperties = libraryProperties instanceof RepositoryLibraryProperties ? (RepositoryLibraryProperties)libraryProperties : null;
        if (repositoryLibraryProperties != null && (libraryProperties = repositoryLibraryProperties.getRepositoryLibraryDescriptor()) != null) {
            LibraryProperties it = libraryProperties;
            boolean bl = false;
            if (it.getGroupId() == null || it.getArtifactId() == null || it.getVersion() == null) {
                package_ = null;
            } else {
                String string = it.getGroupId();
                String string2 = it.getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArtifactId(...)");
                String string3 = it.getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
                package_ = new Package(PackageType.maven, string, string2, string3, null, null, null, 112, null);
            }
        } else {
            package_ = null;
        }
        return package_;
    }

    private static final Attributes.Name getBUNDLE_SYMBOLIC_NAME() {
        return new Attributes.Name("Bundle-SymbolicName");
    }

    private static final Attributes.Name getBUNDLE_NAME() {
        return new Attributes.Name("Bundle-Name");
    }

    private static final Attributes.Name getBUNDLE_VERSION() {
        return new Attributes.Name("Bundle-Version");
    }

    private static final Package getPackageFromLibraryManifest(Library $this$getPackageFromLibraryManifest) {
        Package package_;
        block8: {
            block5: {
                String version;
                String string;
                String namespace;
                String name;
                File jarFile;
                block7: {
                    String string2;
                    block6: {
                        String string3;
                        String jarPath;
                        String[] stringArray = $this$getPackageFromLibraryManifest.getUrls(OrderRootType.CLASSES);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getUrls(...)");
                        String[] urls = stringArray;
                        String string4 = jarPath = urls.length > 0 ? PathUtil.toPresentableUrl((String)urls[0]) : null;
                        if (string4 == null) break block5;
                        String it = string4;
                        boolean bl = false;
                        jarFile = new File(jarPath);
                        String string5 = JarUtil.getJarAttribute((File)jarFile, (Attributes.Name)JavaPackageUtilKt.getBUNDLE_NAME());
                        if (string5 == null && (string5 = JarUtil.getJarAttribute((File)jarFile, (Attributes.Name)Attributes.Name.IMPLEMENTATION_TITLE)) == null) {
                            string5 = name = JarUtil.getJarAttribute((File)jarFile, (Attributes.Name)Attributes.Name.SPECIFICATION_TITLE);
                        }
                        if ((string2 = (string3 = JarUtil.getJarAttribute((File)jarFile, (Attributes.Name)JavaPackageUtilKt.getBUNDLE_SYMBOLIC_NAME()))) == null) break block6;
                        Intrinsics.checkNotNull((Object)string2);
                        string2 = StringsKt.removeSuffix((String)string3, (CharSequence)("." + name));
                        if (string2 != null) break block7;
                    }
                    string2 = namespace = JarUtil.getJarAttribute((File)jarFile, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VENDOR_ID);
                }
                if ((string = JarUtil.getJarAttribute((File)jarFile, (Attributes.Name)JavaPackageUtilKt.getBUNDLE_VERSION())) == null && (string = JarUtil.getJarAttribute((File)jarFile, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION)) == null) {
                    string = version = JarUtil.getJarAttribute((File)jarFile, (Attributes.Name)Attributes.Name.SPECIFICATION_VERSION);
                }
                package_ = namespace != null && name != null && version != null ? new Package(PackageType.maven, namespace, name, version, null, null, null, 112, null) : null;
                break block8;
            }
            package_ = null;
        }
        return package_;
    }

    @Nullable
    public static final Package createMavenPackage(@NotNull DependencyNode $this$createMavenPackage) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$createMavenPackage, (String)"<this>");
        Object object2 = $this$createMavenPackage;
        try {
            DependencyNode $this$createMavenPackage_u24lambda_u247 = object2;
            boolean bl = false;
            if (!($this$createMavenPackage_u24lambda_u247 instanceof ArtifactDependencyNode)) {
                return null;
            }
            String string = ((ArtifactDependencyNode)$this$createMavenPackage_u24lambda_u247).getGroup();
            String string2 = ((ArtifactDependencyNode)$this$createMavenPackage_u24lambda_u247).getModule();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getModule(...)");
            String string3 = ((ArtifactDependencyNode)$this$createMavenPackage_u24lambda_u247).getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
            object = Result.constructor-impl((Object)new Package(PackageType.maven, string, string2, string3, null, null, null, 112, null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Package)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @Nullable
    public static final LibraryScope libraryScope(@NotNull Project $this$libraryScope, @NotNull Package pkg) {
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$libraryScope, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Library[] libraryArray = LibraryTablesRegistrar.getInstance().getLibraryTable($this$libraryScope).getLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"getLibraries(...)");
            for (Object object2 : (Object[])libraryArray) {
                Library it = (Library)object2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Package package_ = JavaPackageUtilKt.createPackage(it);
                if (!(package_ != null ? package_.matches(pkg) : false)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        Library library = (Library)object;
        if (library == null) {
            return null;
        }
        Library library2 = library;
        return new LibraryScope($this$libraryScope, library2);
    }

    @NotNull
    public static final List<LibraryDependency> javaLibraryDependencies(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (module.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        List groupBy = new ArrayList();
        ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary(arg_0 -> JavaPackageUtilKt.javaLibraryDependencies$lambda$9((Function1)new Function1<Library, Boolean>((List<LibraryDependency>)groupBy){
            final /* synthetic */ List<LibraryDependency> $groupBy;
            {
                this.$groupBy = $groupBy;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Library lib) {
                Intrinsics.checkNotNull((Object)lib);
                return this.$groupBy.add(new JavaLibraryDependency(lib));
            }
        }, arg_0));
        return groupBy;
    }

    private static final boolean javaLibraryDependencies$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Maven", (Object)((Object)PackageType.maven)), TuplesKt.to((Object)"Gradle", (Object)((Object)PackageType.maven))};
        packageTypes = MapsKt.mapOf((Pair[])pairArray);
    }
}

