/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.analysis;

import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.IDEACoverageRunner;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.coverage.analysis.AnalysisUtils;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.rt.coverage.data.BranchData;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.UnloadedUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

public final class PackageAnnotator {
    private static final Logger LOG = Logger.getInstance(PackageAnnotator.class);
    @NonNls
    private static final String DEFAULT_CONSTRUCTOR_NAME_SIGNATURE = "<init>()V";
    private final CoverageSuitesBundle mySuite;
    private final Project myProject;
    private final ProjectData myProjectData;
    private final boolean myIgnoreImplicitConstructor;
    private ProjectData myUnloadedClassesProjectData;

    public PackageAnnotator(CoverageSuitesBundle suite, Project project, ProjectData projectData) {
        this.mySuite = suite;
        this.myProject = project;
        this.myProjectData = projectData;
        IDEACoverageRunner.setExcludeAnnotations(project, this.myProjectData);
        JavaCoverageOptionsProvider optionsProvider = JavaCoverageOptionsProvider.getInstance(this.myProject);
        this.myIgnoreImplicitConstructor = optionsProvider.getIgnoreImplicitConstructors();
    }

    private synchronized ProjectData getUnloadedClassesProjectData() {
        if (this.myUnloadedClassesProjectData == null) {
            this.myUnloadedClassesProjectData = new ProjectData();
            IDEACoverageRunner.setExcludeAnnotations(this.myProject, this.myUnloadedClassesProjectData);
        }
        return this.myUnloadedClassesProjectData;
    }

    @NotNull
    public static File findRelativeFile(@NotNull String rootPackageVMName, File outputRoot) {
        if (rootPackageVMName == null) {
            PackageAnnotator.$$$reportNull$$$0(0);
        }
        File file = outputRoot = !rootPackageVMName.isEmpty() ? new File(outputRoot, FileUtil.toSystemDependentName((String)rootPackageVMName)) : outputRoot;
        if (file == null) {
            PackageAnnotator.$$$reportNull$$$0(1);
        }
        return file;
    }

    @Nullable
    public Result visitFiles(String toplevelClassSrcFQName, Map<String, File> children, String packageVMName) {
        Ref containingFileRef = new Ref();
        Ref psiClassRef = new Ref();
        if (this.myProject.isDisposed()) {
            return null;
        }
        DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(toplevelClassSrcFQName, this.mySuite.getSearchScope(this.myProject));
            if (aClass == null || !aClass.isValid()) {
                return;
            }
            psiClassRef.set((Object)aClass);
            PsiElement element = aClass.getNavigationElement();
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            containingFileRef.set((Object)file);
        });
        PsiClass psiClass = (PsiClass)psiClassRef.get();
        if (psiClass == null) {
            return null;
        }
        VirtualFile virtualFile = (VirtualFile)containingFileRef.get();
        ClassCoverageInfo topLevelClassCoverageInfo = new ClassCoverageInfo();
        VirtualFile parent = virtualFile == null ? null : virtualFile.getParent();
        for (Map.Entry<String, File> e : children.entrySet()) {
            String simpleName;
            String classFqName;
            ClassCoverageInfo info;
            File file = e.getValue();
            if (virtualFile == null && !ContainerUtil.exists((Iterable)JavaCoverageEngineExtension.EP_NAME.getExtensionList(), extension -> extension.keepCoverageInfoForClassWithoutSource(this.mySuite, file)) || (info = this.collectClassCoverageInformation(file, psiClass, classFqName = AnalysisUtils.internalNameToFqn(AnalysisUtils.buildVMName(packageVMName, simpleName = e.getKey())))) == null) continue;
            topLevelClassCoverageInfo.append(info);
        }
        return new Result(topLevelClassCoverageInfo, parent);
    }

    @Nullable
    private ClassCoverageInfo collectClassCoverageInformation(@Nullable File classFile, @NotNull PsiClass psiClass, String className2) {
        ClassData fullClassData;
        ClassData classData;
        boolean classExists;
        if (psiClass == null) {
            PackageAnnotator.$$$reportNull$$$0(2);
        }
        boolean bl = classExists = (classData = this.myProjectData.getClassData(className2)) != null && classData.getLines() != null;
        if (!(classFile == null || classExists && classData.isFullyAnalysed() || (fullClassData = this.collectNonCoveredClassInfo(classFile, className2, this.getUnloadedClassesProjectData())) == null)) {
            if (classData == null) {
                classData = fullClassData;
            } else {
                classData.merge((CoverageData)fullClassData);
            }
        }
        return PackageAnnotator.getSummaryInfo(psiClass, classData, this.myIgnoreImplicitConstructor);
    }

    @Nullable
    private static ClassCoverageInfo getSummaryInfo(@NotNull PsiClass psiClass, @Nullable ClassData classData, boolean ignoreImplicitConstructor) {
        Object[] lines;
        if (psiClass == null) {
            PackageAnnotator.$$$reportNull$$$0(3);
        }
        if (classData == null || classData.getLines() == null) {
            return null;
        }
        ClassCoverageInfo info = new ClassCoverageInfo();
        boolean isDefaultConstructorGenerated = false;
        Collection methodSigs = classData.getMethodSigs();
        for (String nameAndSig : methodSigs) {
            if (ignoreImplicitConstructor && PackageAnnotator.isGeneratedDefaultConstructor(psiClass, nameAndSig)) {
                isDefaultConstructorGenerated = true;
                continue;
            }
            if (classData.getStatus(nameAndSig) != 0) {
                ++info.coveredMethodCount;
            }
            ++info.totalMethodCount;
        }
        for (Object l : lines = classData.getLines()) {
            if (!(l instanceof LineData)) continue;
            LineData lineData = (LineData)l;
            if (isDefaultConstructorGenerated && PackageAnnotator.isDefaultConstructor(lineData.getMethodSignature())) continue;
            if (lineData.getStatus() == 2) {
                ++info.fullyCoveredLineCount;
            } else if (lineData.getStatus() == 1) {
                ++info.partiallyCoveredLineCount;
            }
            ++info.totalLineCount;
            BranchData branchData = lineData.getBranchData();
            if (branchData == null) continue;
            info.totalBranchCount += branchData.getTotalBranches();
            info.coveredBranchCount += branchData.getCoveredBranches();
        }
        if (!methodSigs.isEmpty()) {
            info.totalClassCount = 1;
            if (info.getCoveredLineCount() > 0) {
                info.coveredClassCount = 1;
            }
        }
        return info;
    }

    public static boolean isGeneratedDefaultConstructor(@Nullable PsiClass aClass, String nameAndSig) {
        if (aClass == null) {
            return false;
        }
        if (PackageAnnotator.isDefaultConstructor(nameAndSig)) {
            return PackageAnnotator.hasGeneratedConstructor(aClass);
        }
        return false;
    }

    private static boolean isDefaultConstructor(String nameAndSig) {
        return DEFAULT_CONSTRUCTOR_NAME_SIGNATURE.equals(nameAndSig);
    }

    private static boolean hasGeneratedConstructor(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PackageAnnotator.$$$reportNull$$$0(4);
        }
        return aClass.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && (Boolean)ReadAction.compute(() -> {
            if (!aClass.isValid()) {
                return false;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            return constructors.length == 0;
        }) != false;
    }

    @Nullable
    private ClassData collectNonCoveredClassInfo(File classFile, String className2, ProjectData projectData) {
        byte[] content;
        try {
            content = FileUtil.loadFileBytes((File)classFile);
        }
        catch (IOException e) {
            return null;
        }
        UnloadedUtil.appendUnloadedClass((ProjectData)projectData, (String)className2, (ClassReader)new ClassReader(content), (boolean)this.mySuite.isBranchCoverage(), (boolean)false);
        return projectData.getClassData(className2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPackageVMName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/analysis/PackageAnnotator";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/analysis/PackageAnnotator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelativeFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeFile";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectClassCoverageInformation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSummaryInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasGeneratedConstructor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class ClassCoverageInfo
    extends SummaryCoverageInfo {
        public int fullyCoveredLineCount;
        public int partiallyCoveredLineCount;

        public void append(ClassCoverageInfo info) {
            this.totalClassCount += info.totalClassCount;
            this.coveredClassCount += info.coveredClassCount;
            this.totalLineCount += info.totalLineCount;
            this.fullyCoveredLineCount += info.fullyCoveredLineCount;
            this.partiallyCoveredLineCount += info.partiallyCoveredLineCount;
            this.totalMethodCount += info.totalMethodCount;
            this.coveredMethodCount += info.coveredMethodCount;
            this.totalBranchCount += info.totalBranchCount;
            this.coveredBranchCount += info.coveredBranchCount;
        }

        @Override
        public int getCoveredLineCount() {
            return this.fullyCoveredLineCount + this.partiallyCoveredLineCount;
        }
    }

    public static class Result {
        public final ClassCoverageInfo info;
        public final VirtualFile directory;

        public Result(ClassCoverageInfo info, VirtualFile directory) {
            this.info = info;
            this.directory = directory;
        }
    }

    public static class AtomicPackageCoverageInfo {
        private final AtomicInteger myTotalClassCount = new AtomicInteger(0);
        private final AtomicInteger myCoveredClassCount = new AtomicInteger(0);
        private final AtomicInteger myTotalMethodCount = new AtomicInteger(0);
        private final AtomicInteger myCoveredMethodCount = new AtomicInteger(0);
        private final AtomicInteger myTotalLineCount = new AtomicInteger(0);
        private final AtomicInteger myCoveredLineCount = new AtomicInteger(0);
        private final AtomicInteger myTotalBranchCount = new AtomicInteger(0);
        private final AtomicInteger myCoveredBranchCount = new AtomicInteger(0);

        public void append(SummaryCoverageInfo info) {
            this.myTotalClassCount.addAndGet(info.totalClassCount);
            this.myCoveredClassCount.addAndGet(info.coveredClassCount);
            this.myTotalMethodCount.addAndGet(info.totalMethodCount);
            this.myCoveredMethodCount.addAndGet(info.coveredMethodCount);
            this.myTotalLineCount.addAndGet(info.totalLineCount);
            this.myCoveredLineCount.addAndGet(info.getCoveredLineCount());
            this.myTotalBranchCount.addAndGet(info.totalBranchCount);
            this.myCoveredBranchCount.addAndGet(info.coveredBranchCount);
        }

        public PackageCoverageInfo toPackageCoverageInfo() {
            PackageCoverageInfo info = new PackageCoverageInfo();
            info.totalClassCount = this.myTotalClassCount.get();
            info.coveredClassCount = this.myCoveredClassCount.get();
            info.totalMethodCount = this.myTotalMethodCount.get();
            info.coveredMethodCount = this.myCoveredMethodCount.get();
            info.totalLineCount = this.myTotalLineCount.get();
            info.coveredLineCount = this.myCoveredLineCount.get();
            info.totalBranchCount = this.myTotalBranchCount.get();
            info.coveredBranchCount = this.myCoveredBranchCount.get();
            return info;
        }
    }

    public static class DirCoverageInfo
    extends PackageCoverageInfo {
        public final VirtualFile sourceRoot;

        public DirCoverageInfo(VirtualFile sourceRoot) {
            this.sourceRoot = sourceRoot;
        }
    }

    public static class PackageCoverageInfo
    extends SummaryCoverageInfo {
        public int coveredLineCount;

        @Override
        public int getCoveredLineCount() {
            return this.coveredLineCount;
        }

        public void append(SummaryCoverageInfo info) {
            this.totalClassCount += info.totalClassCount;
            this.totalLineCount += info.totalLineCount;
            this.coveredClassCount += info.coveredClassCount;
            this.coveredLineCount += info.getCoveredLineCount();
            this.coveredMethodCount += info.coveredMethodCount;
            this.totalMethodCount += info.totalMethodCount;
            this.totalBranchCount += info.totalBranchCount;
            this.coveredBranchCount += info.coveredBranchCount;
        }
    }

    public static abstract class SummaryCoverageInfo {
        public int totalClassCount;
        public int coveredClassCount;
        public int totalMethodCount;
        public int coveredMethodCount;
        public int totalLineCount;
        public int coveredBranchCount;
        public int totalBranchCount;

        public abstract int getCoveredLineCount();

        public boolean isFullyCovered() {
            return this.totalBranchCount == this.coveredBranchCount && this.totalLineCount == this.getCoveredLineCount() && this.totalMethodCount == this.coveredMethodCount && this.totalClassCount == this.coveredClassCount;
        }
    }
}

