/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.xml;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.JavaCoverageViewExtension;
import com.intellij.coverage.xml.XMLReportAnnotator;
import com.intellij.coverage.xml.XMLReportEditorAnnotator;
import com.intellij.coverage.xml.XMLReportEngineKt;
import com.intellij.coverage.xml.XMLReportRunner;
import com.intellij.coverage.xml.XMLReportSuite;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J(\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016Jm\u0010\u000e\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0018\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010\"J$\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!2\b\u0010%\u001a\u0004\u0018\u00010\b2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u0010H\u0016J\u001c\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u00062\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u00102\u001a\f0\u0012\u00a2\u0006\u0002\b3\u00a2\u0006\u0002\b4H\u0016J\u0010\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u0006H\u0016J\u0014\u00107\u001a\u00020\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016\u00a8\u00068"}, d2={"Lcom/intellij/coverage/xml/XMLReportEngine;", "Lcom/intellij/coverage/CoverageEngine;", "()V", "acceptedByFilters", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "coverageEditorHighlightingApplicableTo", "createCoverageEnabledConfiguration", "", "conf", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "createCoverageSuite", "covRunner", "Lcom/intellij/coverage/CoverageRunner;", "name", "", "coverageDataFileProvider", "Lcom/intellij/coverage/CoverageFileProvider;", "config", "Lcom/intellij/execution/configurations/coverage/CoverageEnabledConfiguration;", "Lcom/intellij/coverage/CoverageSuite;", "filters", "", "lastCoverageTimeStamp", "", "suiteToMerge", "coverageByTestEnabled", "branchCoverage", "trackTestFolders", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/coverage/CoverageRunner;Ljava/lang/String;Lcom/intellij/coverage/CoverageFileProvider;[Ljava/lang/String;JLjava/lang/String;ZZZLcom/intellij/openapi/project/Project;)Lcom/intellij/coverage/CoverageSuite;", "createCoverageViewExtension", "Lcom/intellij/coverage/view/JavaCoverageViewExtension;", "suiteBundle", "stateBean", "Lcom/intellij/coverage/view/CoverageViewManager$StateBean;", "createEmptyCoverageSuite", "Lcom/intellij/coverage/xml/XMLReportSuite;", "coverageRunner", "createSrcFileAnnotator", "Lcom/intellij/coverage/xml/XMLReportEditorAnnotator;", "file", "editor", "Lcom/intellij/openapi/editor/Editor;", "getCoverageAnnotator", "Lcom/intellij/coverage/xml/XMLReportAnnotator;", "getPresentableText", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getQualifiedNames", "sourceFile", "isApplicableTo", "intellij.java.coverage"})
public final class XMLReportEngine
extends CoverageEngine {
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @Nullable String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMerge, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)covRunner, (String)"covRunner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)coverageDataFileProvider, (String)"coverageDataFileProvider");
        if (!(covRunner instanceof XMLReportRunner)) {
            return null;
        }
        return (CoverageSuite)new XMLReportSuite(name, project, (XMLReportRunner)covRunner, coverageDataFileProvider, lastCoverageTimeStamp, this);
    }

    @NotNull
    public Void createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)covRunner, (String)"covRunner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)coverageDataFileProvider, (String)"coverageDataFileProvider");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        throw new IllegalStateException("Should not be called".toString());
    }

    @Nullable
    public XMLReportSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        Intrinsics.checkNotNullParameter((Object)coverageRunner, (String)"coverageRunner");
        if (!(coverageRunner instanceof XMLReportRunner)) {
            return null;
        }
        return new XMLReportSuite(this);
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return psiFile instanceof PsiClassOwner;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Pair<String, String> pair = XMLReportEngineKt.packageAndFileName(psiFile);
        if (pair == null) {
            return false;
        }
        Pair<String, String> pair2 = pair;
        String packageName2 = (String)pair2.component1();
        String fileName = (String)pair2.component2();
        CoverageSuite[] coverageSuiteArray = suite.getSuites();
        Intrinsics.checkNotNullExpressionValue((Object)coverageSuiteArray, (String)"getSuites(...)");
        for (CoverageSuite xmlSuite : coverageSuiteArray) {
            if (!(xmlSuite instanceof XMLReportSuite) || ((XMLReportSuite)xmlSuite).getFileInfo(packageName2, fileName) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public JavaCoverageViewExtension createCoverageViewExtension(@NotNull Project project, @Nullable CoverageSuitesBundle suiteBundle, @Nullable CoverageViewManager.StateBean stateBean) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        XMLReportAnnotator xMLReportAnnotator = this.getCoverageAnnotator(project);
        return new JavaCoverageViewExtension(project, suiteBundle, stateBean, xMLReportAnnotator){

            protected boolean isBranchInfoAvailable(@Nullable CoverageRunner coverageRunner, boolean branchCoverage) {
                return true;
            }
        };
    }

    @NotNull
    public XMLReportEditorAnnotator createSrcFileAnnotator(@Nullable PsiFile file, @Nullable Editor editor) {
        return new XMLReportEditorAnnotator(file, editor);
    }

    public boolean isApplicableTo(@NotNull RunConfigurationBase<?> conf) {
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        return false;
    }

    @NotNull
    public String getPresentableText() {
        String string = JavaCoverageBundle.message("coverage.xml.report.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public XMLReportAnnotator getCoverageAnnotator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return XMLReportAnnotator.Companion.getInstance(project);
    }

    @NotNull
    public Void getQualifiedNames(@NotNull PsiFile sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        throw new IllegalStateException("Should not be called".toString());
    }

    @NotNull
    public Void createCoverageEnabledConfiguration(@NotNull RunConfigurationBase<?> conf) {
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        throw new IllegalStateException("Should not be called".toString());
    }
}

