/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import com.intellij.rt.execution.junit.FileComparisonData;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComparisonFailureData {
    private static final String ASSERTION_CLASS_NAME = "java.lang.AssertionError";
    private static final String ASSERTION_FAILED_CLASS_NAME = "junit.framework.AssertionFailedError";
    public static final String OPENTEST4J_ASSERTION = "org.opentest4j.AssertionFailedError";
    public static final String OPENTEST4J_VALUE_WRAPPER = "org.opentest4j.ValueWrapper";
    public static final String OPENTEST4J_FILE_INFO = "org.opentest4j.FileInfo";
    public static final Charset OPENTEST4J_FILE_CONTENT_CHARSET = StandardCharsets.UTF_8;
    private static final List<String> COMPARISON_FAILURES = Arrays.asList("org.junit.ComparisonFailure", "org.junit.ComparisonFailure");
    private final String myExpected;
    private final String myActual;
    private final String myFilePath;
    private final String myActualFilePath;
    private static final Map<Class<?>, Field> EXPECTED = new HashMap();
    private static final Map<Class<?>, Field> ACTUAL = new HashMap();

    private static void init(String exceptionClassName) throws NoSuchFieldException, ClassNotFoundException {
        Class<?> exceptionClass = Class.forName(exceptionClassName, false, ComparisonFailureData.class.getClassLoader());
        Field expectedField = exceptionClass.getDeclaredField("fExpected");
        expectedField.setAccessible(true);
        EXPECTED.put(exceptionClass, expectedField);
        Field actualField = exceptionClass.getDeclaredField("fActual");
        actualField.setAccessible(true);
        ACTUAL.put(exceptionClass, actualField);
    }

    public ComparisonFailureData(AssertionValue expected, AssertionValue actual) {
        this(expected.text, actual.text, actual.path, expected.path);
    }

    public ComparisonFailureData(String expected, String actual) {
        this(expected, actual, null);
    }

    public ComparisonFailureData(String expected, String actual, String filePath) {
        this(expected, actual, filePath, null);
    }

    public ComparisonFailureData(String expected, String actual, String filePath, String actualFilePath) {
        this.myExpected = expected;
        this.myActual = actual;
        this.myFilePath = filePath != null ? new File(filePath).getAbsolutePath() : null;
        this.myActualFilePath = actualFilePath != null ? new File(actualFilePath).getAbsolutePath() : null;
    }

    public static void registerSMAttributes(ComparisonFailureData notification, String trace, String failureMessage, Map attrs, Throwable throwable) {
        ComparisonFailureData.registerSMAttributes(notification, trace, failureMessage, attrs, throwable, "Comparison Failure: ", "expected:<");
    }

    public static void registerSMAttributes(ComparisonFailureData notification, String trace, String failureMessage, Map attrs, Throwable throwable, String comparisonFailurePrefix, String expectedPrefix) {
        String details;
        int failureIdx = failureMessage != null ? trace.indexOf(failureMessage) : -1;
        int failureMessageLength = failureMessage != null ? failureMessage.length() : 0;
        String string = details = failureIdx > -1 ? trace.substring(failureIdx + failureMessageLength) : trace;
        if (notification != null) {
            int expectedIdx = trace.indexOf(expectedPrefix);
            String comparisonFailureMessage = expectedIdx > 0 ? trace.substring(0, expectedIdx) : (failureIdx > -1 ? trace.substring(0, failureIdx + failureMessageLength) : (failureMessageLength > 0 ? failureMessage + "\n" : "") + comparisonFailurePrefix);
            if (!attrs.containsKey("message")) {
                attrs.put("message", comparisonFailureMessage);
            }
            String filePath = notification.getFilePath();
            String actualFilePath = notification.getActualFilePath();
            String expected = notification.getExpected();
            String actual = notification.getActual();
            int fullLength = (filePath == null && expected != null ? expected.length() : 0) + (actualFilePath == null && actual != null ? actual.length() : 0) + details.length() + comparisonFailureMessage.length() + 100;
            if (filePath != null) {
                attrs.put("expectedFile", filePath);
            } else {
                ComparisonFailureData.writeDiffSide(attrs, "expected", expected, fullLength);
            }
            if (actualFilePath != null) {
                attrs.put("actualFile", actualFilePath);
            } else {
                ComparisonFailureData.writeDiffSide(attrs, "actual", actual, fullLength);
            }
        } else {
            Throwable throwableCause = null;
            try {
                throwableCause = throwable.getCause();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            if (!ComparisonFailureData.isAssertionError(throwable.getClass()) && !ComparisonFailureData.isAssertionError(throwableCause != null ? throwableCause.getClass() : null)) {
                attrs.put("error", "true");
            }
            attrs.put("message", failureIdx > -1 ? trace.substring(0, failureIdx + failureMessageLength) : (failureMessage != null ? failureMessage : ""));
        }
        attrs.put("details", details);
    }

    private static void writeDiffSide(Map attrs, String expectedOrActualPrefix, String text, int fullLength) {
        int threshold;
        String property = System.getProperty("idea.test.cyclic.buffer.size");
        try {
            threshold = Integer.parseInt(property);
        }
        catch (NumberFormatException ignored) {
            threshold = -1;
        }
        if (threshold > 0 && fullLength > threshold) {
            try {
                File tempFile = File.createTempFile(expectedOrActualPrefix, "");
                try (FileOutputStream stream = new FileOutputStream(tempFile);){
                    ((OutputStream)stream).write(text.getBytes(StandardCharsets.UTF_8), 0, text.length());
                }
                attrs.put(expectedOrActualPrefix + "File", tempFile.getAbsolutePath());
                attrs.put(expectedOrActualPrefix + "IsTempFile", "true");
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        attrs.put(expectedOrActualPrefix, text);
    }

    public static boolean isAssertionError(Class throwableClass) {
        if (throwableClass == null) {
            return false;
        }
        String throwableClassName = throwableClass.getName();
        if (throwableClassName.equals(ASSERTION_CLASS_NAME) || throwableClassName.equals(ASSERTION_FAILED_CLASS_NAME) || throwableClassName.equals(OPENTEST4J_ASSERTION)) {
            return true;
        }
        return ComparisonFailureData.isAssertionError(throwableClass.getSuperclass());
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public String getActualFilePath() {
        return this.myActualFilePath;
    }

    public String getExpected() {
        return this.myExpected;
    }

    public String getActual() {
        return this.myActual;
    }

    public static ComparisonFailureData create(Throwable assertion) {
        ComparisonFailureData failureData = ComparisonFailureData.createFileComparisonData(assertion);
        if (failureData != null) {
            return failureData;
        }
        failureData = ComparisonFailureData.createFileComparisonFailure(assertion);
        if (failureData != null) {
            return failureData;
        }
        failureData = ComparisonFailureData.createJunitComparisonFailure(assertion);
        if (failureData != null) {
            return failureData;
        }
        failureData = ComparisonFailureData.createOpentest4jAssertion(assertion);
        return failureData;
    }

    private static ComparisonFailureData createFileComparisonData(Throwable assertion) {
        if (assertion instanceof FileComparisonData) {
            FileComparisonData comparisonFailure = (FileComparisonData)((Object)assertion);
            String actual = comparisonFailure.getActualStringPresentation();
            String expected = comparisonFailure.getExpectedStringPresentation();
            if (actual != null && expected != null) {
                return new ComparisonFailureData(expected, actual, comparisonFailure.getFilePath(), comparisonFailure.getActualFilePath());
            }
        }
        return null;
    }

    private static ComparisonFailureData createFileComparisonFailure(Throwable assertion) {
        if (assertion instanceof FileComparisonFailure) {
            FileComparisonFailure comparisonFailure = (FileComparisonFailure)((Object)assertion);
            String actual = comparisonFailure.getActualStringPresentation();
            String expected = comparisonFailure.getExpectedStringPresentation();
            if (actual != null && expected != null) {
                return new ComparisonFailureData(expected, actual, comparisonFailure.getFilePath(), comparisonFailure.getActualFilePath());
            }
        }
        return null;
    }

    private static ComparisonFailureData createOpentest4jAssertion(Throwable assertion) {
        try {
            if (OPENTEST4J_ASSERTION.equals(assertion.getClass().getName())) {
                Method isExpectedDefinedMethod = assertion.getClass().getDeclaredMethod("isExpectedDefined", new Class[0]);
                Method isActualDefinedMethod = assertion.getClass().getDeclaredMethod("isActualDefined", new Class[0]);
                boolean isExpectedDefined = (Boolean)isExpectedDefinedMethod.invoke((Object)assertion, new Object[0]);
                boolean isActualDefined = (Boolean)isActualDefinedMethod.invoke((Object)assertion, new Object[0]);
                if (isExpectedDefined && isActualDefined) {
                    Method expectedMethod = assertion.getClass().getDeclaredMethod("getExpected", new Class[0]);
                    Method actualMethod = assertion.getClass().getDeclaredMethod("getActual", new Class[0]);
                    Object expectedValueWrapper = expectedMethod.invoke((Object)assertion, new Object[0]);
                    Object actualValueWrapper = actualMethod.invoke((Object)assertion, new Object[0]);
                    AssertionValue expected = ComparisonFailureData.getOpentest4jAssertionValue(expectedValueWrapper);
                    AssertionValue actual = ComparisonFailureData.getOpentest4jAssertionValue(actualValueWrapper);
                    return new ComparisonFailureData(expected, actual);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static AssertionValue getOpentest4jAssertionValue(Object valueWrapper) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (OPENTEST4J_VALUE_WRAPPER.equals(valueWrapper.getClass().getName())) {
            Method valueMethod = valueWrapper.getClass().getDeclaredMethod("getValue", new Class[0]);
            Object value = valueMethod.invoke(valueWrapper, new Object[0]);
            if (value != null && OPENTEST4J_FILE_INFO.equals(value.getClass().getName())) {
                Method contentAsStringMethod = value.getClass().getDeclaredMethod("getContentsAsString", Charset.class);
                String valueString = (String)contentAsStringMethod.invoke(value, OPENTEST4J_FILE_CONTENT_CHARSET);
                Method pathMethod = value.getClass().getDeclaredMethod("getPath", new Class[0]);
                String valuePath = (String)pathMethod.invoke(value, new Object[0]);
                return new AssertionValue(valueString, valuePath);
            }
            Method stringRepresentationMethod = valueWrapper.getClass().getDeclaredMethod("getStringRepresentation", new Class[0]);
            String valueString = (String)stringRepresentationMethod.invoke(valueWrapper, new Object[0]);
            return new AssertionValue(valueString, null);
        }
        return null;
    }

    private static ComparisonFailureData createJunitComparisonFailure(Throwable assertion) {
        try {
            String expected = ComparisonFailureData.getExpected(assertion);
            String actual = ComparisonFailureData.getActual(assertion);
            return new ComparisonFailureData(expected, actual);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    public static String getActual(Throwable assertion) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureData.get(assertion, ACTUAL, "fActual");
    }

    public static String getExpected(Throwable assertion) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureData.get(assertion, EXPECTED, "fExpected");
    }

    private static String get(Throwable assertion, Map<Class<?>, Field> staticMap, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Class<?> assertionClass = assertion.getClass();
        for (Class<?> comparisonClass : staticMap.keySet()) {
            if (!comparisonClass.isAssignableFrom(assertionClass)) continue;
            return (String)staticMap.get(comparisonClass).get(assertion);
        }
        Field field = assertionClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (String)field.get(assertion);
    }

    static {
        try {
            for (String failure : COMPARISON_FAILURES) {
                ComparisonFailureData.init(failure);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class AssertionValue {
        public final String text;
        public final String path;

        public AssertionValue(String text, String path) {
            this.text = text;
            this.path = path;
        }
    }
}

