/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.codeInsight.handlers.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/base/codeInsight/handlers/fixers/KotlinMissingForOrWhileBodyFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "element", "Lcom/intellij/psi/PsiElement;", "isValidLoopCondition", "", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "kotlin.base.code-insight.minimal"})
public final class KotlinMissingForOrWhileBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!(element2 instanceof KtForExpression) && !(element2 instanceof KtWhileExpression)) {
            return;
        }
        KtLoopExpression loopExpression = (KtLoopExpression)element2;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        KtExpression body = loopExpression.getBody();
        if (body instanceof KtBlockExpression) {
            return;
        }
        if (!this.isValidLoopCondition(loopExpression)) {
            return;
        }
        if (body != null && FixersUtilKt.startLine((PsiElement)body, doc) == FixersUtilKt.startLine((PsiElement)loopExpression, doc)) {
            return;
        }
        PsiElement psiElement = loopExpression.getRightParenthesis();
        if (psiElement == null) {
            return;
        }
        PsiElement rParen = psiElement;
        doc.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(rParen)), (CharSequence)"{}");
    }

    private final boolean isValidLoopCondition(KtLoopExpression $this$isValidLoopCondition) {
        return $this$isValidLoopCondition.getLeftParenthesis() != null && $this$isValidLoopCondition.getRightParenthesis() != null;
    }
}

