/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.codeInsight.handlers.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/base/codeInsight/handlers/fixers/KotlinMissingWhenEntryBodyFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.base.code-insight.minimal"})
public final class KotlinMissingWhenEntryBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!(element2 instanceof KtWhenEntry) || ((KtWhenEntry)element2).getExpression() != null) {
            return;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        PsiElement arrow = ((KtWhenEntry)element2).getArrow();
        if (arrow != null) {
            doc.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(arrow)), (CharSequence)"{\n}");
        } else {
            KtWhenCondition[] ktWhenConditionArray = ((KtWhenEntry)element2).getConditions();
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
            KtWhenCondition ktWhenCondition = (KtWhenCondition)ArraysKt.lastOrNull((Object[])ktWhenConditionArray);
            if (ktWhenCondition == null) {
                return;
            }
            KtWhenCondition lastCondition = ktWhenCondition;
            if (PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)lastCondition), PsiErrorElement.class) != null) {
                return;
            }
            int offset = FixersUtilKt.getEnd(FixersUtilKt.getRange((PsiElement)lastCondition));
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            CaretModel caretModel2 = caretModel;
            if (doc.getLineNumber(caretModel2.getOffset()) == doc.getLineNumber(FixersUtilKt.getStart(FixersUtilKt.getRange(element2)))) {
                caretModel2.moveToOffset(offset);
            }
            doc.insertString(offset, (CharSequence)"-> {\n}");
        }
    }
}

