/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.handlers;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.LanguageSmartEnterProcessorFixer;
import org.jetbrains.kotlin.idea.codeInsight.handlers.KotlinSmartEnterHandlerKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0014J \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0014J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0004H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers;", "()V", "getStatementAtCaret", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "moveCaretInsideBracesIfAny", "", "file", "processDefaultEnter", "project", "Lcom/intellij/openapi/project/Project;", "isKotlinStatement", "", "KotlinPlainEnterProcessor", "kotlin.base.code-insight.minimal"})
@SourceDebugExtension(value={"SMAP\nKotlinSmartEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSmartEnterHandler.kt\norg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n37#2,2:132\n142#3:134\n1#4:135\n*S KotlinDebug\n*F\n+ 1 KotlinSmartEnterHandler.kt\norg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler\n*L\n24#1:132,2\n76#1:134\n*E\n"})
public final class KotlinSmartEnterHandler
extends SmartEnterProcessorWithFixers {
    public KotlinSmartEnterHandler() {
        List list = LanguageSmartEnterProcessorFixer.INSTANCE.allForLanguage((Language)KotlinLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allForLanguage(...)");
        List allFixers = list;
        Collection $this$toTypedArray$iv = allFixers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SmartEnterProcessorWithFixers.Fixer[] fixerArray = thisCollection$iv.toArray(new SmartEnterProcessorWithFixers.Fixer[0]);
        this.addFixers(Arrays.copyOf(fixerArray, fixerArray.length));
        fixerArray = new SmartEnterProcessorWithFixers.FixEnterProcessor[]{new KotlinPlainEnterProcessor()};
        this.addEnterProcessors((SmartEnterProcessorWithFixers.FixEnterProcessor[])fixerArray);
    }

    @Nullable
    protected PsiElement getStatementAtCaret(@Nullable Editor editor, @Nullable PsiFile psiFile) {
        PsiElement atCaret = super.getStatementAtCaret(editor, psiFile);
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        while (atCaret != null) {
            if (this.isKotlinStatement(atCaret)) {
                return atCaret;
            }
            if (atCaret.getParent() instanceof KtFunctionLiteral) {
                return atCaret;
            }
            if (atCaret instanceof KtDeclaration) {
                PsiElement declaration = atCaret;
                if (!(declaration instanceof KtParameter && !((KtParameter)declaration).isLambdaParameter() || ((KtDeclaration)declaration).getParent() instanceof KtForExpression)) {
                    return atCaret;
                }
            }
            atCaret = atCaret.getParent();
        }
        return null;
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence chars = charSequence;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}")) {
            caretOffset += 2;
        } else if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            caretOffset += 3;
        }
        caretOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - 2), (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - 3), (CharSequence)"{\n}")) {
            this.commit(editor);
            CommonCodeStyleSettings commonCodeStyleSettings = CodeStyle.getSettings((PsiFile)file).getCommonSettings((Language)KotlinLanguage.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
            CommonCodeStyleSettings settings = commonCodeStyleSettings;
            boolean old = settings.KEEP_LINE_BREAKS;
            settings.KEEP_LINE_BREAKS = true;
            PsiElement psiElement = file.findElementAt(caretOffset - 1);
            if (psiElement != null) {
                PsiElement $this$getStrictParentOfType$iv = psiElement;
                boolean $i$f$getStrictParentOfType = false;
                psiElement = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtBlockExpression.class, (boolean)true);
                if (psiElement != null) {
                    PsiElement p0 = psiElement;
                    boolean bl = false;
                    this.reformat(p0);
                }
            }
            settings.KEEP_LINE_BREAKS = old;
            editor.getCaretModel().moveToOffset(caretOffset - 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKotlinStatement(PsiElement $this$isKotlinStatement) {
        PsiElement psiElement;
        if ($this$isKotlinStatement.getParent() instanceof KtBlockExpression) {
            ASTNode aSTNode = $this$isKotlinStatement.getNode();
            if (!KotlinSmartEnterHandlerKt.access$getBRACES$p().contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null))) {
                return true;
            }
        }
        if (!KotlinSmartEnterHandlerKt.access$getBRANCH_CONTAINERS$p().contains((psiElement = $this$isKotlinStatement.getParent()) != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null)) return false;
        if ($this$isKotlinStatement instanceof KtBlockExpression) return false;
        return true;
    }

    protected void processDefaultEnter(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SmartEnterProcessorWithFixers.plainEnter((Editor)editor);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler$KotlinPlainEnterProcessor;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$FixEnterProcessor;", "()V", "doEnter", "", "atCaret", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "modified", "getControlStatementBlock", "Lorg/jetbrains/kotlin/psi/KtExpression;", "caret", "", "element", "kotlin.base.code-insight.minimal"})
    public static final class KotlinPlainEnterProcessor
    extends SmartEnterProcessorWithFixers.FixEnterProcessor {
        private final KtExpression getControlStatementBlock(int caret, PsiElement element2) {
            PsiElement psiElement = element2;
            if (psiElement instanceof KtDeclarationWithBody) {
                return ((KtDeclarationWithBody)element2).getBodyExpression();
            }
            if (psiElement instanceof KtIfExpression) {
                if (FixersUtilKt.isWithCaret((PsiElement)((KtIfExpression)element2).getThen(), caret)) {
                    return ((KtIfExpression)element2).getThen();
                }
                if (FixersUtilKt.isWithCaret((PsiElement)((KtIfExpression)element2).getElse(), caret)) {
                    return ((KtIfExpression)element2).getElse();
                }
            } else if (psiElement instanceof KtLoopExpression) {
                return ((KtLoopExpression)element2).getBody();
            }
            return null;
        }

        public boolean doEnter(@NotNull PsiElement atCaret, @Nullable PsiFile file, @NotNull Editor editor, boolean modified) {
            KtBlockExpression block;
            Intrinsics.checkNotNullParameter((Object)atCaret, (String)"atCaret");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (modified && atCaret instanceof KtCallExpression) {
                return true;
            }
            KtExpression ktExpression = this.getControlStatementBlock(editor.getCaretModel().getOffset(), atCaret);
            KtBlockExpression ktBlockExpression = block = ktExpression instanceof KtBlockExpression ? (KtBlockExpression)ktExpression : null;
            if (block != null) {
                int n;
                PsiElement firstElement;
                PsiElement psiElement = block.getFirstChild();
                Object object = firstElement = psiElement != null ? psiElement.getNextSibling() : null;
                if (firstElement != null) {
                    TextRange textRange = firstElement.getTextRange();
                    Intrinsics.checkNotNull((Object)textRange);
                    n = textRange.getStartOffset() - 1;
                } else {
                    TextRange textRange = block.getTextRange();
                    Intrinsics.checkNotNull((Object)textRange);
                    n = textRange.getEndOffset();
                }
                int offset = n;
                editor.getCaretModel().moveToOffset(offset);
            }
            this.plainEnter(editor);
            return true;
        }
    }
}

