/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove;

import java.io.Serializable;
import org.jetbrains.coverage.gnu.trove.THash;
import org.jetbrains.coverage.gnu.trove.TObjectHashingStrategy;
import org.jetbrains.coverage.gnu.trove.TObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TObjectHash<T>
extends THash
implements Serializable,
TObjectHashingStrategy<T> {
    protected transient Object[] _set;
    protected TObjectHashingStrategy<T> _hashingStrategy;
    public static final Object REMOVED = new Object();

    public TObjectHash() {
        this._hashingStrategy = this;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectHash(TObjectHashingStrategy<T> strategy) {
        void var1_1;
        this._hashingStrategy = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectHash(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
        this._hashingStrategy = this;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectHash(int initialCapacity, TObjectHashingStrategy<T> strategy) {
        super((int)var1_1);
        void var2_2;
        void var1_1;
        this._hashingStrategy = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectHash(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
        this._hashingStrategy = this;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectHash(int initialCapacity, float loadFactor, TObjectHashingStrategy<T> strategy) {
        super((int)var1_1, (float)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this._hashingStrategy = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TObjectHash<T> clone() {
        void var1_1;
        TObjectHash h = (TObjectHash)super.clone();
        ((TObjectHash)super.clone())._set = (Object[])this._set.clone();
        return var1_1;
    }

    @Override
    protected int capacity() {
        return this._set.length;
    }

    @Override
    protected void removeAt(int index) {
        super.removeAt(index);
        this._set[var1_1] = REMOVED;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int setUp(int initialCapacity) {
        void var1_1;
        int capacity = super.setUp(initialCapacity);
        this._set = new Object[capacity];
        return (int)var1_1;
    }

    public boolean forEach(TObjectProcedure<T> procedure) {
        Object[] set = this._set;
        int i = this._set.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == REMOVED || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(Object obj) {
        void var1_1;
        return this.index(var1_1) >= 0;
    }

    protected int index(T obj) {
        Object[] set = this._set;
        int length = this._set.length;
        int hash = this._hashingStrategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (!(cur == null || cur != REMOVED && this._hashingStrategy.equals(cur, obj))) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == REMOVED || !this._hashingStrategy.equals(cur, obj)));
        }
        if (cur == null) {
            return -1;
        }
        return index;
    }

    protected int insertionIndex(T obj) {
        Object[] set = this._set;
        int length = this._set.length;
        int hash = this._hashingStrategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != REMOVED && this._hashingStrategy.equals(cur, obj)) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index -= probe) >= 0) continue;
            index += length;
        } while ((cur = set[index]) != null && cur != REMOVED && !this._hashingStrategy.equals(cur, obj));
        if (cur == REMOVED) {
            int firstRemoved = index;
            while (!(cur == null || cur != REMOVED && this._hashingStrategy.equals(cur, obj))) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            if (cur != null && cur != REMOVED) {
                return -index - 1;
            }
            return firstRemoved;
        }
        if (cur != null) {
            return -index - 1;
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int computeHashCode(T o) {
        if (o != null) {
            void var1_1;
            return var1_1.hashCode();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(T o1, T o2) {
        void var2_2;
        if (o1 != null) {
            void var1_1;
            return var1_1.equals(o2);
        }
        return var2_2 == null;
    }

    /*
     * WARNING - void declaration
     */
    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + var1_1 + "; object #2 =" + var2_2);
    }
}

