/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.JunitLibrarySetupKt;
import com.intellij.execution.junit.codeInspection.JUnit5ConverterInspectionKt;
import com.intellij.execution.junit.codeInspection.JUnit5ConverterQuickFix;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.testIntegration.TestFramework;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J+\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnit5ConverterInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "aClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "shouldInspect", "file", "Lcom/intellij/psi/PsiFile;", "intellij.junit"})
@SourceDebugExtension(value={"SMAP\nJUnit5ConverterInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnit5ConverterInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnit5ConverterInspection\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,56:1\n26#2:57\n26#2:58\n26#2:59\n*S KotlinDebug\n*F\n+ 1 JUnit5ConverterInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnit5ConverterInspection\n*L\n28#1:57\n29#1:58\n30#1:59\n*E\n"})
public final class JUnit5ConverterInspection
extends AbstractBaseUastLocalInspectionTool {
    public JUnit5ConverterInspection() {
        Class[] classArray = new Class[]{UClass.class};
        super(classArray);
    }

    private final boolean shouldInspect(PsiFile file) {
        return JavaVersionService.getInstance().isAtLeast((PsiElement)file, JavaSdkVersion.JDK_1_8) && JunitLibrarySetupKt.isJUnit4InScope(file) && JunitLibrarySetupKt.isJUnit5InScope(file);
    }

    @NotNull
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiClass javaPsi = aClass.getJavaPsi();
        TestFramework framework = TestFrameworks.detectFramework((PsiClass)javaPsi);
        if (framework == null || !Intrinsics.areEqual((Object)"JUnit4", (Object)framework.getName())) {
            boolean $i$f$emptyArray = false;
            return new ProblemDescriptor[0];
        }
        if (!JUnit5ConverterInspectionKt.canBeConvertedToJUnit5(javaPsi)) {
            boolean $i$f$emptyArray = false;
            return new ProblemDescriptor[0];
        }
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)aClass.getUastAnchor());
        if (psiElement == null) {
            boolean $i$f$emptyArray = false;
            return new ProblemDescriptor[0];
        }
        PsiElement identifier = psiElement;
        ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[1];
        JUnit5ConverterQuickFix[] jUnit5ConverterQuickFixArray = new JUnit5ConverterQuickFix[]{new JUnit5ConverterQuickFix()};
        Intrinsics.checkNotNullExpressionValue((Object)manager.createProblemDescriptor(identifier, JUnitBundle.message("jvm.inspections.junit5.converter.problem.descriptor", new Object[0]), isOnTheFly, (LocalQuickFix[])jUnit5ConverterQuickFixArray, ProblemHighlightType.GENERIC_ERROR_OR_WARNING), (String)"createProblemDescriptor(...)");
        return problemDescriptorArray;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (!this.shouldInspect(psiFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"buildVisitor(...)");
        return psiElementVisitor;
    }
}

