/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProfile;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenPropertyResolver {
    public static final Pattern PATTERN = Pattern.compile("\\$\\{(.+?)}|@(.+?)@");

    public static String resolve(String text2, MavenDomProjectModel projectDom) {
        XmlElement element = projectDom.getXmlElement();
        if (element == null) {
            return text2;
        }
        VirtualFile file = MavenDomUtil.getVirtualFile((PsiElement)element);
        if (file == null) {
            return text2;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(projectDom.getManager().getProject());
        MavenProject mavenProject2 = mavenProjectsManager.findProject(file);
        AdditionalPropertySourceImpl additionalPropertySource = new AdditionalPropertySourceImpl(mavenProject2, projectDom);
        return new MavenPropertyResolverHelper(projectDom, mavenProjectsManager, mavenProject2, additionalPropertySource).filterText(text2);
    }

    @Deprecated
    public static Properties collectPropertiesFromDOM(@Nullable MavenProject project2, MavenDomProjectModel projectDom) {
        Properties result2 = new Properties();
        result2.putAll(MavenPropertyResolver.collectPropertyMapFromDOM(project2, projectDom));
        return result2;
    }

    public static Map<String, String> collectPropertyMapFromDOM(@Nullable MavenProject project2, MavenDomProjectModel projectDom) {
        HashMap<String, String> result2 = new HashMap<String, String>();
        MavenPropertyResolver.collectPropertyMapFromDOM((MavenDomProperties)ReadAction.compute(() -> projectDom.getProperties()), result2);
        if (project2 != null) {
            MavenPropertyResolver.collectPropertiesForActivatedProfiles(project2, projectDom, result2);
        }
        return result2;
    }

    private static void collectPropertiesForActivatedProfiles(@NotNull MavenProject project2, MavenDomProjectModel projectDom, Map<String, String> result2) {
        if (project2 == null) {
            MavenPropertyResolver.$$$reportNull$$$0(0);
        }
        Collection activeProfiles = project2.getActivatedProfilesIds().getEnabledProfiles();
        List profiles2 = (List)ReadAction.compute(() -> projectDom.getProfiles().getProfiles());
        for (MavenDomProfile each : profiles2) {
            XmlTag idTag = each.getId().getXmlTag();
            if (idTag == null || !activeProfiles.contains(idTag.getValue().getTrimmedText())) continue;
            MavenPropertyResolver.collectPropertyMapFromDOM(each.getProperties(), result2);
        }
    }

    private static void collectPropertyMapFromDOM(MavenDomProperties props, Map<String, String> result2) {
        XmlTag propsTag = props.getXmlTag();
        if (propsTag != null) {
            for (XmlTag each : propsTag.getSubTags()) {
                result2.put(each.getName(), each.getValue().getTrimmedText());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenPropertyResolver", "collectPropertiesForActivatedProfiles"));
    }

    private static class AdditionalPropertySourceImpl
    implements AdditionalPropertySource {
        @Nullable
        private final MavenProject mavenProject;
        private final MavenDomProjectModel projectDom;
        private Map<String, String> additionalProperties;

        private AdditionalPropertySourceImpl(@Nullable MavenProject mavenProject2, MavenDomProjectModel projectDom) {
            this.mavenProject = mavenProject2;
            this.projectDom = projectDom;
        }

        @Override
        public String get(String key) {
            if (null == this.additionalProperties) {
                this.additionalProperties = MavenPropertyResolver.collectPropertyMapFromDOM(this.mavenProject, this.projectDom);
            }
            return this.additionalProperties.get(key);
        }
    }

    private static class MavenPropertyResolverHelper {
        private static final Pattern pattern = PATTERN;
        private final MavenDomProjectModel projectDom;
        private final MavenProjectsManager mavenProjectsManager;
        @Nullable
        private final MavenProject mavenProject;
        private final AdditionalPropertySource additionalPropertySource;

        private MavenPropertyResolverHelper(MavenDomProjectModel projectDom, MavenProjectsManager mavenProjectsManager, @Nullable MavenProject mavenProject2, AdditionalPropertySource additionalPropertySource) {
            this.projectDom = projectDom;
            this.mavenProjectsManager = mavenProjectsManager;
            this.mavenProject = mavenProject2;
            this.additionalPropertySource = additionalPropertySource;
        }

        public String filterText(String text2) {
            StringBuilder res = new StringBuilder();
            try {
                this.doFilterText(pattern, text2, null, res);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return res.toString();
        }

        private void doFilterText(Pattern pattern, String text2, @Nullable Map<String, String> resolvedPropertiesParam, Appendable out) throws IOException {
            Map<String, String> resolvedProperties = resolvedPropertiesParam;
            Matcher matcher = pattern.matcher(text2);
            int groupCount = matcher.groupCount();
            int last = 0;
            while (matcher.find()) {
                String propertyValue;
                out.append(text2, last, matcher.start());
                last = matcher.end();
                String propertyName = null;
                for (int i2 = 0; i2 < groupCount && (propertyName = matcher.group(i2 + 1)) == null; ++i2) {
                }
                assert (propertyName != null);
                if (resolvedProperties == null) {
                    resolvedProperties = new HashMap<String, String>();
                }
                if ((propertyValue = resolvedProperties.get(propertyName)) == null) {
                    if (resolvedProperties.containsKey(propertyName)) {
                        out.append(matcher.group());
                        continue;
                    }
                    String resolved = this.mavenProject != null ? this.doResolvePropertyForMavenProject(propertyName) : this.doResolvePropertyForMavenDomModel(propertyName);
                    if (resolved == null) {
                        out.append(matcher.group());
                        continue;
                    }
                    resolvedProperties.put(propertyName, null);
                    StringBuilder sb = new StringBuilder();
                    this.doFilterText(pattern, resolved, resolvedProperties, sb);
                    propertyValue = sb.toString();
                    resolvedProperties.put(propertyName, propertyValue);
                }
                out.append(propertyValue);
            }
            out.append(text2, last, text2.length());
        }

        @Nullable
        private String doResolvePropertyForMavenProject(String propName) {
            String javaVersion;
            String jreDir;
            boolean hasPrefix = false;
            String unprefixed = propName;
            if (propName.startsWith("pom.")) {
                unprefixed = propName.substring("pom.".length());
                hasPrefix = true;
            } else if (propName.startsWith("project.")) {
                unprefixed = propName.substring("project.".length());
                hasPrefix = true;
            }
            MavenProject selectedProject = this.mavenProject;
            while (unprefixed.startsWith("parent.")) {
                if (selectedProject == null) {
                    return null;
                }
                MavenId parentId2 = selectedProject.getParentId();
                if (parentId2 == null) {
                    return null;
                }
                if ((unprefixed = unprefixed.substring("parent.".length())).equals("groupId")) {
                    return parentId2.getGroupId();
                }
                if (unprefixed.equals("artifactId")) {
                    return parentId2.getArtifactId();
                }
                if (unprefixed.equals("version")) {
                    return parentId2.getVersion();
                }
                selectedProject = this.mavenProjectsManager.findProject(parentId2);
                if (selectedProject != null) continue;
                return null;
            }
            if (unprefixed.equals("basedir") || hasPrefix && this.mavenProject == selectedProject && unprefixed.equals("baseUri")) {
                return null == selectedProject ? null : selectedProject.getDirectory();
            }
            if ("java.home".equals(propName) && null != this.mavenProject && (jreDir = MavenUtil.getModuleJreHome(this.mavenProjectsManager, this.mavenProject)) != null) {
                return jreDir;
            }
            if ("java.version".equals(propName) && null != this.mavenProject && (javaVersion = MavenUtil.getModuleJavaVersion(this.mavenProjectsManager, this.mavenProject)) != null) {
                return javaVersion;
            }
            String result2 = MavenUtil.getPropertiesFromMavenOpts().get(propName);
            if (result2 != null) {
                return result2;
            }
            if (null == this.mavenProject) {
                return null;
            }
            result2 = this.mavenProject.getMavenConfig().get(propName);
            if (result2 != null) {
                return result2;
            }
            result2 = this.mavenProject.getJvmConfig().get(propName);
            if (result2 != null) {
                return result2;
            }
            result2 = MavenServerUtil.collectSystemProperties().getProperty(propName);
            if (result2 != null) {
                return result2;
            }
            result2 = selectedProject.getModelMap().get(unprefixed);
            if (result2 != null) {
                return result2;
            }
            result2 = this.additionalPropertySource.get(propName);
            if (result2 != null) {
                return result2;
            }
            result2 = this.mavenProject.getProperties().getProperty(propName);
            if (result2 != null) {
                return result2;
            }
            if ("settings.localRepository".equals(propName)) {
                return this.mavenProject.getLocalRepository().getAbsolutePath();
            }
            return null;
        }

        @Nullable
        private String doResolvePropertyForMavenDomModel(String propName) {
            if (propName.startsWith("parent.")) {
                MavenDomParent parentDomElement = this.projectDom.getMavenParent();
                if (!parentDomElement.exists()) {
                    return null;
                }
                MavenId parentId2 = new MavenId(parentDomElement.getGroupId().getStringValue(), parentDomElement.getArtifactId().getStringValue(), parentDomElement.getVersion().getStringValue());
                if ((propName = propName.substring("parent.".length())).equals("groupId")) {
                    return parentId2.getGroupId();
                }
                if (propName.equals("artifactId")) {
                    return parentId2.getArtifactId();
                }
                if (propName.equals("version")) {
                    return parentId2.getVersion();
                }
                return null;
            }
            String result2 = MavenUtil.getPropertiesFromMavenOpts().get(propName);
            if (result2 != null) {
                return result2;
            }
            result2 = MavenServerUtil.collectSystemProperties().getProperty(propName);
            if (result2 != null) {
                return result2;
            }
            result2 = this.additionalPropertySource.get(propName);
            if (result2 != null) {
                return result2;
            }
            if ("settings.localRepository".equals(propName)) {
                return MavenProjectsManager.getInstance(this.projectDom.getManager().getProject()).getLocalRepository().getAbsolutePath();
            }
            return null;
        }
    }

    static interface AdditionalPropertySource {
        public String get(String var1);
    }
}

