/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters.repositories;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.xmlb.XmlSerializer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.repositories.beans.RepositoriesBean;
import org.jetbrains.idea.maven.dom.converters.repositories.beans.RepositoryBeanInfo;

@Service(value={Service.Level.APP})
public final class MavenRepositoriesProvider {
    final Map<String, RepositoryBeanInfo> myRepositoriesMap = new HashMap<String, RepositoryBeanInfo>();

    public static MavenRepositoriesProvider getInstance() {
        return (MavenRepositoriesProvider)ApplicationManager.getApplication().getService(MavenRepositoriesProvider.class);
    }

    public MavenRepositoriesProvider() {
        RepositoriesBean repositoriesBean = (RepositoriesBean)XmlSerializer.deserialize((URL)MavenRepositoriesProvider.class.getResource("repositories.xml"), RepositoriesBean.class);
        RepositoryBeanInfo[] repositories = repositoriesBean.getRepositories();
        assert (repositories != null);
        for (RepositoryBeanInfo repository : repositories) {
            this.registerRepository(repository.getId(), repository);
        }
    }

    public void registerRepository(@NotNull String id, RepositoryBeanInfo info) {
        if (id == null) {
            MavenRepositoriesProvider.$$$reportNull$$$0(0);
        }
        this.myRepositoriesMap.put(id, info);
    }

    @NotNull
    public Set<String> getRepositoryIds() {
        Set<String> set2 = this.myRepositoriesMap.keySet();
        if (set2 == null) {
            MavenRepositoriesProvider.$$$reportNull$$$0(1);
        }
        return set2;
    }

    @Nullable
    public String getRepositoryName(@Nullable String id) {
        RepositoryBeanInfo pair = this.myRepositoriesMap.get(id);
        return pair != null ? pair.getName() : null;
    }

    @Nullable
    public String getRepositoryUrl(@Nullable String id) {
        RepositoryBeanInfo pair = this.myRepositoriesMap.get(id);
        return pair != null ? pair.getUrl() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoriesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoriesProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerRepository";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

