/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProjectBundle;

public class MavenDuplicatePluginInspection
extends DomElementsInspection<MavenDomProjectModel> {
    public MavenDuplicatePluginInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    public void checkFileElement(@NotNull DomFileElement<MavenDomProjectModel> domFileElement, @NotNull DomElementAnnotationHolder holder) {
        if (domFileElement == null) {
            MavenDuplicatePluginInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            MavenDuplicatePluginInspection.$$$reportNull$$$0(1);
        }
        MavenDomProjectModel projectModel = (MavenDomProjectModel)domFileElement.getRootElement();
        MultiMap duplicates = MultiMap.createSet();
        for (MavenDomPlugin plugin : projectModel.getBuild().getPlugins().getPlugins()) {
            String groupId = plugin.getGroupId().getStringValue();
            String artifactId = plugin.getArtifactId().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)artifactId)) continue;
            if ("".equals(groupId) || "org.apache.maven.plugins".equals(groupId) || "org.codehaus.mojo".equals(groupId)) {
                groupId = null;
            }
            duplicates.putValue((Object)Pair.create((Object)groupId, (Object)artifactId), (Object)plugin);
        }
        for (Map.Entry entry : duplicates.entrySet()) {
            Collection set2 = (Collection)entry.getValue();
            if (set2.size() <= 1) continue;
            for (MavenDomPlugin dependency : set2) {
                holder.createProblem((DomElement)dependency, HighlightSeverity.WARNING, MavenProjectBundle.message("inspection.message.duplicated.plugin.declaration", new Object[0]));
            }
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            MavenDuplicatePluginInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "MavenDuplicatePluginInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            MavenDuplicatePluginInspection.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domFileElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/inspections/MavenDuplicatePluginInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/inspections/MavenDuplicatePluginInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFileElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

