/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.execution.build.MavenExecutionEnvironmentProvider;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenApplicationConfigurationExecutionEnvironmentProvider
implements MavenExecutionEnvironmentProvider {
    @Override
    public boolean isApplicable(@NotNull ExecuteRunConfigurationTask task2) {
        if (task2 == null) {
            MavenApplicationConfigurationExecutionEnvironmentProvider.$$$reportNull$$$0(0);
        }
        return task2.getRunProfile() instanceof ApplicationConfiguration;
    }

    @Override
    @Nullable
    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project2, @NotNull ExecuteRunConfigurationTask task2, @Nullable Executor executor) {
        if (project2 == null) {
            MavenApplicationConfigurationExecutionEnvironmentProvider.$$$reportNull$$$0(1);
        }
        if (task2 == null) {
            MavenApplicationConfigurationExecutionEnvironmentProvider.$$$reportNull$$$0(2);
        }
        ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)task2.getRunProfile();
        MavenExecConfigurationFactory configurationFactory = new MavenExecConfigurationFactory(applicationConfiguration);
        String mainClassName = applicationConfiguration.getMainClassName();
        if (StringUtil.isEmpty((String)mainClassName)) {
            return null;
        }
        Module module2 = ((JavaRunConfigurationModule)applicationConfiguration.getConfigurationModule()).getModule();
        if (module2 == null) {
            return null;
        }
        MavenProject mavenProject2 = MavenProjectsManager.getInstance(project2).findProject(module2);
        if (mavenProject2 == null) {
            return null;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance((Project)project2).createConfiguration(applicationConfiguration.getName(), (ConfigurationFactory)configurationFactory);
        MyExecRunConfiguration mavenRunConfiguration = (MyExecRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
        mavenRunConfiguration.setBeforeRunTasks(applicationConfiguration.getBeforeRunTasks());
        MavenApplicationConfigurationExecutionEnvironmentProvider.copyLogParameters(applicationConfiguration, mavenRunConfiguration);
        MavenRunnerParameters runnerParameters = mavenRunConfiguration.getRunnerParameters();
        runnerParameters.setWorkingDirPath(mavenProject2.getDirectory());
        runnerParameters.setPomFileName(mavenProject2.getFile().getName());
        JavaParameters javaParameters = new JavaParameters();
        JavaParametersUtil.configureConfiguration((SimpleJavaParameters)javaParameters, (CommonJavaRunConfigurationParameters)applicationConfiguration);
        ParametersList execArgs = new ParametersList();
        execArgs.addAll(javaParameters.getVMParametersList().getList());
        execArgs.add("-classpath");
        execArgs.add("%classpath");
        execArgs.add(mainClassName);
        execArgs.addParametersString(applicationConfiguration.getProgramParameters());
        String execExecutable = MavenApplicationConfigurationExecutionEnvironmentProvider.getJdkExecPath(applicationConfiguration);
        if (execExecutable == null) {
            throw new RuntimeException(ExecutionBundle.message((String)"run.configuration.cannot.find.vm.executable", (Object[])new Object[0]));
        }
        String workingDirectory = ProgramParametersUtil.getWorkingDir((CommonProgramRunConfigurationParameters)applicationConfiguration, (Project)project2, (Module)module2);
        List<String> goals = runnerParameters.getGoals();
        if (StringUtil.isNotEmpty((String)workingDirectory)) {
            goals.add("-Dexec.workingdir=" + workingDirectory);
        }
        goals.add("-Dexec.args=" + execArgs.getParametersString());
        goals.add("-Dexec.executable=" + FileUtil.toSystemDependentName((String)execExecutable));
        goals.add("exec:exec");
        if (executor == null) {
            executor = DefaultRunExecutor.getRunExecutorInstance();
        }
        return new ExecutionEnvironmentBuilder(project2, executor).runProfile((RunProfile)mavenRunConfiguration).runnerAndSettings(ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runnerAndConfigurationSettings.getConfiguration()), runnerAndConfigurationSettings).build();
    }

    private static String getJdkExecPath(@NotNull ApplicationConfiguration applicationConfiguration) {
        if (applicationConfiguration == null) {
            MavenApplicationConfigurationExecutionEnvironmentProvider.$$$reportNull$$$0(3);
        }
        Project project2 = applicationConfiguration.getProject();
        try {
            Sdk jdk2 = JavaParametersUtil.createProjectJdk((Project)project2, (String)applicationConfiguration.getAlternativeJrePath());
            if (jdk2 == null) {
                throw new RuntimeException(ExecutionBundle.message((String)"run.configuration.error.no.jdk.specified", (Object[])new Object[0]));
            }
            SdkTypeId type2 = jdk2.getSdkType();
            if (!(type2 instanceof JavaSdkType)) {
                throw new RuntimeException(ExecutionBundle.message((String)"run.configuration.error.no.jdk.specified", (Object[])new Object[0]));
            }
            return ((JavaSdkType)type2).getVMExecutablePath(jdk2);
        }
        catch (CantRunException e) {
            ExecutionErrorDialog.show((ExecutionException)((Object)e), (String)RunnerBundle.message("dialog.title.cannot.use.specified.jre", new Object[0]), (Project)project2);
            return null;
        }
    }

    private static void copyLogParameters(ApplicationConfiguration applicationConfiguration, MavenRunConfiguration mavenRunConfiguration) {
        for (PredefinedLogFile file : applicationConfiguration.getPredefinedLogFiles()) {
            mavenRunConfiguration.addPredefinedLogFile(file);
        }
        for (LogFileOptions op : applicationConfiguration.getLogFiles()) {
            mavenRunConfiguration.addLogFile(op.getPathPattern(), op.getName(), op.isEnabled(), op.isSkipContent(), op.isShowAll());
        }
        mavenRunConfiguration.setFileOutputPath(applicationConfiguration.getOutputFilePath());
        mavenRunConfiguration.setSaveOutputToFile(applicationConfiguration.isSaveOutputToFile());
        mavenRunConfiguration.setShowConsoleOnStdOut(applicationConfiguration.isShowConsoleOnStdOut());
        mavenRunConfiguration.setShowConsoleOnStdErr(applicationConfiguration.isShowConsoleOnStdErr());
    }

    public static List<String> patchVmParameters(ParametersList vmParameters) {
        ArrayList<String> patchedVmParameters = new ArrayList<String>(vmParameters.getList());
        Iterator iterator = patchedVmParameters.iterator();
        while (iterator.hasNext()) {
            String parameter = (String)iterator.next();
            if (!parameter.contains("suspend=n,server=y")) continue;
            iterator.remove();
            patchedVmParameters.add(StringUtil.replace((String)parameter, (String)"suspend=n,server=y", (String)"suspend=y,server=y"));
            break;
        }
        return patchedVmParameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationConfiguration";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenApplicationConfigurationExecutionEnvironmentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createExecutionEnvironment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getJdkExecPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MavenExecConfigurationFactory
    extends ConfigurationFactory {
        private final ApplicationConfiguration myApplicationConfiguration;

        protected MavenExecConfigurationFactory(ApplicationConfiguration applicationConfiguration) {
            super((ConfigurationType)MavenRunConfigurationType.getInstance());
            this.myApplicationConfiguration = applicationConfiguration;
        }

        @NotNull
        public String getId() {
            return "Maven";
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project2) {
            if (project2 == null) {
                MavenExecConfigurationFactory.$$$reportNull$$$0(0);
            }
            return new MyExecRunConfiguration(project2, (ConfigurationFactory)this, this.myApplicationConfiguration);
        }

        @NotNull
        public RunConfiguration createConfiguration(@Nullable String name, @NotNull RunConfiguration template) {
            if (template == null) {
                MavenExecConfigurationFactory.$$$reportNull$$$0(1);
            }
            return new MyExecRunConfiguration(template.getProject(), (ConfigurationFactory)this, this.myApplicationConfiguration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenApplicationConfigurationExecutionEnvironmentProvider$MavenExecConfigurationFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTemplateConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyExecRunConfiguration
    extends MavenRunConfiguration {
        private final ApplicationConfiguration myApplicationConfiguration;

        MyExecRunConfiguration(Project project2, ConfigurationFactory configurationFactory, ApplicationConfiguration applicationConfiguration) {
            super(project2, configurationFactory, applicationConfiguration.getName());
            this.myApplicationConfiguration = applicationConfiguration;
        }

        @Override
        @NotNull
        public RemoteConnectionCreator createRemoteConnectionCreator(final JavaParameters javaParameters) {
            return new RemoteConnectionCreator(){

                public RemoteConnection createRemoteConnection(ExecutionEnvironment environment) {
                    try {
                        JavaParameters parameters = new JavaParameters();
                        parameters.setJdk(JavaParametersUtil.createProjectJdk((Project)this.getProject(), (String)myApplicationConfiguration.getAlternativeJrePath()));
                        RemoteConnection connection = new RemoteConnectionBuilder(false, DebuggerSettings.getInstance().getTransport(), "").asyncAgent(true).project(environment.getProject()).create(parameters);
                        ParametersList programParametersList = javaParameters.getProgramParametersList();
                        String execArgsPrefix = "-Dexec.args=";
                        int execArgsIndex = ContainerUtil.indexOf((List)programParametersList.getList(), s -> s.startsWith(execArgsPrefix));
                        String execArgsStr = programParametersList.get(execArgsIndex);
                        ParametersList execArgs = new ParametersList();
                        execArgs.addAll(MavenApplicationConfigurationExecutionEnvironmentProvider.patchVmParameters(parameters.getVMParametersList()));
                        execArgs.addParametersString(execArgsStr.substring(execArgsPrefix.length()));
                        String classPath = FileUtil.toSystemDependentName((String)parameters.getClassPath().getPathsString());
                        execArgs.replaceOrPrepend("%classpath", "%classpath" + File.pathSeparator + classPath);
                        programParametersList.set(execArgsIndex, execArgsPrefix + execArgs.getParametersString());
                        return connection;
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException("Cannot create debug connection", e);
                    }
                }

                public boolean isPollConnection() {
                    return true;
                }
            };
        }
    }
}

