/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.util.Key;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.MavenSpyOutputParser;

public class MavenSimpleConsoleEventsBuffer {
    private final TypedBuffer myBuffer;
    private final BiConsumer<String, Key<String>> myConsumer;
    private final boolean myShowSpyOutput;

    public MavenSimpleConsoleEventsBuffer(BiConsumer<String, Key<String>> consumer, boolean showSpyOutput) {
        this.myConsumer = consumer;
        this.myShowSpyOutput = showSpyOutput;
        this.myBuffer = new TypedBuffer(consumer);
    }

    public void addText(@NotNull String text2, @NotNull Key<String> outputType) {
        if (text2 == null) {
            MavenSimpleConsoleEventsBuffer.$$$reportNull$$$0(0);
        }
        if (outputType == null) {
            MavenSimpleConsoleEventsBuffer.$$$reportNull$$$0(1);
        }
        if (this.myShowSpyOutput) {
            this.myConsumer.accept(text2, outputType);
            return;
        }
        this.myBuffer.append(text2, outputType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "outputType";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/execution/MavenSimpleConsoleEventsBuffer";
        objectArray[2] = "addText";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class TypedBuffer {
        private final BiConsumer<String, @NotNull Key<String>> myConsumer;
        private final StringBuilder myBuilder = new StringBuilder();
        private Key<String> myOutputType;
        private boolean myIsProcessingSpyNow;

        private TypedBuffer(BiConsumer<String, @NotNull Key<String>> consumer) {
            this.myConsumer = consumer;
        }

        private void reset() {
            this.myBuilder.setLength(0);
            this.myOutputType = null;
        }

        private void sendAndReset() {
            this.myConsumer.accept(this.getText(), this.myOutputType);
            this.reset();
        }

        private String getText() {
            return this.myBuilder.toString();
        }

        private boolean canAppend(@NotNull Key<String> outputType) {
            Key<String> currentOutputType;
            if (outputType == null) {
                TypedBuffer.$$$reportNull$$$0(0);
            }
            return null == (currentOutputType = this.myOutputType) || currentOutputType.toString().equals(outputType.toString());
        }

        public void append(@NotNull String text2, @NotNull Key<String> outputType) {
            boolean lastChunk;
            if (text2 == null) {
                TypedBuffer.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                TypedBuffer.$$$reportNull$$$0(2);
            }
            boolean bl = lastChunk = text2.charAt(text2.length() - 1) == '\n';
            if (this.myIsProcessingSpyNow) {
                this.myIsProcessingSpyNow = !lastChunk;
                return;
            }
            if (!this.canAppend(outputType)) {
                this.sendAndReset();
            }
            this.myBuilder.append(text2);
            this.myOutputType = outputType;
            if (this.myBuilder.length() >= "[IJ]-".length() || lastChunk) {
                if (!MavenSpyOutputParser.isSpyLog(this.getText())) {
                    this.sendAndReset();
                } else {
                    this.myIsProcessingSpyNow = !lastChunk;
                    this.reset();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenSimpleConsoleEventsBuffer$TypedBuffer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canAppend";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "append";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

