/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.importing.MavenAnnotationProcessorConfigurator;
import org.jetbrains.idea.maven.importing.MavenAnnotationProcessorConfiguratorKt;
import org.jetbrains.idea.maven.importing.MavenAnnotationProcessorConfiguratorUtil;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenModuleType;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenResolveResultProblemProcessor;
import org.jetbrains.idea.maven.server.MavenArtifactResolveResult;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001NB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016J2\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JL\u0010\u0015\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u001a\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u001a\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b0\u00192\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001f0\u001eH\u0002J<\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00172\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0019H\u0002J<\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0012\u0018\u00010)2\u0006\u0010*\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00140\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010,\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\f2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bH\u0002J \u0010-\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u001cH\u0002JB\u00100\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u001cH\u0002J\u0010\u00105\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\fH\u0016J\u0010\u00106\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u00107\u001a\u00020\u0012H\u0016J\u001c\u00108\u001a\u00020\u00122\b\u00109\u001a\u0004\u0018\u00010\u00102\b\u0010:\u001a\u0004\u0018\u00010\u0010H\u0002J(\u0010;\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\f2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016JZ\u0010@\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020$2\u0006\u0010*\u001a\u00020\f2\u0006\u0010<\u001a\u00020=2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001c0E2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u001bH\u0016J&\u0010H\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020\f2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LJ\u0010\u0010M\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\fH\u0002\u00a8\u0006O"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "()V", "afterModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$AppliedModelContext;", "beforeModelApplied", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "cleanAndMergeModuleProfiles", "rootProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "compilerConfiguration", "Lcom/intellij/compiler/CompilerConfigurationImpl;", "moduleProfile", "Lorg/jetbrains/jps/model/java/compiler/ProcessorConfigProfile;", "isDefault", "", "module", "Lcom/intellij/openapi/module/Module;", "collectProcessorModuleNames", "projects", "", "moduleNameByProjectId", "Ljava/util/function/Function;", "Lorg/jetbrains/idea/maven/model/MavenId;", "", "", "result", "", "", "configureProfiles", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "projectsWithModules", "Lorg/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator$MavenProjectWithProcessorModules;", "moduleByName", "createOrUpdateProfile", "Lcom/intellij/openapi/util/Pair;", "mavenProject", "processorModules", "getAnnotationProcessorPath", "getAnnotationsDirectoryRelativeTo", "isTest", "relativeTo", "getModuleProfile", "moduleProfileName", "outputRelativeToContentRoot", "annotationProcessorDirectory", "testAnnotationProcessorDirectory", "isApplicable", "isLevelMoreThan6", "isMigratedToConfigurator", "isSimilarProfiles", "profile1", "profile2", "postProcess", "changes", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "modifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "process", "rootModel", "Lorg/jetbrains/idea/maven/importing/MavenRootModelAdapter;", "mavenModel", "mavenProjectToModuleName", "", "postTasks", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "resolve", "nativeMavenProject", "Lorg/jetbrains/idea/maven/server/NativeMavenProjectHolder;", "embedder", "Lorg/jetbrains/idea/maven/server/MavenEmbedderWrapper;", "shouldEnableAnnotationProcessors", "MavenProjectWithProcessorModules", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenAnnotationProcessorConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenAnnotationProcessorConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,503:1\n1603#2,9:504\n1855#2:513\n1856#2:515\n1612#2:516\n1603#2,9:517\n1855#2:526\n1856#2:528\n1612#2:529\n1#3:514\n1#3:527\n*S KotlinDebug\n*F\n+ 1 MavenAnnotationProcessorConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator\n*L\n67#1:504,9\n67#1:513\n67#1:515\n67#1:516\n239#1:517,9\n239#1:526\n239#1:528\n239#1:529\n67#1:514\n239#1:527\n*E\n"})
public final class MavenAnnotationProcessorConfigurator
extends MavenImporter
implements MavenWorkspaceConfigurator {
    public MavenAnnotationProcessorConfigurator() {
        super("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    @Override
    public boolean isApplicable(@NotNull MavenProject mavenProject2) {
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        return true;
    }

    @Override
    public boolean isMigratedToConfigurator() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Map mavenProjectToModuleNamesCache = new HashMap();
        for (MavenWorkspaceConfigurator.MavenProjectWithModules each : SequencesKt.asIterable(context2.getMavenProjectsWithModules())) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = each.getModules();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                MavenWorkspaceConfigurator.ModuleWithType it = (MavenWorkspaceConfigurator.ModuleWithType)element$iv$iv;
                boolean bl2 = false;
                if ((it.getType().getContainsCode() ? ((ModuleEntity)it.getModule()).getName() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List moduleNames = (List)destination$iv$iv;
            Map map = mavenProjectToModuleNamesCache;
            MavenId mavenId2 = each.getMavenProject().getMavenId();
            Intrinsics.checkNotNullExpressionValue((Object)mavenId2, (String)"getMavenId(...)");
            map.put(mavenId2, moduleNames);
        }
        Sequence changedOnlyProjects2 = SequencesKt.mapNotNull(context2.getMavenProjectsWithModules(), (Function1)beforeModelApplied.changedOnlyProjects.1.INSTANCE);
        HashMap map = new HashMap();
        this.collectProcessorModuleNames(SequencesKt.asIterable((Sequence)changedOnlyProjects2), arg_0 -> MavenAnnotationProcessorConfigurator.beforeModelApplied$lambda$1(mavenProjectToModuleNamesCache, arg_0), map);
        MavenAnnotationProcessorConfiguratorKt.access$getANNOTATION_PROCESSOR_MODULE_NAMES$p().set((UserDataHolder)context2, map);
    }

    public void process(@NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull Module module2, @NotNull MavenRootModelAdapter rootModel, @NotNull MavenProjectsTree mavenModel, @NotNull MavenProject mavenProject2, @NotNull MavenProjectChanges changes, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull List<? extends MavenProjectsProcessorTask> postTasks) {
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
        Intrinsics.checkNotNullParameter((Object)mavenModel, (String)"mavenModel");
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter(mavenProjectToModuleName, (String)"mavenProjectToModuleName");
        Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
        Element config = this.getConfig(mavenProject2, "annotationProcessorPaths");
        if (config == null) {
            return;
        }
        String string = mavenProject2.getAnnotationProcessorDirectory(false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAnnotationProcessorDirectory(...)");
        String annotationTargetDir = string;
        new File(rootModel.toPath(annotationTargetDir).getPath()).mkdirs();
        rootModel.addGeneratedJavaSourceFolder(annotationTargetDir, JavaSourceRootType.SOURCE, false);
        Map map = (Map)MavenAnnotationProcessorConfiguratorKt.access$getANNOTATION_PROCESSOR_MODULE_NAMES$p().get((UserDataHolder)modifiableModelsProvider, new HashMap());
        List<MavenProject> list = List.of(mavenProject2);
        Intrinsics.checkNotNullExpressionValue(list, (String)"of(...)");
        Iterable iterable = list;
        Function<MavenId, List<String>> function = arg_0 -> MavenAnnotationProcessorConfigurator.process$lambda$2(mavenModel, mavenProjectToModuleName, arg_0);
        Intrinsics.checkNotNull((Object)map);
        this.collectProcessorModuleNames(iterable, function, map);
        MavenAnnotationProcessorConfiguratorKt.access$getANNOTATION_PROCESSOR_MODULE_NAMES$p().set((UserDataHolder)modifiableModelsProvider, (Object)map);
    }

    private final void collectProcessorModuleNames(Iterable<? extends MavenProject> projects2, Function<MavenId, List<String>> moduleNameByProjectId, Map<MavenProject, List<String>> result2) {
        for (MavenProject mavenProject2 : projects2) {
            Element config;
            if (!this.shouldEnableAnnotationProcessors(mavenProject2) || (config = this.getConfig(mavenProject2, "annotationProcessorPaths")) == null) continue;
            for (MavenArtifactInfo info : MavenAnnotationProcessorConfiguratorUtil.INSTANCE.getProcessorArtifactInfos(config)) {
                MavenId mavenId2 = new MavenId(info.getGroupId(), info.getArtifactId(), info.getVersion());
                List<String> processorModuleNames = moduleNameByProjectId.apply(mavenId2);
                if (processorModuleNames == null) continue;
                result2.computeIfAbsent(mavenProject2, arg_0 -> MavenAnnotationProcessorConfigurator.collectProcessorModuleNames$lambda$3(collectProcessorModuleNames.1.INSTANCE, arg_0)).addAll((Collection)processorModuleNames);
            }
        }
    }

    @Override
    public void afterModelApplied(@NotNull MavenWorkspaceConfigurator.AppliedModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Map nameToModuleCache = new HashMap();
        for (MavenWorkspaceConfigurator.MavenProjectWithModules each : SequencesKt.asIterable(context2.getMavenProjectsWithModules())) {
            for (MavenWorkspaceConfigurator.ModuleWithType moduleWithType2 : each.getModules()) {
                Module module2 = (Module)moduleWithType2.getModule();
                Map map = nameToModuleCache;
                String string = module2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                map.put(string, module2);
            }
        }
        Function<String, Module> moduleByName = arg_0 -> MavenAnnotationProcessorConfigurator.afterModelApplied$lambda$4(nameToModuleCache, arg_0);
        Object object = MavenAnnotationProcessorConfiguratorKt.access$getANNOTATION_PROCESSOR_MODULE_NAMES$p().get((UserDataHolder)context2, Map.of());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Map perProjectProcessorModuleNames = (Map)object;
        Sequence changedOnly2 = SequencesKt.filter(context2.getMavenProjectsWithModules(), (Function1)afterModelApplied.changedOnly.1.INSTANCE);
        Sequence projectWithModules2 = SequencesKt.map((Sequence)changedOnly2, (Function1)((Function1)new Function1<MavenWorkspaceConfigurator.MavenProjectWithModules<Module>, MavenProjectWithProcessorModules>((Map<MavenProject, ? extends List<String>>)perProjectProcessorModuleNames){
            final /* synthetic */ Map<MavenProject, List<String>> $perProjectProcessorModuleNames;
            {
                this.$perProjectProcessorModuleNames = $perProjectProcessorModuleNames;
                super(1);
            }

            @NotNull
            public final MavenProjectWithProcessorModules invoke(@NotNull MavenWorkspaceConfigurator.MavenProjectWithModules<Module> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                List<String> processorModuleNames = this.$perProjectProcessorModuleNames.getOrDefault(it.getMavenProject(), CollectionsKt.emptyList());
                return new MavenProjectWithProcessorModules(it.getMavenProject(), it.getModules(), processorModuleNames);
            }
        }));
        this.configureProfiles(context2.getProject(), context2.getMavenProjectsTree(), SequencesKt.asIterable((Sequence)projectWithModules2), moduleByName);
    }

    @Override
    public void postProcess(@NotNull Module module2, @NotNull MavenProject mavenProject2, @NotNull MavenProjectChanges changes, @NotNull IdeModifiableModelsProvider modifiableModelsProvider) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Object object = MavenAnnotationProcessorConfiguratorKt.access$getANNOTATION_PROCESSOR_MODULE_NAMES$p().get((UserDataHolder)modifiableModelsProvider, Map.of());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Map map = (Map)object;
        List list = CollectionsKt.emptyList();
        List processorModuleNames = map.getOrDefault(mavenProject2, list);
        MavenWorkspaceConfigurator.ModuleWithType moduleWithType2 = new MavenWorkspaceConfigurator.ModuleWithType<Module>(module2){
            final /* synthetic */ Module $module;
            {
                this.$module = $module;
            }

            @NotNull
            public Module getModule() {
                return this.$module;
            }

            @NotNull
            public MavenModuleType getType() {
                return StandardMavenModuleType.SINGLE_MODULE;
            }
        };
        MavenProjectWithProcessorModules projectWithModules2 = new MavenProjectWithProcessorModules(mavenProject2, CollectionsKt.listOf((Object)moduleWithType2), processorModuleNames);
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        MavenProjectsTree mavenProjectsTree = MavenProjectsManager.getInstance(module2.getProject()).getProjectsTree();
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsTree, (String)"getProjectsTree(...)");
        List<MavenProjectWithProcessorModules> list2 = List.of(projectWithModules2);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"of(...)");
        this.configureProfiles(project2, mavenProjectsTree, (Iterable<MavenProjectWithProcessorModules>)list2, arg_0 -> MavenAnnotationProcessorConfigurator.postProcess$lambda$5(modifiableModelsProvider, arg_0));
    }

    public final void resolve(@NotNull Project project2, @NotNull MavenProject mavenProject2, @NotNull NativeMavenProjectHolder nativeMavenProject, @NotNull MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)nativeMavenProject, (String)"nativeMavenProject");
        Intrinsics.checkNotNullParameter((Object)embedder, (String)"embedder");
        Element config = this.getConfig(mavenProject2, "annotationProcessorPaths");
        if (config == null) {
            return;
        }
        List<MavenArtifactInfo> artifactsInfo = MavenAnnotationProcessorConfiguratorUtil.INSTANCE.getProcessorArtifactInfos(config);
        if (artifactsInfo.isEmpty()) {
            return;
        }
        List externalArtifacts = new ArrayList();
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        MavenProjectsTree mavenProjectsTree = mavenProjectsManager.getProjectsTree();
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsTree, (String)"getProjectsTree(...)");
        MavenProjectsTree tree = mavenProjectsTree;
        for (MavenArtifactInfo info : artifactsInfo) {
            MavenProject mavenArtifact = tree.findProject(new MavenId(info.getGroupId(), info.getArtifactId(), info.getVersion()));
            if (mavenArtifact != null) continue;
            externalArtifacts.add(info);
        }
        try {
            MavenArtifactResolveResult annotationProcessors = embedder.resolveArtifactTransitively(new ArrayList(externalArtifacts), new ArrayList(mavenProject2.getRemoteRepositories()));
            if (annotationProcessors.problem != null) {
                MavenProjectProblem mavenProjectProblem = annotationProcessors.problem;
                Intrinsics.checkNotNull((Object)mavenProjectProblem);
                MavenResolveResultProblemProcessor.notifySyncForProblem(project2, mavenProjectProblem);
            } else {
                mavenProject2.addAnnotationProcessors(annotationProcessors.mavenResolvedArtifacts);
            }
        }
        catch (Exception e) {
            String message = e.getMessage() != null ? e.getMessage() : ExceptionUtil.getThrowableText((Throwable)e);
            MavenSyncConsole mavenSyncConsole = MavenProjectsManager.getInstance(project2).getSyncConsole();
            String string = SyncBundle.message("maven.sync.annotation.processor.problem", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = message;
            Intrinsics.checkNotNull((Object)string2);
            mavenSyncConsole.addWarning(string, string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void configureProfiles(Project project2, MavenProjectsTree tree, Iterable<MavenProjectWithProcessorModules> projectsWithModules, Function<String, Module> moduleByName) {
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project2);
        Intrinsics.checkNotNull((Object)compilerConfiguration, (String)"null cannot be cast to non-null type com.intellij.compiler.CompilerConfigurationImpl");
        CompilerConfigurationImpl compilerConfiguration2 = (CompilerConfigurationImpl)compilerConfiguration;
        for (MavenProjectWithProcessorModules it : projectsWithModules) {
            MavenProject rootProject = tree.findRootProject(it.getMavenProject());
            for (MavenWorkspaceConfigurator.ModuleWithType<Module> moduleWithType2 : it.getMavenProjectModules()) {
                Module module2 = moduleWithType2.getModule();
                MavenModuleType moduleType = moduleWithType2.getType();
                if (!this.isLevelMoreThan6(module2)) continue;
                if (this.shouldEnableAnnotationProcessors(it.getMavenProject()) && moduleType.getContainsCode()) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = it.getProcessorModuleNames();
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Module it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        String it2 = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (moduleByName.apply(it2) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List processorModules = (List)destination$iv$iv;
                    Pair<ProcessorConfigProfile, Boolean> profileIsDefault = this.createOrUpdateProfile(it.getMavenProject(), module2, processorModules, compilerConfiguration2);
                    if (profileIsDefault == null) continue;
                    ProcessorConfigProfile processorConfigProfile = (ProcessorConfigProfile)profileIsDefault.first;
                    Object object = profileIsDefault.second;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
                    this.cleanAndMergeModuleProfiles(rootProject, compilerConfiguration2, processorConfigProfile, (Boolean)object, module2);
                    continue;
                }
                this.cleanAndMergeModuleProfiles(rootProject, compilerConfiguration2, null, false, module2);
            }
        }
    }

    private final Pair<ProcessorConfigProfile, Boolean> createOrUpdateProfile(MavenProject mavenProject2, Module module2, List<? extends Module> processorModules, CompilerConfigurationImpl compilerConfiguration) {
        boolean isDefaultSettings;
        List<String> processors = mavenProject2.getDeclaredAnnotationProcessors();
        Map<String, String> options = mavenProject2.getAnnotationProcessorOptions();
        boolean outputRelativeToContentRoot = false;
        String annotationProcessorDirectory = null;
        String testAnnotationProcessorDirectory = null;
        if (MavenImportUtil.isMainOrTestSubmodule(module2.getName())) {
            outputRelativeToContentRoot = false;
            String string = mavenProject2.getOutputDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputDirectory(...)");
            annotationProcessorDirectory = this.getAnnotationsDirectoryRelativeTo(mavenProject2, false, string);
            String string2 = mavenProject2.getTestOutputDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTestOutputDirectory(...)");
            testAnnotationProcessorDirectory = this.getAnnotationsDirectoryRelativeTo(mavenProject2, true, string2);
        } else {
            String string = mavenProject2.getDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDirectory(...)");
            String mavenProjectDirectory = string;
            outputRelativeToContentRoot = true;
            annotationProcessorDirectory = this.getAnnotationsDirectoryRelativeTo(mavenProject2, false, mavenProjectDirectory);
            testAnnotationProcessorDirectory = this.getAnnotationsDirectoryRelativeTo(mavenProject2, true, mavenProjectDirectory);
        }
        String annotationProcessorPath = this.getAnnotationProcessorPath(mavenProject2, processorModules);
        boolean isDefault = false;
        String moduleProfileName = null;
        boolean bl = isDefaultSettings = ContainerUtil.isEmpty((Collection)processors) && options.isEmpty() && StringUtil.isEmpty((String)annotationProcessorPath);
        if (isDefaultSettings && Intrinsics.areEqual((Object)"target/generated-sources/annotations", (Object)FileUtil.toSystemIndependentName((String)annotationProcessorDirectory)) && Intrinsics.areEqual((Object)"target/generated-test-sources/test-annotations", (Object)FileUtil.toSystemIndependentName((String)testAnnotationProcessorDirectory))) {
            moduleProfileName = "Maven default annotation processors profile";
            isDefault = true;
        } else if (isDefaultSettings && Intrinsics.areEqual((Object)"target/generated-sources/apt", (Object)FileUtil.toSystemIndependentName((String)annotationProcessorDirectory)) && Intrinsics.areEqual((Object)"target/generated-sources/apt-test", (Object)FileUtil.toSystemIndependentName((String)testAnnotationProcessorDirectory))) {
            moduleProfileName = MavenAnnotationProcessorConfiguratorKt.getMAVEN_BSC_DEFAULT_ANNOTATION_PROFILE();
            isDefault = true;
        } else {
            String string = module2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            moduleProfileName = MavenAnnotationProcessorConfiguratorUtil.INSTANCE.getModuleProfileName(string);
            isDefault = false;
        }
        ProcessorConfigProfile moduleProfile = this.getModuleProfile(module2, mavenProject2, compilerConfiguration, moduleProfileName, outputRelativeToContentRoot, annotationProcessorDirectory, testAnnotationProcessorDirectory);
        if (moduleProfile == null) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)annotationProcessorPath)) {
            moduleProfile.setObtainProcessorsFromClasspath(false);
            moduleProfile.setProcessorPath(annotationProcessorPath);
        }
        return Pair.pair((Object)moduleProfile, (Object)isDefault);
    }

    private final ProcessorConfigProfile getModuleProfile(Module module2, MavenProject mavenProject2, CompilerConfigurationImpl compilerConfiguration, String moduleProfileName, boolean outputRelativeToContentRoot, String annotationProcessorDirectory, String testAnnotationProcessorDirectory) {
        ProcessorConfigProfile moduleProfile = compilerConfiguration.findModuleProcessorProfile(moduleProfileName);
        if (moduleProfile == null) {
            moduleProfile = (ProcessorConfigProfile)new ProcessorConfigProfileImpl(moduleProfileName);
            ((ProcessorConfigProfileImpl)moduleProfile).setEnabled(true);
            compilerConfiguration.addModuleProcessorProfile(moduleProfile);
        }
        if (!moduleProfile.isEnabled()) {
            return null;
        }
        moduleProfile.setObtainProcessorsFromClasspath(true);
        moduleProfile.setOutputRelativeToContentRoot(outputRelativeToContentRoot);
        moduleProfile.setGeneratedSourcesDirectoryName(annotationProcessorDirectory, false);
        moduleProfile.setGeneratedSourcesDirectoryName(testAnnotationProcessorDirectory, true);
        moduleProfile.clearProcessorOptions();
        Map<String, String> map = mavenProject2.getAnnotationProcessorOptions();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getAnnotationProcessorOptions(...)");
        for (Map.Entry<String, String> object : map.entrySet()) {
            String key = object.getKey();
            String value = object.getValue();
            moduleProfile.setOption(key, value);
        }
        moduleProfile.clearProcessors();
        List<String> processors = mavenProject2.getDeclaredAnnotationProcessors();
        if (processors != null) {
            for (String processor : processors) {
                moduleProfile.addProcessor(processor);
            }
        }
        moduleProfile.addModuleName(module2.getName());
        return moduleProfile;
    }

    private final boolean isLevelMoreThan6(Module module2) {
        String versionString;
        LanguageLevel languageLevel;
        Sdk sdk = (Sdk)ReadAction.compute(() -> MavenAnnotationProcessorConfigurator.isLevelMoreThan6$lambda$7(module2));
        return sdk == null || (languageLevel = LanguageLevel.parse((String)(versionString = sdk.getVersionString()))) == null || !languageLevel.isLessThan(LanguageLevel.JDK_1_6);
    }

    private final String getAnnotationProcessorPath(MavenProject mavenProject2, List<? extends Module> processorModules) {
        StringJoiner annotationProcessorPath = new StringJoiner(File.pathSeparator);
        Consumer resultAppender = arg_0 -> MavenAnnotationProcessorConfigurator.getAnnotationProcessorPath$lambda$8(annotationProcessorPath, arg_0);
        for (MavenArtifact mavenArtifact : mavenProject2.getExternalAnnotationProcessors()) {
            resultAppender.consume((Object)mavenArtifact.getPath());
        }
        for (Module module2 : processorModules) {
            String[] stringArray;
            OrderEnumerator enumerator;
            Intrinsics.checkNotNullExpressionValue((Object)OrderEnumerator.orderEntries((Module)module2).withoutSdk().productionOnly().runtimeOnly().recursively(), (String)"recursively(...)");
            Intrinsics.checkNotNullExpressionValue((Object)enumerator.classes().getUrls(), (String)"getUrls(...)");
            for (String url : stringArray) {
                resultAppender.consume((Object)JpsPathUtil.urlToPath((String)url));
            }
        }
        String string = annotationProcessorPath.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void cleanAndMergeModuleProfiles(MavenProject rootProject, CompilerConfigurationImpl compilerConfiguration, ProcessorConfigProfile moduleProfile, boolean isDefault, Module module2) {
        List profiles2 = new ArrayList(compilerConfiguration.getModuleProcessorProfiles());
        for (ProcessorConfigProfile p : profiles2) {
            if (p != moduleProfile) {
                p.removeModuleName(module2.getName());
                if (p.getModuleNames().isEmpty()) {
                    String string = p.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (StringsKt.startsWith$default((String)string, (String)"Annotation profile for ", (boolean)false, (int)2, null)) {
                        compilerConfiguration.removeModuleProcessorProfile(p);
                    }
                }
            }
            if (isDefault || moduleProfile == null || !this.isSimilarProfiles(p, moduleProfile)) continue;
            moduleProfile.setEnabled(p.isEnabled());
            String string = rootProject.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            String mavenProjectRootProfileName = MavenAnnotationProcessorConfiguratorUtil.INSTANCE.getModuleProfileName(string);
            ProcessorConfigProfile mergedProfile = compilerConfiguration.findModuleProcessorProfile(mavenProjectRootProfileName);
            if (mergedProfile == null) {
                mergedProfile = (ProcessorConfigProfile)new ProcessorConfigProfileImpl(moduleProfile);
                ((ProcessorConfigProfileImpl)mergedProfile).setName(mavenProjectRootProfileName);
                compilerConfiguration.addModuleProcessorProfile(mergedProfile);
                ((ProcessorConfigProfileImpl)mergedProfile).addModuleNames((Collection)p.getModuleNames());
                p.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(p);
                moduleProfile.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(moduleProfile);
                continue;
            }
            if (p != mergedProfile && !this.isSimilarProfiles(mergedProfile, moduleProfile)) continue;
            if (moduleProfile != mergedProfile) {
                mergedProfile.addModuleNames((Collection)moduleProfile.getModuleNames());
                moduleProfile.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(moduleProfile);
            }
            if (p == mergedProfile) continue;
            mergedProfile.addModuleNames((Collection)p.getModuleNames());
            p.clearModuleNames();
            compilerConfiguration.removeModuleProcessorProfile(p);
        }
    }

    private final boolean isSimilarProfiles(ProcessorConfigProfile profile1, ProcessorConfigProfile profile2) {
        if (profile1 == null || profile2 == null) {
            return false;
        }
        ProcessorConfigProfileImpl p1 = new ProcessorConfigProfileImpl(profile1);
        p1.setName("tmp");
        p1.setEnabled(true);
        p1.clearModuleNames();
        ProcessorConfigProfileImpl p2 = new ProcessorConfigProfileImpl(profile2);
        p2.setName("tmp");
        p2.setEnabled(true);
        p2.clearModuleNames();
        return Intrinsics.areEqual((Object)p1, (Object)p2);
    }

    private final String getAnnotationsDirectoryRelativeTo(MavenProject mavenProject2, boolean isTest, String relativeTo) {
        String string;
        String string2 = mavenProject2.getAnnotationProcessorDirectory(isTest);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAnnotationProcessorDirectory(...)");
        String annotationProcessorDirectory = string2;
        Path path2 = Path.of(annotationProcessorDirectory, new String[0]);
        if (!path2.isAbsolute()) {
            return annotationProcessorDirectory;
        }
        try {
            string = ((Object)Path.of(relativeTo, new String[0]).relativize(path2)).toString();
        }
        catch (IllegalArgumentException e) {
            string = isTest ? "target/generated-test-sources/test-annotations" : "target/generated-sources/annotations";
        }
        return string;
    }

    private final boolean shouldEnableAnnotationProcessors(MavenProject mavenProject2) {
        if (Intrinsics.areEqual((Object)"pom", (Object)mavenProject2.getPackaging())) {
            return false;
        }
        return mavenProject2.getProcMode() != MavenProject.ProcMode.NONE || mavenProject2.findPlugin("org.bsc.maven", "maven-processor-plugin") != null;
    }

    private static final List beforeModelApplied$lambda$1(Map $mavenProjectToModuleNamesCache, MavenId moduleName) {
        Intrinsics.checkNotNullParameter((Object)$mavenProjectToModuleNamesCache, (String)"$mavenProjectToModuleNamesCache");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return (List)$mavenProjectToModuleNamesCache.get(moduleName);
    }

    private static final List process$lambda$2(MavenProjectsTree $mavenModel, Map $mavenProjectToModuleName, MavenId mavenId2) {
        Intrinsics.checkNotNullParameter((Object)$mavenModel, (String)"$mavenModel");
        Intrinsics.checkNotNullParameter((Object)$mavenProjectToModuleName, (String)"$mavenProjectToModuleName");
        MavenProject mavenArtifact = $mavenModel.findProject(mavenId2);
        if (mavenArtifact == null) {
            return null;
        }
        String moduleName = (String)$mavenProjectToModuleName.get(mavenArtifact);
        if (moduleName == null) {
            return null;
        }
        return List.of(moduleName);
    }

    private static final List collectProcessorModuleNames$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final Module afterModelApplied$lambda$4(Map $nameToModuleCache, String moduleName) {
        Intrinsics.checkNotNullParameter((Object)$nameToModuleCache, (String)"$nameToModuleCache");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return (Module)$nameToModuleCache.get(moduleName);
    }

    private static final Module postProcess$lambda$5(IdeModifiableModelsProvider $modifiableModelsProvider, String moduleName) {
        Intrinsics.checkNotNullParameter((Object)$modifiableModelsProvider, (String)"$modifiableModelsProvider");
        String string = moduleName;
        Intrinsics.checkNotNull((Object)string);
        return $modifiableModelsProvider.findIdeModule(string);
    }

    private static final Sdk isLevelMoreThan6$lambda$7(Module $module) {
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        return ModuleRootManager.getInstance((Module)$module).getSdk();
    }

    private static final void getAnnotationProcessorPath$lambda$8(StringJoiner $annotationProcessorPath, String path2) {
        Intrinsics.checkNotNullParameter((Object)$annotationProcessorPath, (String)"$annotationProcessorPath");
        String string = path2;
        Intrinsics.checkNotNull((Object)string);
        $annotationProcessorPath.add(FileUtil.toSystemDependentName((String)string));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator$MavenProjectWithProcessorModules;", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "mavenProjectModules", "", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$ModuleWithType;", "Lcom/intellij/openapi/module/Module;", "processorModuleNames", "", "(Lorg/jetbrains/idea/maven/project/MavenProject;Ljava/util/List;Ljava/util/List;)V", "getMavenProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "getMavenProjectModules", "()Ljava/util/List;", "getProcessorModuleNames", "intellij.maven"})
    private static final class MavenProjectWithProcessorModules {
        @NotNull
        private final MavenProject mavenProject;
        @NotNull
        private final List<MavenWorkspaceConfigurator.ModuleWithType<Module>> mavenProjectModules;
        @NotNull
        private final List<String> processorModuleNames;

        public MavenProjectWithProcessorModules(@NotNull MavenProject mavenProject2, @NotNull List<? extends MavenWorkspaceConfigurator.ModuleWithType<Module>> mavenProjectModules, @NotNull List<String> processorModuleNames) {
            Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
            Intrinsics.checkNotNullParameter(mavenProjectModules, (String)"mavenProjectModules");
            Intrinsics.checkNotNullParameter(processorModuleNames, (String)"processorModuleNames");
            this.mavenProject = mavenProject2;
            this.mavenProjectModules = mavenProjectModules;
            this.processorModuleNames = processorModuleNames;
        }

        @NotNull
        public final MavenProject getMavenProject() {
            return this.mavenProject;
        }

        @NotNull
        public final List<MavenWorkspaceConfigurator.ModuleWithType<Module>> getMavenProjectModules() {
            return this.mavenProjectModules;
        }

        @NotNull
        public final List<String> getProcessorModuleNames() {
            return this.processorModuleNames;
        }
    }
}

