/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.DependencyScope;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleDependency;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntityAndExtensions;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.ide.impl.LegacyBridgeJpsEntitySourceFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenShadePluginConfigurator;
import org.jetbrains.idea.maven.importing.MavenShadePluginConfiguratorKt;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.importing.workspaceModel.WorkspaceModuleImporter;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J4\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenShadePluginConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "()V", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "Lorg/jetbrains/annotations/NotNull;", "addJarDependency", "", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "dependencyMavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "addLibraryEntity", "libraryId", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "libraryRootsProvider", "Lkotlin/Function0;", "", "Lcom/intellij/platform/workspace/jps/entities/LibraryRoot;", "beforeModelApplied", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenShadePluginConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenShadePluginConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenShadePluginConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n800#2,11:156\n*S KotlinDebug\n*F\n+ 1 MavenShadePluginConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenShadePluginConfigurator\n*L\n55#1:156,11\n*E\n"})
public final class MavenShadePluginConfigurator
implements MavenWorkspaceConfigurator {
    @NotNull
    private final ProjectModelExternalSource externalSource;

    public MavenShadePluginConfigurator() {
        ProjectModelExternalSource projectModelExternalSource = ExternalProjectSystemRegistry.getInstance().getSourceById(WorkspaceModuleImporter.Companion.getEXTERNAL_SOURCE_ID());
        Intrinsics.checkNotNullExpressionValue((Object)projectModelExternalSource, (String)"getSourceById(...)");
        this.externalSource = projectModelExternalSource;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!Registry.is((String)"maven.shade.plugin.create.uber.jar.dependency")) {
            return;
        }
        List shadeProjectsWithModules2 = SequencesKt.toList((Sequence)SequencesKt.filter(context2.getMavenProjectsWithModules(), (Function1)beforeModelApplied.shadeProjectsWithModules.1.INSTANCE));
        if (shadeProjectsWithModules2.isEmpty()) {
            return;
        }
        Set shadedMavenProjectsToBuildUberJar = new LinkedHashSet();
        HashMap shadeModuleIdToMavenProject = new HashMap();
        for (MavenWorkspaceConfigurator.MavenProjectWithModules shadeProjectWithModules : shadeProjectsWithModules2) {
            for (MavenWorkspaceConfigurator.ModuleWithType module2 : shadeProjectWithModules.getModules()) {
                ((Map)shadeModuleIdToMavenProject).put(((ModuleEntity)module2.getModule()).getSymbolicId(), shadeProjectWithModules.getMavenProject());
            }
        }
        Set set2 = shadeModuleIdToMavenProject.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        Set shadeModuleIds = set2;
        for (ModuleEntity module3 : ((MutableEntityStorage)context2.getStorage()).entities(ModuleEntity.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = module3.getDependencies();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ModuleDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (ModuleDependency dependency : (List)destination$iv$iv) {
                ModuleId dependencyModuleId = dependency.getModule();
                if (!shadeModuleIds.contains(dependencyModuleId)) continue;
                Object v = shadeModuleIdToMavenProject.get(dependencyModuleId);
                Intrinsics.checkNotNull(v);
                MavenProject mavenProject2 = (MavenProject)v;
                this.addJarDependency((MutableEntityStorage)context2.getStorage(), context2.getProject(), module3, mavenProject2);
                shadedMavenProjectsToBuildUberJar.add(mavenProject2);
            }
        }
        context2.putUserDataIfAbsent(MavenShadePluginConfiguratorKt.access$getSHADED_MAVEN_PROJECTS$p(), shadedMavenProjectsToBuildUberJar);
    }

    private final void addJarDependency(MutableEntityStorage builder2, Project project2, ModuleEntity module2, MavenProject dependencyMavenProject) {
        String libraryName = "Maven Shade: " + dependencyMavenProject.getMavenId().getDisplayString();
        LibraryId libraryId = new LibraryId(libraryName, (LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE);
        MavenId mavenId2 = dependencyMavenProject.getMavenId();
        Intrinsics.checkNotNullExpressionValue((Object)mavenId2, (String)"getMavenId(...)");
        MavenId mavenId3 = mavenId2;
        String fileName = mavenId3.getArtifactId() + "-" + mavenId3.getVersion() + ".jar";
        String[] stringArray = new String[]{fileName};
        Path path2 = Path.of(dependencyMavenProject.getBuildDirectory(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        String jarPath = ((Object)path2).toString();
        VirtualFileUrl jarUrl = WorkspaceModel.Companion.getInstance(project2).getVirtualFileUrlManager().getOrCreateFromUri("jar://" + jarPath + "!/");
        this.addLibraryEntity(builder2, project2, libraryId, (Function0<? extends List<LibraryRoot>>)((Function0)new Function0<List<? extends LibraryRoot>>(jarUrl){
            final /* synthetic */ VirtualFileUrl $jarUrl;
            {
                this.$jarUrl = $jarUrl;
                super(0);
            }

            @NotNull
            public final List<LibraryRoot> invoke() {
                return CollectionsKt.listOf((Object)new LibraryRoot(this.$jarUrl, LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null));
            }
        }));
        DependencyScope scope = DependencyScope.COMPILE;
        LibraryDependency libraryDependency = new LibraryDependency(libraryId, false, scope);
        ModuleEntityAndExtensions.modifyEntity((MutableEntityStorage)builder2, (ModuleEntity)module2, (Function1)((Function1)new Function1<ModuleEntity.Builder, Unit>(libraryDependency){
            final /* synthetic */ LibraryDependency $libraryDependency;
            {
                this.$libraryDependency = $libraryDependency;
                super(1);
            }

            public final void invoke(@NotNull ModuleEntity.Builder $this$modifyEntity) {
                Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$this$modifyEntity");
                $this$modifyEntity.getDependencies().add(this.$libraryDependency);
            }
        }));
    }

    private final void addLibraryEntity(MutableEntityStorage builder2, Project project2, LibraryId libraryId, Function0<? extends List<LibraryRoot>> libraryRootsProvider2) {
        if (builder2.contains((SymbolicEntityId)libraryId)) {
            return;
        }
        EntitySource librarySource = LegacyBridgeJpsEntitySourceFactory.createEntitySourceForProjectLibrary$default((LegacyBridgeJpsEntitySourceFactory)LegacyBridgeJpsEntitySourceFactory.INSTANCE, (Project)project2, (ProjectModelExternalSource)this.externalSource, null, null, (int)12, null);
        builder2.addEntity((WorkspaceEntity)LibraryEntity.Companion.create$default((LibraryEntity.Companion)LibraryEntity.Companion, (String)libraryId.getName(), (LibraryTableId)libraryId.getTableId(), (List)((List)libraryRootsProvider2.invoke()), (EntitySource)librarySource, null, (int)16, null));
    }
}

