/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.externalSystem.project.ArtifactExternalDependenciesImporter;
import com.intellij.openapi.externalSystem.project.PackagingModel;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporterImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.DefaultPackagingElementResolvingContext;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenModuleType;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.importing.MavenWorkspaceFacetConfiguratorKt;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.importing.workspaceModel.ImporterModifiableArtifactModel;
import org.jetbrains.idea.maven.importing.workspaceModel.WorkspaceProjectImporterKt;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001:\u0001$J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH&J\u0014\u0010\f\u001a\u00020\t2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J0\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016Jb\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006%\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenWorkspaceFacetConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "beforeModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "configureMavenProject", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableMavenProjectContext;", "isApplicable", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "isFacetDetectionDisabled", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$Context;", "preProcess", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "artifactModel", "Lcom/intellij/packaging/artifacts/ModifiableArtifactModel;", "process", "mavenTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "mavenProjectToModuleName", "", "", "packagingModel", "Lcom/intellij/openapi/externalSystem/project/PackagingModel;", "postTasks", "", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "userDataHolder", "Lcom/intellij/openapi/util/UserDataHolderEx;", "FacetPackagingModel", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenWorkspaceFacetConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenWorkspaceFacetConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenWorkspaceFacetConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n689#2:143\n722#2,2:144\n725#2:160\n2333#3,14:146\n*S KotlinDebug\n*F\n+ 1 MavenWorkspaceFacetConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenWorkspaceFacetConfigurator\n*L\n98#1:143\n98#1:144,2\n98#1:160\n99#1:146,14\n*E\n"})
public interface MavenWorkspaceFacetConfigurator
extends MavenWorkspaceConfigurator {
    public boolean isApplicable(@NotNull MavenProject var1);

    public boolean isFacetDetectionDisabled(@NotNull Project var1);

    default public void preProcess(@NotNull MutableEntityStorage storage, @NotNull ModuleEntity module2, @NotNull Project project2, @NotNull MavenProject mavenProject2, @NotNull ModifiableArtifactModel artifactModel) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)artifactModel, (String)"artifactModel");
        this.preProcess(storage, module2);
    }

    default public void preProcess(@NotNull MutableEntityStorage storage, @NotNull ModuleEntity module2) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
    }

    default public void process(@NotNull MutableEntityStorage storage, @NotNull ModuleEntity module2, @NotNull Project project2, @NotNull MavenProject mavenProject2, @NotNull MavenProjectsTree mavenTree, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull PackagingModel packagingModel, @NotNull List<MavenProjectsProcessorTask> postTasks, @NotNull UserDataHolderEx userDataHolder) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)mavenTree, (String)"mavenTree");
        Intrinsics.checkNotNullParameter(mavenProjectToModuleName, (String)"mavenProjectToModuleName");
        Intrinsics.checkNotNullParameter((Object)packagingModel, (String)"packagingModel");
        Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
        Intrinsics.checkNotNullParameter((Object)userDataHolder, (String)"userDataHolder");
    }

    private boolean isFacetDetectionDisabled(MavenWorkspaceConfigurator.Context<?> context2) {
        context2.putUserDataIfAbsent(MavenWorkspaceFacetConfiguratorKt.access$getFACET_DETECTION_DISABLED_KEY$p(), new ConcurrentHashMap());
        Boolean bl = ((ConcurrentHashMap)MavenWorkspaceFacetConfiguratorKt.access$getFACET_DETECTION_DISABLED_KEY$p().get((UserDataHolder)context2)).computeIfAbsent(this, arg_0 -> MavenWorkspaceFacetConfigurator.isFacetDetectionDisabled$lambda$0((Function1)new Function1<MavenWorkspaceFacetConfigurator, Boolean>(this, context2){
            final /* synthetic */ MavenWorkspaceFacetConfigurator this$0;
            final /* synthetic */ MavenWorkspaceConfigurator.Context<?> $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MavenWorkspaceFacetConfigurator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.isFacetDetectionDisabled(this.$context.getProject());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
        return bl;
    }

    @Override
    default public void configureMavenProject(@NotNull MavenWorkspaceConfigurator.MutableMavenProjectContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.isFacetDetectionDisabled(context2)) {
            return;
        }
        Project project2 = context2.getProject();
        MavenWorkspaceConfigurator.MavenProjectWithModules<ModuleEntity> mavenProjectWithModules = context2.getMavenProjectWithModules();
        MavenProject mavenProject2 = mavenProjectWithModules.getMavenProject();
        if (!this.isApplicable(mavenProject2)) {
            return;
        }
        List<MavenWorkspaceConfigurator.ModuleWithType<ModuleEntity>> modules = mavenProjectWithModules.getModules();
        for (MavenWorkspaceConfigurator.ModuleWithType<ModuleEntity> moduleWithType2 : modules) {
            MavenModuleType moduleType = moduleWithType2.getType();
            if (!moduleType.getContainsCode()) continue;
            ModuleEntity module2 = moduleWithType2.getModule();
            MutableEntityStorage mutableEntityStorage = (MutableEntityStorage)context2.getStorage();
            Object object = WorkspaceProjectImporterKt.getARTIFACT_MODEL_KEY().get((UserDataHolder)context2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this.preProcess(mutableEntityStorage, module2, project2, mavenProject2, (ModifiableArtifactModel)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.isFacetDetectionDisabled(context2)) {
            return;
        }
        Project project2 = context2.getProject();
        ImporterModifiableArtifactModel artifactModel = (ImporterModifiableArtifactModel)WorkspaceProjectImporterKt.getARTIFACT_MODEL_KEY().get((UserDataHolder)context2);
        DefaultPackagingElementResolvingContext resolvingContext2 = new DefaultPackagingElementResolvingContext(project2, artifactModel){
            final /* synthetic */ ImporterModifiableArtifactModel $artifactModel;
            {
                this.$artifactModel = $artifactModel;
                super($project);
            }

            @NotNull
            public ArtifactModel getArtifactModel() {
                ImporterModifiableArtifactModel importerModifiableArtifactModel = this.$artifactModel;
                Intrinsics.checkNotNullExpressionValue((Object)importerModifiableArtifactModel, (String)"$artifactModel");
                return (ArtifactModel)importerModifiableArtifactModel;
            }
        };
        Intrinsics.checkNotNull((Object)artifactModel);
        PackagingModel packagingModel = new FacetPackagingModel(artifactModel, (PackagingElementResolvingContext)resolvingContext2);
        Sequence mavenProjectsWithModules = context2.getMavenProjectsWithModules();
        MutableEntityStorage storage = (MutableEntityStorage)context2.getStorage();
        MavenProjectsTree mavenTree = context2.getMavenProjectsTree();
        List postTasks = new ArrayList();
        Sequence $this$associateBy$iv = mavenProjectsWithModules;
        boolean $i$f$associateBy = false;
        Sequence sequence = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Object v0;
            MavenWorkspaceConfigurator.MavenProjectWithModules mavenProjectWithModules = (MavenWorkspaceConfigurator.MavenProjectWithModules)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            MavenWorkspaceConfigurator.MavenProjectWithModules it = (MavenWorkspaceConfigurator.MavenProjectWithModules)element$iv$iv;
            MavenProject mavenProject2 = it.getMavenProject();
            boolean bl2 = false;
            Iterable $this$minByOrNull$iv = it.getModules();
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    MavenWorkspaceConfigurator.ModuleWithType moduleWithType2 = (MavenWorkspaceConfigurator.ModuleWithType)minElem$iv;
                    boolean bl3 = false;
                    int minValue$iv = MavenWorkspaceFacetConfigurator.beforeModelApplied$mavenModuleTypeOrder(moduleWithType2.getType());
                    do {
                        Object e$iv = iterator$iv.next();
                        MavenWorkspaceConfigurator.ModuleWithType moduleWithType3 = (MavenWorkspaceConfigurator.ModuleWithType)e$iv;
                        $i$a$-minByOrNull-MavenWorkspaceFacetConfigurator$beforeModelApplied$mavenProjectToModuleName$2$1 = false;
                        int v$iv = MavenWorkspaceFacetConfigurator.beforeModelApplied$mavenModuleTypeOrder(moduleWithType3.getType());
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v0);
            String string = ((ModuleEntity)((MavenWorkspaceConfigurator.ModuleWithType)v0).getModule()).getName();
            map.put(mavenProject2, string);
        }
        Map mavenProjectToModuleName = destination$iv$iv;
        for (MavenWorkspaceConfigurator.MavenProjectWithModules mavenProjectWithModules : mavenProjectsWithModules) {
            MavenProject mavenProject3 = mavenProjectWithModules.getMavenProject();
            if (!this.isApplicable(mavenProject3)) continue;
            List modules = mavenProjectWithModules.getModules();
            for (MavenWorkspaceConfigurator.ModuleWithType moduleWithType4 : modules) {
                MavenModuleType moduleType = moduleWithType4.getType();
                if (!moduleType.getContainsCode()) continue;
                ModuleEntity module2 = (ModuleEntity)moduleWithType4.getModule();
                this.process(storage, module2, project2, mavenProject3, mavenTree, mavenProjectToModuleName, packagingModel, postTasks, context2);
            }
        }
    }

    private static Boolean isFacetDetectionDisabled$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static int beforeModelApplied$mavenModuleTypeOrder(MavenModuleType type2) {
        int n;
        MavenModuleType mavenModuleType = type2;
        if (mavenModuleType == StandardMavenModuleType.SINGLE_MODULE) {
            n = 0;
        } else if (mavenModuleType == StandardMavenModuleType.MAIN_ONLY) {
            n = 1;
        } else if (mavenModuleType == StandardMavenModuleType.TEST_ONLY) {
            n = 2;
        } else if (mavenModuleType == StandardMavenModuleType.COMPOUND_MODULE) {
            n = 3;
        } else if (mavenModuleType == StandardMavenModuleType.AGGREGATOR) {
            n = 4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenWorkspaceFacetConfigurator$FacetPackagingModel;", "Lcom/intellij/openapi/externalSystem/project/PackagingModel;", "myArtifactModel", "Lcom/intellij/packaging/artifacts/ModifiableArtifactModel;", "myResolvingContext", "Lcom/intellij/packaging/elements/PackagingElementResolvingContext;", "(Lcom/intellij/packaging/artifacts/ModifiableArtifactModel;Lcom/intellij/packaging/elements/PackagingElementResolvingContext;)V", "myDependenciesImporter", "Lcom/intellij/openapi/externalSystem/project/ArtifactExternalDependenciesImporter;", "getArtifactExternalDependenciesImporter", "getModifiableArtifactModel", "getPackagingElementResolvingContext", "intellij.maven"})
    public static final class FacetPackagingModel
    implements PackagingModel {
        @NotNull
        private final ModifiableArtifactModel myArtifactModel;
        @NotNull
        private final PackagingElementResolvingContext myResolvingContext;
        @NotNull
        private final ArtifactExternalDependenciesImporter myDependenciesImporter;

        public FacetPackagingModel(@NotNull ModifiableArtifactModel myArtifactModel, @NotNull PackagingElementResolvingContext myResolvingContext) {
            Intrinsics.checkNotNullParameter((Object)myArtifactModel, (String)"myArtifactModel");
            Intrinsics.checkNotNullParameter((Object)myResolvingContext, (String)"myResolvingContext");
            this.myArtifactModel = myArtifactModel;
            this.myResolvingContext = myResolvingContext;
            this.myDependenciesImporter = (ArtifactExternalDependenciesImporter)new ArtifactExternalDependenciesImporterImpl();
        }

        @NotNull
        public ModifiableArtifactModel getModifiableArtifactModel() {
            return this.myArtifactModel;
        }

        @NotNull
        public PackagingElementResolvingContext getPackagingElementResolvingContext() {
            return this.myResolvingContext;
        }

        @NotNull
        public ArtifactExternalDependenciesImporter getArtifactExternalDependenciesImporter() {
            return this.myDependenciesImporter;
        }
    }
}

