/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.workspaceModel;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.java.workspace.entities.ArtifactEntity;
import com.intellij.java.workspace.entities.ArtifactKt;
import com.intellij.java.workspace.entities.ArtifactPropertiesEntity;
import com.intellij.java.workspace.entities.CompositePackagingElementEntity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.workspaceModel.ide.impl.LegacyBridgeJpsEntitySourceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.workspaceModel.ImporterModifiableArtifact;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0015J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\bH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0016J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#H\u0016\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0&2\u0006\u0010'\u001a\u00020\u000fH\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0016J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u001fH\u0016J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u001fH\u0016J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010\r*\u0006\u0012\u0002\b\u000300H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ImporterModifiableArtifactModel;", "Lcom/intellij/packaging/artifacts/ModifiableArtifactModel;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/workspace/storage/MutableEntityStorage;)V", "artifacts", "", "Lorg/jetbrains/idea/maven/importing/workspaceModel/ImporterModifiableArtifact;", "addArtifact", "Lcom/intellij/packaging/artifacts/ModifiableArtifact;", "name", "", "artifactType", "Lcom/intellij/packaging/artifacts/ArtifactType;", "rootElement", "Lcom/intellij/packaging/elements/CompositePackagingElement;", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "addListener", "", "listener", "Lcom/intellij/packaging/artifacts/ArtifactListener;", "applyToStorage", "commit", "dispose", "findArtifact", "generateUniqueName", "baseName", "getAllArtifactsIncludingInvalid", "Lcom/intellij/packaging/artifacts/Artifact;", "getArtifactByOriginal", "artifact", "getArtifacts", "", "()[Lcom/intellij/packaging/artifacts/Artifact;", "getArtifactsByType", "", "type", "getModifiableCopy", "getOrCreateModifiableArtifact", "getOriginalArtifact", "isModified", "", "removeArtifact", "removeListener", "propertiesTag", "Lcom/intellij/packaging/artifacts/ArtifactProperties;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nImporterModifiableArtifactModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImporterModifiableArtifactModel.kt\norg/jetbrains/idea/maven/importing/workspaceModel/ImporterModifiableArtifactModel\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n37#2,2:235\n288#3,2:237\n766#3:239\n857#3,2:240\n3190#3,10:243\n1855#3,2:253\n1#4:242\n*S KotlinDebug\n*F\n+ 1 ImporterModifiableArtifactModel.kt\norg/jetbrains/idea/maven/importing/workspaceModel/ImporterModifiableArtifactModel\n*L\n118#1:235,2\n119#1:237,2\n122#1:239\n122#1:240,2\n188#1:243,10\n193#1:253,2\n*E\n"})
public final class ImporterModifiableArtifactModel
implements ModifiableArtifactModel {
    @NotNull
    private final Project project;
    @NotNull
    private final MutableEntityStorage storage;
    @NotNull
    private final List<ImporterModifiableArtifact> artifacts;

    public ImporterModifiableArtifactModel(@NotNull Project project2, @NotNull MutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.project = project2;
        this.storage = storage;
        this.artifacts = new ArrayList();
    }

    @NotNull
    public Artifact[] getArtifacts() {
        Collection $this$toTypedArray$iv = this.artifacts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Artifact[0]);
    }

    @Nullable
    public ModifiableArtifact findArtifact(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.artifacts;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ImporterModifiableArtifact it = (ImporterModifiableArtifact)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return artifact;
    }

    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return artifact;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<? extends Artifact> getArtifactsByType(@NotNull ArtifactType type2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Iterable $this$filter$iv = this.artifacts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ImporterModifiableArtifact it = (ImporterModifiableArtifact)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getArtifactType(), (Object)type2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    @NotNull
    public List<? extends Artifact> getAllArtifactsIncludingInvalid() {
        return this.artifacts;
    }

    private final String generateUniqueName(String baseName) {
        String string = UniqueNameGenerator.generateUniqueName((String)baseName, arg_0 -> ImporterModifiableArtifactModel.generateUniqueName$lambda$2((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ ImporterModifiableArtifactModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                Intrinsics.checkNotNull((Object)it);
                return this.this$0.findArtifact(it) == null;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
        return string;
    }

    @NotNull
    public ModifiableArtifact addArtifact(@NotNull String name, @NotNull ArtifactType artifactType, @NotNull CompositePackagingElement<?> rootElement, @Nullable ProjectModelExternalSource externalSource) {
        VirtualFileUrl outputUrl;
        VirtualFileUrl virtualFileUrl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)artifactType, (String)"artifactType");
        Intrinsics.checkNotNullParameter(rootElement, (String)"rootElement");
        String uniqueName = this.generateUniqueName(name);
        String outputPath = ArtifactUtil.getDefaultArtifactOutputPath((String)uniqueName, (Project)this.project);
        VirtualFileUrlManager fileManager = WorkspaceModel.Companion.getInstance(this.project).getVirtualFileUrlManager();
        String string = outputPath;
        if (string != null) {
            String it = string;
            boolean bl = false;
            String string2 = VfsUtilCore.pathToUrl((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathToUrl(...)");
            virtualFileUrl = fileManager.getOrCreateFromUri(string2);
        } else {
            virtualFileUrl = null;
        }
        VirtualFileUrl virtualFileUrl2 = outputUrl = virtualFileUrl;
        Intrinsics.checkNotNull((Object)virtualFileUrl2);
        ImporterModifiableArtifact artifact = new ImporterModifiableArtifact(this.project, uniqueName, artifactType, virtualFileUrl2, rootElement, externalSource);
        this.artifacts.add(artifact);
        return artifact;
    }

    public void removeArtifact(@NotNull Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        TypeIntrinsics.asMutableCollection((Object)this.artifacts).remove(artifact);
    }

    @NotNull
    public ModifiableArtifact getOrCreateModifiableArtifact(@NotNull Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return (ModifiableArtifact)artifact;
    }

    @NotNull
    public Artifact getModifiableCopy(@NotNull Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return artifact;
    }

    public void addListener(@NotNull ArtifactListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removeListener(@NotNull ArtifactListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public boolean isModified() {
        return true;
    }

    public final void applyToStorage() {
        for (ImporterModifiableArtifact artifact : this.artifacts) {
            EntitySource source = LegacyBridgeJpsEntitySourceFactory.INSTANCE.createEntitySourceForArtifact(this.project, artifact.getExternalSource());
            CompositePackagingElement<?> rootElement = artifact.getRootElement();
            WorkspaceEntity workspaceEntity = rootElement.getOrAddEntity(this.storage, source, this.project);
            Intrinsics.checkNotNull((Object)workspaceEntity, (String)"null cannot be cast to non-null type com.intellij.java.workspace.entities.CompositePackagingElementEntity");
            CompositePackagingElementEntity rootElementEntity = (CompositePackagingElementEntity)workspaceEntity;
            String string = artifact.getName();
            String string2 = artifact.getArtifactType().getId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
            ArtifactEntity artifactEntity2 = (ArtifactEntity)this.storage.addEntity((WorkspaceEntity)ArtifactEntity.Companion.create(string, string2, false, source, (Function1)new Function1<ArtifactEntity.Builder, Unit>(artifact, rootElementEntity){
                final /* synthetic */ ImporterModifiableArtifact $artifact;
                final /* synthetic */ CompositePackagingElementEntity $rootElementEntity;
                {
                    this.$artifact = $artifact;
                    this.$rootElementEntity = $rootElementEntity;
                    super(1);
                }

                public final void invoke(@NotNull ArtifactEntity.Builder $this$invoke) {
                    Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                    $this$invoke.setOutputUrl(this.$artifact.getOutputUrl());
                    $this$invoke.setRootElement(this.$rootElementEntity);
                    $this$invoke.setIncludeInProjectBuild(this.$artifact.isBuildOnMake());
                }
            }));
            for (ArtifactPropertiesProvider provider : artifact.getPropertiesProviders()) {
                Iterator iterator;
                String tag;
                block8: {
                    ArtifactProperties<?> properties = artifact.getProperties(provider);
                    if (properties == null) {
                        ArtifactPropertiesEntity it;
                        Iterable $this$partition$iv = artifactEntity2.getCustomProperties();
                        boolean $i$f$partition = false;
                        ArrayList first$iv = new ArrayList();
                        ArrayList second$iv = new ArrayList();
                        for (Object element$iv : $this$partition$iv) {
                            it = (ArtifactPropertiesEntity)element$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it.getProviderType(), (Object)provider.getId())) {
                                first$iv.add(element$iv);
                                continue;
                            }
                            second$iv.add(element$iv);
                        }
                        Pair pair = new Pair(first$iv, second$iv);
                        List toBeRemoved = (List)pair.component1();
                        List filtered = (List)pair.component2();
                        if (!(!((Collection)toBeRemoved).isEmpty())) continue;
                        ArtifactKt.modifyEntity((MutableEntityStorage)this.storage, (ArtifactEntity)artifactEntity2, (Function1)((Function1)new Function1<ArtifactEntity.Builder, Unit>((List<? extends ArtifactPropertiesEntity>)filtered){
                            final /* synthetic */ List<ArtifactPropertiesEntity> $filtered;
                            {
                                this.$filtered = $filtered;
                                super(1);
                            }

                            public final void invoke(@NotNull ArtifactEntity.Builder $this$modifyEntity) {
                                Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$this$modifyEntity");
                                $this$modifyEntity.setCustomProperties(this.$filtered);
                            }
                        }));
                        Iterable $this$forEach$iv = toBeRemoved;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it = (ArtifactPropertiesEntity)element$iv;
                            boolean bl = false;
                            this.storage.removeEntity((WorkspaceEntity)it);
                        }
                        continue;
                    }
                    tag = this.propertiesTag(properties);
                    Iterable iterable = artifactEntity2.getCustomProperties();
                    for (Iterator iterator2 : iterable) {
                        ArtifactPropertiesEntity it = (ArtifactPropertiesEntity)iterator2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getProviderType(), (Object)provider.getId())) continue;
                        iterator = iterator2;
                        break block8;
                    }
                    iterator = null;
                }
                ArtifactPropertiesEntity existingProperty = (ArtifactPropertiesEntity)iterator;
                if (existingProperty == null) {
                    String string3 = provider.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
                    this.storage.addEntity((WorkspaceEntity)ArtifactPropertiesEntity.Companion.create(string3, artifactEntity2.getEntitySource(), (Function1)new Function1<ArtifactPropertiesEntity.Builder, Unit>(artifactEntity2, tag){
                        final /* synthetic */ ArtifactEntity $artifactEntity;
                        final /* synthetic */ String $tag;
                        {
                            this.$artifactEntity = $artifactEntity;
                            this.$tag = $tag;
                            super(1);
                        }

                        public final void invoke(@NotNull ArtifactPropertiesEntity.Builder $this$invoke) {
                            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                            $this$invoke.setArtifact(this.$artifactEntity);
                            $this$invoke.setPropertiesXmlTag(this.$tag);
                        }
                    }));
                    continue;
                }
                ArtifactKt.modifyEntity((MutableEntityStorage)this.storage, (ArtifactPropertiesEntity)existingProperty, (Function1)((Function1)new Function1<ArtifactPropertiesEntity.Builder, Unit>(tag){
                    final /* synthetic */ String $tag;
                    {
                        this.$tag = $tag;
                        super(1);
                    }

                    public final void invoke(@NotNull ArtifactPropertiesEntity.Builder $this$modifyEntity) {
                        Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$this$modifyEntity");
                        $this$modifyEntity.setPropertiesXmlTag(this.$tag);
                    }
                }));
            }
        }
    }

    private final String propertiesTag(ArtifactProperties<?> $this$propertiesTag) {
        String string;
        Object state2 = $this$propertiesTag.getState();
        if (state2 != null) {
            Element element = XmlSerializer.serialize$default((Object)state2, null, (boolean)false, (int)6, null);
            if (element == null) {
                return null;
            }
            Element element2 = element;
            element2.setName("options");
            string = JDOMUtil.write((Element)element2);
        } else {
            string = null;
        }
        return string;
    }

    public void commit() {
    }

    public void dispose() {
    }

    private static final boolean generateUniqueName$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

