/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.indices.MavenArchetypeManager;
import org.jetbrains.idea.maven.indices.MavenGAVIndex;
import org.jetbrains.idea.maven.indices.MavenIndexUtils;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.MavenRepositoryProvider;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.indices.MavenSystemIndicesManager;
import org.jetbrains.idea.maven.indices.MavenUpdatableIndex;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.model.RepositoryKind;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.server.AddArtifactResponse;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.statistics.MavenIndexUsageCollector;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0005?@ABCB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JO\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001925\u0010\u001a\u001a1\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001e\u0012\u0004\u0012\u00020\u00150\u001b\u00a2\u0006\u0002\b\u001fH\u0002J\b\u0010 \u001a\u00020\u0015H\u0002J\b\u0010!\u001a\u00020\u0015H\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010#\u001a\u00020\u000bJ\u0013\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0%H\u0000\u00a2\u0006\u0002\b&J\u001a\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010)J\u0010\u0010+\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010)J$\u0010,\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010)2\b\u0010-\u001a\u0004\u0018\u00010)J\b\u0010.\u001a\u00020\u0015H\u0002J \u0010/\u001a\u00020\b2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00102\u001a\u00020)J\u000e\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\bJ\u0006\u00105\u001a\u00020\u0015J\u0014\u00105\u001a\u00020\u00152\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001507J\b\u00108\u001a\u00020\u0015H\u0007J\u000e\u00109\u001a\u00020\u00152\u0006\u00104\u001a\u00020\bJ\u000e\u0010:\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010;J\u0006\u0010<\u001a\u00020\u0015J\b\u0010=\u001a\u00020\u0015H\u0007J\b\u0010>\u001a\u00020\u0015H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/idea/maven/indices/MavenIndicesManager;", "Lcom/intellij/openapi/Disposable;", "myProject", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "isInit", "", "()Z", "localMavenGavIndex", "Lorg/jetbrains/idea/maven/indices/MavenGAVIndex;", "getLocalMavenGavIndex", "()Lorg/jetbrains/idea/maven/indices/MavenGAVIndex;", "myDownloadListener", "Lorg/jetbrains/idea/maven/indices/MavenIndicesManager$MavenIndexServerDownloadListener;", "myGavIndices", "Ljava/util/concurrent/CopyOnWriteArrayList;", "updateMutex", "Lkotlinx/coroutines/sync/Mutex;", "addToIndexAndNotify", "", "index", "Lorg/jetbrains/idea/maven/indices/MavenUpdatableIndex;", "artifactFile", "Ljava/io/File;", "action", "Lkotlin/Function4;", "Lorg/jetbrains/idea/maven/indices/MavenIndicesManager$MavenIndexerListener;", "Lorg/jetbrains/idea/maven/model/MavenRepositoryInfo;", "", "Lkotlin/ExtensionFunctionType;", "deleteIndicesDirInUnitTests", "dispose", "fixIndex", "getCommonGavIndex", "getGAVIndices", "", "getGAVIndices$intellij_maven", "hasLocalArtifactId", "groupId", "", "artifactId", "hasLocalGroupId", "hasLocalVersion", "version", "initListeners", "scheduleArtifactIndexing", "mavenId", "Lorg/jetbrains/idea/maven/model/MavenId;", "localRepo", "scheduleUpdateContentAll", "explicit", "scheduleUpdateIndicesList", "onUpdate", "Lkotlin/Function0;", "scheduleUpdateIndicesListAndWait", "scheduleUpdateLocalGavContent", "updateIndexList", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateIndicesListSync", "waitForGavUpdateCompleted", "waitForLuceneUpdateCompleted", "Companion", "MavenGAVIndexWrapper", "MavenIndexServerDownloadListener", "MavenIndexerListener", "MavenSearchIndexListener", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenIndicesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenIndicesManager.kt\norg/jetbrains/idea/maven/indices/MavenIndicesManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n288#2,2:327\n288#2,2:329\n766#2:331\n857#2,2:332\n800#2,11:334\n1#3:345\n*S KotlinDebug\n*F\n+ 1 MavenIndicesManager.kt\norg/jetbrains/idea/maven/indices/MavenIndicesManager\n*L\n52#1:327,2\n164#1:329,2\n210#1:331\n210#1:332,2\n212#1:334,11\n*E\n"})
public final class MavenIndicesManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final CopyOnWriteArrayList<MavenGAVIndex> myGavIndices;
    @NotNull
    private final MavenIndexServerDownloadListener myDownloadListener;
    @NotNull
    private final Mutex updateMutex;
    @Topic.AppLevel
    @JvmField
    @NotNull
    public static final Topic<MavenIndexerListener> INDEXER_TOPIC = new Topic(MavenIndexerListener.class.getSimpleName(), MavenIndexerListener.class);

    public MavenIndicesManager(@NotNull Project myProject, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.myProject = myProject;
        this.cs = cs;
        this.myGavIndices = new CopyOnWriteArrayList();
        this.myDownloadListener = new MavenIndexServerDownloadListener(this);
        this.updateMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.initListeners();
    }

    private final MavenGAVIndex getLocalMavenGavIndex() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.myGavIndices;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MavenGAVIndex it = (MavenGAVIndex)element$iv;
                boolean bl = false;
                if (!(it.getRepository().getKind() == RepositoryKind.LOCAL)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public void dispose() {
        this.deleteIndicesDirInUnitTests();
    }

    private final void deleteIndicesDirInUnitTests() {
        if (MavenUtil.isMavenUnitTestModeEnabled()) {
            FileUtil.deleteRecursively((Path)MavenSystemIndicesManager.Companion.getInstance().getIndicesDir());
        }
    }

    @NotNull
    public final MavenGAVIndex getCommonGavIndex() {
        return new MavenGAVIndexWrapper();
    }

    public final void updateIndicesListSync() {
        this.scheduleUpdateIndicesList();
    }

    public final boolean isInit() {
        return true;
    }

    private final void initListeners() {
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        busConnection.subscribe(MavenServerConnector.DOWNLOAD_LISTENER_TOPIC, (Object)this.myDownloadListener);
        Topic<MavenSearchIndex.IndexListener> topic = MavenSearchIndex.INDEX_IS_BROKEN;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"INDEX_IS_BROKEN");
        busConnection.subscribe(topic, (Object)new MavenSearchIndexListener(this));
        MavenRepositoryProvider.EP_NAME.addChangeListener(() -> MavenIndicesManager.initListeners$lambda$1(this), (Disposable)this);
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this);
        Topic<MavenImportListener> topic2 = MavenImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, (Object)new MavenImportListener(this){
            final /* synthetic */ MavenIndicesManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void importFinished(@NotNull Collection<MavenProject> importedProjects, @NotNull List<Module> newModules) {
                Intrinsics.checkNotNullParameter(importedProjects, (String)"importedProjects");
                Intrinsics.checkNotNullParameter(newModules, (String)"newModules");
                this.this$0.scheduleUpdateIndicesList();
            }
        });
    }

    public final void scheduleUpdateIndicesList() {
        this.scheduleUpdateIndicesList((Function0<Unit>)((Function0)scheduleUpdateIndicesList.1.INSTANCE));
    }

    @TestOnly
    public final void scheduleUpdateIndicesListAndWait() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MavenIndicesManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.updateIndexList((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public final void scheduleUpdateIndicesList(@NotNull Function0<Unit> onUpdate) {
        Intrinsics.checkNotNullParameter(onUpdate, (String)"onUpdate");
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, onUpdate, null){
            int label;
            final /* synthetic */ MavenIndicesManager this$0;
            final /* synthetic */ Function0<Unit> $onUpdate;
            {
                this.this$0 = $receiver;
                this.$onUpdate = $onUpdate;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.updateIndexList((Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.$onUpdate.invoke();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Object updateIndexList(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof updateIndexList.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MavenIndicesManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateIndexList((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    MavenLog.LOG.info("Updating index list for project " + this.myProject);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = Mutex.DefaultImpls.lock$default((Mutex)this.updateMutex, null, (Continuation)$continuation, (int)1, null);
                    v1 = v0;
                }
                catch (Exception e) {
                    MavenLog.LOG.error((Throwable)e);
                    return Unit.INSTANCE;
                }
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl34
            }
            case 1: {
                this = (MavenIndicesManager)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl34:
                    // 2 sources

                    existing = (MavenGAVIndex)CollectionsKt.firstOrNull((List)this.myGavIndices);
                    repository = MavenIndexUtils.getLocalRepository(this.myProject);
                    if (existing == null || !Intrinsics.areEqual((Object)existing.getRepository(), (Object)repository)) ** GOTO lbl-1000
                    MavenLog.LOG.info("updating index list for " + this.myProject + " - " + repository + " remains the same, nothing to update");
                    var4_9 = Unit.INSTANCE;
                }
                Mutex.DefaultImpls.unlock$default((Mutex)this.updateMutex, null, (int)1, null);
                MavenSystemIndicesManager.Companion.getInstance().gc();
                return var4_9;
lbl-1000:
                // 1 sources

                {
                    this.myGavIndices.clear();
                    v2 = repository;
                    if (v2 == null) break;
                    it = v2;
                    $i$a$-let-MavenIndicesManager$updateIndexList$2 = false;
                    v3 = existing;
                    MavenLog.LOG.info("updating index list for " + this.myProject + " - will add repository " + it + ", before was " + (MavenRepositoryInfo)(v3 != null ? v3.getRepository() : null));
                    var7_13 = this.myGavIndices;
                    $continuation.L$0 = this;
                    $continuation.L$1 = var7_13;
                    $continuation.label = 2;
                    v4 = MavenSystemIndicesManager.Companion.getInstance().getGAVIndexForRepository(it, (Continuation<? super MavenGAVIndex>)$continuation);
                    ** if (v4 != var10_4) goto lbl56
                }
lbl55:
                // 1 sources

                return var10_4;
lbl56:
                // 1 sources

                ** GOTO lbl64
            }
            case 2: {
                $i$a$-let-MavenIndicesManager$updateIndexList$2 = false;
                var7_13 = (CopyOnWriteArrayList<MavenGAVIndex>)$continuation.L$1;
                this = (MavenIndicesManager)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl64:
                    // 2 sources

                    Boxing.boxBoolean((boolean)var7_13.add((MavenGAVIndex)v4));
                    break;
                }
            }
        }
        Mutex.DefaultImpls.unlock$default((Mutex)this.updateMutex, null, (int)1, null);
        MavenSystemIndicesManager.Companion.getInstance().gc();
        return Unit.INSTANCE;
        finally {
            Mutex.DefaultImpls.unlock$default((Mutex)this.updateMutex, null, (int)1, null);
            MavenSystemIndicesManager.Companion.getInstance().gc();
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean hasLocalGroupId(@Nullable String groupId) {
        MavenGAVIndex localIndex = this.getLocalMavenGavIndex();
        return localIndex != null && groupId != null && localIndex.hasGroupId(groupId);
    }

    public final boolean hasLocalArtifactId(@Nullable String groupId, @Nullable String artifactId) {
        MavenGAVIndex localIndex = this.getLocalMavenGavIndex();
        return localIndex != null && groupId != null && artifactId != null && localIndex.hasArtifactId(groupId, artifactId);
    }

    public final boolean hasLocalVersion(@Nullable String groupId, @Nullable String artifactId, @Nullable String version2) {
        MavenGAVIndex localIndex = this.getLocalMavenGavIndex();
        return localIndex != null && groupId != null && artifactId != null && version2 != null && localIndex.hasVersion(groupId, artifactId, version2);
    }

    public final boolean scheduleArtifactIndexing(@Nullable MavenId mavenId2, @NotNull File artifactFile, @NotNull String localRepo) {
        Intrinsics.checkNotNullParameter((Object)artifactFile, (String)"artifactFile");
        Intrinsics.checkNotNullParameter((Object)localRepo, (String)"localRepo");
        try {
            Object v0;
            block7: {
                Iterable $this$firstOrNull$iv = this.myGavIndices;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MavenGAVIndex it = (MavenGAVIndex)element$iv;
                    boolean bl = false;
                    if (!(it.getRepository().getKind() == RepositoryKind.LOCAL && Intrinsics.areEqual((Object)it.getRepository().getUrl(), (Object)localRepo))) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            MavenGAVIndex localIndex = v0;
            if (localIndex == null) {
                return false;
            }
            if (mavenId2 != null) {
                String groupId = mavenId2.getGroupId();
                String artifactId = mavenId2.getArtifactId();
                String version2 = mavenId2.getVersion();
                if (groupId == null || artifactId == null || version2 == null) {
                    return false;
                }
                if (localIndex.hasVersion(groupId, artifactId, version2)) {
                    return false;
                }
            }
            this.fixIndex(artifactFile);
        }
        catch (AlreadyDisposedException ignore) {
            return false;
        }
        return true;
    }

    public final void scheduleUpdateLocalGavContent(boolean explicit) {
        MavenGAVIndex localIndex = this.getLocalMavenGavIndex();
        if (localIndex instanceof MavenUpdatableIndex) {
            MavenSystemIndicesManager.Companion.getInstance().scheduleUpdateIndexContent$intellij_maven(CollectionsKt.listOf((Object)localIndex), explicit);
        }
    }

    public final void scheduleUpdateContentAll(boolean explicit) {
        ArrayList<MavenGAVIndex> toUpdate = new ArrayList<MavenGAVIndex>();
        MavenGAVIndex localIndex = this.getLocalMavenGavIndex();
        if (localIndex instanceof MavenUpdatableIndex) {
            toUpdate.add(localIndex);
        }
        MavenSystemIndicesManager.Companion.getInstance().scheduleUpdateIndexContent$intellij_maven((List<? extends MavenUpdatableIndex>)toUpdate, explicit);
    }

    /*
     * WARNING - void declaration
     */
    private final void fixIndex(File artifactFile) {
        block2: {
            MavenUpdatableIndex localGavIndex;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            MavenIndexUsageCollector.ADD_ARTIFACT_FROM_POM.log(this.myProject);
            Iterable $this$filter$iv = this.myGavIndices;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MavenGAVIndex it = (MavenGAVIndex)element$iv$iv;
                boolean bl = false;
                if (!(it.getRepository().getKind() == RepositoryKind.LOCAL)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$filterTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MavenUpdatableIndex)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            MavenUpdatableIndex mavenUpdatableIndex = localGavIndex = (MavenUpdatableIndex)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (mavenUpdatableIndex == null) break block2;
            MavenUpdatableIndex it = mavenUpdatableIndex;
            boolean bl = false;
            this.addToIndexAndNotify(it, artifactFile, (Function4<? super MavenIndexerListener, ? super MavenRepositoryInfo, ? super Set<? extends File>, ? super Set<? extends File>, Unit>)((Function4)fixIndex.1.1.INSTANCE));
        }
    }

    private final void addToIndexAndNotify(MavenUpdatableIndex index, File artifactFile, Function4<? super MavenIndexerListener, ? super MavenRepositoryInfo, ? super Set<? extends File>, ? super Set<? extends File>, Unit> action) {
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(index, artifactFile, action, null){
            int label;
            final /* synthetic */ MavenUpdatableIndex $index;
            final /* synthetic */ File $artifactFile;
            final /* synthetic */ Function4<MavenIndexerListener, MavenRepositoryInfo, Set<? extends File>, Set<? extends File>, Unit> $action;
            {
                this.$index = $index;
                this.$artifactFile = $artifactFile;
                this.$action = $action;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        AddArtifactResponse it;
                        Iterable $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        ResultKt.throwOnFailure((Object)object);
                        List<AddArtifactResponse> artifactResponses = this.$index.tryAddArtifacts(CollectionsKt.listOf((Object)this.$artifactFile));
                        Object object2 = ApplicationManager.getApplication().getMessageBus().syncPublisher(MavenIndicesManager.INDEXER_TOPIC);
                        MavenRepositoryInfo mavenRepositoryInfo = this.$index.getRepository();
                        Intrinsics.checkNotNullExpressionValue((Object)mavenRepositoryInfo, (String)"getRepository(...)");
                        Iterable iterable = artifactResponses;
                        MavenRepositoryInfo mavenRepositoryInfo2 = mavenRepositoryInfo;
                        Object object3 = object2;
                        Function4<MavenIndexerListener, MavenRepositoryInfo, Set<? extends File>, Set<? extends File>, Unit> function4 = this.$action;
                        boolean $i$f$filter = false;
                        void var5_8 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (AddArtifactResponse)element$iv$iv;
                            boolean bl = false;
                            if (!(it.indexedMavenId() != null)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Collection<E> collection = (List)destination$iv$iv;
                        Iterable $this$map$iv = collection;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (AddArtifactResponse)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.artifactFile());
                        }
                        collection = (List)destination$iv$iv;
                        $this$map$iv = artifactResponses;
                        collection = CollectionsKt.toSet((Iterable)collection);
                        $i$f$filter = false;
                        $this$mapTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (AddArtifactResponse)element$iv$iv;
                            boolean bl = false;
                            if (!(it.indexedMavenId() == null)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Collection<File> collection2 = (List)destination$iv$iv;
                        $this$map$iv = collection2;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (AddArtifactResponse)item$iv$iv;
                            collection2 = destination$iv$iv;
                            boolean bl = false;
                            collection2.add(it.artifactFile());
                        }
                        collection2 = (List)destination$iv$iv;
                        function4.invoke(object3, (Object)mavenRepositoryInfo2, (Object)collection, (Object)CollectionsKt.toSet((Iterable)collection2));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public final List<MavenGAVIndex> getGAVIndices$intellij_maven() {
        return new ArrayList(this.myGavIndices);
    }

    @TestOnly
    public final void waitForGavUpdateCompleted() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = MavenSystemIndicesManager.Companion.getInstance().waitAllGavsUpdatesCompleted((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @TestOnly
    public final void waitForLuceneUpdateCompleted() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = MavenSystemIndicesManager.Companion.getInstance().waitAllLuceneUpdatesCompleted((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final void initListeners$lambda$1(MavenIndicesManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scheduleUpdateIndicesList();
    }

    @JvmStatic
    @NotNull
    public static final MavenIndicesManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @JvmStatic
    @Nullable
    public static final MavenIndicesManager getInstanceIfCreated(@NotNull Project project2) {
        return Companion.getInstanceIfCreated(project2);
    }

    @JvmStatic
    public static final void addArchetype(@NotNull MavenArchetype archetype) {
        Companion.addArchetype(archetype);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/maven/indices/MavenIndicesManager$Companion;", "", "()V", "INDEXER_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lorg/jetbrains/idea/maven/indices/MavenIndicesManager$MavenIndexerListener;", "userArchetypesFile", "Ljava/nio/file/Path;", "getUserArchetypesFile", "()Ljava/nio/file/Path;", "addArchetype", "", "archetype", "Lorg/jetbrains/idea/maven/model/MavenArchetype;", "getInstance", "Lorg/jetbrains/idea/maven/indices/MavenIndicesManager;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceIfCreated", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MavenIndicesManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(MavenIndicesManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (MavenIndicesManager)object;
        }

        @JvmStatic
        @Nullable
        public final MavenIndicesManager getInstanceIfCreated(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return (MavenIndicesManager)project2.getServiceIfCreated(MavenIndicesManager.class);
        }

        @JvmStatic
        public final void addArchetype(@NotNull MavenArchetype archetype) {
            Intrinsics.checkNotNullParameter((Object)archetype, (String)"archetype");
            MavenArchetypeManager.addArchetype(archetype, this.getUserArchetypesFile());
        }

        private final Path getUserArchetypesFile() {
            Path path2 = MavenSystemIndicesManager.Companion.getInstance().getIndicesDir().resolve("UserArchetypes.xml");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            return path2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/indices/MavenIndicesManager$MavenGAVIndexWrapper;", "Lorg/jetbrains/idea/maven/indices/MavenGAVIndex;", "(Lorg/jetbrains/idea/maven/indices/MavenIndicesManager;)V", "close", "", "releaseIndexContext", "", "getArtifactIds", "", "", "groupId", "getGroupIds", "", "getRepository", "Lorg/jetbrains/idea/maven/model/MavenRepositoryInfo;", "getVersions", "artifactId", "hasArtifactId", "hasGroupId", "hasVersion", "version", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenIndicesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenIndicesManager.kt\norg/jetbrains/idea/maven/indices/MavenIndicesManager$MavenGAVIndexWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,326:1\n1360#2:327\n1446#2,5:328\n1360#2:333\n1446#2,5:334\n1360#2:339\n1446#2,5:340\n1747#2,3:345\n1747#2,3:348\n1747#2,3:351\n*S KotlinDebug\n*F\n+ 1 MavenIndicesManager.kt\norg/jetbrains/idea/maven/indices/MavenIndicesManager$MavenGAVIndexWrapper\n*L\n297#1:327\n297#1:328,5\n301#1:333\n301#1:334,5\n305#1:339\n305#1:340,5\n309#1:345,3\n313#1:348,3\n317#1:351,3\n*E\n"})
    public final class MavenGAVIndexWrapper
    implements MavenGAVIndex {
        @Override
        public void close(boolean releaseIndexContext) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Collection<String> getGroupIds() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = MavenIndicesManager.this.myGavIndices;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                MavenGAVIndex it = (MavenGAVIndex)element$iv$iv;
                boolean bl = false;
                Collection<String> collection = it.getGroupIds();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getGroupIds(...)");
                Iterable list$iv$iv = collection;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Set<String> getArtifactIds(@NotNull String groupId) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Iterable $this$flatMap$iv = MavenIndicesManager.this.myGavIndices;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                MavenGAVIndex it = (MavenGAVIndex)element$iv$iv;
                boolean bl = false;
                Set<String> set2 = it.getArtifactIds(groupId);
                Intrinsics.checkNotNullExpressionValue(set2, (String)"getArtifactIds(...)");
                Iterable list$iv$iv = set2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Set<String> getVersions(@NotNull String groupId, @NotNull String artifactId) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Iterable $this$flatMap$iv = MavenIndicesManager.this.myGavIndices;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                MavenGAVIndex it = (MavenGAVIndex)element$iv$iv;
                boolean bl = false;
                Set<String> set2 = it.getVersions(groupId, artifactId);
                Intrinsics.checkNotNullExpressionValue(set2, (String)"getVersions(...)");
                Iterable list$iv$iv = set2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        @Override
        public boolean hasGroupId(@NotNull String groupId) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
                Iterable $this$any$iv = MavenIndicesManager.this.myGavIndices;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MavenGAVIndex it = (MavenGAVIndex)element$iv;
                        boolean bl2 = false;
                        if (!it.hasGroupId(groupId)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean hasArtifactId(@NotNull String groupId, @NotNull String artifactId) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
                Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
                Iterable $this$any$iv = MavenIndicesManager.this.myGavIndices;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MavenGAVIndex it = (MavenGAVIndex)element$iv;
                        boolean bl2 = false;
                        if (!it.hasArtifactId(groupId, artifactId)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean hasVersion(@NotNull String groupId, @NotNull String artifactId, @NotNull String version2) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
                Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                Iterable $this$any$iv = MavenIndicesManager.this.myGavIndices;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MavenGAVIndex it = (MavenGAVIndex)element$iv;
                        boolean bl2 = false;
                        if (!it.hasVersion(groupId, artifactId, version2)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        @NotNull
        public MavenRepositoryInfo getRepository() {
            throw new IllegalStateException("Internal API, do not use it");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/indices/MavenIndicesManager$MavenIndexServerDownloadListener;", "Lorg/jetbrains/idea/maven/server/MavenServerDownloadListener;", "myManager", "Lorg/jetbrains/idea/maven/indices/MavenIndicesManager;", "(Lorg/jetbrains/idea/maven/indices/MavenIndicesManager;)V", "artifactDownloaded", "", "file", "Ljava/io/File;", "relativePath", "", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenIndicesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenIndicesManager.kt\norg/jetbrains/idea/maven/indices/MavenIndicesManager$MavenIndexServerDownloadListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1#2:327\n*E\n"})
    private static final class MavenIndexServerDownloadListener
    implements MavenServerDownloadListener {
        @NotNull
        private final MavenIndicesManager myManager;

        public MavenIndexServerDownloadListener(@NotNull MavenIndicesManager myManager) {
            Intrinsics.checkNotNullParameter((Object)myManager, (String)"myManager");
            this.myManager = myManager;
        }

        public void artifactDownloaded(@NotNull File file, @NotNull String relativePath) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                MavenRepositoryInfo localRepository2 = MavenIndexUtils.getLocalRepository(this.myManager.myProject);
                Object object = localRepository2;
                if (object == null || (object = object.getUrl()) == null) break block0;
                Object it = object;
                boolean bl = false;
                this.myManager.scheduleArtifactIndexing(null, file, (String)it);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/maven/indices/MavenIndicesManager$MavenIndexerListener;", "", "gavIndexUpdated", "", "repo", "Lorg/jetbrains/idea/maven/model/MavenRepositoryInfo;", "added", "", "Ljava/io/File;", "failedToAdd", "intellij.maven"})
    public static interface MavenIndexerListener {
        default public void gavIndexUpdated(@NotNull MavenRepositoryInfo repo, @NotNull Set<? extends File> added, @NotNull Set<? extends File> failedToAdd) {
            Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
            Intrinsics.checkNotNullParameter(added, (String)"added");
            Intrinsics.checkNotNullParameter(failedToAdd, (String)"failedToAdd");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/indices/MavenIndicesManager$MavenSearchIndexListener;", "Lorg/jetbrains/idea/maven/indices/MavenSearchIndex$IndexListener;", "myManager", "Lorg/jetbrains/idea/maven/indices/MavenIndicesManager;", "(Lorg/jetbrains/idea/maven/indices/MavenIndicesManager;)V", "indexIsBroken", "", "index", "Lorg/jetbrains/idea/maven/indices/MavenSearchIndex;", "intellij.maven"})
    private static final class MavenSearchIndexListener
    implements MavenSearchIndex.IndexListener {
        @NotNull
        private final MavenIndicesManager myManager;

        public MavenSearchIndexListener(@NotNull MavenIndicesManager myManager) {
            Intrinsics.checkNotNullParameter((Object)myManager, (String)"myManager");
            this.myManager = myManager;
        }

        @Override
        public void indexIsBroken(@NotNull MavenSearchIndex index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            if (index instanceof MavenUpdatableIndex) {
                MavenSystemIndicesManager.Companion.getInstance().scheduleUpdateIndexContent$intellij_maven(CollectionsKt.listOf((Object)index), false);
            }
        }
    }
}

