/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.progress.ProcessCanceledException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.indices.MavenUpdatableIndex;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenIndexId;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.server.AddArtifactResponse;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u001e\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/idea/maven/indices/MavenLuceneClassIndexServer;", "Lorg/jetbrains/idea/maven/indices/MavenUpdatableIndex;", "Lorg/jetbrains/idea/maven/indices/MavenSearchIndex;", "myRepo", "Lorg/jetbrains/idea/maven/model/MavenRepositoryInfo;", "myIndexId", "Lorg/jetbrains/idea/maven/model/MavenIndexId;", "myNexusIndexer", "Lorg/jetbrains/idea/maven/server/MavenIndexerWrapper;", "(Lorg/jetbrains/idea/maven/model/MavenRepositoryInfo;Lorg/jetbrains/idea/maven/model/MavenIndexId;Lorg/jetbrains/idea/maven/server/MavenIndexerWrapper;)V", "myUpdateTimestamp", "", "close", "", "releaseIndexContext", "", "getFailureMessage", "", "getRepository", "search", "", "Lorg/jetbrains/idea/maven/model/MavenArtifactInfo;", "pattern", "maxResult", "", "tryAddArtifacts", "", "Lorg/jetbrains/idea/maven/server/AddArtifactResponse;", "artifactFiles", "", "Ljava/io/File;", "update", "indicator", "Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;", "explicit", "(Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenLuceneClassIndexServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenLuceneClassIndexServer.kt\norg/jetbrains/idea/maven/indices/MavenLuceneClassIndexServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1549#2:64\n1620#2,3:65\n*S KotlinDebug\n*F\n+ 1 MavenLuceneClassIndexServer.kt\norg/jetbrains/idea/maven/indices/MavenLuceneClassIndexServer\n*L\n52#1:64\n52#1:65,3\n*E\n"})
public final class MavenLuceneClassIndexServer
implements MavenUpdatableIndex,
MavenSearchIndex {
    @NotNull
    private final MavenRepositoryInfo myRepo;
    @NotNull
    private final MavenIndexId myIndexId;
    @NotNull
    private final MavenIndexerWrapper myNexusIndexer;
    private long myUpdateTimestamp;

    public MavenLuceneClassIndexServer(@NotNull MavenRepositoryInfo myRepo, @NotNull MavenIndexId myIndexId, @NotNull MavenIndexerWrapper myNexusIndexer) {
        Intrinsics.checkNotNullParameter((Object)myRepo, (String)"myRepo");
        Intrinsics.checkNotNullParameter((Object)myIndexId, (String)"myIndexId");
        Intrinsics.checkNotNullParameter((Object)myNexusIndexer, (String)"myNexusIndexer");
        this.myRepo = myRepo;
        this.myIndexId = myIndexId;
        this.myNexusIndexer = myNexusIndexer;
        this.myUpdateTimestamp = -1L;
    }

    @Override
    public void close(boolean releaseIndexContext) {
        try {
            if (releaseIndexContext) {
                this.myNexusIndexer.releaseIndex(this.myIndexId);
            }
        }
        catch (MavenServerIndexerException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    @Override
    @NotNull
    public String getFailureMessage() {
        return "";
    }

    @Override
    @NotNull
    public Set<MavenArtifactInfo> search(@NotNull String pattern, int maxResult) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.myNexusIndexer.search(this.myIndexId, pattern, maxResult);
    }

    @Override
    @Nullable
    public Object update(@NotNull MavenProgressIndicator indicator, boolean explicit, @NotNull Continuation<? super Unit> $completion) {
        this.myNexusIndexer.updateIndex(this.myIndexId, indicator, explicit);
        this.myUpdateTimestamp = System.currentTimeMillis();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AddArtifactResponse> tryAddArtifacts(@NotNull Collection<? extends File> artifactFiles) {
        Intrinsics.checkNotNullParameter(artifactFiles, (String)"artifactFiles");
        try {
            return this.myNexusIndexer.addArtifacts(this.myIndexId, artifactFiles);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            void $this$mapTo$iv$iv;
            MavenLog.LOG.error("exception adding artifacts into index " + this.myIndexId);
            Iterable $this$map$iv = artifactFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AddArtifactResponse((File)it, null));
            }
            return (List)destination$iv$iv;
        }
    }

    @Override
    @NotNull
    public MavenRepositoryInfo getRepository() {
        return this.myRepo;
    }
}

