/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.maven4;

import com.intellij.maven.server.telemetry.MavenServerTelemetryClasspathUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenVersionAwareSupportExtension;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.BundledMaven4;
import org.jetbrains.idea.maven.project.StaticResolvedMavenHomeType;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.impl.BundledMavenDownloader;

final class Maven4Support
implements MavenVersionAwareSupportExtension {
    Maven4Support() {
    }

    @Override
    public boolean isSupportedByExtension(@Nullable File mavenHome) {
        String version2 = MavenUtil.getMavenVersion(mavenHome);
        return StringUtil.compareVersionNumbers((String)version2, (String)"4") >= 0;
    }

    @Override
    @Nullable
    public File getMavenHomeFile(@Nullable StaticResolvedMavenHomeType mavenHomeType) {
        if (mavenHomeType == null) {
            return null;
        }
        if (mavenHomeType == BundledMaven4.INSTANCE) {
            return MavenDistributionsCache.resolveEmbeddedMavenHome().getMavenHome().toFile();
        }
        return null;
    }

    @Override
    @NotNull
    public List<File> collectClassPathAndLibsFolder(@NotNull MavenDistribution distribution) {
        if (distribution == null) {
            Maven4Support.$$$reportNull$$$0(0);
        }
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        ArrayList<File> classpath = new ArrayList<File>();
        if (pluginFileOrDir.isDirectory()) {
            MavenLog.LOG.debug("collecting classpath for local run");
            Maven4Support.prepareClassPathForLocalRunAndUnitTests(distribution.getVersion(), classpath, root);
        } else {
            MavenLog.LOG.debug("collecting classpath for production");
            Maven4Support.prepareClassPathForProduction(distribution.getVersion(), classpath, root);
        }
        Maven4Support.addMavenLibs(classpath, distribution.getMavenHome().toFile());
        MavenLog.LOG.debug("Collected classpath = ", new Object[]{classpath});
        ArrayList<File> arrayList = classpath;
        if (arrayList == null) {
            Maven4Support.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void prepareClassPathForProduction(@NotNull String mavenVersion, List<File> classpath, String root) {
        if (mavenVersion == null) {
            Maven4Support.$$$reportNull$$$0(2);
        }
        classpath.add(new File(PathUtil.getJarPathForClass(MavenId.class)));
        classpath.add(new File(PathUtil.getJarPathForClass(MavenServer.class)));
        classpath.add(new File(root, "maven-server-telemetry.jar"));
        try {
            classpath.add(new File(PathUtil.getJarPathForClass(Class.forName("io.opentelemetry.sdk.trace.export.SpanExporter"))));
        }
        catch (ClassNotFoundException e) {
            MavenLog.LOG.error((Throwable)e);
        }
        Maven4Support.addDir(classpath, new File(root, "maven-telemetry-lib"), f -> true);
        Maven4Support.addDir(classpath, new File(root, "maven4-server-lib"), f -> true);
        classpath.add(new File(root, "maven40-server.jar"));
    }

    private static void prepareClassPathForLocalRunAndUnitTests(@NotNull String mavenVersion, List<File> classpath, String root) {
        if (mavenVersion == null) {
            Maven4Support.$$$reportNull$$$0(3);
        }
        BuildDependenciesCommunityRoot communityRoot = new BuildDependenciesCommunityRoot(Path.of(PathManager.getCommunityHomePath(), new String[0]));
        BundledMavenDownloader.INSTANCE.downloadMaven4LibsSync(communityRoot);
        classpath.add(new File(PathUtil.getJarPathForClass(MavenId.class)));
        classpath.add(new File(root, "intellij.maven.server"));
        classpath.add(new File(root, "intellij.maven.server.telemetry"));
        classpath.addAll(MavenUtil.collectClasspath(MavenServerTelemetryClasspathUtil.TELEMETRY_CLASSES));
        File parentFile = MavenUtil.getMavenPluginParentFile();
        Maven4Support.addDir(classpath, new File(parentFile, "maven40-server-impl/lib"), f -> true);
        classpath.add(new File(root, "intellij.maven.server.m40"));
    }

    private static void addMavenLibs(List<File> classpath, File mavenHome) {
        Maven4Support.addDir(classpath, new File(mavenHome, "lib"), f -> !f.getName().contains("maven-slf4j-provider"));
        File bootFolder = new File(mavenHome, "boot");
        File[] classworldsJars = bootFolder.listFiles((dir2, name) -> StringUtil.contains((CharSequence)name, (CharSequence)"classworlds"));
        if (classworldsJars != null) {
            Collections.addAll(classpath, classworldsJars);
        }
    }

    private static void addDir(List<File> classpath, File dir2, Predicate<File> filter) {
        File[] files2 = dir2.listFiles();
        if (files2 == null) {
            return;
        }
        for (File jar : files2) {
            if (!jar.isFile() || !jar.getName().endsWith(".jar") || !filter.test(jar)) continue;
            classpath.add(jar);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/maven4/Maven4Support";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/maven4/Maven4Support";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassPathAndLibsFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPathAndLibsFolder";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForProduction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForLocalRunAndUnitTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

