/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.pom.Navigatable;
import icons.MavenIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.navigator.structure.RepositoriesNode;

class RepositoryNode
extends MavenSimpleNode {
    @NlsSafe
    private final String myId;
    @NlsSafe
    private final String myUrl;
    private final boolean myLocal;

    RepositoryNode(MavenProjectsStructure structure, RepositoriesNode parent, String id, String url, boolean local) {
        super(structure, parent);
        this.myId = id;
        this.myUrl = url;
        this.myLocal = local;
        this.getTemplatePresentation().setIcon(this.getDefaultIcon());
    }

    @NotNull
    private Icon getDefaultIcon() {
        Icon icon = this.myLocal ? MavenIcons.MavenRepoLocal : MavenIcons.MavenRepoRemote;
        if (icon == null) {
            RepositoryNode.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public String getName() {
        return this.myId;
    }

    @Override
    @NonNls
    protected String getMenuId() {
        return "Maven.RepositoryMenu";
    }

    String getId() {
        return this.myId;
    }

    String getUrl() {
        return this.myUrl;
    }

    boolean isLocal() {
        return this.myLocal;
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/navigator/structure/RepositoryNode", "getDefaultIcon"));
    }
}

