/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.performancePlugin;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.performancePlugin.ExecuteMavenGoalCommand;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J6\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/ExecuteMavenGoalCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "perform", "", "project", "Lcom/intellij/openapi/project/Project;", "moduleName", "goals", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nExecuteMavenGoalCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecuteMavenGoalCommand.kt\norg/jetbrains/idea/maven/performancePlugin/ExecuteMavenGoalCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n288#2,2:85\n*S KotlinDebug\n*F\n+ 1 ExecuteMavenGoalCommand.kt\norg/jetbrains/idea/maven/performancePlugin/ExecuteMavenGoalCommand\n*L\n66#1:85,2\n*E\n"})
public final class ExecuteMavenGoalCommand
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%executeMavenGoals";

    public ExecuteMavenGoalCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        AsyncPromise promise2 = new AsyncPromise();
        String args = this.extractCommandArgument(PREFIX);
        Regex regex = new Regex("(?<=moduleName)(.*)(?=goalNames)");
        Intrinsics.checkNotNull((Object)args);
        Object object = Regex.find$default((Regex)regex, (CharSequence)args, (int)0, (int)2, null);
        if (object == null || (object = object.getValue()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
            throw new IllegalArgumentException(args + " doesn't contain valid module with goal name");
        }
        Object moduleName = object;
        String[] stringArray = new String[]{","};
        List goals = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)args, (String)"goalNames", null, (int)2, null))).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Project project2 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        project3.getMessageBus().connect().subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener((AsyncPromise<Object>)promise2){
            final /* synthetic */ AsyncPromise<Object> $promise;
            {
                this.$promise = $promise;
            }

            public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @Nullable Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                if (cause != null) {
                    this.$promise.setError(cause);
                }
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
                Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                if (exitCode != 0) {
                    this.$promise.setError("Process finished with code exit code " + exitCode);
                } else {
                    this.$promise.setResult(null);
                }
            }
        });
        this.perform(project3, (String)moduleName, goals, (AsyncPromise<Object>)promise2);
        return (Promise)promise2;
    }

    private final void perform(Project project2, String moduleName, List<String> goals, AsyncPromise<Object> promise2) {
        ApplicationManager.getApplication().invokeLater(() -> ExecuteMavenGoalCommand.perform$lambda$1(project2, promise2, moduleName, goals));
    }

    private static final void perform$lambda$1(Project $project, AsyncPromise $promise, String $moduleName, List $goals) {
        Object v1;
        List<MavenProject> currentProjects;
        MavenProjectsManager projectsManager;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$promise, (String)"$promise");
            Intrinsics.checkNotNullParameter((Object)$moduleName, (String)"$moduleName");
            Intrinsics.checkNotNullParameter((Object)$goals, (String)"$goals");
            projectsManager = MavenProjectsManager.getInstance($project);
            if (projectsManager == null) {
                $promise.setError("There is no MavenProjectsManager for project");
                return;
            }
            List<MavenProject> list = projectsManager.getProjects();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getProjects(...)");
            currentProjects = list;
            Iterable $this$firstOrNull$iv = currentProjects;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MavenProject it = (MavenProject)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)$moduleName)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        MavenProject mavenProject2 = v1;
        if (mavenProject2 == null) {
            $promise.setError("There is no module with name " + $moduleName + ". Actual modules: " + CollectionsKt.joinToString$default((Iterable)currentProjects, (CharSequence)"\n", null, null, (int)0, null, (Function1)perform.1.1.INSTANCE, (int)30, null));
            return;
        }
        MavenExplicitProfiles mavenExplicitProfiles = projectsManager.getExplicitProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)mavenExplicitProfiles, (String)"getExplicitProfiles(...)");
        MavenExplicitProfiles explicitProfiles = mavenExplicitProfiles;
        MavenRunnerParameters params = new MavenRunnerParameters(true, mavenProject2.getDirectory(), mavenProject2.getFile().getName(), $goals, explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
        MavenRunConfigurationType.runConfiguration($project, params, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/ExecuteMavenGoalCommand$Companion;", "", "()V", "PREFIX", "", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

