/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.performancePlugin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0003H\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/ToggleMavenProfilesCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "Companion", "intellij.maven"})
public final class ToggleMavenProfilesCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "toggleMavenProfiles";
    @NotNull
    public static final String PREFIX = "%toggleMavenProfiles";

    public ToggleMavenProfilesCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context2, @NotNull Continuation<? super Unit> $completion) {
        Project project2 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        ArrayList arrayList = this.extractCommandList(PREFIX, " ");
        Intrinsics.checkNotNull((Object)arrayList);
        String profileIds = (String)((List)arrayList).get(0);
        String enable = (String)((List)arrayList).get(1);
        Intrinsics.checkNotNull((Object)profileIds);
        String[] stringArray = new String[]{","};
        Set profileIdsSet = CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)profileIds, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project3);
        Collection<String> collection = projectsManager.getAvailableProfiles();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAvailableProfiles(...)");
        Collection<String> availableProfiles = collection;
        if (!availableProfiles.containsAll(profileIdsSet)) {
            throw new IllegalArgumentException("Available profiles " + availableProfiles + " does not contains all selected profiles " + profileIdsSet + "}");
        }
        MavenExplicitProfiles mavenExplicitProfiles = projectsManager.getExplicitProfiles().clone();
        Intrinsics.checkNotNullExpressionValue((Object)mavenExplicitProfiles, (String)"clone(...)");
        MavenExplicitProfiles newExplicitProfiles = mavenExplicitProfiles;
        if (Boolean.parseBoolean(enable)) {
            newExplicitProfiles.getDisabledProfiles().removeAll(profileIdsSet);
            newExplicitProfiles.getEnabledProfiles().addAll(profileIdsSet);
        } else {
            newExplicitProfiles.getEnabledProfiles().removeAll(profileIdsSet);
            newExplicitProfiles.getDisabledProfiles().addAll(profileIdsSet);
        }
        projectsManager.setExplicitProfiles(newExplicitProfiles);
        return Unit.INSTANCE;
    }

    @NotNull
    protected String getName() {
        return NAME;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/ToggleMavenProfilesCommand$Companion;", "", "()V", "NAME", "", "PREFIX", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

