/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ExceptionUtil;
import java.text.MessageFormat;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;

@Deprecated
public abstract class MavenConsole {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final int myOutputLevel;
    private static final BiMap<String, Integer> PREFIX_TO_LEVEL = ImmutableBiMap.of((Object)"DEBUG", (Object)0, (Object)"INFO", (Object)1, (Object)"WARNING", (Object)2, (Object)"ERROR", (Object)3, (Object)"FATAL_ERROR", (Object)4);

    @Deprecated(forRemoval=true)
    public MavenConsole(MavenExecutionOptions.LoggingLevel outputLevel, boolean ignored) {
        this(outputLevel);
    }

    public MavenConsole(MavenExecutionOptions.LoggingLevel outputLevel) {
        this.myOutputLevel = outputLevel.getLevel();
    }

    private boolean isSuppressed(int level) {
        return level < this.myOutputLevel;
    }

    @Deprecated(forRemoval=true)
    public boolean isSuppressed(String line) {
        return this.isSuppressed(MavenConsole.getLevel(line));
    }

    public void systemMessage(int level, String string, Throwable throwable) {
        this.printMessage(level, string, throwable);
    }

    private void printMessage(int level, String string, Throwable throwable) {
        if (this.isSuppressed(level)) {
            return;
        }
        OutputType type2 = OutputType.NORMAL;
        if (throwable != null || level == 2 || level == 3 || level == 4) {
            type2 = OutputType.ERROR;
        }
        this.doPrint(MavenConsole.composeLine(level, string), type2);
        if (throwable != null) {
            String throwableText = ExceptionUtil.getThrowableText((Throwable)throwable);
            if (Registry.is((String)"maven.print.import.stacktraces") || ApplicationManager.getApplication().isUnitTestMode()) {
                this.doPrint(LINE_SEPARATOR + MavenConsole.composeLine(3, throwableText), type2);
            } else {
                this.doPrint(LINE_SEPARATOR + MavenConsole.composeLine(3, throwable.getMessage()), type2);
            }
        }
    }

    protected abstract void doPrint(String var1, OutputType var2);

    private static int getLevel(String line) {
        return MavenConsole.getLevelByPrefix(MavenConsole.extractPrefix(line));
    }

    private static String extractPrefix(String line) {
        int closing;
        if (line.startsWith("[") && (closing = line.indexOf("] ", 1)) > 1) {
            return line.substring(1, closing);
        }
        return "";
    }

    private static int getLevelByPrefix(String prefix) {
        Integer level = (Integer)PREFIX_TO_LEVEL.get((Object)prefix);
        return level != null ? level : 2;
    }

    private static String composeLine(int level, String message) {
        return MessageFormat.format("[{0}] {1}", MavenConsole.getPrefixByLevel(level), message);
    }

    private static String getPrefixByLevel(int level) {
        return (String)PREFIX_TO_LEVEL.inverse().get((Object)level);
    }

    public static enum OutputType {
        NORMAL,
        SYSTEM,
        ERROR;

    }
}

