/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenEmbeddersManager {
    public static final Key FOR_DEPENDENCIES_RESOLVE = Key.create((String)(MavenEmbeddersManager.class + ".FOR_DEPENDENCIES_RESOLVE"));
    public static final Key FOR_PLUGINS_RESOLVE = Key.create((String)(MavenEmbeddersManager.class + ".FOR_PLUGINS_RESOLVE"));
    public static final Key FOR_FOLDERS_RESOLVE = Key.create((String)(MavenEmbeddersManager.class + ".FOR_FOLDERS_RESOLVE"));
    public static final Key FOR_POST_PROCESSING = Key.create((String)(MavenEmbeddersManager.class + ".FOR_POST_PROCESSING"));
    public static final Key FOR_MODEL_READ = Key.create((String)(MavenEmbeddersManager.class + ".FOR_MODEL_READ"));
    public static final Key FOR_DOWNLOAD = Key.create((String)(MavenEmbeddersManager.class + ".FOR_DOWNLOAD"));
    private final Project myProject;
    private final Map<Pair<Key, String>, MavenEmbedderWrapper> myPool = ContainerUtil.createSoftValueMap();
    private final Set<MavenEmbedderWrapper> myEmbeddersInUse = new HashSet<MavenEmbedderWrapper>();

    public MavenEmbeddersManager(Project project2) {
        this.myProject = project2;
    }

    public synchronized void reset() {
        this.releasePooledEmbedders(false);
    }

    @NotNull
    public synchronized MavenEmbedderWrapper getEmbedder(@NotNull MavenProject mavenProject2, Key kind) {
        if (mavenProject2 == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(0);
        }
        String baseDir2 = MavenUtil.getBaseDir(mavenProject2.getDirectoryFile()).toString();
        MavenEmbedderWrapper mavenEmbedderWrapper = this.getEmbedder(kind, baseDir2);
        if (mavenEmbedderWrapper == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(1);
        }
        return mavenEmbedderWrapper;
    }

    @NotNull
    public synchronized MavenEmbedderWrapper getEmbedder(Key kind, @NotNull String multiModuleProjectDirectory) {
        boolean alwaysOnline;
        if (multiModuleProjectDirectory == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(2);
        }
        String embedderDir = this.guessExistingEmbedderDir(multiModuleProjectDirectory);
        Pair key = Pair.create((Object)kind, (Object)embedderDir);
        MavenEmbedderWrapper result2 = this.myPool.get(key);
        boolean bl = alwaysOnline = kind == FOR_DOWNLOAD;
        if (result2 == null) {
            result2 = this.createEmbedder(embedderDir, alwaysOnline);
            this.myPool.put((Pair<Key, String>)key, result2);
        }
        if (this.myEmbeddersInUse.contains(result2)) {
            MavenLog.LOG.warn("embedder " + key + " is already used");
            return this.createEmbedder(embedderDir, alwaysOnline);
        }
        this.myEmbeddersInUse.add(result2);
        MavenEmbedderWrapper mavenEmbedderWrapper = result2;
        if (mavenEmbedderWrapper == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(3);
        }
        return mavenEmbedderWrapper;
    }

    private String guessExistingEmbedderDir(@NotNull String multiModuleProjectDirectory) {
        Path originalPath;
        Path path2;
        String dir2;
        if (multiModuleProjectDirectory == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(4);
        }
        if ((dir2 = multiModuleProjectDirectory).isBlank()) {
            MavenLog.LOG.warn("Maven project directory is blank. Using project base path");
            dir2 = this.myProject.getBasePath();
        }
        if (null == dir2 || dir2.isBlank()) {
            MavenLog.LOG.warn("Maven project directory is blank. Using tmp dir");
            dir2 = System.getProperty("java.io.tmpdir");
        }
        for (path2 = originalPath = Path.of(dir2, new String[0]).toAbsolutePath(); null != path2 && !Files.exists(path2, new LinkOption[0]); path2 = path2.getParent()) {
            MavenLog.LOG.warn(String.format("Maven project %s directory does not exist. Using parent", path2));
        }
        if (null == path2) {
            MavenLog.LOG.warn("Could not determine maven project directory: " + multiModuleProjectDirectory);
            return originalPath.toString();
        }
        return path2.toString();
    }

    @NotNull
    private MavenEmbedderWrapper createEmbedder(@NotNull String multiModuleProjectDirectory, boolean alwaysOnline) {
        if (multiModuleProjectDirectory == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(5);
        }
        MavenEmbedderWrapper mavenEmbedderWrapper = MavenServerManager.getInstance().createEmbedder(this.myProject, alwaysOnline, multiModuleProjectDirectory);
        if (mavenEmbedderWrapper == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(6);
        }
        return mavenEmbedderWrapper;
    }

    @Deprecated
    @NotNull
    public synchronized MavenEmbedderWrapper getEmbedder(Key kind, String ignoredWorkingDirectory, @NotNull String multiModuleProjectDirectory) {
        if (multiModuleProjectDirectory == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(7);
        }
        MavenEmbedderWrapper mavenEmbedderWrapper = this.getEmbedder(kind, multiModuleProjectDirectory);
        if (mavenEmbedderWrapper == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(8);
        }
        return mavenEmbedderWrapper;
    }

    public synchronized void release(@NotNull MavenEmbedderWrapper embedder) {
        if (embedder == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(9);
        }
        if (!this.myEmbeddersInUse.contains(embedder)) {
            embedder.release();
            return;
        }
        this.myEmbeddersInUse.remove(embedder);
    }

    @TestOnly
    public synchronized void releaseInTests() {
        if (!this.myEmbeddersInUse.isEmpty()) {
            MavenLog.LOG.warn("embedders should be release first");
        }
        this.releasePooledEmbedders(false);
    }

    public synchronized void releaseForcefullyInTests() {
        this.releasePooledEmbedders(true);
    }

    private synchronized void releasePooledEmbedders(boolean force) {
        this.forEachPooled(force, each -> {
            each.release();
            return null;
        });
        this.myPool.clear();
        this.myEmbeddersInUse.clear();
    }

    private void forEachPooled(boolean includeInUse, Function<MavenEmbedderWrapper, ?> func) {
        for (Pair<Key, String> each : this.myPool.keySet()) {
            MavenEmbedderWrapper embedder = this.myPool.get(each);
            if (embedder == null || !includeInUse && this.myEmbeddersInUse.contains(embedder)) continue;
            func.fun((Object)embedder);
        }
    }

    public void execute(@NotNull MavenProject mavenProject2, @NotNull Key embedderKind, @NotNull EmbedderTask task2) throws MavenProcessCanceledException {
        if (mavenProject2 == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(10);
        }
        if (embedderKind == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(11);
        }
        if (task2 == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(12);
        }
        String baseDir2 = MavenUtil.getBaseDir(mavenProject2.getDirectoryFile()).toString();
        this.execute(baseDir2, embedderKind, task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NotNull String baseDir2, @NotNull Key embedderKind, @NotNull EmbedderTask task2) throws MavenProcessCanceledException {
        if (baseDir2 == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(13);
        }
        if (embedderKind == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(14);
        }
        if (task2 == null) {
            MavenEmbeddersManager.$$$reportNull$$$0(15);
        }
        MavenEmbedderWrapper embedder = this.getEmbedder(embedderKind, baseDir2);
        try {
            task2.run(embedder);
        }
        finally {
            this.release(embedder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenEmbeddersManager";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiModuleProjectDirectory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedder";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedderKind";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenEmbeddersManager";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbedder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmbedder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEmbedder";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "guessExistingEmbedderDir";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEmbedder";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 8 -> new IllegalStateException(string);
        };
    }

    public static interface EmbedderTask {
        public void run(MavenEmbedderWrapper var1) throws MavenProcessCanceledException;
    }
}

