/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.config.MavenConfig;
import org.jetbrains.idea.maven.config.MavenConfigParser;
import org.jetbrains.idea.maven.config.MavenConfigSettings;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.project.BundledMaven3;
import org.jetbrains.idea.maven.project.BundledMaven4;
import org.jetbrains.idea.maven.project.MavenHomeKt;
import org.jetbrains.idea.maven.project.MavenHomeType;
import org.jetbrains.idea.maven.project.MavenInSpecificPath;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWrapper;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

public class MavenGeneralSettings
implements Cloneable {
    private static final MavenHomeType DEFAULT_MAVEN = BundledMaven3.INSTANCE;
    private transient boolean myForPersistence = false;
    private transient Project myProject;
    private boolean workOffline = false;
    private MavenHomeType mavenHomeType = DEFAULT_MAVEN;
    private String mavenSettingsFile = "";
    private String overriddenLocalRepository = "";
    private boolean printErrorStackTraces = false;
    private boolean nonRecursive = false;
    private boolean alwaysUpdateSnapshots = false;
    private boolean showDialogWithAdvancedSettings = false;
    private boolean useMavenConfig = true;
    private String threads;
    private boolean emulateTerminal = false;
    private MavenExecutionOptions.LoggingLevel outputLevel = MavenExecutionOptions.LoggingLevel.INFO;
    MavenExecutionOptions.ChecksumPolicy checksumPolicy = MavenExecutionOptions.ChecksumPolicy.NOT_SET;
    private MavenExecutionOptions.FailureMode failureBehavior = MavenExecutionOptions.FailureMode.NOT_SET;
    private transient File myEffectiveLocalRepositoryCache;
    private transient MavenConfig mavenConfigCache;
    private int myBulkUpdateLevel = 0;
    private List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public MavenGeneralSettings() {
    }

    public MavenGeneralSettings(Project project2) {
        this.myProject = project2;
    }

    public void setProject(Project project2) {
        this.myProject = project2;
    }

    public void beginUpdate() {
        ++this.myBulkUpdateLevel;
    }

    public void endUpdate() {
        if (--this.myBulkUpdateLevel == 0) {
            this.changed();
        }
    }

    public void changed() {
        this.changed(true);
    }

    public void changed(boolean fireUpdate) {
        if (this.myBulkUpdateLevel > 0) {
            return;
        }
        this.myEffectiveLocalRepositoryCache = null;
        this.mavenConfigCache = null;
        if (fireUpdate) {
            this.fireChanged();
        }
    }

    @Property
    @NotNull
    public MavenExecutionOptions.ChecksumPolicy getChecksumPolicy() {
        MavenExecutionOptions.ChecksumPolicy checksumPolicy = this.checksumPolicy;
        if (checksumPolicy == null) {
            MavenGeneralSettings.$$$reportNull$$$0(0);
        }
        return checksumPolicy;
    }

    public void setChecksumPolicy(MavenExecutionOptions.ChecksumPolicy value) {
        if (value == null) {
            return;
        }
        if (!Comparing.equal((Object)((Object)this.checksumPolicy), (Object)((Object)value))) {
            this.checksumPolicy = value;
            this.changed();
        }
    }

    @Property
    @NotNull
    public MavenExecutionOptions.FailureMode getFailureBehavior() {
        MavenExecutionOptions.FailureMode failureMode = this.failureBehavior;
        if (failureMode == null) {
            MavenGeneralSettings.$$$reportNull$$$0(1);
        }
        return failureMode;
    }

    public void setFailureBehavior(MavenExecutionOptions.FailureMode value) {
        if (value == null) {
            return;
        }
        if (!Comparing.equal((Object)((Object)this.failureBehavior), (Object)((Object)value))) {
            this.failureBehavior = value;
            this.changed();
        }
    }

    @Transient
    @Deprecated(forRemoval=true)
    @NotNull
    public MavenExecutionOptions.LoggingLevel getLoggingLevel() {
        MavenExecutionOptions.LoggingLevel loggingLevel = this.getOutputLevel();
        if (loggingLevel == null) {
            MavenGeneralSettings.$$$reportNull$$$0(2);
        }
        return loggingLevel;
    }

    @Property
    @NotNull
    public MavenExecutionOptions.LoggingLevel getOutputLevel() {
        MavenExecutionOptions.LoggingLevel loggingLevel = this.outputLevel;
        if (loggingLevel == null) {
            MavenGeneralSettings.$$$reportNull$$$0(3);
        }
        return loggingLevel;
    }

    public void setOutputLevel(MavenExecutionOptions.LoggingLevel value) {
        if (value == null) {
            return;
        }
        if (!Comparing.equal((Object)((Object)this.outputLevel), (Object)((Object)value))) {
            this.outputLevel = value;
            this.changed();
        }
    }

    public boolean isWorkOffline() {
        return this.workOffline;
    }

    public void setWorkOffline(boolean value) {
        if (!Comparing.equal((Object)this.workOffline, (Object)value)) {
            this.workOffline = value;
            this.changed();
        }
    }

    @Deprecated(forRemoval=true)
    @Nullable
    @ApiStatus.ScheduledForRemoval
    public String getMavenHome() {
        if (this.myForPersistence) {
            return DEFAULT_MAVEN.getTitle();
        }
        return this.mavenHomeType.getTitle();
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval
    public void setMavenHome(@NotNull String mavenHome) {
        if (mavenHome == null) {
            MavenGeneralSettings.$$$reportNull$$$0(4);
        }
        this.setMavenHome(MavenHomeKt.resolveMavenHomeType(mavenHome), true);
    }

    @Transient
    @NotNull
    public MavenHomeType getMavenHomeType() {
        MavenHomeType type2 = this.mavenHomeType;
        if (type2 != null) {
            MavenHomeType mavenHomeType = type2;
            if (mavenHomeType == null) {
                MavenGeneralSettings.$$$reportNull$$$0(5);
            }
            return mavenHomeType;
        }
        BundledMaven3 bundledMaven3 = BundledMaven3.INSTANCE;
        if (bundledMaven3 == null) {
            MavenGeneralSettings.$$$reportNull$$$0(6);
        }
        return bundledMaven3;
    }

    public void setMavenHomeType(@NotNull MavenHomeType mavenHome) {
        if (mavenHome == null) {
            MavenGeneralSettings.$$$reportNull$$$0(7);
        }
        this.setMavenHome(mavenHome, true);
    }

    @Deprecated
    @TestOnly
    public void setMavenHomeNoFire(@NotNull String mavenHome) {
        if (mavenHome == null) {
            MavenGeneralSettings.$$$reportNull$$$0(8);
        }
        this.setMavenHome(MavenHomeKt.resolveMavenHomeType(mavenHome), false);
    }

    @TestOnly
    public void setMavenHomeNoFire(@NotNull MavenHomeType mavenHome) {
        if (mavenHome == null) {
            MavenGeneralSettings.$$$reportNull$$$0(9);
        }
        this.setMavenHome(mavenHome, false);
    }

    private void setMavenHome(@NotNull MavenHomeType mavenHome, boolean fireChanged) {
        MavenHomeType mavenHomeToSet;
        if (mavenHome == null) {
            MavenGeneralSettings.$$$reportNull$$$0(10);
        }
        if (!Objects.equals(this.mavenHomeType, mavenHomeToSet = mavenHome)) {
            this.mavenHomeType = mavenHomeToSet;
            if (fireChanged) {
                this.changed();
            }
        }
    }

    @NotNull
    public String getUserSettingsFile() {
        String string = this.mavenSettingsFile;
        if (string == null) {
            MavenGeneralSettings.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setUserSettingsFile(@Nullable String mavenSettingsFile) {
        if (mavenSettingsFile == null) {
            return;
        }
        if (!Objects.equals(this.mavenSettingsFile, mavenSettingsFile)) {
            this.mavenSettingsFile = mavenSettingsFile;
            this.changed();
        }
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public File getEffectiveUserSettingsIoFile() {
        return MavenWslUtil.getUserSettings(this.myProject, this.getUserSettingsFile(), this.getMavenConfig());
    }

    @Deprecated
    @Nullable
    public File getEffectiveGlobalSettingsIoFile() {
        return MavenWslUtil.getGlobalSettings(this.myProject, MavenHomeKt.staticOrBundled(this.getMavenHomeType()), this.getMavenConfig());
    }

    @Deprecated
    @Nullable
    public VirtualFile getEffectiveUserSettingsFile() {
        File file = this.getEffectiveUserSettingsIoFile();
        return file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    @Deprecated(forRemoval=true)
    public List<VirtualFile> getEffectiveSettingsFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(2);
        VirtualFile file = this.getEffectiveUserSettingsFile();
        if (file != null) {
            result2.add(file);
        }
        if ((file = this.getEffectiveGlobalSettingsFile()) != null) {
            result2.add(file);
        }
        return result2;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public VirtualFile getEffectiveGlobalSettingsFile() {
        File file = this.getEffectiveGlobalSettingsIoFile();
        return file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    @NotNull
    public String getLocalRepository() {
        String string = this.overriddenLocalRepository;
        if (string == null) {
            MavenGeneralSettings.$$$reportNull$$$0(12);
        }
        return string;
    }

    public void setLocalRepository(@Nullable String overriddenLocalRepository) {
        if (overriddenLocalRepository == null) {
            return;
        }
        if (!Objects.equals(this.overriddenLocalRepository, overriddenLocalRepository)) {
            this.overriddenLocalRepository = overriddenLocalRepository;
            if (this.myProject != null) {
                MavenUtil.restartMavenConnectors(this.myProject, false);
            }
            this.changed();
        }
    }

    @Deprecated(forRemoval=true)
    public File getEffectiveLocalRepository() {
        File result2 = this.myEffectiveLocalRepositoryCache;
        if (result2 != null) {
            return result2;
        }
        this.myEffectiveLocalRepositoryCache = result2 = MavenWslUtil.getLocalRepo(this.myProject, this.overriddenLocalRepository, MavenHomeKt.staticOrBundled(this.mavenHomeType), this.mavenSettingsFile, this.getMavenConfig());
        return result2;
    }

    public boolean isPrintErrorStackTraces() {
        return this.printErrorStackTraces;
    }

    public void setPrintErrorStackTraces(boolean value) {
        if (!Comparing.equal((Object)this.printErrorStackTraces, (Object)value)) {
            this.printErrorStackTraces = value;
            this.changed();
        }
    }

    public boolean isUseMavenConfig() {
        return this.useMavenConfig;
    }

    public void setUseMavenConfig(boolean value) {
        if (!Comparing.equal((Object)this.useMavenConfig, (Object)value)) {
            this.useMavenConfig = value;
            this.changed();
        }
    }

    public boolean isAlwaysUpdateSnapshots() {
        return this.alwaysUpdateSnapshots;
    }

    public void setAlwaysUpdateSnapshots(boolean value) {
        if (!Comparing.equal((Object)this.alwaysUpdateSnapshots, (Object)value)) {
            this.alwaysUpdateSnapshots = value;
            this.changed();
        }
    }

    public boolean isShowDialogWithAdvancedSettings() {
        return this.showDialogWithAdvancedSettings;
    }

    public void setShowDialogWithAdvancedSettings(boolean value) {
        if (!Comparing.equal((Object)this.showDialogWithAdvancedSettings, (Object)value)) {
            this.showDialogWithAdvancedSettings = value;
            this.changed();
        }
    }

    public boolean isNonRecursive() {
        return this.nonRecursive;
    }

    public void setNonRecursive(boolean value) {
        if (!Comparing.equal((Object)this.nonRecursive, (Object)value)) {
            this.nonRecursive = value;
            this.changed();
        }
    }

    @Nullable
    public String getThreads() {
        return this.threads;
    }

    public void setThreads(@Nullable String value) {
        String nullizeValue = StringUtil.nullize((String)value);
        if (!Objects.equals(this.threads, nullizeValue)) {
            this.threads = nullizeValue;
            this.changed();
        }
    }

    public boolean isEmulateTerminal() {
        return this.emulateTerminal;
    }

    public void setEmulateTerminal(boolean emulateTerminal) {
        if (!Comparing.equal((Object)this.emulateTerminal, (Object)emulateTerminal)) {
            this.emulateTerminal = emulateTerminal;
            this.changed();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenGeneralSettings that = (MavenGeneralSettings)o;
        if (this.nonRecursive != that.nonRecursive) {
            return false;
        }
        if (this.outputLevel != that.outputLevel) {
            return false;
        }
        if (this.alwaysUpdateSnapshots != that.alwaysUpdateSnapshots) {
            return false;
        }
        if (this.showDialogWithAdvancedSettings != that.showDialogWithAdvancedSettings) {
            return false;
        }
        if (this.printErrorStackTraces != that.printErrorStackTraces) {
            return false;
        }
        if (this.useMavenConfig != that.useMavenConfig) {
            return false;
        }
        if (this.workOffline != that.workOffline) {
            return false;
        }
        if (!this.checksumPolicy.equals((Object)that.checksumPolicy)) {
            return false;
        }
        if (!this.failureBehavior.equals((Object)that.failureBehavior)) {
            return false;
        }
        if (!this.overriddenLocalRepository.equals(that.overriddenLocalRepository)) {
            return false;
        }
        if (!this.mavenHomeType.equals(that.mavenHomeType)) {
            return false;
        }
        if (!this.mavenSettingsFile.equals(that.mavenSettingsFile)) {
            return false;
        }
        if (!Objects.equals(this.threads, that.threads)) {
            return false;
        }
        return this.emulateTerminal == that.emulateTerminal;
    }

    public int hashCode() {
        int result2 = this.workOffline ? 1 : 0;
        result2 = 31 * result2 + this.mavenHomeType.hashCode();
        result2 = 31 * result2 + this.mavenSettingsFile.hashCode();
        result2 = 31 * result2 + this.overriddenLocalRepository.hashCode();
        result2 = 31 * result2 + (this.printErrorStackTraces ? 1 : 0);
        result2 = 31 * result2 + (this.useMavenConfig ? 1 : 0);
        result2 = 31 * result2 + (this.nonRecursive ? 1 : 0);
        result2 = 31 * result2 + this.outputLevel.hashCode();
        result2 = 31 * result2 + this.checksumPolicy.hashCode();
        result2 = 31 * result2 + this.failureBehavior.hashCode();
        result2 = 31 * result2 + (this.emulateTerminal ? 1 : 0);
        return result2;
    }

    public MavenGeneralSettings clone() {
        try {
            MavenGeneralSettings result2 = (MavenGeneralSettings)super.clone();
            result2.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            result2.myBulkUpdateLevel = 0;
            result2.setProject(this.myProject);
            return result2;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void addListener(Listener l, Disposable parentDisposable) {
        this.addListener(l);
        Disposer.register((Disposable)parentDisposable, () -> this.removeListener(l));
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void removeListener(Listener l) {
        this.myListeners.remove(l);
    }

    public void copyListeners(MavenGeneralSettings another) {
        this.myListeners.addAll(another.myListeners);
    }

    @Transient
    public void updateFromMavenConfig(@NotNull List<VirtualFile> mavenRootProjects) {
        MavenConfig config;
        if (mavenRootProjects == null) {
            MavenGeneralSettings.$$$reportNull$$$0(13);
        }
        if (mavenRootProjects.isEmpty() || !this.useMavenConfig) {
            return;
        }
        this.mavenConfigCache = null;
        VirtualFile file = mavenRootProjects.get(0);
        this.mavenConfigCache = config = MavenConfigParser.parse(file.isDirectory() ? file.getPath() : file.getParent().getPath());
        if (config == null) {
            return;
        }
        MavenExecutionOptions.ChecksumPolicy checksumConfig = Objects.requireNonNullElse(config.getChecksumPolicy(), MavenExecutionOptions.ChecksumPolicy.NOT_SET);
        boolean needUpdate = !Objects.equals((Object)checksumConfig, (Object)this.checksumPolicy);
        this.checksumPolicy = checksumConfig;
        MavenExecutionOptions.FailureMode failureBehaviorConfig = Objects.requireNonNullElse(config.getFailureMode(), MavenExecutionOptions.FailureMode.NOT_SET);
        needUpdate = needUpdate || !Objects.equals((Object)this.failureBehavior, (Object)failureBehaviorConfig);
        this.failureBehavior = failureBehaviorConfig;
        MavenExecutionOptions.LoggingLevel outputLevelConfig = Objects.requireNonNullElse(config.getOutputLevel(), MavenExecutionOptions.LoggingLevel.INFO);
        needUpdate = needUpdate || !Objects.equals((Object)this.outputLevel, (Object)outputLevelConfig);
        this.outputLevel = outputLevelConfig;
        Boolean offlineConfig = config.hasOption(MavenConfigSettings.OFFLINE);
        needUpdate = needUpdate || !Objects.equals(this.workOffline, offlineConfig);
        this.workOffline = offlineConfig;
        Boolean stackTracesConfig = config.hasOption(MavenConfigSettings.ERRORS);
        needUpdate = needUpdate || !Objects.equals(this.printErrorStackTraces, stackTracesConfig);
        this.printErrorStackTraces = stackTracesConfig;
        Boolean updateSnapshotsConfig = config.hasOption(MavenConfigSettings.UPDATE_SNAPSHOTS);
        needUpdate = needUpdate || !Objects.equals(this.alwaysUpdateSnapshots, updateSnapshotsConfig);
        this.alwaysUpdateSnapshots = updateSnapshotsConfig;
        Boolean nonRecursiveConfig = config.hasOption(MavenConfigSettings.NON_RECURSIVE);
        needUpdate = needUpdate || !Objects.equals(this.nonRecursive, nonRecursiveConfig);
        this.nonRecursive = nonRecursiveConfig;
        String threadsConfig = StringUtil.nullize((String)config.getOptionValue(MavenConfigSettings.THREADS));
        needUpdate = needUpdate || !Objects.equals(StringUtil.nullize((String)this.threads), threadsConfig);
        this.threads = threadsConfig;
        if (needUpdate) {
            this.changed(false);
        }
        this.mavenConfigCache = config;
    }

    @Transient
    public MavenConfig getMavenConfig() {
        MavenProjectsManager instance;
        if (!this.useMavenConfig) {
            return null;
        }
        if (this.mavenConfigCache != null) {
            return this.mavenConfigCache;
        }
        MavenProjectsManager mavenProjectsManager = instance = this.myProject != null ? MavenProjectsManager.getInstance(this.myProject) : null;
        if (instance == null) {
            return null;
        }
        List<VirtualFile> files2 = MavenUtil.collectFiles(instance.getRootProjects());
        if (files2.isEmpty()) {
            files2 = instance.getProjectsTree().getExistingManagedFiles();
        }
        this.updateFromMavenConfig(files2);
        return this.mavenConfigCache;
    }

    private void fireChanged() {
        for (Listener each : this.myListeners) {
            each.changed();
        }
    }

    @ApiStatus.Internal
    public MavenHomeTypeForPersistence getMavenHomeTypeForPersistence() {
        if (this.mavenHomeType instanceof MavenWrapper) {
            return MavenHomeTypeForPersistence.WRAPPER;
        }
        if (this.mavenHomeType instanceof BundledMaven3) {
            return MavenHomeTypeForPersistence.BUNDLED3;
        }
        if (this.mavenHomeType instanceof BundledMaven4) {
            return MavenHomeTypeForPersistence.BUNDLED4;
        }
        return MavenHomeTypeForPersistence.CUSTOM;
    }

    @ApiStatus.Internal
    public void setMavenHomeTypeForPersistence(MavenHomeTypeForPersistence value) {
        switch (value) {
            case WRAPPER: {
                this.setMavenHomeType(MavenWrapper.INSTANCE);
                break;
            }
            case BUNDLED3: {
                this.setMavenHomeType(BundledMaven3.INSTANCE);
                break;
            }
            case BUNDLED4: {
                this.setMavenHomeType(BundledMaven4.INSTANCE);
                break;
            }
        }
    }

    @ApiStatus.Internal
    public String getCustomMavenHome() {
        MavenHomeType mavenHomeType = this.mavenHomeType;
        if (mavenHomeType instanceof MavenInSpecificPath) {
            MavenInSpecificPath m = (MavenInSpecificPath)mavenHomeType;
            return m.getMavenHome();
        }
        return null;
    }

    @ApiStatus.Internal
    public void setCustomMavenHome(String custom) {
        if (custom != null) {
            this.setMavenHomeType(new MavenInSpecificPath(custom));
        }
    }

    @ApiStatus.Internal
    MavenGeneralSettings cloneForPersistence() {
        MavenGeneralSettings clone = this.clone();
        clone.myForPersistence = true;
        return clone;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 7, 8, 9, 10, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenGeneralSettings";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenHome";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenRootProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChecksumPolicy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailureBehavior";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggingLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputLevel";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenGeneralSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenHomeType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserSettingsFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepository";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setMavenHome";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMavenHomeType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setMavenHomeNoFire";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateFromMavenConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 7, 8, 9, 10, 13 -> new IllegalArgumentException(string);
        };
    }

    public static interface Listener {
        public void changed();
    }

    @ApiStatus.Internal
    public static enum MavenHomeTypeForPersistence {
        WRAPPER,
        BUNDLED3,
        BUNDLED4,
        CUSTOM;

    }
}

