/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class RemoveManagedFilesAction
extends MavenAction {
    @Override
    protected boolean isVisible(@NotNull AnActionEvent e) {
        if (e == null) {
            RemoveManagedFilesAction.$$$reportNull$$$0(0);
        }
        if (!super.isVisible(e)) {
            return false;
        }
        DataContext context2 = e.getDataContext();
        Project project2 = MavenActionUtil.getProject(context2);
        if (project2 == null) {
            return false;
        }
        List<VirtualFile> selectedFiles = MavenActionUtil.getMavenProjectsFiles(context2);
        if (selectedFiles.size() == 0) {
            return false;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        for (VirtualFile pomXml : selectedFiles) {
            MavenProject mavenProject2 = projectsManager.findProject(pomXml);
            if (mavenProject2 == null) {
                return false;
            }
            MavenProject aggregator = projectsManager.findAggregator(mavenProject2);
            while (aggregator != null && !projectsManager.isManagedFile(aggregator.getFile())) {
                aggregator = projectsManager.findAggregator(aggregator);
            }
            if (aggregator == null || selectedFiles.contains(aggregator.getFile())) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext context2;
        Project project2;
        if (e == null) {
            RemoveManagedFilesAction.$$$reportNull$$$0(1);
        }
        if ((project2 = MavenActionUtil.getProject(context2 = e.getDataContext())) == null) {
            return;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        List<VirtualFile> selectedFiles = MavenActionUtil.getMavenProjectsFiles(context2);
        projectsManager.removeManagedFiles(selectedFiles, mavenProject2 -> {
            assert (mavenProject2 != null);
            MavenProject aggregator = projectsManager.findAggregator((MavenProject)mavenProject2);
            while (aggregator != null && !projectsManager.isManagedFile(aggregator.getFile())) {
                aggregator = projectsManager.findAggregator(aggregator);
            }
            if (aggregator != null && !selectedFiles.contains(aggregator.getFile())) {
                RemoveManagedFilesAction.notifyUser(context2, mavenProject2, aggregator);
            }
        }, names -> {
            int returnCode = Messages.showOkCancelDialog((String)ExternalSystemBundle.message((String)"action.detach.external.confirmation.prompt", (Object[])new Object[]{"Maven", names.size(), names}), (String)RemoveManagedFilesAction.getActionTitle(names), (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
            return returnCode == 0;
        });
    }

    @Nls
    private static String getActionTitle(List<String> names) {
        return StringUtil.pluralize((String)ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{"Maven"}), (int)names.size());
    }

    private static void notifyUser(DataContext context2, MavenProject mavenProject2, MavenProject aggregator) {
        String aggregatorDescription = " (" + aggregator.getMavenId().getDisplayString() + ")";
        Notification notification = new Notification("Maven", MavenProjectBundle.message("maven.module.remove.failed", new Object[0]), MavenProjectBundle.message("maven.module.remove.failed.explanation", mavenProject2.getDisplayName(), aggregatorDescription), NotificationType.ERROR);
        notification.setImportant(true);
        notification.notify(MavenActionUtil.getProject(context2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/idea/maven/project/actions/RemoveManagedFilesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

