/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.auto.reload;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemSettingsFilesReloadContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MavenSyncSpec;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenSyncListener;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/maven/project/auto/reload/MavenProjectAware;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "myProject", "Lcom/intellij/openapi/project/Project;", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "manager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;Lorg/jetbrains/idea/maven/project/MavenProjectsManager;)V", "isSyncCompleted", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "getProjectId", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "settingsFiles", "", "", "getSettingsFiles", "()Ljava/util/Set;", "collectSettingsFiles", "hasPomFile", "", "rootDirectory", "reloadProject", "", "context", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectReloadContext;", "subscribe", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenProjectAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectAware.kt\norg/jetbrains/idea/maven/project/auto/reload/MavenProjectAware\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n12474#2,2:119\n1549#3:121\n1620#3,3:122\n*S KotlinDebug\n*F\n+ 1 MavenProjectAware.kt\norg/jetbrains/idea/maven/project/auto/reload/MavenProjectAware\n*L\n77#1:119,2\n85#1:121\n85#1:122,3\n*E\n"})
public final class MavenProjectAware
implements ExternalSystemProjectAware {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemProjectId projectId;
    @NotNull
    private final MavenProjectsManager manager;
    @NotNull
    private final AtomicBooleanProperty isSyncCompleted;

    public MavenProjectAware(@NotNull Project myProject, @NotNull ExternalSystemProjectId projectId, @NotNull MavenProjectsManager manager) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.myProject = myProject;
        this.projectId = projectId;
        this.manager = manager;
        this.isSyncCompleted = new AtomicBooleanProperty(true);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.manager).subscribe(MavenSyncListener.Companion.getTOPIC(), (Object)new MavenSyncListener(){

            @Override
            public void syncFinished(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                if (Intrinsics.areEqual((Object)myProject, (Object)project2)) {
                    isSyncCompleted.set(true);
                }
            }

            @Override
            public void syncStarted(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                if (Intrinsics.areEqual((Object)myProject, (Object)project2)) {
                    isSyncCompleted.set(false);
                }
            }
        });
    }

    @NotNull
    public ExternalSystemProjectId getProjectId() {
        return this.projectId;
    }

    @NotNull
    public Set<String> getSettingsFiles() {
        return this.collectSettingsFiles();
    }

    public void subscribe(@NotNull ExternalSystemProjectListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.isSyncCompleted.afterReset(parentDisposable, (Function0)new Function0<Unit>(listener2){
            final /* synthetic */ ExternalSystemProjectListener $listener;
            {
                this.$listener = $listener;
                super(0);
            }

            public final void invoke() {
                this.$listener.onProjectReloadStart();
            }
        });
        this.isSyncCompleted.afterSet(parentDisposable, (Function0)new Function0<Unit>(listener2){
            final /* synthetic */ ExternalSystemProjectListener $listener;
            {
                this.$listener = $listener;
                super(0);
            }

            public final void invoke() {
                this.$listener.onProjectReloadFinish(ExternalSystemRefreshStatus.SUCCESS);
            }
        });
    }

    public void reloadProject(@NotNull ExternalSystemProjectReloadContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ApplicationManager.getApplication().invokeAndWait(MavenProjectAware::reloadProject$lambda$0);
        if (context2.getHasUndefinedModifications()) {
            this.manager.findAllAvailablePomFilesIfNotMavenized();
            MavenSyncSpec spec = MavenSyncSpec.incremental("MavenProjectAware.reloadProject, undefined modifications", context2.isExplicitReload());
            Intrinsics.checkNotNull((Object)spec);
            this.manager.scheduleUpdateAllMavenProjects(spec);
        } else {
            ExternalSystemSettingsFilesReloadContext settingsFilesContext = context2.getSettingsFilesContext();
            List filesToUpdate = new ArrayList();
            List filesToDelete = new ArrayList();
            for (VirtualFile projectsFile : this.manager.getProjectsTree().getProjectsFiles()) {
                String path2;
                Intrinsics.checkNotNullExpressionValue((Object)projectsFile.getPath(), (String)"getPath(...)");
                if (settingsFilesContext.getCreated().contains(path2)) {
                    filesToUpdate.add(projectsFile);
                }
                if (settingsFilesContext.getUpdated().contains(path2)) {
                    filesToUpdate.add(projectsFile);
                }
                if (!settingsFilesContext.getDeleted().contains(path2)) continue;
                filesToDelete.add(projectsFile);
            }
            Set updated = SetsKt.plus((Set)settingsFilesContext.getCreated(), (Iterable)settingsFilesContext.getUpdated());
            Set deleted = settingsFilesContext.getDeleted();
            if (updated.size() == filesToUpdate.size() && deleted.size() == filesToDelete.size()) {
                spec = MavenSyncSpec.incremental("MavenProjectAware.reloadProject, sync selected", context2.isExplicitReload());
                Intrinsics.checkNotNull((Object)spec);
                this.manager.scheduleUpdateMavenProjects(spec, filesToUpdate, filesToDelete);
            } else {
                this.manager.findAllAvailablePomFilesIfNotMavenized();
                spec = MavenSyncSpec.incremental("MavenProjectAware.reloadProject, sync all", context2.isExplicitReload());
                Intrinsics.checkNotNull((Object)spec);
                this.manager.scheduleUpdateAllMavenProjects(spec);
            }
        }
    }

    private final boolean hasPomFile(String rootDirectory) {
        boolean bl;
        block1: {
            MavenProjectsTree mavenProjectsTree = this.manager.getProjectsTree();
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsTree, (String)"getProjectsTree(...)");
            MavenProjectsTree projectTree = mavenProjectsTree;
            Intrinsics.checkNotNullExpressionValue((Object)MavenConstants.POM_NAMES, (String)"POM_NAMES");
            Object[] $this$any$iv = MavenConstants.POM_NAMES;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!projectTree.isPotentialProject(rootDirectory + "/" + it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> collectSettingsFiles() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        LinkedHashSet<CallSite> result2 = new LinkedHashSet<CallSite>();
        result2.addAll((Collection)this.manager.getProjectsTree().getManagedFilesPaths());
        Iterable iterable = this.manager.getProjectsTree().getProjectsFiles();
        LinkedHashSet<CallSite> linkedHashSet = result2;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        linkedHashSet.addAll((List)destination$iv$iv);
        for (MavenProject mavenProject2 : this.manager.getProjectsTree().getProjects()) {
            String rootDirectory;
            ProgressManager.checkCanceled();
            result2.addAll((Collection)mavenProject2.getModulePaths());
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject2.getDirectory(), (String)"getDirectory(...)");
            result2.add((CallSite)((Object)(rootDirectory + "//.mvn/jvm.config")));
            result2.add((CallSite)((Object)(rootDirectory + "//.mvn/maven.config")));
            result2.add((CallSite)((Object)(rootDirectory + "//.mvn/wrapper/maven-wrapper.properties")));
            if (!this.hasPomFile(rootDirectory)) continue;
            result2.add((CallSite)((Object)(rootDirectory + "/profiles.xml")));
        }
        return result2;
    }

    private static final void reloadProject$lambda$0() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }
}

