/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.nio.file.Path;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.server.AbstractMavenServerConnector;
import org.jetbrains.idea.maven.server.MavenBuildPathsChange;
import org.jetbrains.idea.maven.server.MavenCoreInitializationException;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerStatus;
import org.jetbrains.idea.maven.server.MisconfiguredPlexusDummyEmbedder;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u0007H\u0016J4\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070*H\u0096@\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\u00020$2\u0006\u0010#\u001a\u00020$2\u0006\u0010-\u001a\u00020$H\u0096@\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020 H\u0016J\u000e\u0010:\u001a\u00020;H\u00a4@\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020;H%J&\u0010>\u001a\u00020$2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010?\u001a\u00020&H\u0096@\u00a2\u0006\u0002\u0010@J!\u0010A\u001a\u0002HB\"\u0004\b\u0000\u0010B2\f\u0010C\u001a\b\u0012\u0004\u0012\u0002HB0DH$\u00a2\u0006\u0002\u0010EJ\b\u0010F\u001a\u00020\u0007H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006G"}, d2={"Lorg/jetbrains/idea/maven/server/AbstractMavenServerConnector;", "Lorg/jetbrains/idea/maven/server/MavenServerConnector;", "project", "Lcom/intellij/openapi/project/Project;", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "vmOptions", "", "mavenDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "multimoduleDirectory", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Lorg/jetbrains/idea/maven/server/MavenDistribution;Ljava/lang/String;)V", "embedderLock", "", "getJdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getMavenDistribution", "()Lorg/jetbrains/idea/maven/server/MavenDistribution;", "multimoduleDirectories", "", "getMultimoduleDirectories", "()Ljava/util/List;", "myCreationTrace", "Ljava/lang/Exception;", "Lkotlin/Exception;", "myMultimoduleDirectories", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "getVmOptions", "()Ljava/lang/String;", "addMultimoduleDir", "", "applyProfiles", "Lorg/jetbrains/idea/maven/server/ProfileApplicationResult;", "model", "Lorg/jetbrains/idea/maven/model/MavenModel;", "basedir", "Ljava/nio/file/Path;", "explicitProfiles", "Lorg/jetbrains/idea/maven/model/MavenExplicitProfiles;", "alwaysOnProfiles", "", "(Lorg/jetbrains/idea/maven/model/MavenModel;Ljava/nio/file/Path;Lorg/jetbrains/idea/maven/model/MavenExplicitProfiles;Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "assembleInheritance", "parentModel", "(Lorg/jetbrains/idea/maven/model/MavenModel;Lorg/jetbrains/idea/maven/model/MavenModel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createEmbedder", "Lorg/jetbrains/idea/maven/server/MavenServerEmbedder;", "settings", "Lorg/jetbrains/idea/maven/server/MavenEmbedderSettings;", "createIndexer", "Lorg/jetbrains/idea/maven/server/MavenServerIndexer;", "dispose", "", "getDebugStatus", "Lorg/jetbrains/idea/maven/server/MavenServerStatus;", "clean", "getServer", "Lorg/jetbrains/idea/maven/server/MavenServer;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getServerBlocking", "interpolateAndAlignModel", "pomDir", "(Lorg/jetbrains/idea/maven/model/MavenModel;Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "perform", "R", "r", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "toString", "intellij.maven"})
public abstract class AbstractMavenServerConnector
implements MavenServerConnector {
    @Nullable
    private final Project project;
    @NotNull
    private final Sdk jdk;
    @NotNull
    private final String vmOptions;
    @NotNull
    private final MavenDistribution mavenDistribution;
    @JvmField
    @NotNull
    protected final Set<String> myMultimoduleDirectories;
    @NotNull
    private final Object embedderLock;
    @NotNull
    private final Exception myCreationTrace;

    public AbstractMavenServerConnector(@Nullable Project project2, @NotNull Sdk jdk2, @NotNull String vmOptions, @NotNull MavenDistribution mavenDistribution, @NotNull String multimoduleDirectory) {
        Intrinsics.checkNotNullParameter((Object)jdk2, (String)"jdk");
        Intrinsics.checkNotNullParameter((Object)vmOptions, (String)"vmOptions");
        Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
        Intrinsics.checkNotNullParameter((Object)multimoduleDirectory, (String)"multimoduleDirectory");
        this.project = project2;
        this.jdk = jdk2;
        this.vmOptions = vmOptions;
        this.mavenDistribution = mavenDistribution;
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.myMultimoduleDirectories = keySetView;
        this.embedderLock = new Object();
        this.myCreationTrace = new Exception();
        this.myMultimoduleDirectories.add(multimoduleDirectory);
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public Sdk getJdk() {
        return this.jdk;
    }

    @Override
    @NotNull
    public String getVmOptions() {
        return this.vmOptions;
    }

    @Override
    @NotNull
    public MavenDistribution getMavenDistribution() {
        return this.mavenDistribution;
    }

    @Override
    public boolean addMultimoduleDir(@NotNull String multimoduleDirectory) {
        Intrinsics.checkNotNullParameter((Object)multimoduleDirectory, (String)"multimoduleDirectory");
        return this.myMultimoduleDirectories.add(multimoduleDirectory);
    }

    @Deprecated(message="use suspend", replaceWith=@ReplaceWith(expression="getServer", imports={}))
    @NotNull
    protected abstract MavenServer getServerBlocking();

    @Nullable
    protected abstract Object getServer(@NotNull Continuation<? super MavenServer> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MavenServerEmbedder createEmbedder(@NotNull MavenEmbedderSettings settings) throws RemoteException {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Object object = this.embedderLock;
        synchronized (object) {
            boolean bl = false;
            try {
                MavenServerEmbedder mavenServerEmbedder = this.getServerBlocking().createEmbedder(settings, MavenRemoteObjectWrapper.ourToken);
                Intrinsics.checkNotNullExpressionValue((Object)mavenServerEmbedder, (String)"createEmbedder(...)");
                MavenServerEmbedder mavenServerEmbedder2 = mavenServerEmbedder;
                return mavenServerEmbedder2;
            }
            catch (Exception e) {
                block7: {
                    MavenCoreInitializationException cause = (MavenCoreInitializationException)ExceptionUtil.findCause((Throwable)e, MavenCoreInitializationException.class);
                    if (cause == null) break block7;
                    Project project2 = this.getProject();
                    Intrinsics.checkNotNull((Object)project2);
                    String string = cause.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    MavenServerEmbedder mavenServerEmbedder = new MisconfiguredPlexusDummyEmbedder(project2, string, this.myMultimoduleDirectories, this.getMavenDistribution().getVersion(), cause.getUnresolvedExtensionId());
                    return mavenServerEmbedder;
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MavenServerIndexer createIndexer() throws RemoteException {
        Object object = this.embedderLock;
        synchronized (object) {
            boolean bl = false;
            MavenServerIndexer mavenServerIndexer = this.getServerBlocking().createIndexer(MavenRemoteObjectWrapper.ourToken);
            Intrinsics.checkNotNullExpressionValue((Object)mavenServerIndexer, (String)"createIndexer(...)");
            MavenServerIndexer mavenServerIndexer2 = mavenServerIndexer;
            return mavenServerIndexer2;
        }
    }

    @Override
    @Nullable
    public Object interpolateAndAlignModel(@NotNull MavenModel model, @NotNull Path basedir, @NotNull Path pomDir, @NotNull Continuation<? super MavenModel> $completion) {
        return AbstractMavenServerConnector.interpolateAndAlignModel$suspendImpl(this, model, basedir, pomDir, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object interpolateAndAlignModel$suspendImpl(AbstractMavenServerConnector var0, MavenModel var1_1, Path var2_2, Path var3_3, Continuation<? super MavenModel> var4_4) {
        if (!(var4_4 instanceof interpolateAndAlignModel.1)) ** GOTO lbl-1000
        var11_5 = var4_4;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractMavenServerConnector this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AbstractMavenServerConnector.interpolateAndAlignModel$suspendImpl(this.this$0, null, null, null, (Continuation<? super MavenModel>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $this.getProject();
                Intrinsics.checkNotNull((Object)v0);
                transformer = RemotePathTransformerFactory.createForProject(v0);
                targetBasedir = new File(transformer.toRemotePathOrSelf(basedir.toString()));
                targetPomDir = new File(transformer.toRemotePathOrSelf(pomDir.toString()));
                $continuation.L$0 = model;
                $continuation.L$1 = transformer;
                $continuation.L$2 = targetBasedir;
                $continuation.L$3 = targetPomDir;
                $continuation.label = 1;
                v1 = $this.getServer((Continuation<? super MavenServer>)$continuation);
                if (v1 == var12_7) {
                    return var12_7;
                }
                ** GOTO lbl33
            }
            case 1: {
                targetPomDir = (File)$continuation.L$3;
                targetBasedir = (File)$continuation.L$2;
                transformer = (RemotePathTransformerFactory.Transformer)$continuation.L$1;
                model = (MavenModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                var9_11 = ((MavenServer)v1).interpolateAndAlignModel(model, targetBasedir, targetPomDir, MavenRemoteObjectWrapper.ourToken);
                Intrinsics.checkNotNullExpressionValue((Object)var9_11, (String)"interpolateAndAlignModel(...)");
                m = var9_11;
                if (transformer != RemotePathTransformerFactory.Transformer.ID) {
                    new MavenBuildPathsChange((Function1<? super String, String>)((Function1)new Function1<String, String>(transformer){
                        final /* synthetic */ RemotePathTransformerFactory.Transformer $transformer;
                        {
                            this.$transformer = $transformer;
                            super(1);
                        }

                        @NotNull
                        public final String invoke(@Nullable String s) {
                            String string = s;
                            Intrinsics.checkNotNull((Object)string);
                            String string2 = this.$transformer.toIdePath(string);
                            Intrinsics.checkNotNull((Object)string2);
                            return string2;
                        }
                    }), (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(transformer){
                        final /* synthetic */ RemotePathTransformerFactory.Transformer $transformer;
                        {
                            this.$transformer = $transformer;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@Nullable String s) {
                            return this.$transformer.canBeRemotePath(s);
                        }
                    })).perform(m);
                }
                return m;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object assembleInheritance(@NotNull MavenModel model, @NotNull MavenModel parentModel, @NotNull Continuation<? super MavenModel> $completion) {
        return AbstractMavenServerConnector.assembleInheritance$suspendImpl(this, model, parentModel, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object assembleInheritance$suspendImpl(AbstractMavenServerConnector var0, MavenModel var1_1, MavenModel var2_2, Continuation<? super MavenModel> var3_3) {
        if (!(var3_3 instanceof assembleInheritance.1)) ** GOTO lbl-1000
        var5_4 = var3_3;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractMavenServerConnector this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AbstractMavenServerConnector.assembleInheritance$suspendImpl(this.this$0, null, null, (Continuation<? super MavenModel>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = model;
                $continuation.L$1 = parentModel;
                $continuation.label = 1;
                v0 = $this.getServer((Continuation<? super MavenServer>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                parentModel = (MavenModel)$continuation.L$1;
                model = (MavenModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                v1 = ((MavenServer)v0).assembleInheritance(model, parentModel, MavenRemoteObjectWrapper.ourToken);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"assembleInheritance(...)");
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object applyProfiles(@NotNull MavenModel model, @NotNull Path basedir, @NotNull MavenExplicitProfiles explicitProfiles, @NotNull Collection<String> alwaysOnProfiles, @NotNull Continuation<? super ProfileApplicationResult> $completion) {
        return AbstractMavenServerConnector.applyProfiles$suspendImpl(this, model, basedir, explicitProfiles, alwaysOnProfiles, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object applyProfiles$suspendImpl(AbstractMavenServerConnector var0, MavenModel var1_1, Path var2_2, MavenExplicitProfiles var3_3, Collection<String> var4_4, Continuation<? super ProfileApplicationResult> var5_5) {
        if (!(var5_5 instanceof applyProfiles.1)) ** GOTO lbl-1000
        var9_6 = var5_5;
        if ((var9_6.label & -2147483648) != 0) {
            var9_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var5_5){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractMavenServerConnector this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AbstractMavenServerConnector.applyProfiles$suspendImpl(this.this$0, null, null, null, null, (Continuation<? super ProfileApplicationResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $this.getProject();
                Intrinsics.checkNotNull((Object)v0);
                transformer = RemotePathTransformerFactory.createForProject(v0);
                targetBasedir = new File(transformer.toRemotePathOrSelf(basedir.toString()));
                $continuation.L$0 = model;
                $continuation.L$1 = explicitProfiles;
                $continuation.L$2 = alwaysOnProfiles;
                $continuation.L$3 = targetBasedir;
                $continuation.label = 1;
                v1 = $this.getServer((Continuation<? super MavenServer>)$continuation);
                if (v1 == var10_8) {
                    return var10_8;
                }
                ** GOTO lbl32
            }
            case 1: {
                targetBasedir = (File)$continuation.L$3;
                alwaysOnProfiles = (Collection)$continuation.L$2;
                explicitProfiles = (MavenExplicitProfiles)$continuation.L$1;
                model = (MavenModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                v2 = ((MavenServer)v1).applyProfiles(model, targetBasedir, explicitProfiles, new HashSet<E>(alwaysOnProfiles), MavenRemoteObjectWrapper.ourToken);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"applyProfiles(...)");
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    protected abstract <R> R perform(@NotNull Function0<? extends R> var1);

    public void dispose() {
        MavenServerManager.Companion.getInstance().shutdownConnector(this, true);
    }

    @Override
    @NotNull
    public List<String> getMultimoduleDirectories() {
        return new ArrayList(this.myMultimoduleDirectories);
    }

    @Override
    @NotNull
    public MavenServerStatus getDebugStatus(boolean clean) {
        Object r = this.perform((Function0)new Function0<MavenServerStatus>(this, clean){
            final /* synthetic */ AbstractMavenServerConnector this$0;
            final /* synthetic */ boolean $clean;
            {
                this.this$0 = $receiver;
                this.$clean = $clean;
                super(0);
            }

            @NotNull
            public final MavenServerStatus invoke() {
                return this.this$0.getServerBlocking().getDebugStatus(this.$clean);
            }
        });
        Intrinsics.checkNotNullExpressionValue(r, (String)"perform(...)");
        return (MavenServerStatus)r;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "{" + Integer.toHexString(this.hashCode()) + ", myDistribution=" + this.getMavenDistribution().getMavenHome() + ", myJdk=" + this.getJdk().getName() + ", myMultimoduleDirectories=" + this.myMultimoduleDirectories + ", myCreationTrace = " + ExceptionUtil.getThrowableText((Throwable)this.myCreationTrace) + "}";
    }
}

