/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.concurrency.ThreadContext;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.DownloadArtifactEvent;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenPullDownloadListener;
import org.jetbrains.idea.maven.server.MavenPullServerLogger;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenRemoteProcessSupportFactory;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerConnectorBase;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.ServerLogEvent;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 '2\u00020\u0001:\u0002'(B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001a\u001a\u00020\u001bH\u0014J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u000bH\u0016J\f\u0010!\u001a\u00060\"R\u00020\u0000H\u0014J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerConnectorImpl;", "Lorg/jetbrains/idea/maven/server/MavenServerConnectorBase;", "project", "Lcom/intellij/openapi/project/Project;", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "vmOptions", "", "debugPort", "", "mavenDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "multimoduleDirectory", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/idea/maven/server/MavenDistribution;Ljava/lang/String;)V", "myDownloadConnectFailedCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "myExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "myLoggerConnectFailedCount", "myPullingDownloadFuture", "Ljava/util/concurrent/ScheduledFuture;", "myPullingLoggerFuture", "supportType", "getSupportType", "()Ljava/lang/String;", "cleanUpFutures", "", "isCompatibleWith", "", "anotherJdk", "otherVmOptions", "distribution", "newStartServerTask", "Lorg/jetbrains/idea/maven/server/MavenServerConnectorImpl$StartServerTask;", "startPullingDownloadListener", "server", "Lorg/jetbrains/idea/maven/server/MavenServer;", "startPullingLogger", "Companion", "StartServerTask", "intellij.maven"})
public class MavenServerConnectorImpl
extends MavenServerConnectorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScheduledExecutorService myExecutor;
    @NotNull
    private final AtomicInteger myLoggerConnectFailedCount;
    @NotNull
    private final AtomicInteger myDownloadConnectFailedCount;
    @Nullable
    private ScheduledFuture<?> myPullingLoggerFuture;
    @Nullable
    private ScheduledFuture<?> myPullingDownloadFuture;
    @NotNull
    private static final Logger LOG;

    public MavenServerConnectorImpl(@NotNull Project project2, @NotNull Sdk jdk2, @NotNull String vmOptions, @Nullable Integer debugPort, @NotNull MavenDistribution mavenDistribution, @NotNull String multimoduleDirectory) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jdk2, (String)"jdk");
        Intrinsics.checkNotNullParameter((Object)vmOptions, (String)"vmOptions");
        Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
        Intrinsics.checkNotNullParameter((Object)multimoduleDirectory, (String)"multimoduleDirectory");
        super(project2, jdk2, vmOptions, mavenDistribution, multimoduleDirectory, debugPort);
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Maven connector pulling", (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"createBoundedScheduledExecutorService(...)");
        this.myExecutor = scheduledExecutorService;
        this.myLoggerConnectFailedCount = new AtomicInteger(0);
        this.myDownloadConnectFailedCount = new AtomicInteger(0);
    }

    @Override
    public boolean isCompatibleWith(@NotNull Sdk anotherJdk, @NotNull String otherVmOptions, @NotNull MavenDistribution distribution) {
        Intrinsics.checkNotNullParameter((Object)anotherJdk, (String)"anotherJdk");
        Intrinsics.checkNotNullParameter((Object)otherVmOptions, (String)"otherVmOptions");
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        if (!this.getMavenDistribution().compatibleWith(distribution)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getJdk().getName(), (CharSequence)anotherJdk.getName())) {
            return false;
        }
        return StringUtil.equals((CharSequence)this.getVmOptions(), (CharSequence)otherVmOptions);
    }

    @Override
    @NotNull
    protected StartServerTask newStartServerTask() {
        return new StartServerTask();
    }

    @Override
    protected void cleanUpFutures() {
        try {
            int count;
            MavenServerConnectorImpl.Companion.cancelFuture(this.myPullingDownloadFuture);
            MavenServerConnectorImpl.Companion.cancelFuture(this.myPullingLoggerFuture);
            if (!this.myExecutor.isShutdown()) {
                this.myExecutor.shutdownNow();
            }
            if ((count = this.myLoggerConnectFailedCount.get()) != 0) {
                MavenLog.LOG.warn("Maven pulling logger failed: " + count + " times");
            }
            if ((count = this.myDownloadConnectFailedCount.get()) != 0) {
                MavenLog.LOG.warn("Maven pulling download listener failed: " + count + " times");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public String getSupportType() {
        String string;
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport support;
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport mavenRemoteProcessSupport = support = this.mySupport;
        if (mavenRemoteProcessSupport == null) {
            string = "???";
        } else {
            String string2 = mavenRemoteProcessSupport.type();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type(...)");
        }
        return string;
    }

    private final void startPullingDownloadListener(MavenServer server) throws RemoteException {
        MavenPullDownloadListener listener2 = server.createPullDownloadListener(MavenRemoteObjectWrapper.ourToken);
        if (listener2 == null) {
            return;
        }
        this.myPullingDownloadFuture = this.myExecutor.scheduleWithFixedDelay(() -> MavenServerConnectorImpl.startPullingDownloadListener$lambda$0(listener2, this), 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private final void startPullingLogger(MavenServer server) throws RemoteException {
        MavenPullServerLogger logger = server.createPullLogger(MavenRemoteObjectWrapper.ourToken);
        if (logger == null) {
            return;
        }
        this.myPullingLoggerFuture = this.myExecutor.scheduleWithFixedDelay(() -> MavenServerConnectorImpl.startPullingLogger$lambda$1(logger, this), 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private static final void startPullingDownloadListener$lambda$0(MavenPullDownloadListener $listener, MavenServerConnectorImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            List list = $listener.pull();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pull(...)");
            List artifactEvents = list;
            for (DownloadArtifactEvent e : artifactEvents) {
                ((MavenServerDownloadListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(MavenServerConnector.DOWNLOAD_LISTENER_TOPIC)).artifactDownloaded(new File(e.getFile()), e.getPath());
            }
            this$0.myDownloadConnectFailedCount.set(0);
        }
        catch (RemoteException e) {
            if (!Thread.currentThread().isInterrupted()) {
                this$0.myDownloadConnectFailedCount.incrementAndGet();
            }
            MavenLog.LOG.warn("Maven pulling download listener stopped");
            ScheduledFuture<?> scheduledFuture = this$0.myPullingDownloadFuture;
            Intrinsics.checkNotNull(scheduledFuture);
            scheduledFuture.cancel(true);
        }
    }

    private static final void startPullingLogger$lambda$1(MavenPullServerLogger $logger, MavenServerConnectorImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            List list = $logger.pull();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pull(...)");
            List logEvents = list;
            for (ServerLogEvent e : logEvents) {
                switch (WhenMappings.$EnumSwitchMapping$0[e.getType().ordinal()]) {
                    case 1: {
                        MavenLog.LOG.debug(e.getMessage());
                        break;
                    }
                    case 2: 
                    case 3: {
                        MavenLog.LOG.info(e.getMessage());
                        break;
                    }
                    case 4: 
                    case 5: {
                        MavenLog.LOG.warn(e.getMessage());
                    }
                }
            }
            this$0.myLoggerConnectFailedCount.set(0);
        }
        catch (RemoteException e) {
            if (!Thread.currentThread().isInterrupted()) {
                this$0.myLoggerConnectFailedCount.incrementAndGet();
            }
            MavenLog.LOG.warn("Maven pulling logger stopped");
            ScheduledFuture<?> scheduledFuture = this$0.myPullingLoggerFuture;
            Intrinsics.checkNotNull(scheduledFuture);
            scheduledFuture.cancel(true);
        }
    }

    static {
        Logger logger = Logger.getInstance(MavenServerConnectorImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerConnectorImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "cancelFuture", "", "future", "Ljava/util/concurrent/ScheduledFuture;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private final void cancelFuture(ScheduledFuture<?> future) {
            if (future != null) {
                try {
                    future.cancel(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerConnectorImpl$StartServerTask;", "Ljava/lang/Runnable;", "(Lorg/jetbrains/idea/maven/server/MavenServerConnectorImpl;)V", "run", "", "intellij.maven"})
    public final class StartServerTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProgressIndicator indicator = (ProgressIndicator)new EmptyProgressIndicator();
            String dirForLogs = (String)MavenServerConnectorImpl.this.myMultimoduleDirectories.iterator().next();
            MavenLog.LOG.debug("Connecting maven connector in " + dirForLogs);
            try {
                if (MavenServerConnectorImpl.this.myDebugPort != null) {
                    System.out.println((Object)("Listening for transport dt_socket at address: " + MavenServerConnectorImpl.this.myDebugPort));
                }
                Project project2 = MavenServerConnectorImpl.this.getProject();
                Intrinsics.checkNotNull((Object)project2);
                MavenRemoteProcessSupportFactory mavenRemoteProcessSupportFactory = MavenRemoteProcessSupportFactory.forProject(project2);
                Intrinsics.checkNotNullExpressionValue((Object)mavenRemoteProcessSupportFactory, (String)"forProject(...)");
                MavenRemoteProcessSupportFactory factory = mavenRemoteProcessSupportFactory;
                MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport mavenRemoteProcessSupport = MavenServerConnectorImpl.this.mySupport = factory.create(MavenServerConnectorImpl.this.getJdk(), MavenServerConnectorImpl.this.getVmOptions(), MavenServerConnectorImpl.this.getMavenDistribution(), MavenServerConnectorImpl.this.getProject(), MavenServerConnectorImpl.this.myDebugPort);
                Intrinsics.checkNotNull((Object)((Object)mavenRemoteProcessSupport));
                mavenRemoteProcessSupport.onTerminate(arg_0 -> StartServerTask.run$lambda$0(MavenServerConnectorImpl.this, arg_0));
                AutoCloseable autoCloseable = (AutoCloseable)ThreadContext.resetThreadContext();
                MavenServerConnectorImpl mavenServerConnectorImpl = MavenServerConnectorImpl.this;
                Throwable throwable = null;
                try {
                    AccessToken it = (AccessToken)autoCloseable;
                    boolean bl = false;
                    MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport mavenRemoteProcessSupport2 = mavenServerConnectorImpl.mySupport;
                    Intrinsics.checkNotNull((Object)((Object)mavenRemoteProcessSupport2));
                    MavenServer server = (MavenServer)mavenRemoteProcessSupport2.acquire(this, "", indicator);
                    Intrinsics.checkNotNull((Object)server);
                    mavenServerConnectorImpl.startPullingDownloadListener(server);
                    mavenServerConnectorImpl.startPullingLogger(server);
                    mavenServerConnectorImpl.myServerPromise.setResult((Object)server);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                MavenLog.LOG.debug("[connector] in " + dirForLogs + " has been connected " + MavenServerConnectorImpl.this);
            }
            catch (Throwable e) {
                MavenLog.LOG.warn("[connector] cannot connect in " + dirForLogs, e);
                MavenServerConnectorImpl.this.myServerPromise.setError(e);
            }
        }

        private static final void run$lambda$0(MavenServerConnectorImpl this$0, ProcessEvent it) {
            block0: {
                MavenServerManager mavenServerManager;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                MavenLog.LOG.debug("[connector] terminate " + this$0);
                MavenServerManager mavenServerManager2 = mavenServerManager = (MavenServerManager)ApplicationManager.getApplication().getServiceIfCreated(MavenServerManager.class);
                if (mavenServerManager2 == null) break block0;
                mavenServerManager2.shutdownConnector(this$0, false);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ServerLogEvent.Type.values().length];
            try {
                nArray[ServerLogEvent.Type.DEBUG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerLogEvent.Type.PRINT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerLogEvent.Type.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerLogEvent.Type.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerLogEvent.Type.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

