/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.wsl;

import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenImportingSettingsQuickFix;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerCMDState;
import org.jetbrains.idea.maven.server.WslMavenDistribution;
import org.jetbrains.idea.maven.server.wsl.BuildIssueWslJdk;
import org.jetbrains.idea.maven.server.wsl.MavenWslProcessHandler;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0007H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0015H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/maven/server/wsl/WslMavenCmdState;", "Lorg/jetbrains/idea/maven/server/MavenServerCMDState;", "myWslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "vmOptions", "", "mavenDistribution", "Lorg/jetbrains/idea/maven/server/WslMavenDistribution;", "debugPort", "", "myProject", "Lcom/intellij/openapi/project/Project;", "remoteHost", "(Lcom/intellij/execution/wsl/WSLDistribution;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Lorg/jetbrains/idea/maven/server/WslMavenDistribution;Ljava/lang/Integer;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getRemoteHost", "()Ljava/lang/String;", "createJavaParameters", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "getMavenOpts", "", "getWorkingDirectory", "startProcess", "Lcom/intellij/execution/process/ProcessHandler;", "toWslParameters", "parameters", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nWslMavenCmdState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslMavenCmdState.kt\norg/jetbrains/idea/maven/server/wsl/WslMavenCmdState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1603#2,9:133\n1855#2:142\n1856#2:144\n1612#2:145\n1#3:143\n1#3:146\n*S KotlinDebug\n*F\n+ 1 WslMavenCmdState.kt\norg/jetbrains/idea/maven/server/wsl/WslMavenCmdState\n*L\n66#1:133,9\n66#1:142\n66#1:144\n66#1:145\n66#1:143\n*E\n"})
public final class WslMavenCmdState
extends MavenServerCMDState {
    @NotNull
    private final WSLDistribution myWslDistribution;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String remoteHost;

    public WslMavenCmdState(@NotNull WSLDistribution myWslDistribution, @NotNull Sdk jdk2, @Nullable String vmOptions, @NotNull WslMavenDistribution mavenDistribution, @Nullable Integer debugPort, @NotNull Project myProject, @NotNull String remoteHost) {
        Intrinsics.checkNotNullParameter((Object)myWslDistribution, (String)"myWslDistribution");
        Intrinsics.checkNotNullParameter((Object)jdk2, (String)"jdk");
        Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        super(jdk2, vmOptions, mavenDistribution, debugPort);
        this.myWslDistribution = myWslDistribution;
        this.myProject = myProject;
        this.remoteHost = remoteHost;
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    public final String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    @NotNull
    protected Map<String, String> getMavenOpts() {
        return MavenWslUtil.getPropertiesFromMavenOpts(this.myWslDistribution);
    }

    @Override
    @NotNull
    protected String getWorkingDirectory() {
        String string = this.myWslDistribution.getUserHome();
        if (string == null) {
            string = "/";
        }
        return string;
    }

    @Override
    @NotNull
    protected SimpleJavaParameters createJavaParameters() {
        SimpleJavaParameters parameters = super.createJavaParameters();
        Intrinsics.checkNotNull((Object)parameters);
        SimpleJavaParameters wslParams = this.toWslParameters(parameters);
        wslParams.getVMParametersList().add("-Djava.rmi.server.hostname=" + this.remoteHost);
        wslParams.getVMParametersList().add("-Didea.maven.wsl=true");
        return wslParams;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleJavaParameters toWslParameters(SimpleJavaParameters parameters) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        SimpleJavaParameters wslParams = new SimpleJavaParameters();
        wslParams.setMainClass(parameters.getMainClass());
        for (String item : parameters.getVMParametersList().getParameters()) {
            wslParams.getVMParametersList().add(item);
        }
        for (String item : parameters.getProgramParametersList().getParameters()) {
            wslParams.getProgramParametersList().add(item);
        }
        wslParams.setCharset(parameters.getCharset());
        wslParams.getVMParametersList().add("-classpath");
        ParametersList parametersList = wslParams.getVMParametersList();
        List list = parameters.getClassPath().getPathList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathList(...)");
        Iterable iterable = list;
        WSLDistribution wSLDistribution = this.myWslDistribution;
        ParametersList parametersList2 = parametersList;
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String p0 = (String)element$iv$iv;
            boolean bl2 = false;
            if (wSLDistribution.getWslPath(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        parametersList2.add(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)":", null, null, (int)0, null, null, (int)62, null));
        return wslParams;
    }

    @Override
    @NotNull
    protected ProcessHandler startProcess() {
        String string;
        String wslPath;
        String projectJdkHomePath;
        WslTargetEnvironmentConfiguration wslConfig = new WslTargetEnvironmentConfiguration(this.myWslDistribution);
        WslTargetEnvironmentRequest request = new WslTargetEnvironmentRequest(wslConfig);
        SimpleJavaParameters wslParams = this.createJavaParameters();
        JavaLanguageRuntimeConfiguration languageRuntime = new JavaLanguageRuntimeConfiguration();
        String jdkHomePath = this.myJdk.getHomePath();
        Sdk sdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        String string2 = projectJdkHomePath = sdk != null ? sdk.getHomePath() : null;
        if (!Intrinsics.areEqual((Object)MavenWslUtil.tryGetWslDistributionForPath(jdkHomePath), (Object)this.myWslDistribution) && !Intrinsics.areEqual((Object)MavenWslUtil.tryGetWslDistributionForPath(projectJdkHomePath), (Object)this.myWslDistribution)) {
            MavenProjectsManager.getInstance(this.myProject).getSyncConsole().addBuildIssue(new BuildIssueWslJdk(), MessageEvent.Kind.WARNING);
        } else if (!Intrinsics.areEqual((Object)MavenWslUtil.tryGetWslDistributionForPath(jdkHomePath), (Object)this.myWslDistribution) && Intrinsics.areEqual((Object)MavenWslUtil.tryGetWslDistributionForPath(projectJdkHomePath), (Object)this.myWslDistribution)) {
            jdkHomePath = projectJdkHomePath;
            MavenProjectsManager.getInstance(this.myProject).getSyncConsole().addBuildIssue(new BuildIssue(){
                @NotNull
                private final String title;
                @NotNull
                private final String description;
                @NotNull
                private final List<BuildIssueQuickFix> quickFixes;
                {
                    String string = SyncBundle.message("maven.sync.wsl.jdk.set.to.project", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.title = string;
                    this.description = SyncBundle.message("maven.sync.wsl.jdk.set.to.project", new Object[0]) + "\n<a href=\"open_maven_importing_settings_quick_fix\">" + SyncBundle.message("maven.sync.wsl.jdk.fix", new Object[0]) + "</a>";
                    this.quickFixes = CollectionsKt.listOf((Object)new OpenMavenImportingSettingsQuickFix());
                }

                @NotNull
                public String getTitle() {
                    return this.title;
                }

                @NotNull
                public String getDescription() {
                    return this.description;
                }

                @NotNull
                public List<BuildIssueQuickFix> getQuickFixes() {
                    return this.quickFixes;
                }

                @Nullable
                public Navigatable getNavigatable(@NotNull Project project2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    return null;
                }
            }, MessageEvent.Kind.INFO);
        }
        String string3 = jdkHomePath;
        if (string3 != null) {
            String string4 = string3;
            WSLDistribution wSLDistribution = this.myWslDistribution;
            String p0 = string4;
            boolean bl = false;
            v3 = wSLDistribution.getWslPath(p0);
        } else {
            v3 = wslPath = null;
        }
        if (wslPath == null) {
            MavenProjectsManager.getInstance(this.myProject).getSyncConsole().addBuildIssue(new BuildIssue(){
                @NotNull
                private final String title;
                @NotNull
                private final String description;
                @NotNull
                private final List<BuildIssueQuickFix> quickFixes;
                {
                    String string = SyncBundle.message("maven.sync.wsl.jdk.revert.usr", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.title = string;
                    this.description = SyncBundle.message("maven.sync.wsl.jdk", new Object[0]) + "\n<a href=\"open_maven_importing_settings_quick_fix\">" + SyncBundle.message("maven.sync.wsl.jdk.fix", new Object[0]) + "</a>";
                    this.quickFixes = CollectionsKt.listOf((Object)new OpenMavenImportingSettingsQuickFix());
                }

                @NotNull
                public String getTitle() {
                    return this.title;
                }

                @NotNull
                public String getDescription() {
                    return this.description;
                }

                @NotNull
                public List<BuildIssueQuickFix> getQuickFixes() {
                    return this.quickFixes;
                }

                @Nullable
                public Navigatable getNavigatable(@NotNull Project project2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    return null;
                }
            }, MessageEvent.Kind.WARNING);
        }
        if ((string = wslPath) == null) {
            string = "/usr";
        }
        languageRuntime.setHomePath(string);
        request.getConfiguration().addLanguageRuntime((LanguageRuntimeConfiguration)languageRuntime);
        TargetedCommandLineBuilder targetedCommandLineBuilder = wslParams.toCommandLine((TargetEnvironmentRequest)request);
        Intrinsics.checkNotNullExpressionValue((Object)targetedCommandLineBuilder, (String)"toCommandLine(...)");
        TargetedCommandLineBuilder builder2 = targetedCommandLineBuilder;
        builder2.setWorkingDirectory(this.getWorkingDirectory());
        TargetProgressIndicator targetProgressIndicator = TargetProgressIndicator.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)targetProgressIndicator, (String)"EMPTY");
        TargetEnvironment wslEnvironment = request.prepareEnvironment(targetProgressIndicator);
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.myProject);
        TargetedCommandLine commandLine = builder2.build();
        String commandPresentation = commandLine.getCommandPresentation(wslEnvironment);
        MavenLog.LOG.info("Staring maven server on WSL as " + commandPresentation);
        ProgressIndicator progressIndicator = new MavenProgressIndicator(this.myProject, manager::getSyncConsole).getIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getIndicator(...)");
        Process process2 = wslEnvironment.createProcess(commandLine, progressIndicator);
        return (ProcessHandler)new MavenWslProcessHandler(process2, commandPresentation, this.myWslDistribution);
    }
}

