/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.DefaultJavaProgramRunner;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTask;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTasksProvider;
import org.jetbrains.idea.maven.tasks.MavenCompilerTask;
import org.jetbrains.idea.maven.tasks.MavenTasksManagerState;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;

@Service(value={Service.Level.PROJECT})
@State(name="MavenCompilerTasksManager")
public final class MavenTasksManager
extends MavenSimpleProjectComponent
implements PersistentStateComponent<MavenTasksManagerState>,
Disposable {
    private volatile MavenTasksManagerState myState;
    private final Object myStateLock;
    private final DisposableWrapperList<Listener> myListeners;

    public static MavenTasksManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            MavenTasksManager.$$$reportNull$$$0(0);
        }
        return (MavenTasksManager)project2.getService(MavenTasksManager.class);
    }

    public MavenTasksManager(@NotNull Project project2) {
        if (project2 == null) {
            MavenTasksManager.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myState = new MavenTasksManagerState();
        this.myStateLock = new Object();
        this.myListeners = new DisposableWrapperList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenTasksManagerState getState() {
        Object object = this.myStateLock;
        synchronized (object) {
            MavenTasksManagerState result2 = new MavenTasksManagerState();
            result2.afterCompileTasks = new HashSet<MavenCompilerTask>(this.myState.afterCompileTasks);
            result2.beforeCompileTasks = new HashSet<MavenCompilerTask>(this.myState.beforeCompileTasks);
            result2.afterRebuildTask = new HashSet<MavenCompilerTask>(this.myState.afterRebuildTask);
            result2.beforeRebuildTask = new HashSet<MavenCompilerTask>(this.myState.beforeRebuildTask);
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull MavenTasksManagerState state2) {
        if (state2 == null) {
            MavenTasksManager.$$$reportNull$$$0(2);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState = state2;
        }
        this.fireTasksChanged();
    }

    public void dispose() {
        this.myListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExecute(boolean before, CompileContext context2) {
        List<MavenRunnerParameters> parametersList;
        Object object = this.myStateLock;
        synchronized (object) {
            Set<Object> tasks;
            Set<Object> set2 = tasks = before ? this.myState.beforeCompileTasks : this.myState.afterCompileTasks;
            if (context2.isRebuild()) {
                tasks = ContainerUtil.union(before ? this.myState.beforeRebuildTask : this.myState.afterRebuildTask, tasks);
            }
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
            Set affectedModules = (Set)ReadAction.compute(() -> Set.of(context2.getCompileScope().getAffectedModules()));
            ArrayList<MavenTaskInfo> taskInfos = new ArrayList<MavenTaskInfo>();
            for (MavenCompilerTask mavenCompilerTask : tasks) {
                Module module2;
                MavenProject mavenProject2;
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(mavenCompilerTask.getProjectPath());
                if (file == null || null == (mavenProject2 = projectsManager.findProject(file)) || null == (module2 = (Module)ReadAction.compute(() -> projectsManager.findModule(mavenProject2))) || !affectedModules.contains(module2)) continue;
                MavenProject rootProject = projectsManager.findRootProject(mavenProject2);
                if (null == rootProject) {
                    rootProject = mavenProject2;
                }
                taskInfos.add(new MavenTaskInfo(mavenCompilerTask.getGoal(), file, mavenProject2, rootProject));
            }
            MavenExplicitProfiles explicitProfiles = projectsManager.getExplicitProfiles();
            parametersList = MavenTasksManager.taskInfosToParametersList(taskInfos, explicitProfiles);
        }
        if (parametersList.isEmpty()) {
            return true;
        }
        return MavenTasksManager.doRunTask(context2, parametersList);
    }

    private static List<MavenRunnerParameters> taskInfosToParametersList(@NotNull List<MavenTaskInfo> taskInfos, MavenExplicitProfiles explicitProfiles) {
        if (taskInfos == null) {
            MavenTasksManager.$$$reportNull$$$0(3);
        }
        if (taskInfos.isEmpty()) {
            return List.of();
        }
        Collection enabledProfiles = explicitProfiles.getEnabledProfiles();
        Collection disabledProfiles = explicitProfiles.getDisabledProfiles();
        ArrayList<MavenRunnerParameters> parametersList = new ArrayList<MavenRunnerParameters>();
        Collection<List<MavenTaskInfo>> taskGroups = taskInfos.stream().collect(Collectors.groupingBy(MavenTaskInfo::goalAndRootProject)).values();
        for (List<MavenTaskInfo> tasksInGroup : taskGroups) {
            MavenTaskInfo firstTask = tasksInGroup.get(0);
            MavenRunnerParameters params = new MavenRunnerParameters(true, firstTask.file().getParent().getPath(), firstTask.file().getName(), Collections.singletonList(firstTask.goal()), enabledProfiles, disabledProfiles);
            if (tasksInGroup.size() > 1) {
                String workingDirPath = firstTask.rootProject().getDirectory();
                params.setWorkingDirPath(workingDirPath);
                List<String> projectsCmdOptionValues = tasksInGroup.stream().map(task2 -> task2.mavenProject().getMavenId()).map(mavenId2 -> mavenId2.getGroupId() + ":" + mavenId2.getArtifactId()).toList();
                params.setProjectsCmdOptionValues(projectsCmdOptionValues);
            }
            parametersList.add(params);
        }
        return parametersList;
    }

    private static boolean doRunTask(CompileContext context2, List<MavenRunnerParameters> parametersList) {
        try {
            ProgramRunner runner = DefaultJavaProgramRunner.getInstance();
            Executor executor = DefaultRunExecutor.getRunExecutorInstance();
            long executionId = ExecutionEnvironment.getNextUnusedExecutionId();
            int count = 0;
            for (MavenRunnerParameters params : parametersList) {
                RunnerAndConfigurationSettings configuration = MavenRunConfigurationType.createRunnerAndConfigurationSettings(null, null, params, context2.getProject());
                if (parametersList.size() > 1) {
                    configuration.setName(MavenProjectBundle.message("maven.before.build.of.count", ++count, parametersList.size(), configuration.getName()));
                }
                ExecutionEnvironment environment = new ExecutionEnvironment(executor, runner, configuration, context2.getProject());
                environment.setExecutionId(executionId);
                boolean result2 = RunConfigurationBeforeRunProvider.doRunTask((String)executor.getId(), (ExecutionEnvironment)environment, (ProgramRunner)runner);
                if (result2) continue;
                return false;
            }
            return true;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            MavenLog.LOG.error("Cannot execute:", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompileTaskOfPhase(@NotNull MavenCompilerTask task2, @NotNull Phase phase) {
        if (task2 == null) {
            MavenTasksManager.$$$reportNull$$$0(4);
        }
        if (phase == null) {
            MavenTasksManager.$$$reportNull$$$0(5);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myState.getTasks(phase).contains(task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompileTasks(List<MavenCompilerTask> tasks, @NotNull Phase phase) {
        if (phase == null) {
            MavenTasksManager.$$$reportNull$$$0(6);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.getTasks(phase).addAll(tasks);
        }
        this.fireTasksChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompileTasks(List<MavenCompilerTask> tasks, @NotNull Phase phase) {
        if (phase == null) {
            MavenTasksManager.$$$reportNull$$$0(7);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.getTasks(phase).removeAll(tasks);
        }
        this.fireTasksChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(MavenProject project2, String goal) {
        ArrayList<String> result2 = new ArrayList<String>();
        MavenCompilerTask compilerTask = new MavenCompilerTask(project2.getPath(), goal);
        Iterator iterator = this.myStateLock;
        synchronized (iterator) {
            for (Phase phase : Phase.values()) {
                if (!this.myState.getTasks(phase).contains(compilerTask)) continue;
                result2.add(TasksBundle.message(phase.myMessageKey, new Object[0]));
            }
        }
        for (MavenBeforeRunTask each : RunManagerEx.getInstanceEx((Project)this.myProject).getBeforeRunTasks(MavenBeforeRunTasksProvider.ID)) {
            if (!each.isFor(project2, goal)) continue;
            result2.add(TasksBundle.message("maven.tasks.goal.before.run", new Object[0]));
            break;
        }
        return StringUtil.join(result2, (String)", ");
    }

    public void addListener(@NotNull Listener l, @NotNull Disposable disposable) {
        if (l == null) {
            MavenTasksManager.$$$reportNull$$$0(8);
        }
        if (disposable == null) {
            MavenTasksManager.$$$reportNull$$$0(9);
        }
        this.myListeners.add((Object)l, disposable);
    }

    public void fireTasksChanged() {
        for (Listener each : this.myListeners) {
            each.compileTasksChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskInfos";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/tasks/MavenTasksManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "taskInfosToParametersList";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompileTaskOfPhase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompileTasks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCompileTasks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record MavenTaskInfo(@NotNull String goal, @NotNull VirtualFile file, MavenProject mavenProject, MavenProject rootProject) {
        @NotNull
        private final String goal;
        @NotNull
        private final VirtualFile file;

        private MavenTaskInfo(@NotNull String goal, @NotNull VirtualFile file, MavenProject mavenProject2, MavenProject rootProject) {
            if (goal == null) {
                MavenTaskInfo.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MavenTaskInfo.$$$reportNull$$$0(1);
            }
        }

        public Pair<String, MavenProject> goalAndRootProject() {
            return new Pair((Object)this.goal(), (Object)this.rootProject());
        }

        @NotNull
        public String goal() {
            String string = this.goal;
            if (string == null) {
                MavenTaskInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public VirtualFile file() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                MavenTaskInfo.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "goal";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/tasks/MavenTasksManager$MavenTaskInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/tasks/MavenTasksManager$MavenTaskInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "goal";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static enum Phase {
        BEFORE_COMPILE("maven.tasks.goal.before.compile"),
        AFTER_COMPILE("maven.tasks.goal.after.compile"),
        BEFORE_REBUILD("maven.tasks.goal.before.rebuild"),
        AFTER_REBUILD("maven.tasks.goal.after.rebuild");

        @PropertyKey(resourceBundle="messages.MavenTasksBundle")
        public final @PropertyKey(resourceBundle="messages.MavenTasksBundle") String myMessageKey;

        private Phase(String messageKey) {
            this.myMessageKey = messageKey;
        }
    }

    public static interface Listener {
        public void compileTasksChanged();
    }

    @ApiStatus.Internal
    static final class MavenAfterCompileTask
    extends MyCompileTask {
        MavenAfterCompileTask() {
            super(false);
        }
    }

    @ApiStatus.Internal
    static final class MavenBeforeCompileTask
    extends MyCompileTask {
        MavenBeforeCompileTask() {
            super(true);
        }
    }

    private static class MyCompileTask
    implements CompileTask {
        private final boolean myBefore;

        MyCompileTask(boolean before) {
            this.myBefore = before;
        }

        public boolean execute(@NotNull CompileContext context2) {
            if (context2 == null) {
                MyCompileTask.$$$reportNull$$$0(0);
            }
            MavenTasksManager mavenTasksManager = MavenTasksManager.getInstance(context2.getProject());
            return mavenTasksManager.doExecute(this.myBefore, context2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/tasks/MavenTasksManager$MyCompileTask", "execute"));
        }
    }
}

