/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilderDriver;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001c\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\bH\u0007J(\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0007J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0007J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0007J\u001a\u0010\u0015\u001a\u00020\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\bH\u0007J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0087@\u00a2\u0006\u0002\u0010\u001aJ\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenJDOMUtil;", "", "()V", "collectChildren", "", "Lorg/jdom/Element;", "container", "subPath", "", "doRead", "text", "handler", "Lorg/jetbrains/idea/maven/utils/MavenJDOMUtil$ErrorHandler;", "findChildByPath", "element", "path", "findChildValueByPath", "defaultValue", "findChildrenByPath", "findChildrenValuesByPath", "childrenName", "hasChildByPath", "", "read", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/idea/maven/utils/MavenJDOMUtil$ErrorHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bytes", "", "ErrorHandler", "intellij.maven"})
public final class MavenJDOMUtil {
    @NotNull
    public static final MavenJDOMUtil INSTANCE = new MavenJDOMUtil();

    private MavenJDOMUtil() {
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @Nullable
    public static final Object read(@NotNull VirtualFile var0, @Nullable ErrorHandler var1_1, @NotNull Continuation<? super Element> var2_2) {
        if (!(var2_2 instanceof read.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var2_2){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MavenJDOMUtil.read(null, null, (Continuation<? super Element>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                app = ApplicationManager.getApplication();
                if (app == null || app.isDisposed()) {
                    return null;
                }
                $continuation.L$0 = handler;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)((Function0)new Function0<String>(file, handler){
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ ErrorHandler $handler;
                    {
                        this.$file = $file;
                        this.$handler = $handler;
                        super(0);
                    }

                    @Nullable
                    public final String invoke() {
                        String string;
                        if (!this.$file.isValid()) {
                            return null;
                        }
                        try {
                            string = VfsUtilCore.loadText((VirtualFile)this.$file);
                        }
                        catch (IOException e) {
                            ErrorHandler errorHandler = this.$handler;
                            if (errorHandler != null) {
                                errorHandler.onReadError(e);
                            }
                            string = null;
                        }
                        return string;
                    }
                }), (Continuation)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                handler = (ErrorHandler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                v1 = text = (String)v0;
                return v1 == null ? null : MavenJDOMUtil.INSTANCE.doRead(v1, handler);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @JvmStatic
    @Nullable
    public static final Element read(@NotNull byte[] bytes, @Nullable ErrorHandler handler) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String string = CharsetToolkit.bytesToString((byte[])bytes, (Charset)EncodingRegistry.getInstance().getDefaultCharset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bytesToString(...)");
        return INSTANCE.doRead(string, handler);
    }

    private final Element doRead(String text2, ErrorHandler handler) {
        LinkedList<Element> stack = new LinkedList<Element>();
        Element[] elementArray = new Element[]{null};
        Element[] result2 = elementArray;
        XmlBuilderDriver driver = new XmlBuilderDriver((CharSequence)text2);
        XmlBuilder builder2 = new XmlBuilder(stack, result2, handler){
            final /* synthetic */ LinkedList<Element> $stack;
            final /* synthetic */ Element[] $result;
            final /* synthetic */ ErrorHandler $handler;
            {
                this.$stack = $stack;
                this.$result = $result;
                this.$handler = $handler;
            }

            public void doctype(@Nullable CharSequence publicId, @Nullable CharSequence systemId, int startOffset, int endOffset) {
            }

            @NotNull
            public XmlBuilder.ProcessingOrder startTag(@NotNull CharSequence localName, @NotNull String namespace, int startoffset, int endoffset, int headerEndOffset) {
                Element parent;
                Element element;
                Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
                Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
                String name = ((Object)localName).toString();
                if (StringsKt.isBlank((CharSequence)name)) {
                    return XmlBuilder.ProcessingOrder.TAGS;
                }
                try {
                    element = new Element(name);
                }
                catch (IllegalNameException e) {
                    element = new Element("invalidName");
                }
                Element newElement = element;
                Element element2 = parent = this.$stack.isEmpty() ? null : this.$stack.getLast();
                if (parent == null) {
                    this.$result[0] = newElement;
                } else {
                    parent.addContent(newElement);
                }
                this.$stack.addLast(newElement);
                return XmlBuilder.ProcessingOrder.TAGS_AND_TEXTS;
            }

            public void endTag(@NotNull CharSequence localName, @NotNull String namespace, int startoffset, int endoffset) {
                Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
                Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
                String name = ((Object)localName).toString();
                if (StringsKt.isBlank((CharSequence)name)) {
                    return;
                }
                Iterator<Element> itr = this.$stack.descendingIterator();
                while (itr.hasNext()) {
                    Element element = itr.next();
                    if (!Intrinsics.areEqual((Object)element.getName(), (Object)name)) continue;
                    while (this.$stack.removeLast() != element) {
                    }
                    break;
                }
            }

            public void textElement(@NotNull CharSequence text2, @NotNull CharSequence physical, int startoffset, int endoffset) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)physical, (String)"physical");
                this.$stack.getLast().addContent(JDOMUtil.legalizeText((String)((Object)text2).toString()));
            }

            public void attribute(@NotNull CharSequence name, @NotNull CharSequence value, int startoffset, int endoffset) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            }

            public void entityRef(@NotNull CharSequence ref, int startOffset, int endOffset) {
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            }

            public void error(@NotNull String message, int startOffset, int endOffset) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    ErrorHandler errorHandler = this.$handler;
                    if (errorHandler == null) break block0;
                    errorHandler.onSyntaxError();
                }
            }
        };
        driver.build(builder2);
        return result2[0];
    }

    @JvmStatic
    @Nullable
    public static final Element findChildByPath(@Nullable Element element, @NotNull String path2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        int i2 = 0;
        for (Element el = element; el != null; el = el.getChild(string)) {
            int dot = StringsKt.indexOf$default((CharSequence)path2, (char)'.', (int)i2, (boolean)false, (int)4, null);
            if (dot == -1) {
                String string2 = path2.substring(i2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return el.getChild(string2);
            }
            string = path2.substring(i2, dot);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            i2 = dot + 1;
        }
        return null;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String findChildValueByPath(@Nullable Element element, @NotNull String path2, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Element child = MavenJDOMUtil.findChildByPath(element, path2);
        if (child == null) {
            return defaultValue;
        }
        String childValue = child.getTextTrim();
        Intrinsics.checkNotNull((Object)childValue);
        return ((CharSequence)childValue).length() == 0 ? defaultValue : childValue;
    }

    public static /* synthetic */ String findChildValueByPath$default(Element element, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return MavenJDOMUtil.findChildValueByPath(element, string, string2);
    }

    @JvmStatic
    public static final boolean hasChildByPath(@Nullable Element element, @NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return MavenJDOMUtil.findChildByPath(element, path2) != null;
    }

    @JvmStatic
    @NotNull
    public static final List<Element> findChildrenByPath(@Nullable Element element, @NotNull String path2, @NotNull String subPath) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)subPath, (String)"subPath");
        return INSTANCE.collectChildren(MavenJDOMUtil.findChildByPath(element, path2), subPath);
    }

    @JvmStatic
    @NotNull
    public static final List<String> findChildrenValuesByPath(@Nullable Element element, @NotNull String path2, @NotNull String childrenName) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)childrenName, (String)"childrenName");
        List result2 = new ArrayList();
        for (Element each : MavenJDOMUtil.findChildrenByPath(element, path2, childrenName)) {
            String value = each.getTextTrim();
            Intrinsics.checkNotNull((Object)value);
            if (((CharSequence)value).length() == 0) continue;
            result2.add(value);
        }
        return result2;
    }

    private final List<Element> collectChildren(Element container, String subPath) {
        if (container == null) {
            return CollectionsKt.emptyList();
        }
        int firstDot = StringsKt.indexOf$default((CharSequence)subPath, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (firstDot == -1) {
            List list = container.getChildren(subPath);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            return list;
        }
        String string = subPath.substring(0, firstDot);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String childName = string;
        String string2 = subPath.substring(firstDot + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String pathInChild = string2;
        List result2 = new ArrayList();
        for (Element each : container.getChildren(childName)) {
            Element child = MavenJDOMUtil.findChildByPath(each, pathInChild);
            if (child == null) continue;
            result2.add(child);
        }
        return result2;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String findChildValueByPath(@Nullable Element element, @NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return MavenJDOMUtil.findChildValueByPath$default(element, path2, null, 4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenJDOMUtil$ErrorHandler;", "", "onReadError", "", "e", "Ljava/io/IOException;", "onSyntaxError", "intellij.maven"})
    public static interface ErrorHandler {
        public void onReadError(@Nullable IOException var1);

        public void onSyntaxError();
    }
}

