/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.externalAnnotation.NonNlsAnnotationProvider;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.options.JavaClassValidator;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.i18n.I18nizeBatchQuickFix;
import com.intellij.codeInspection.i18n.I18nizeConcatenationQuickFix;
import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.codeInspection.i18n.SuppressByCommentOutAction;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptTab;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.codeInspection.restriction.AnnotationContext;
import com.intellij.codeInspection.restriction.RestrictionInfoFactory;
import com.intellij.codeInspection.restriction.StringFlowUtil;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.fixes.IntroduceConstantFix;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.intellij.lang.annotations.RegExp;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public final class I18nInspection
extends AbstractBaseUastLocalInspectionTool
implements CustomSuppressableInspectionTool {
    private static final CallMatcher ERROR_WRAPPER_METHODS = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"kotlin.PreconditionsKt__PreconditionsKt", (String[])new String[]{"error"}).parameterCount(1), CallMatcher.staticCall((String)"kotlin.StandardKt__StandardKt", (String[])new String[]{"TODO"}).parameterCount(1)});
    private static final Set<UastBinaryOperator> STRING_COMPARISON_OPS = Set.of(UastBinaryOperator.EQUALS, UastBinaryOperator.NOT_EQUALS, UastBinaryOperator.IDENTITY_EQUALS, UastBinaryOperator.IDENTITY_NOT_EQUALS);
    private static final CallMatcher IGNORED_METHODS = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.lang.String", (String[])new String[]{"valueOf"}).parameterTypes(new String[]{"int"}), CallMatcher.staticCall((String)"java.lang.String", (String[])new String[]{"valueOf"}).parameterTypes(new String[]{"double"}), CallMatcher.staticCall((String)"java.lang.String", (String[])new String[]{"valueOf"}).parameterTypes(new String[]{"long"}), CallMatcher.staticCall((String)"java.lang.String", (String[])new String[]{"valueOf"}).parameterTypes(new String[]{"char"}), CallMatcher.staticCall((String)"java.lang.Double", (String[])new String[]{"toString"}), CallMatcher.staticCall((String)"java.lang.Integer", (String[])new String[]{"toString"}), CallMatcher.staticCall((String)"java.lang.Long", (String[])new String[]{"toString"}), CallMatcher.instanceCall((String)"java.io.File", (String[])new String[]{"getAbsolutePath", "getCanonicalPath", "getName", "getPath"}), CallMatcher.instanceCall((String)"java.nio.file.Path", (String[])new String[]{"toString"}), CallMatcher.instanceCall((String)"java.lang.Throwable", (String[])new String[]{"getMessage", "getLocalizedMessage"}).parameterCount(0), CallMatcher.instanceCall((String)"java.lang.Throwable", (String[])new String[]{"toString"}).parameterCount(0), CallMatcher.instanceCall((String)"javax.swing.text.JTextComponent", (String[])new String[]{"getText"}).parameterCount(0)});
    private static final CallMatcher STRING_BUILDER_TO_STRING = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.instanceCall((String)"java.lang.StringBuffer", (String[])new String[]{"toString"}).parameterCount(0), CallMatcher.instanceCall((String)"java.lang.StringBuilder", (String[])new String[]{"toString"}).parameterCount(0)});
    @RegExp
    private static final String DEFAULT_NON_NLS_LITERAL_PATTERN = "((?i)https?://.+)|\\w*(\\.\\w+)+|\\w*[$]\\w*|((?i)</?(html|b|i|body|br|li|ol|ul|code)/?>)*|&\\w+;|[A-Za-z][a-z0-9]*([A-Z]+[a-z0-9]*)+";
    private static final CallMatcher STRING_LENGTH = CallMatcher.instanceCall((String)"java.lang.String", (String[])new String[]{"length"}).parameterCount(0);
    private static final CallMatcher STRING_EQUALS = CallMatcher.instanceCall((String)"java.lang.String", (String[])new String[]{"equals", "equalsIgnoreCase"}).parameterCount(1);
    public boolean ignoreForAssertStatements = true;
    public boolean ignoreForExceptionConstructors = true;
    @NlsSafe
    public String ignoreForSpecifiedExceptionConstructors = "";
    public boolean ignoreForJUnitAsserts = true;
    public boolean ignoreForClassReferences = true;
    public boolean ignoreForPropertyKeyReferences = true;
    public boolean ignoreForNonAlpha = true;
    private boolean ignoreForAllButNls = false;
    private boolean reportUnannotatedReferences = false;
    public boolean ignoreAssignedToConstants;
    public boolean ignoreToString;
    @NlsSafe
    private String nonNlsLiteralPattern;
    @NlsSafe
    public String nonNlsCommentPattern;
    private boolean ignoreForEnumConstants;
    @Nullable
    private Pattern myCachedCommentPattern;
    @Nullable
    private Pattern myCachedLiteralPattern;
    @NonNls
    private static final String TO_STRING = "toString";
    private static final String SKIP_FOR_ENUM = "ignoreForEnumConstant";
    private static final String IGNORE_ALL_BUT_NLS = "ignoreAllButNls";
    private static final String REPORT_UNANNOTATED_REFERENCES = "reportUnannotatedReferences";
    private static final String NON_NLS_LITERAL_PATTERN = "nonNlsLiteralPattern";

    public I18nInspection() {
        this.setNonNlsCommentPattern("NON-NLS");
        this.setNonNlsLiteralPattern(DEFAULT_NON_NLS_LITERAL_PATTERN);
    }

    public SuppressIntentionAction @NotNull [] getSuppressActions(PsiElement element) {
        Object[] suppressActions = this.getBatchSuppressActions(element);
        if (this.myCachedCommentPattern == null) {
            SuppressIntentionAction[] suppressIntentionActionArray = (SuppressIntentionAction[])ContainerUtil.map2Array((Object[])suppressActions, SuppressIntentionAction.class, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction);
            if (suppressIntentionActionArray == null) {
                I18nInspection.$$$reportNull$$$0(0);
            }
            return suppressIntentionActionArray;
        }
        ArrayList<SuppressByCommentOutAction> suppressors = new ArrayList<SuppressByCommentOutAction>(suppressActions.length + 1);
        suppressors.add(new SuppressByCommentOutAction(this.nonNlsCommentPattern));
        suppressors.addAll(ContainerUtil.map((Object[])suppressActions, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction));
        SuppressIntentionAction[] suppressIntentionActionArray = suppressors.toArray(SuppressIntentionAction.EMPTY_ARRAY);
        if (suppressIntentionActionArray == null) {
            I18nInspection.$$$reportNull$$$0(1);
        }
        return suppressIntentionActionArray;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            I18nInspection.$$$reportNull$$$0(2);
        }
        super.writeSettings(node);
        if (this.ignoreForEnumConstants) {
            node.addContent(new Element("option").setAttribute("name", SKIP_FOR_ENUM).setAttribute("value", Boolean.toString(this.ignoreForEnumConstants)));
        }
        if (this.reportUnannotatedReferences) {
            node.addContent(new Element("option").setAttribute("name", REPORT_UNANNOTATED_REFERENCES).setAttribute("value", Boolean.toString(this.reportUnannotatedReferences)));
        }
        if (this.ignoreForAllButNls) {
            node.addContent(new Element("option").setAttribute("name", IGNORE_ALL_BUT_NLS).setAttribute("value", Boolean.toString(this.ignoreForAllButNls)));
        }
        if (!this.nonNlsLiteralPattern.equals(DEFAULT_NON_NLS_LITERAL_PATTERN)) {
            node.addContent(new Element("option").setAttribute("name", NON_NLS_LITERAL_PATTERN).setAttribute("value", this.nonNlsLiteralPattern));
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            I18nInspection.$$$reportNull$$$0(3);
        }
        super.readSettings(node);
        for (Element o : node.getChildren()) {
            String nameAttr = o.getAttributeValue("name");
            String valueAttr = o.getAttributeValue("value");
            if (Comparing.strEqual((String)nameAttr, (String)SKIP_FOR_ENUM)) {
                if (valueAttr == null) continue;
                this.ignoreForEnumConstants = Boolean.parseBoolean(valueAttr);
                continue;
            }
            if (Comparing.strEqual((String)nameAttr, (String)IGNORE_ALL_BUT_NLS)) {
                if (valueAttr == null) continue;
                this.ignoreForAllButNls = Boolean.parseBoolean(valueAttr);
                continue;
            }
            if (Comparing.strEqual((String)nameAttr, (String)REPORT_UNANNOTATED_REFERENCES)) {
                if (valueAttr == null) continue;
                this.reportUnannotatedReferences = Boolean.parseBoolean(valueAttr);
                continue;
            }
            if (!Comparing.strEqual((String)nameAttr, (String)NON_NLS_LITERAL_PATTERN) || valueAttr == null) continue;
            this.setNonNlsLiteralPattern(valueAttr);
        }
        this.setNonNlsCommentPattern(this.nonNlsCommentPattern);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.internationalization.issues", (Object[])new Object[0]);
        if (string == null) {
            I18nInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "HardCodedStringLiteral";
    }

    @TestOnly
    public boolean setIgnoreForEnumConstants(boolean ignoreForEnumConstants) {
        boolean old = this.ignoreForEnumConstants;
        this.ignoreForEnumConstants = ignoreForEnumConstants;
        return old;
    }

    @TestOnly
    public boolean setReportUnannotatedReferences(boolean reportUnannotatedReferences) {
        boolean old = this.reportUnannotatedReferences;
        this.reportUnannotatedReferences = reportUnannotatedReferences;
        return old;
    }

    @TestOnly
    public boolean setIgnoreForAllButNls(boolean ignoreForAllButNls) {
        boolean old = this.ignoreForAllButNls;
        this.ignoreForAllButNls = ignoreForAllButNls;
        return old;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.tabs((OptTab[])new OptTab[]{OptPane.tab((String)JavaI18nBundle.message("inspection.i18n.option.tab.general", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreForAllButNls", (String)JavaI18nBundle.message("inspection.i18n.option.ignore.nls", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(JavaI18nBundle.message("inspection.i18n.option.ignore.nls.description", new Object[0])), OptPane.checkbox((String)REPORT_UNANNOTATED_REFERENCES, (String)JavaI18nBundle.message("inspection.i18n.option.report.unannotated.refs", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(JavaI18nBundle.message("inspection.i18n.option.report.unannotated.refs.description", new Object[0])), OptPane.expandableString((String)"nonNlsCommentPattern", (String)JavaI18nBundle.message("inspection.i18n.option.suppression.comment", new Object[0]), (String)"\n").description(JavaI18nBundle.message("inspection.i18n.option.suppression.comment.description", new Object[0]))}), OptPane.tab((String)JavaI18nBundle.message("inspection.i18n.option.tab.context", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.group((String)JavaI18nBundle.message("inspection.i18n.option.ignore.context", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreForAssertStatements", (String)JavaI18nBundle.message("inspection.i18n.option.ignore.context.assert", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(I18nInspection.exampleDescription("assert s.equals(\"Message\");")), OptPane.checkbox((String)"ignoreForJUnitAsserts", (String)JavaI18nBundle.message("inspection.i18n.option.ignore.context.junit.assert", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(I18nInspection.exampleDescription("assertEquals(s, \"Message\");")), OptPane.checkbox((String)"ignoreAssignedToConstants", (String)JavaI18nBundle.message("inspection.i18n.option.ignore.context.assigned.to.constants", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(I18nInspection.exampleDescription("static final ID = \"Message\"")), OptPane.checkbox((String)"ignoreToString", (String)JavaI18nBundle.message("inspection.i18n.option.ignore.context.tostring", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(I18nInspection.exampleDescription("public String toString() {\n  return \"MyObject: value = \" + value;\n}")), OptPane.checkbox((String)"ignoreForEnumConstants", (String)JavaI18nBundle.message("inspection.i18n.option.ignore.context.enum", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(I18nInspection.exampleDescription("enum MyEnum {\n  VALUE(\"Message\");\n  MyEnum(String msg) {}\n}")), OptPane.checkbox((String)"ignoreForExceptionConstructors", (String)JavaI18nBundle.message("inspection.i18n.option.ignore.context.exception.constructor", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"ignoreForSpecifiedExceptionConstructors", (String)"", (StringValidator)new JavaClassValidator().withSuperClass(new String[]{"java.lang.Throwable"}))})})}), OptPane.tab((String)JavaI18nBundle.message("inspection.i18n.option.tab.literals", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.group((String)JavaI18nBundle.message("inspection.i18n.option.no.report.content", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreForClassReferences", (String)JavaI18nBundle.message("inspection.i18n.option.no.report.content.qualified.class.names", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreForPropertyKeyReferences", (String)JavaI18nBundle.message("inspection.i18n.option.no.report.content.property.keys", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreForNonAlpha", (String)JavaI18nBundle.message("inspection.i18n.option.no.report.content.nonalphanumerics", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.expandableString((String)NON_NLS_LITERAL_PATTERN, (String)JavaI18nBundle.message("inspection.i18n.option.no.report.content.string.pattern", new Object[0]), (String)"\n")})})})});
        if (optPane == null) {
            I18nInspection.$$$reportNull$$$0(5);
        }
        return optPane;
    }

    @NotNull
    private static HtmlChunk exampleDescription(@NlsSafe String exampleText) {
        HtmlChunk htmlChunk = HtmlChunk.fragment((HtmlChunk[])new HtmlChunk[]{HtmlChunk.text((String)JavaI18nBundle.message("tooltip.example", new Object[0])), HtmlChunk.br(), HtmlChunk.tag((String)"pre").addText(exampleText)});
        if (htmlChunk == null) {
            I18nInspection.$$$reportNull$$$0(6);
        }
        return htmlChunk;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValue("ignoreForSpecifiedExceptionConstructors", () -> StringUtil.split((String)this.ignoreForSpecifiedExceptionConstructors, (String)","), res -> {
            this.ignoreForSpecifiedExceptionConstructors = StringUtil.join((Iterable)res, (String)",");
        }).onValueSet("nonNlsCommentPattern", pattern -> this.setNonNlsCommentPattern(pattern.toString())).onValueSet(NON_NLS_LITERAL_PATTERN, pattern -> this.setNonNlsLiteralPattern(pattern.toString()));
        if (optionController == null) {
            I18nInspection.$$$reportNull$$$0(7);
        }
        return optionController;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiDirectory directory;
        if (holder == null) {
            I18nInspection.$$$reportNull$$$0(8);
        }
        if ((directory = holder.getFile().getContainingDirectory()) != null && I18nInspection.isPackageNonNls(JavaDirectoryService.getInstance().getPackage(directory))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                I18nInspection.$$$reportNull$$$0(9);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new StringI18nVisitor(holder, isOnTheFly), (Class[])this.getHints());
        if (psiElementVisitor == null) {
            I18nInspection.$$$reportNull$$$0(10);
        }
        return psiElementVisitor;
    }

    private Class<? extends UElement>[] getHints() {
        Class[] classArray;
        if (this.reportUnannotatedReferences) {
            Class[] classArray2 = new Class[3];
            classArray2[0] = UInjectionHost.class;
            classArray2[1] = UCallExpression.class;
            classArray = classArray2;
            classArray2[2] = UReferenceExpression.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = UInjectionHost.class;
        }
        return classArray;
    }

    @NotNull
    public String getAlternativeID() {
        return "nls";
    }

    @NotNull
    private static LocalQuickFix createIntroduceConstantFix() {
        return new IntroduceConstantFix();
    }

    @Nullable
    private static ULocalVariable getVariableToSearch(UExpression passThrough) {
        PsiElement target;
        UExpression left;
        UElement uastParent = passThrough.getUastParent();
        ULocalVariable uVar = null;
        if (uastParent instanceof ULocalVariable) {
            uVar = (ULocalVariable)uastParent;
        } else if (uastParent instanceof UBinaryExpression && (((UBinaryExpression)uastParent).getOperator() == UastBinaryOperator.ASSIGN || ((UBinaryExpression)uastParent).getOperator() == UastBinaryOperator.PLUS_ASSIGN) && AnnotationContext.expressionsAreEquivalent((UExpression)((UBinaryExpression)uastParent).getRightOperand(), (UExpression)passThrough) && (left = ((UBinaryExpression)uastParent).getLeftOperand()) instanceof UResolvable && (uVar = (ULocalVariable)ObjectUtils.tryCast((Object)UastContextKt.toUElement((PsiElement)(target = ((UResolvable)left).resolve())), ULocalVariable.class)) == null && target != null) {
            uVar = (ULocalVariable)ObjectUtils.tryCast((Object)UastContextKt.toUElement((PsiElement)target.getParent()), ULocalVariable.class);
        }
        return uVar;
    }

    private static @Nullable List<@NotNull UExpression> findUsages(UExpression passThrough, ULocalVariable uVar) {
        PsiElement psiVar = uVar.getSourcePsi();
        PsiElement psi = passThrough.getSourcePsi();
        if (psi != null && psiVar != null) {
            if (psiVar instanceof PsiLocalVariable) {
                PsiLocalVariable local = (PsiLocalVariable)psiVar;
                PsiElement codeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)local, null);
                if (codeBlock instanceof PsiCodeBlock) {
                    List refs = VariableAccessUtils.getVariableReferences((PsiVariable)local, (PsiElement)codeBlock);
                    return ContainerUtil.mapNotNull((Collection)refs, ref -> PsiUtil.isAccessedForWriting((PsiExpression)ref) ? null : (UExpression)UastContextKt.toUElement((PsiElement)ref, UExpression.class));
                }
            } else {
                Collection refs = ReferencesSearch.search((PsiElement)psiVar, (SearchScope)psiVar.getUseScope()).findAll();
                return ContainerUtil.mapNotNull((Collection)refs, ref -> {
                    UExpression expr = (UExpression)UastContextKt.toUElement((PsiElement)ref.getElement(), UExpression.class);
                    if (expr != null && expr.getUastParent() instanceof UBinaryExpression && AnnotationContext.expressionsAreEquivalent((UExpression)((UBinaryExpression)expr.getUastParent()).getLeftOperand(), (UExpression)expr)) {
                        return null;
                    }
                    return expr;
                });
            }
        }
        return null;
    }

    private static String getStringValueOfKnownPart(@NotNull UInjectionHost expression) {
        UStringConcatenationsFacade concatenationsFacade;
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(11);
        }
        if ((concatenationsFacade = UStringConcatenationsFacade.createFromUExpression((UExpression)expression)) != null) {
            return concatenationsFacade.asPartiallyKnownString().getConcatenationOfKnown();
        }
        return expression.evaluateToString();
    }

    static List<UExpression> findIndirectUsages(UExpression expression, boolean allowStringModifications) {
        List<UExpression> usages;
        UExpression passThrough = StringFlowUtil.goUp((UExpression)expression, (boolean)allowStringModifications, (RestrictionInfoFactory)NlsInfo.factory());
        ULocalVariable uVar = I18nInspection.getVariableToSearch(passThrough);
        if (uVar != null && NlsInfo.fromUVariable((UVariable)uVar).getNlsStatus() == ThreeState.UNSURE && (usages = I18nInspection.findUsages(passThrough, uVar)) != null) {
            return usages;
        }
        return Collections.singletonList(passThrough);
    }

    private NlsInfo getExpectedNlsInfo(@NotNull Project project, @NotNull UExpression expression, @Nullable String value, @NotNull Set<? super PsiModifierListOwner> nonNlsTargets, boolean onTheFly, boolean ignoreForAllButNls) {
        if (project == null) {
            I18nInspection.$$$reportNull$$$0(12);
        }
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(13);
        }
        if (nonNlsTargets == null) {
            I18nInspection.$$$reportNull$$$0(14);
        }
        if (this.ignoreForNonAlpha && value != null && !StringUtil.containsAlphaCharacters((String)value)) {
            return NlsInfo.nonLocalized();
        }
        if (this.isSuppressedByComment(project, expression)) {
            return NlsInfo.nonLocalized();
        }
        if (value != null && this.myCachedLiteralPattern != null && this.myCachedLiteralPattern.matcher(value).matches()) {
            return NlsInfo.nonLocalized();
        }
        List<UExpression> usages = I18nInspection.findIndirectUsages(expression, true);
        if (usages.isEmpty()) {
            usages = Collections.singletonList(expression);
        }
        for (UExpression usage : usages) {
            NlsInfo info = NlsInfo.forExpression(usage);
            switch (info.getNlsStatus()) {
                case YES: {
                    return info;
                }
                case UNSURE: {
                    if (ignoreForAllButNls || this.shouldIgnoreUsage(project, value, nonNlsTargets, usage)) break;
                    if (!onTheFly) {
                        nonNlsTargets.clear();
                    }
                    ContainerUtil.addIfNotNull(nonNlsTargets, (Object)((NlsInfo.NlsUnspecified)info).getAnnotationCandidate());
                    return NlsInfo.localized();
                }
            }
        }
        return NlsInfo.nonLocalized();
    }

    private boolean isSuppressedByComment(@NotNull Project project, @NotNull UExpression expression) {
        Pattern pattern;
        if (project == null) {
            I18nInspection.$$$reportNull$$$0(15);
        }
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(16);
        }
        if ((pattern = this.myCachedCommentPattern) != null) {
            PsiElement sourcePsi = expression.getSourcePsi();
            if (sourcePsi == null) {
                return false;
            }
            PsiFile file = sourcePsi.getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document == null) {
                return false;
            }
            int line = document.getLineNumber(sourcePsi.getTextRange().getStartOffset());
            int lineStartOffset = document.getLineStartOffset(line);
            CharSequence lineText = document.getCharsSequence().subSequence(lineStartOffset, document.getLineEndOffset(line));
            Matcher matcher = pattern.matcher(lineText);
            int start = 0;
            while (matcher.find(start)) {
                start = matcher.start();
                PsiElement element = file.findElementAt(lineStartOffset + start);
                if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                    return true;
                }
                if (start == lineText.length() - 1) break;
                ++start;
            }
        }
        return false;
    }

    private boolean shouldIgnoreUsage(@NotNull Project project, @Nullable String value, @NotNull Set<? super PsiModifierListOwner> nonNlsTargets, @NotNull UExpression usage) {
        if (project == null) {
            I18nInspection.$$$reportNull$$$0(17);
        }
        if (nonNlsTargets == null) {
            I18nInspection.$$$reportNull$$$0(18);
        }
        if (usage == null) {
            I18nInspection.$$$reportNull$$$0(19);
        }
        if (I18nInspection.isInNonNlsCallChain(usage, nonNlsTargets)) {
            return true;
        }
        if (I18nInspection.isSafeStringMethod(usage, nonNlsTargets)) {
            return true;
        }
        if (this.isPassedToNonNls(usage, nonNlsTargets)) {
            return true;
        }
        if (this.ignoreForAssertStatements && I18nInspection.isArgOfAssertStatement(usage)) {
            return true;
        }
        if (this.ignoreForExceptionConstructors && I18nInspection.isExceptionArgument(usage)) {
            return true;
        }
        if (this.ignoreForEnumConstants && I18nInspection.isArgOfEnumConstant(usage)) {
            return true;
        }
        if (!this.ignoreForExceptionConstructors && I18nInspection.isArgOfSpecifiedExceptionConstructor(usage, this.ignoreForSpecifiedExceptionConstructors.split(","))) {
            return true;
        }
        if (this.ignoreForJUnitAsserts && I18nInspection.isArgOfJUnitAssertion(usage)) {
            return true;
        }
        if (this.ignoreForClassReferences && value != null && I18nInspection.isClassRef(project, value)) {
            return true;
        }
        if (this.ignoreForPropertyKeyReferences && value != null && !PropertiesImplUtil.findPropertiesByKey((Project)project, (String)value).isEmpty()) {
            return true;
        }
        return this.ignoreToString && I18nInspection.isToString(usage);
    }

    private static boolean isArgOfEnumConstant(UExpression expression) {
        return expression.getUastParent() instanceof UEnumConstant;
    }

    public void setNonNlsCommentPattern(String pattern) {
        this.nonNlsCommentPattern = pattern;
        this.myCachedCommentPattern = null;
        if (!pattern.trim().isEmpty()) {
            try {
                this.myCachedCommentPattern = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    public void setNonNlsLiteralPattern(String pattern) {
        this.nonNlsLiteralPattern = pattern;
        this.myCachedLiteralPattern = null;
        if (!pattern.trim().isEmpty()) {
            try {
                this.myCachedLiteralPattern = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    private static boolean isClassRef(@NotNull Project project, String value) {
        if (project == null) {
            I18nInspection.$$$reportNull$$$0(20);
        }
        if (StringUtil.startsWithChar((CharSequence)value, (char)'#')) {
            value = value.substring(1);
        }
        return JavaPsiFacade.getInstance((Project)project).findClass(value, GlobalSearchScope.allScope((Project)project)) != null || ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)project), (String)value) != null;
    }

    public static boolean isPackageNonNls(PsiPackage psiPackage) {
        if (psiPackage == null || psiPackage.getName() == null) {
            return false;
        }
        PsiModifierList pkgModifierList = psiPackage.getAnnotationList();
        return pkgModifierList != null && pkgModifierList.hasAnnotation("org.jetbrains.annotations.NonNls") || I18nInspection.isPackageNonNls(psiPackage.getParentPackage());
    }

    private boolean isPassedToNonNls(@NotNull UExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        NlsInfo info;
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(21);
        }
        if ((info = NlsInfo.forExpression(JavaI18nUtil.getTopLevelExpression(expression, false))).getNlsStatus() == ThreeState.NO) {
            return true;
        }
        if (info instanceof NlsInfo.NlsUnspecified) {
            PsiModifierListOwner candidate = ((NlsInfo.NlsUnspecified)info).getAnnotationCandidate();
            if (candidate instanceof PsiVariable && this.ignoreAssignedToConstants && candidate.hasModifierProperty("static") && candidate.hasModifierProperty("final")) {
                return true;
            }
            ContainerUtil.addIfNotNull(nonNlsTargets, (Object)candidate);
        }
        return false;
    }

    private static boolean annotatedAsNonNls(@NotNull PsiModifierListOwner parent) {
        if (parent == null) {
            I18nInspection.$$$reportNull$$$0(22);
        }
        return NlsInfo.forModifierListOwner(parent).getNlsStatus() == ThreeState.NO;
    }

    private static boolean isSafeStringMethod(UExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        UBinaryExpression binOp;
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent());
        if (parent instanceof UBinaryExpression && STRING_COMPARISON_OPS.contains((binOp = (UBinaryExpression)parent).getOperator())) {
            UResolvable left = (UResolvable)ObjectUtils.tryCast((Object)UastUtils.skipParenthesizedExprDown((UExpression)binOp.getLeftOperand()), UResolvable.class);
            UResolvable right = (UResolvable)ObjectUtils.tryCast((Object)UastUtils.skipParenthesizedExprDown((UExpression)binOp.getRightOperand()), UResolvable.class);
            return left != null && I18nInspection.isNonNlsCall(left, nonNlsTargets) || right != null && I18nInspection.isNonNlsCall(right, nonNlsTargets);
        }
        if (!(parent instanceof UQualifiedReferenceExpression)) {
            return false;
        }
        UExpression selector = ((UQualifiedReferenceExpression)parent).getSelector();
        if (!(selector instanceof UCallExpression)) {
            return false;
        }
        UCallExpression call = (UCallExpression)selector;
        if (STRING_EQUALS.uCallMatches(call)) {
            List expressions = call.getValueArguments();
            if (expressions.size() != 1) {
                return false;
            }
            UExpression arg = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)expressions.get(0)));
            UReferenceExpression ref = (UReferenceExpression)ObjectUtils.tryCast((Object)arg, UReferenceExpression.class);
            if (ref != null) {
                return I18nInspection.isNonNlsCall((UResolvable)ref, nonNlsTargets);
            }
            return false;
        }
        return STRING_LENGTH.uCallMatches(call);
    }

    private static boolean isInNonNlsCallChain(@NotNull UExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        UElement parentOfNew;
        UExpression operand;
        UExpression parent;
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(23);
        }
        if ((parent = UastUtils.skipParenthesizedExprDown((UExpression)JavaI18nUtil.getTopLevelExpression(expression, true))) instanceof UResolvable && I18nInspection.isNonNlsCall((UResolvable)parent, nonNlsTargets)) {
            return true;
        }
        if (UastExpressionUtils.isAssignment((UElement)parent) && (operand = ((UBinaryExpression)parent).getLeftOperand()) instanceof UReferenceExpression && I18nInspection.isNonNlsCall((UResolvable)((UReferenceExpression)operand), nonNlsTargets)) {
            return true;
        }
        if (parent instanceof UCallExpression && (parentOfNew = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent())) instanceof ULocalVariable) {
            ULocalVariable newVariable = (ULocalVariable)parentOfNew;
            if (I18nInspection.annotatedAsNonNls((PsiModifierListOwner)newVariable.getPsi())) {
                return true;
            }
            PsiElement variableJavaPsi = newVariable.getJavaPsi();
            if (variableJavaPsi instanceof PsiModifierListOwner) {
                nonNlsTargets.add((PsiModifierListOwner)((PsiModifierListOwner)variableJavaPsi));
            }
            return false;
        }
        return false;
    }

    private static boolean isNonNlsCall(UResolvable qualifier, Set<? super PsiModifierListOwner> nonNlsTargets) {
        UExpression receiver;
        ULocalVariable uVar;
        PsiElement resolved = qualifier.resolve();
        if (resolved instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)resolved;
            if (I18nInspection.annotatedAsNonNls(modifierListOwner)) {
                return true;
            }
            nonNlsTargets.add((PsiModifierListOwner)modifierListOwner);
        }
        if ((uVar = (ULocalVariable)UastContextKt.toUElement((PsiElement)resolved, ULocalVariable.class)) != null) {
            PsiModifierListOwner method;
            if (NlsInfo.fromUVariable((UVariable)uVar).getNlsStatus() == ThreeState.NO) {
                return true;
            }
            UExpression initializer = uVar.getUastInitializer();
            if (initializer instanceof UResolvable && (method = (PsiModifierListOwner)ObjectUtils.tryCast((Object)((UResolvable)initializer).resolve(), PsiModifierListOwner.class)) != null) {
                if (I18nInspection.annotatedAsNonNls(method)) {
                    return true;
                }
                nonNlsTargets.add((PsiModifierListOwner)method);
            }
        }
        if (qualifier instanceof UQualifiedReferenceExpression && (receiver = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)qualifier).getReceiver())) instanceof UResolvable) {
            return I18nInspection.isNonNlsCall((UResolvable)receiver, nonNlsTargets);
        }
        return false;
    }

    private static boolean isToString(UExpression expression) {
        UMethod method = (UMethod)UastUtils.getParentOfType((UElement)expression, UMethod.class);
        if (method == null) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        return TO_STRING.equals(method.getName()) && method.getUastParameters().isEmpty() && returnType != null && "java.lang.String".equals(returnType.getCanonicalText());
    }

    private static boolean isArgOfJUnitAssertion(UExpression expression) {
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent());
        if (parent == null || !UastExpressionUtils.isMethodCall((UElement)parent)) {
            return false;
        }
        @NonNls String methodName = ((UCallExpression)parent).getMethodName();
        if (methodName == null) {
            return false;
        }
        if (!methodName.startsWith("assert") && !methodName.equals("fail")) {
            return false;
        }
        PsiMethod method = ((UCallExpression)parent).resolve();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.junit.Assert") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.junit.jupiter.api.Assertions") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.Assert");
    }

    private static boolean isArgOfSpecifiedExceptionConstructor(UExpression expression, String[] specifiedExceptions) {
        PsiClass aClass;
        if (specifiedExceptions.length == 0) {
            return false;
        }
        UCallExpression parent = (UCallExpression)UastUtils.getParentOfType((UElement)expression, UCallExpression.class, (boolean)true, (Class[])new Class[]{UClass.class});
        if (parent == null || !UastExpressionUtils.isConstructorCall((UElement)parent)) {
            return false;
        }
        PsiMethod resolved = parent.resolve();
        PsiClass psiClass = aClass = resolved != null ? resolved.getContainingClass() : null;
        if (aClass == null) {
            return false;
        }
        return ArrayUtil.contains((String)aClass.getQualifiedName(), (String[])specifiedExceptions);
    }

    private static boolean isArgOfAssertStatement(UExpression expression) {
        UCallExpression parent = (UCallExpression)UastUtils.getParentOfType((UElement)expression, UCallExpression.class);
        return parent != null && "assert".equals(parent.getMethodName());
    }

    public static boolean isExceptionArgument(@NotNull UExpression expression) {
        UCallExpression newExpression;
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(24);
        }
        if ((newExpression = (UCallExpression)UastUtils.getParentOfType((UElement)expression, UCallExpression.class, (boolean)true, (Class[])new Class[]{UBlockExpression.class, UClass.class})) != null) {
            PsiClass cls;
            UReferenceExpression classReference;
            if (UastExpressionUtils.isConstructorCall((UElement)newExpression) && (classReference = newExpression.getClassReference()) != null && (cls = (PsiClass)ObjectUtils.tryCast((Object)classReference.resolve(), PsiClass.class)) != null) {
                return InheritanceUtil.isInheritor((PsiClass)cls, (String)"java.lang.Throwable");
            }
            PsiMethod method = newExpression.resolve();
            if (method != null) {
                if (method.isConstructor()) {
                    return InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (String)"java.lang.Throwable");
                }
                return ERROR_WRAPPER_METHODS.methodMatches(method);
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 8, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/I18nInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonNlsTargets";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/I18nInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "exampleDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStringValueOfKnownPart";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedNlsInfo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedByComment";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shouldIgnoreUsage";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isClassRef";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPassedToNonNls";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "annotatedAsNonNls";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInNonNlsCallChain";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isExceptionArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 8, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24 -> new IllegalArgumentException(string);
        };
    }

    private final class StringI18nVisitor
    extends AbstractUastNonRecursiveVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myOnTheFly;

        private StringI18nVisitor(ProblemsHolder holder, boolean onTheFly) {
            if (holder == null) {
                StringI18nVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
            this.myOnTheFly = onTheFly;
        }

        public boolean visitCallExpression(@NotNull UCallExpression ref) {
            PsiClass containingClass;
            PsiElement sourcePsi;
            if (ref == null) {
                StringI18nVisitor.$$$reportNull$$$0(1);
            }
            if ((sourcePsi = ref.getSourcePsi()) == null) {
                return true;
            }
            PsiMethod target = ref.resolve();
            if (target == null) {
                return true;
            }
            if (IGNORED_METHODS.methodMatches(target)) {
                return true;
            }
            if (!target.hasModifierProperty("static") && (containingClass = target.getContainingClass()) != null && ("java.lang.String".equals(containingClass.getQualifiedName()) || "java.lang.CharSequence".equals(containingClass.getQualifiedName()))) {
                return true;
            }
            UElement uElement = ref.getUastParent();
            if (uElement instanceof UQualifiedReferenceExpression) {
                UExpression receiver;
                UQualifiedReferenceExpression parent = (UQualifiedReferenceExpression)uElement;
                if (STRING_BUILDER_TO_STRING.methodMatches(target) && (receiver = parent.getReceiver()) instanceof UResolvable) {
                    PsiElement receiverTarget = ((UResolvable)receiver).resolve();
                    if (receiverTarget instanceof PsiModifierListOwner && NlsInfo.forModifierListOwner((PsiModifierListOwner)receiverTarget).canBeUsedInLocalizedContext()) {
                        return false;
                    }
                    ULocalVariable uVar = (ULocalVariable)UastContextKt.toUElement((PsiElement)receiverTarget, ULocalVariable.class);
                    if (uVar != null && NlsInfo.fromUVariable((UVariable)uVar).canBeUsedInLocalizedContext()) {
                        return false;
                    }
                }
            }
            this.processReferenceToNonLocalized(sourcePsi, (UExpression)ref, (PsiModifierListOwner)target);
            return true;
        }

        public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression ref) {
            if (ref == null) {
                StringI18nVisitor.$$$reportNull$$$0(2);
            }
            return this.visitReference((UReferenceExpression)ref);
        }

        public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression ref) {
            if (ref == null) {
                StringI18nVisitor.$$$reportNull$$$0(3);
            }
            return this.visitReference((UReferenceExpression)ref);
        }

        private boolean visitReference(@NotNull UReferenceExpression ref) {
            PsiElement sourcePsi;
            if (ref == null) {
                StringI18nVisitor.$$$reportNull$$$0(4);
            }
            if ((sourcePsi = ref.getSourcePsi()) == null) {
                return true;
            }
            PsiVariable target = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
            if (target == null || target instanceof PsiLocalVariable) {
                return true;
            }
            this.processReferenceToNonLocalized(sourcePsi, (UExpression)ref, (PsiModifierListOwner)target);
            return true;
        }

        private void processReferenceToNonLocalized(@NotNull PsiElement sourcePsi, @NotNull UExpression ref, PsiModifierListOwner target) {
            PsiType type;
            if (sourcePsi == null) {
                StringI18nVisitor.$$$reportNull$$$0(5);
            }
            if (ref == null) {
                StringI18nVisitor.$$$reportNull$$$0(6);
            }
            if (!TypeUtils.isJavaLangString((PsiType)(type = ref.getExpressionType())) && !TypeUtils.typeEquals((String)"java.lang.CharSequence", (PsiType)type)) {
                return;
            }
            if (target instanceof PsiMethod && (StringFlowUtil.isStringProcessingMethod((PsiMethod)((PsiMethod)target), (RestrictionInfoFactory)NlsInfo.factory()) || StringFlowUtil.isPassthroughMethod((PsiMethod)((PsiMethod)target), null, null, (RestrictionInfoFactory)NlsInfo.factory()))) {
                return;
            }
            if (NlsInfo.forModifierListOwner(target).canBeUsedInLocalizedContext()) {
                return;
            }
            if (NlsInfo.forType(type).canBeUsedInLocalizedContext()) {
                return;
            }
            String value = target instanceof PsiVariable ? (String)ObjectUtils.tryCast((Object)((PsiVariable)target).computeConstantValue(), String.class) : null;
            NlsInfo targetInfo = I18nInspection.this.getExpectedNlsInfo(this.myHolder.getProject(), ref, value, new HashSet(), this.myOnTheFly, true);
            if (targetInfo instanceof NlsInfo.Localized) {
                boolean addNullSafe;
                ArrayList<Object> fixes = new ArrayList<Object>();
                String fqn = ((NlsInfo.Localized)targetInfo).suggestAnnotation((PsiElement)target);
                ExternalAnnotationsManager.AnnotationPlace annotationPlace = AddAnnotationPsiFix.choosePlace((String)fqn, (PsiModifierListOwner)target);
                boolean bl = addNullSafe = JavaPsiFacade.getInstance((Project)target.getProject()).findClass("com.intellij.openapi.util.NlsSafe", target.getResolveScope()) != null;
                if (annotationPlace == ExternalAnnotationsManager.AnnotationPlace.IN_CODE && target instanceof JvmModifiersOwner) {
                    fixes.addAll(IntentionWrapper.wrapToQuickFixes((List)JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)((JvmModifiersOwner)target), (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)fqn, (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0])), (PsiFile)sourcePsi.getContainingFile()));
                    if (addNullSafe) {
                        for (IntentionAction action : JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)((JvmModifiersOwner)target), (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)"com.intellij.openapi.util.NlsSafe", (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]))) {
                            fixes.add(new IntentionWrapper(action){

                                @NotNull
                                public String getFamilyName() {
                                    String string = JavaI18nBundle.message("intention.family.name.mark.as.nlssafe", new Object[0]);
                                    if (string == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    return string;
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/I18nInspection$StringI18nVisitor$1", "getFamilyName"));
                                }
                            });
                        }
                    }
                } else {
                    fixes.add(new AddAnnotationFix(fqn, target, new String[]{"org.jetbrains.annotations.NonNls"}));
                    if (addNullSafe) {
                        fixes.add((Object)new MarkAsSafeFix(target));
                    }
                }
                String description = JavaI18nBundle.message("inspection.i18n.message.non.localized.passed.to.localized", new Object[0]);
                this.myHolder.registerProblem(sourcePsi, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        public boolean visitElement(@NotNull UElement node) {
            PsiElement psi;
            if (node == null) {
                StringI18nVisitor.$$$reportNull$$$0(7);
            }
            if (node instanceof UInjectionHost && (psi = node.getSourcePsi()) != null) {
                this.visitLiteralExpression(psi, (UInjectionHost)node);
            }
            return super.visitElement(node);
        }

        private void visitLiteralExpression(@NotNull PsiElement sourcePsi, @NotNull UInjectionHost expression) {
            String stringValue;
            if (sourcePsi == null) {
                StringI18nVisitor.$$$reportNull$$$0(8);
            }
            if (expression == null) {
                StringI18nVisitor.$$$reportNull$$$0(9);
            }
            if (StringUtil.isEmptyOrSpaces((String)(stringValue = I18nInspection.getStringValueOfKnownPart(expression)))) {
                return;
            }
            HashSet<PsiModifierListOwner> nonNlsTargets = new HashSet<PsiModifierListOwner>();
            NlsInfo info = I18nInspection.this.getExpectedNlsInfo(this.myHolder.getProject(), (UExpression)expression, stringValue, nonNlsTargets, this.myOnTheFly, I18nInspection.this.ignoreForAllButNls);
            if (!(info instanceof NlsInfo.Localized)) {
                return;
            }
            UField parentField = (UField)UastUtils.getParentOfType((UElement)expression, UField.class);
            if (parentField != null) {
                nonNlsTargets.add((PsiModifierListOwner)parentField.getJavaPsi());
            }
            String description = JavaI18nBundle.message("inspection.i18n.message.general.with.value", "#ref");
            ArrayList<Object> fixes = new ArrayList<Object>();
            if (sourcePsi instanceof PsiLiteralExpression && PsiUtil.isLanguageLevel5OrHigher((PsiElement)sourcePsi)) {
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myHolder.getProject());
                for (PsiModifierListOwner element : nonNlsTargets) {
                    if (NlsInfo.forModifierListOwner(element).getNlsStatus() != ThreeState.UNSURE || element.getManager().isInProject((PsiElement)element) && facade.findClass("org.jetbrains.annotations.NonNls", element.getResolveScope()) == null) continue;
                    fixes.add(new NonNlsAnnotationProvider().createFix(element));
                }
            }
            if (!(sourcePsi instanceof PsiLiteralExpression) || !StringI18nVisitor.isSwitchCase(expression)) {
                if (this.myOnTheFly) {
                    fixes.add(new I18nizeQuickFix((NlsInfo.Localized)info));
                    if (I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(sourcePsi) != null) {
                        fixes.add(new I18nizeConcatenationQuickFix((NlsInfo.Localized)info));
                    }
                    if (sourcePsi instanceof PsiLiteralExpression && !StringI18nVisitor.isNotConstantFieldInitializer((PsiExpression)sourcePsi)) {
                        fixes.add(I18nInspection.createIntroduceConstantFix());
                    }
                } else {
                    fixes.add(new I18nizeBatchQuickFix());
                }
            }
            LocalQuickFix[] farr = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
            this.myHolder.registerProblem(sourcePsi, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, farr);
        }

        private static boolean isSwitchCase(@NotNull UInjectionHost expression) {
            UElement uElement;
            if (expression == null) {
                StringI18nVisitor.$$$reportNull$$$0(10);
            }
            if ((uElement = expression.getUastParent()) instanceof USwitchClauseExpression) {
                USwitchClauseExpression parent = (USwitchClauseExpression)uElement;
                return ContainerUtil.exists((Iterable)parent.getCaseValues(), value -> expression.equals(value));
            }
            return false;
        }

        private static boolean isNotConstantFieldInitializer(PsiExpression expression) {
            PsiField parentField = expression.getParent() instanceof PsiField ? (PsiField)expression.getParent() : null;
            return parentField != null && expression == parentField.getInitializer() && parentField.hasModifierProperty("final") && parentField.hasModifierProperty("static");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcePsi";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/i18n/I18nInspection$StringI18nVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitQualifiedReferenceExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSimpleNameReferenceExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReference";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processReferenceToNonLocalized";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteralExpression";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSwitchCase";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MarkAsSafeFix
    extends AddAnnotationFix
    implements LowPriorityAction {
        MarkAsSafeFix(PsiModifierListOwner target) {
            super("com.intellij.openapi.util.NlsSafe", target, new String[]{"org.jetbrains.annotations.NonNls"});
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaI18nBundle.message("intention.family.name.mark.as.nlssafe", new Object[0]);
            if (string == null) {
                MarkAsSafeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/I18nInspection$MarkAsSafeFix", "getFamilyName"));
        }
    }
}

