/*
 * Decompiled with CFR 0.152.
 */
package training.dsl.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.PreviousTaskInfo;
import training.dsl.TaskContext;
import training.dsl.TaskTestContext;
import training.dsl.TaskTextProperties;
import training.dsl.impl.LessonExecutor;
import training.dsl.impl.LessonExecutorUtil;
import training.dsl.impl.TaskContextImpl;
import training.dsl.impl.TaskProperties;
import training.learn.ActionsRecorder;
import training.learn.course.KLesson;
import training.learn.exceptons.NoTextEditor;
import training.learn.lesson.LessonManager;
import training.statistic.LearningInternalProblems;
import training.statistic.StatisticBase;
import training.ui.LearnToolWindow;
import training.ui.LearningUiUtil;
import training.util.UtilsKt;
import training.util.WeakReferenceDelegator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0004\u0084\u0001\u0085\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010F\u001a\u00020GH\u0002J?\u0010H\u001a\u00020G2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010J2\u001b\b\u0002\u0010K\u001a\u0015\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020G\u0018\u00010L\u00a2\u0006\u0002\bN2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020G08H\u0002J!\u0010P\u001a\u00020G2\u0006\u0010Q\u001a\u00020R2\n\b\u0002\u0010S\u001a\u0004\u0018\u00010TH\u0000\u00a2\u0006\u0002\bUJ\u0006\u0010V\u001a\u00020\u0014J\u0010\u0010W\u001a\u00020\u00112\u0006\u0010Q\u001a\u00020RH\u0002J \u0010X\u001a\u00020G2\u0006\u0010Q\u001a\u00020R2\u0006\u0010Y\u001a\u00020\u000e2\u0006\u0010Z\u001a\u00020[H\u0002J\u0018\u0010\\\u001a\u00020G2\u0006\u0010Q\u001a\u00020R2\u0006\u0010Z\u001a\u00020[H\u0002J\b\u0010]\u001a\u00020GH\u0002J\b\u0010^\u001a\u00020GH\u0016J\b\u0010_\u001a\u00020GH\u0002J\u0018\u0010`\u001a\u00020G2\u0006\u0010a\u001a\u00020A2\u0006\u0010b\u001a\u00020\u0014H\u0002J\u0006\u0010c\u001a\u00020dJ\u000e\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020\u0014J\u001c\u0010h\u001a\u00020G2\u000e\b\u0004\u0010i\u001a\b\u0012\u0004\u0012\u00020G08H\u0086\b\u00f8\u0001\u0000J\u0010\u0010j\u001a\u00020G2\u0006\u0010k\u001a\u00020\u0014H\u0002J\b\u0010l\u001a\u00020GH\u0002J!\u0010m\u001a\u00020G2\u0017\u0010K\u001a\u0013\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020G0L\u00a2\u0006\u0002\bNH\u0002J\u0010\u0010n\u001a\u00020G2\u0006\u0010Q\u001a\u00020RH\u0002J)\u0010o\u001a\u00020G2\b\u0010p\u001a\u0004\u0018\u00010\u001d2\u0010\u0010q\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u000108H\u0000\u00a2\u0006\u0002\brJ'\u0010s\u001a\u00020G2\u0006\u0010Q\u001a\u00020R2\u0006\u0010t\u001a\u00020\u00142\b\u0010S\u001a\u0004\u0018\u00010TH\u0000\u00a2\u0006\u0002\buJ\b\u0010v\u001a\u00020GH\u0002J\u0006\u0010w\u001a\u00020GJ\u0018\u0010x\u001a\u00020G2\u0006\u0010Q\u001a\u00020R2\u0006\u0010y\u001a\u00020AH\u0002J\u0006\u0010z\u001a\u00020GJ\u001f\u0010{\u001a\u00020G2\u0017\u0010K\u001a\u0013\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020G0L\u00a2\u0006\u0002\bNJ(\u0010|\u001a\u00020G2\n\b\u0002\u0010}\u001a\u0004\u0018\u00010~2\u000e\b\u0004\u0010i\u001a\b\u0012\u0004\u0012\u00020G08H\u0086\b\u00f8\u0001\u0000J)\u0010\u007f\u001a\u00020G2\b\b\u0001\u0010\u007f\u001a\u00020d2\t\b\u0002\u0010\u0080\u0001\u001a\u00020\u00112\f\b\u0002\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u0001J\u000f\u0010\u0083\u0001\u001a\u00020G2\u0006\u0010t\u001a\u00020\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010-\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00078F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b.\u0010\u001b\"\u0004\b/\u00100R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R$\u00107\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u000108X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0016\u0010=\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u001bR\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010B\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\bC\u00104R\u0014\u0010D\u001a\u00020\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u0017\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0086\u0001"}, d2={"Ltraining/dsl/impl/LessonExecutor;", "Lcom/intellij/openapi/Disposable;", "lesson", "Ltraining/learn/course/KLesson;", "project", "Lcom/intellij/openapi/project/Project;", "initialEditor", "Lcom/intellij/openapi/editor/Editor;", "predefinedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ltraining/learn/course/KLesson;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vfs/VirtualFile;)V", "continueHighlighting", "Ljava/util/concurrent/atomic/AtomicBoolean;", "currentRecorder", "Ltraining/learn/ActionsRecorder;", "currentRestoreFuture", "Ljava/util/concurrent/CompletableFuture;", "", "currentRestoreRecorder", "<set-?>", "", "currentTaskIndex", "getCurrentTaskIndex$intellij_featuresTrainer", "()I", "currentVisualIndex", "editor", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "foundComponent", "Ljava/awt/Component;", "getFoundComponent", "()Ljava/awt/Component;", "setFoundComponent", "(Ljava/awt/Component;)V", "hasBeenStopped", "getHasBeenStopped", "()Z", "internalProblems", "", "Ltraining/statistic/LearningInternalProblems;", "getInternalProblems$intellij_featuresTrainer", "()Ljava/util/Set;", "getLesson", "()Ltraining/learn/course/KLesson;", "parentDisposable", "predefinedEditor", "getPredefinedEditor", "setPredefinedEditor", "(Lcom/intellij/openapi/editor/Editor;)V", "predefinedEditor$delegate", "Ltraining/util/WeakReferenceDelegator;", "getPredefinedFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "rehighlightComponent", "Lkotlin/Function0;", "getRehighlightComponent", "()Lkotlin/jvm/functions/Function0;", "setRehighlightComponent", "(Lkotlin/jvm/functions/Function0;)V", "selectedEditor", "getSelectedEditor", "taskActions", "", "Ltraining/dsl/impl/LessonExecutor$TaskInfo;", "virtualFile", "getVirtualFile", "visualIndexNumber", "getVisualIndexNumber$intellij_featuresTrainer", "addAllInactiveMessages", "", "addTaskAction", "taskProperties", "Ltraining/dsl/impl/TaskProperties;", "taskContent", "Lkotlin/Function1;", "Ltraining/dsl/TaskContext;", "Lkotlin/ExtensionFunctionType;", "content", "applyRestore", "taskContext", "Ltraining/dsl/impl/TaskContextImpl;", "restoreId", "Ltraining/dsl/TaskContext$TaskId;", "applyRestore$intellij_featuresTrainer", "calculateRestoreIndex", "canBeRestored", "chainNextTask", "recorder", "taskData", "Ltraining/dsl/impl/LessonExecutor$TaskData;", "checkForRestore", "clearRestore", "dispose", "disposeRecorders", "finishRestore", "restoreInfo", "restoreIndex", "getLessonInfoString", "", "getUserVisibleInfo", "Ltraining/dsl/PreviousTaskInfo;", "index", "invokeInBackground", "runnable", "processNextTask", "taskIndex", "processNextTask2", "processTask", "processTestActions", "rehighlightFoundComponent", "component", "highlightingFunction", "rehighlightFoundComponent$intellij_featuresTrainer", "restoreByTimer", "delayMillis", "restoreByTimer$intellij_featuresTrainer", "setUserVisibleInfo", "startLesson", "stepHasBeenCompleted", "taskInfo", "stopLesson", "task", "taskInvokeLater", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "text", "removeAfterDone", "textProperties", "Ltraining/dsl/TaskTextProperties;", "waitBeforeContinue", "TaskData", "TaskInfo", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nLessonExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LessonExecutor.kt\ntraining/dsl/impl/LessonExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,480:1\n195#1,11:482\n1#2:481\n1855#3,2:493\n1855#3,2:495\n1726#3,3:497\n1747#3,3:500\n1855#3,2:503\n*S KotlinDebug\n*F\n+ 1 LessonExecutor.kt\ntraining/dsl/impl/LessonExecutor\n*L\n210#1:482,11\n312#1:493,2\n396#1:495,2\n415#1:497,3\n433#1:500,3\n439#1:503,2\n*E\n"})
public final class LessonExecutor
implements Disposable {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final KLesson lesson;
    @NotNull
    private final Project project;
    @Nullable
    private final VirtualFile predefinedFile;
    @NotNull
    private final WeakReferenceDelegator predefinedEditor$delegate;
    @NotNull
    private final List<TaskInfo> taskActions;
    @Nullable
    private Component foundComponent;
    @Nullable
    private Function0<? extends Component> rehighlightComponent;
    @Nullable
    private ActionsRecorder currentRecorder;
    @Nullable
    private ActionsRecorder currentRestoreRecorder;
    @Nullable
    private CompletableFuture<Boolean> currentRestoreFuture;
    private int currentTaskIndex;
    private int currentVisualIndex;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private AtomicBoolean continueHighlighting;
    @NotNull
    private final Set<LearningInternalProblems> internalProblems;
    private volatile boolean hasBeenStopped;

    public LessonExecutor(@NotNull KLesson lesson, @NotNull Project project, @Nullable Editor initialEditor, @Nullable VirtualFile predefinedFile) {
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.lesson = lesson;
        this.project = project;
        this.predefinedFile = predefinedFile;
        this.predefinedEditor$delegate = new WeakReferenceDelegator<Editor>(initialEditor);
        this.taskActions = new ArrayList();
        this.currentVisualIndex = 1;
        LearnToolWindow learnToolWindow = UtilsKt.getLearnToolWindowForProject(this.project);
        if (learnToolWindow == null || (learnToolWindow = learnToolWindow.getParentDisposable$intellij_featuresTrainer()) == null) {
            learnToolWindow = (Disposable)this.project;
        }
        this.parentDisposable = learnToolWindow;
        this.continueHighlighting = new AtomicBoolean(true);
        this.internalProblems = new LinkedHashSet();
        Disposer.register((Disposable)this.parentDisposable, (Disposable)this);
    }

    @NotNull
    public final KLesson getLesson() {
        return this.lesson;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final VirtualFile getPredefinedFile() {
        return this.predefinedFile;
    }

    @Nullable
    public final Editor getPredefinedEditor() {
        return (Editor)this.predefinedEditor$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void setPredefinedEditor(Editor editor) {
        this.predefinedEditor$delegate.setValue(this, $$delegatedProperties[0], editor);
    }

    private final Editor getSelectedEditor() {
        Object object;
        Editor result2;
        Editor editor;
        if (this.lesson.getLessonType().isSingleEditor$intellij_featuresTrainer()) {
            editor = this.getPredefinedEditor();
        } else {
            Editor editor2 = FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
            if (editor2 != null) {
                Editor editor3;
                Editor it = editor3 = editor2;
                boolean bl = false;
                this.setPredefinedEditor(null);
                editor = editor3;
            } else {
                editor = this.getPredefinedEditor();
            }
        }
        Editor editor4 = result2 = editor;
        if (editor4 != null) {
            Editor editor5;
            Editor it = editor5 = editor4;
            boolean bl = false;
            object = !it.isDisposed() ? editor5 : null;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public final Editor getEditor() {
        Editor editor = this.getSelectedEditor();
        if (editor == null) {
            throw new NoTextEditor();
        }
        return editor;
    }

    @Nullable
    public final Component getFoundComponent() {
        return this.foundComponent;
    }

    public final void setFoundComponent(@Nullable Component component2) {
        this.foundComponent = component2;
    }

    @Nullable
    public final Function0<Component> getRehighlightComponent() {
        return this.rehighlightComponent;
    }

    public final void setRehighlightComponent(@Nullable Function0<? extends Component> function0) {
        this.rehighlightComponent = function0;
    }

    public final int getCurrentTaskIndex$intellij_featuresTrainer() {
        return this.currentTaskIndex;
    }

    public final int getVisualIndexNumber$intellij_featuresTrainer() {
        Integer n = this.taskActions.get(this.currentTaskIndex).getTaskVisualIndex();
        return n != null ? n : 0;
    }

    @NotNull
    public final Set<LearningInternalProblems> getInternalProblems$intellij_featuresTrainer() {
        return this.internalProblems;
    }

    public final boolean getHasBeenStopped() {
        return this.hasBeenStopped;
    }

    private final void addTaskAction(TaskProperties taskProperties, Function1<? super TaskContext, Unit> taskContent, Function0<Unit> content) {
        Integer n;
        int previousIndex = Math.max(this.taskActions.size() - 1, 0);
        if (taskProperties != null && taskProperties.getHasDetection() && taskProperties.getMessagesNumber() > 0) {
            int n2 = this.currentVisualIndex;
            this.currentVisualIndex = n2 + 1;
            n = n2;
        } else {
            n = null;
        }
        Integer taskVisualIndex = n;
        this.taskActions.add(new TaskInfo(content, previousIndex, taskProperties, taskContent, taskVisualIndex, false, 0, null, null, null, null, null, 4064, null));
    }

    static /* synthetic */ void addTaskAction$default(LessonExecutor lessonExecutor, TaskProperties taskProperties, Function1 function1, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            taskProperties = null;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        lessonExecutor.addTaskAction(taskProperties, (Function1<? super TaskContext, Unit>)function1, (Function0<Unit>)function0);
    }

    @NotNull
    public final PreviousTaskInfo getUserVisibleInfo(int index) {
        PreviousTaskInfo previousTaskInfo = this.taskActions.get(index).getUserVisibleInfo();
        if (previousTaskInfo == null) {
            throw new IllegalArgumentException("No information available for task " + index);
        }
        return previousTaskInfo;
    }

    public final void waitBeforeContinue(int delayMillis) {
        LessonExecutor.addTaskAction$default(this, null, null, (Function0)new Function0<Unit>(delayMillis, this){
            final /* synthetic */ int $delayMillis;
            final /* synthetic */ LessonExecutor this$0;
            {
                this.$delayMillis = $delayMillis;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Function0 action2 = (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ LessonExecutor this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        PreviousTaskInfo previousTaskInfo = ((TaskInfo)LessonExecutor.access$getTaskActions$p(this.this$0).get(this.this$0.getCurrentTaskIndex$intellij_featuresTrainer())).getUserVisibleInfo();
                        this.this$0.setFoundComponent(previousTaskInfo != null ? previousTaskInfo.getUi() : null);
                        this.this$0.setRehighlightComponent(((TaskInfo)LessonExecutor.access$getTaskActions$p(this.this$0).get(this.this$0.getCurrentTaskIndex$intellij_featuresTrainer())).getRehighlightComponent());
                        LessonExecutor.access$processNextTask(this.this$0, this.this$0.getCurrentTaskIndex$intellij_featuresTrainer() + 1);
                    }
                };
                new Alarm().addRequest(() -> waitBeforeContinue.1.invoke$lambda$0(action2), this.$delayMillis);
            }

            private static final void invoke$lambda$0(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke();
            }
        }, 3, null);
    }

    public final void task(@NotNull Function1<? super TaskContext, Unit> taskContent) {
        Intrinsics.checkNotNullParameter(taskContent, (String)"taskContent");
        ThreadingAssertions.assertEventDispatchThread();
        TaskProperties taskProperties = LessonExecutorUtil.INSTANCE.taskProperties(taskContent, this.project);
        this.addTaskAction(taskProperties, taskContent, (Function0<Unit>)((Function0)new Function0<Unit>(this, taskContent){
            final /* synthetic */ LessonExecutor this$0;
            final /* synthetic */ Function1<TaskContext, Unit> $taskContent;
            {
                this.this$0 = $receiver;
                this.$taskContent = $taskContent;
                super(0);
            }

            public final void invoke() {
                TaskInfo taskInfo = (TaskInfo)LessonExecutor.access$getTaskActions$p(this.this$0).get(this.this$0.getCurrentTaskIndex$intellij_featuresTrainer());
                TaskProperties taskProperties = taskInfo.getTaskProperties();
                if (taskProperties != null) {
                    int it = taskProperties.getMessagesNumber();
                    boolean bl = false;
                    LessonManager.Companion.getInstance().removeInactiveMessages(it);
                    TaskProperties taskProperties2 = taskInfo.getTaskProperties();
                    if (taskProperties2 != null) {
                        taskProperties2.setMessagesNumber(0);
                    }
                }
                LessonExecutor.access$processTask(this.this$0, this.$taskContent);
            }
        }));
    }

    public void dispose() {
        int n;
        boolean lessonPassed;
        if (this.hasBeenStopped) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        boolean bl = lessonPassed = this.currentTaskIndex == this.taskActions.size();
        if (lessonPassed) {
            n = this.currentVisualIndex;
        } else {
            Integer n2 = this.taskActions.get(this.currentTaskIndex).getTaskVisualIndex();
            n = n2 != null ? n2 : 0;
        }
        int visualIndex = n;
        this.lesson.onStop$intellij_featuresTrainer(this.project, lessonPassed, this.currentTaskIndex, visualIndex, this.internalProblems);
        this.continueHighlighting.set(false);
        this.clearRestore();
        this.disposeRecorders();
        this.hasBeenStopped = true;
        this.taskActions.clear();
    }

    public final void stopLesson() {
        Disposer.dispose((Disposable)this);
    }

    private final void disposeRecorders() {
        ActionsRecorder it;
        ActionsRecorder actionsRecorder = this.currentRecorder;
        if (actionsRecorder != null) {
            it = actionsRecorder;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.currentRecorder = null;
        ActionsRecorder actionsRecorder2 = this.currentRestoreRecorder;
        if (actionsRecorder2 != null) {
            it = actionsRecorder2;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.currentRestoreRecorder = null;
        this.currentRestoreFuture = null;
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(this.getEditor().getDocument());
        if (virtualFile == null) {
            throw new IllegalStateException("No Virtual File".toString());
        }
        return virtualFile;
    }

    public final void startLesson() {
        this.addAllInactiveMessages();
        this.processNextTask(0);
    }

    public final void invokeInBackground(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        boolean $i$f$invokeInBackground = false;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(runnable, this){
            final /* synthetic */ Function0<Unit> $runnable;
            final /* synthetic */ LessonExecutor this$0;
            {
                this.$runnable = $runnable;
                this.this$0 = $receiver;
            }

            public final void run() {
                try {
                    this.$runnable.invoke();
                }
                catch (Throwable e) {
                    LessonExecutor $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(LessonExecutor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error(this.this$0.getLessonInfoString(), e);
                }
            }
        });
    }

    public final void taskInvokeLater(@Nullable ModalityState modalityState, @NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        boolean $i$f$taskInvokeLater = false;
        ActionsKt.invokeLater((ModalityState)modalityState, (Function0)((Function0)new Function0<Unit>(this, runnable){
            final /* synthetic */ LessonExecutor this$0;
            final /* synthetic */ Function0<Unit> $runnable;
            {
                this.this$0 = $receiver;
                this.$runnable = $runnable;
                super(0);
            }

            public final void invoke() {
                try {
                    if (!this.this$0.getHasBeenStopped()) {
                        this.$runnable.invoke();
                    }
                }
                catch (Throwable e) {
                    LessonExecutor $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(LessonExecutor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error(this.this$0.getLessonInfoString(), e);
                }
            }
        }));
    }

    public static /* synthetic */ void taskInvokeLater$default(LessonExecutor $this, ModalityState modalityState, Function0 runnable, int n, Object object) {
        if ((n & 1) != 0) {
            modalityState = null;
        }
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        boolean $i$f$taskInvokeLater = false;
        ActionsKt.invokeLater((ModalityState)modalityState, (Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
    }

    /*
     * WARNING - void declaration
     */
    private final void processNextTask(int taskIndex) {
        void this_$iv;
        LessonExecutor lessonExecutor = this;
        ModalityState modalityState$iv = ModalityState.any();
        boolean $i$f$taskInvokeLater = false;
        ActionsKt.invokeLater((ModalityState)modalityState$iv, (Function0)((Function0)new Function0<Unit>((LessonExecutor)this_$iv, this, taskIndex){
            final /* synthetic */ LessonExecutor this$0$inline_fun;
            final /* synthetic */ LessonExecutor this$0;
            final /* synthetic */ int $taskIndex$inlined;
            {
                this.this$0$inline_fun = $receiver;
                this.this$0 = lessonExecutor;
                this.$taskIndex$inlined = n;
                super(0);
            }

            public final void invoke() {
                try {
                    if (!this.this$0$inline_fun.getHasBeenStopped()) {
                        boolean bl = false;
                        LessonExecutor.access$disposeRecorders(this.this$0);
                        LessonExecutor.access$getContinueHighlighting$p(this.this$0).set(false);
                        LessonExecutor.access$setContinueHighlighting$p(this.this$0, new AtomicBoolean(true));
                        LessonExecutor.access$setCurrentTaskIndex$p(this.this$0, this.$taskIndex$inlined);
                        LessonExecutor.access$processNextTask2(this.this$0);
                    }
                }
                catch (Throwable e) {
                    LessonExecutor $this$thisLogger$iv = this.this$0$inline_fun;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(LessonExecutor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error(this.this$0$inline_fun.getLessonInfoString(), e);
                }
            }
        }));
    }

    private final void processNextTask2() {
        LessonManager.Companion.getInstance().clearRestoreMessage();
        ThreadingAssertions.assertEventDispatchThread();
        if (this.currentTaskIndex == this.taskActions.size()) {
            LessonManager.Companion.getInstance().passLesson(this.lesson);
            return;
        }
        TaskInfo taskInfo = this.taskActions.get(this.currentTaskIndex);
        taskInfo.setNextTaskHasBeenScheduled(false);
        taskInfo.setMessagesNumberBeforeStart(LessonManager.Companion.getInstance().messagesNumber());
        this.setUserVisibleInfo();
        taskInfo.getContent().invoke();
    }

    private final void setUserVisibleInfo() {
        TaskInfo taskInfo = this.taskActions.get(this.currentTaskIndex);
        if (taskInfo.getUserVisibleInfo() == null) {
            taskInfo.setUserVisibleInfo(new PreviousTaskInfo(this){
                @NotNull
                private final String text;
                @NotNull
                private final LogicalPosition position;
                @NotNull
                private final LessonSample sample;
                @Nullable
                private final Component ui;
                @Nullable
                private final VirtualFile file;
                {
                    VirtualFile virtualFile;
                    setUserVisibleInfo.1 var5_4;
                    Object object;
                    block8: {
                        block7: {
                            void it;
                            LogicalPosition logicalPosition;
                            Editor editor;
                            String string;
                            Editor editor2 = LessonExecutor.access$getSelectedEditor($receiver);
                            if ((editor2 != null && (editor2 = editor2.getDocument()) != null ? editor2.getText() : (string = null)) == null) {
                                string = this.text = "";
                            }
                            if (((editor = LessonExecutor.access$getSelectedEditor($receiver)) != null && (editor = editor.getCaretModel()) != null && (editor = editor.getCurrentCaret()) != null ? editor.getLogicalPosition() : (logicalPosition = null)) == null) {
                                logicalPosition = new LogicalPosition(0, 0);
                            }
                            this.position = logicalPosition;
                            setUserVisibleInfo.1 v4 = this;
                            object = LessonExecutor.access$getSelectedEditor($receiver);
                            if (object == null) break block7;
                            Editor editor3 = object;
                            var5_4 = v4;
                            boolean bl = false;
                            LessonSample lessonSample = LessonSampleKt.prepareSampleFromCurrentState((Editor)it);
                            v4 = var5_4;
                            object = lessonSample;
                            if (lessonSample != null) break block8;
                        }
                        object = LessonSampleKt.parseLessonSample("");
                    }
                    v4.sample = object;
                    this.ui = $receiver.getFoundComponent();
                    setUserVisibleInfo.1 v7 = this;
                    Editor editor = LessonExecutor.access$getSelectedEditor($receiver);
                    if (editor != null) {
                        void it;
                        Editor editor4 = editor;
                        var5_4 = v7;
                        boolean bl = false;
                        virtualFile = FileDocumentManager.getInstance().getFile(it.getDocument());
                        v7 = var5_4;
                    } else {
                        virtualFile = null;
                    }
                    v7.file = virtualFile;
                }

                @NotNull
                public String getText() {
                    return this.text;
                }

                @NotNull
                public LogicalPosition getPosition() {
                    return this.position;
                }

                @NotNull
                public LessonSample getSample() {
                    return this.sample;
                }

                @Nullable
                public Component getUi() {
                    return this.ui;
                }

                @Nullable
                public VirtualFile getFile() {
                    return this.file;
                }
            });
            taskInfo.setRehighlightComponent(this.rehighlightComponent);
        }
        int n = this.taskActions.size();
        for (int i = this.currentTaskIndex + 1; i < n; ++i) {
            this.taskActions.get(i).setUserVisibleInfo(null);
            this.taskActions.get(i).setRehighlightComponent(null);
        }
        this.foundComponent = null;
        this.rehighlightComponent = null;
    }

    private final void processTask(Function1<? super TaskContext, Unit> taskContent) {
        TaskContextImpl taskContext;
        ActionsRecorder recorder;
        ThreadingAssertions.assertEventDispatchThread();
        Editor editor = this.getSelectedEditor();
        this.currentRecorder = recorder = new ActionsRecorder(this.project, (Document)(editor != null ? editor.getDocument() : null), this);
        TaskData taskCallbackData = new TaskData(null, null, null, null, null, 0, 63, null);
        TaskContextImpl taskContextImpl = taskContext = new TaskContextImpl(this, recorder, this.currentTaskIndex, taskCallbackData);
        taskContent.invoke((Object)taskContextImpl);
        if (Intrinsics.areEqual((Object)taskCallbackData.getHighlightPreviousUi(), (Object)true)) {
            TaskInfo taskInfo = this.taskActions.get(this.currentTaskIndex);
            PreviousTaskInfo previousTaskInfo = taskInfo.getUserVisibleInfo();
            this.rehighlightFoundComponent$intellij_featuresTrainer(previousTaskInfo != null ? previousTaskInfo.getUi() : null, taskInfo.getRehighlightComponent());
        }
        TaskInfo it = this.taskActions.get(this.currentTaskIndex);
        boolean bl = false;
        it.setTransparentRestore(taskCallbackData.getTransparentRestore());
        it.setHighlightPreviousUi(taskCallbackData.getHighlightPreviousUi());
        if (taskContext.getSteps().isEmpty()) {
            this.processNextTask(this.currentTaskIndex + 1);
            return;
        }
        this.chainNextTask(taskContext, recorder, taskCallbackData);
        this.processTestActions(taskContext);
    }

    public final void rehighlightFoundComponent$intellij_featuresTrainer(@Nullable Component component2, @Nullable Function0<? extends Component> highlightingFunction) {
        if (highlightingFunction == null) {
            return;
        }
        AtomicBoolean condition = this.continueHighlighting;
        ApplicationManager.getApplication().executeOnPooledThread(() -> LessonExecutor.rehighlightFoundComponent$lambda$6(component2, condition, highlightingFunction));
    }

    public final void restoreByTimer$intellij_featuresTrainer(@NotNull TaskContextImpl taskContext, int delayMillis, @Nullable TaskContext.TaskId restoreId) {
        Intrinsics.checkNotNullParameter((Object)taskContext, (String)"taskContext");
        Function0 restore2 = (Function0)new Function0<Unit>(this, taskContext, restoreId){
            final /* synthetic */ LessonExecutor this$0;
            final /* synthetic */ TaskContextImpl $taskContext;
            final /* synthetic */ TaskContext.TaskId $restoreId;
            {
                this.this$0 = $receiver;
                this.$taskContext = $taskContext;
                this.$restoreId = $restoreId;
                super(0);
            }

            public final void invoke() {
                if (this.this$0.getCurrentTaskIndex$intellij_featuresTrainer() == this.$taskContext.getTaskIndex()) {
                    this.this$0.applyRestore$intellij_featuresTrainer(this.$taskContext, this.$restoreId);
                }
            }
        };
        new Alarm().addRequest(() -> LessonExecutor.restoreByTimer$lambda$7(restore2), delayMillis);
    }

    public final void applyRestore$intellij_featuresTrainer(@NotNull TaskContextImpl taskContext, @Nullable TaskContext.TaskId restoreId) {
        Intrinsics.checkNotNullParameter((Object)taskContext, (String)"taskContext");
        this.clearRestore();
        this.disposeRecorders();
        Iterable $this$forEach$iv = taskContext.getSteps();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompletableFuture it = (CompletableFuture)element$iv;
            boolean bl = false;
            it.cancel(true);
        }
        TaskContext.TaskId taskId = restoreId;
        int restoreIndex = taskId != null ? taskId.getIdx() : this.taskActions.get(taskContext.getTaskIndex()).getRestoreIndex();
        for (TaskInfo info : this.taskActions.subList(restoreIndex + 1, this.taskActions.size())) {
            info.setRehighlightComponent(null);
            info.setUserVisibleInfo(null);
            info.setHighlightPreviousUi(null);
            info.getRemoveAfterDoneMessages().clear();
        }
        TaskInfo restoreInfo = this.taskActions.get(restoreIndex);
        Function0<Component> rehighlightComponentFn = restoreInfo.getRehighlightComponent();
        if (rehighlightComponentFn != null) {
            CompletableFuture<Boolean> feature = new CompletableFuture<Boolean>();
            feature.whenCompleteAsync((arg_0, arg_1) -> LessonExecutor.applyRestore$lambda$9((Function2)new Function2<Boolean, Throwable, Unit>(this, restoreInfo, restoreIndex){
                final /* synthetic */ LessonExecutor this$0;
                final /* synthetic */ TaskInfo $restoreInfo;
                final /* synthetic */ int $restoreIndex;
                {
                    this.this$0 = $receiver;
                    this.$restoreInfo = $restoreInfo;
                    this.$restoreIndex = $restoreIndex;
                    super(2);
                }

                public final void invoke(Boolean bl, Throwable throwable) {
                    ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this.this$0, this.$restoreInfo, this.$restoreIndex){
                        final /* synthetic */ LessonExecutor this$0;
                        final /* synthetic */ TaskInfo $restoreInfo;
                        final /* synthetic */ int $restoreIndex;
                        {
                            this.this$0 = $receiver;
                            this.$restoreInfo = $restoreInfo;
                            this.$restoreIndex = $restoreIndex;
                            super(0);
                        }

                        public final void invoke() {
                            LessonExecutor.access$finishRestore(this.this$0, this.$restoreInfo, this.$restoreIndex);
                        }
                    }), (int)1, null);
                }
            }, arg_0, arg_1));
            feature.completeOnTimeout(true, LearningUiUtil.INSTANCE.getDefaultComponentSearchShortTimeout().duration(), TimeUnit.MILLISECONDS);
            ApplicationManager.getApplication().executeOnPooledThread(() -> LessonExecutor.applyRestore$lambda$10(rehighlightComponentFn, feature));
        } else {
            this.finishRestore(restoreInfo, restoreIndex);
        }
    }

    public static /* synthetic */ void applyRestore$intellij_featuresTrainer$default(LessonExecutor lessonExecutor, TaskContextImpl taskContextImpl, TaskContext.TaskId taskId, int n, Object object) {
        if ((n & 2) != 0) {
            taskId = null;
        }
        lessonExecutor.applyRestore$intellij_featuresTrainer(taskContextImpl, taskId);
    }

    private final void finishRestore(TaskInfo restoreInfo, int restoreIndex) {
        LessonManager.Companion.getInstance().resetMessagesNumber(restoreInfo.getMessagesNumberBeforeStart());
        StatisticBase.INSTANCE.logRestorePerformed(this.lesson, this.currentTaskIndex);
        this.processNextTask(restoreIndex);
    }

    public final int calculateRestoreIndex() {
        int i;
        for (i = this.currentTaskIndex - 1; i > 0 && Intrinsics.areEqual((Object)this.taskActions.get(i).getTransparentRestore(), (Object)true); --i) {
        }
        return i;
    }

    private final void checkForRestore(TaskContextImpl taskContext, TaskData taskData) {
        block5: {
            Object object;
            Function0<Function0<Unit>> shouldRestore;
            block4: {
                ActionsRecorder restoreRecorder;
                Function0<Function0<Unit>> function0 = taskData.getShouldRestore();
                if (function0 == null) {
                    return;
                }
                shouldRestore = function0;
                Editor editor = this.getSelectedEditor();
                this.currentRestoreRecorder = restoreRecorder = new ActionsRecorder(this.project, (Document)(editor != null ? editor.getDocument() : null), this);
                this.currentRestoreFuture = restoreRecorder.futureCheck((Function0<Boolean>)((Function0)new Function0<Boolean>(this, shouldRestore, taskData, taskContext){
                    final /* synthetic */ LessonExecutor this$0;
                    final /* synthetic */ Function0<Function0<Unit>> $shouldRestore;
                    final /* synthetic */ TaskData $taskData;
                    final /* synthetic */ TaskContextImpl $taskContext;
                    {
                        this.this$0 = $receiver;
                        this.$shouldRestore = $shouldRestore;
                        this.$taskData = $taskData;
                        this.$taskContext = $taskContext;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        LessonExecutor.access$checkForRestore$checkFunction(this.this$0, this.$shouldRestore, this.$taskData, this.$taskContext);
                        return false;
                    }
                }));
                object = taskData.getCheckRestoreByTimer();
                if (object == null) break block4;
                int it = ((Number)object).intValue();
                boolean bl = false;
                CompletableFuture<Boolean> completableFuture = restoreRecorder.timerCheck(it, (Function0<Boolean>)((Function0)new Function0<Boolean>(this, shouldRestore, taskData, taskContext){
                    final /* synthetic */ LessonExecutor this$0;
                    final /* synthetic */ Function0<Function0<Unit>> $shouldRestore;
                    final /* synthetic */ TaskData $taskData;
                    final /* synthetic */ TaskContextImpl $taskContext;
                    {
                        this.this$0 = $receiver;
                        this.$shouldRestore = $shouldRestore;
                        this.$taskData = $taskData;
                        this.$taskContext = $taskContext;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        LessonExecutor.access$checkForRestore$checkFunction(this.this$0, this.$shouldRestore, this.$taskData, this.$taskContext);
                        return false;
                    }
                }));
                object = completableFuture;
                if (completableFuture != null) break block5;
            }
            LessonExecutor.checkForRestore$checkFunction(this, shouldRestore, taskData, taskContext);
            object = Unit.INSTANCE;
        }
    }

    private final void clearRestore() {
        CompletableFuture<Boolean> completableFuture = this.currentRestoreFuture;
        if (completableFuture == null) {
            return;
        }
        CompletableFuture<Boolean> future2 = completableFuture;
        if (!future2.isDone()) {
            future2.cancel(true);
        }
        LessonManager.Companion.getInstance().clearRestoreMessage();
    }

    private final void chainNextTask(TaskContextImpl taskContext, ActionsRecorder recorder, TaskData taskData) {
        this.checkForRestore(taskContext, taskData);
        recorder.tryToCheckCallback();
        Iterable $this$forEach$iv = taskContext.getSteps();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompletableFuture step2 = (CompletableFuture)element$iv;
            boolean bl = false;
            step2.thenAccept(arg_0 -> LessonExecutor.chainNextTask$lambda$14$lambda$13((Function1)new Function1<Boolean, Unit>(this, taskContext){
                final /* synthetic */ LessonExecutor this$0;
                final /* synthetic */ TaskContextImpl $taskContext;
                {
                    this.this$0 = $receiver;
                    this.$taskContext = $taskContext;
                    super(1);
                }

                public final void invoke(Boolean it) {
                    try {
                        if (!this.this$0.getHasBeenStopped()) {
                            LessonExecutor.access$stepHasBeenCompleted(this.this$0, this.$taskContext, (TaskInfo)LessonExecutor.access$getTaskActions$p(this.this$0).get(this.this$0.getCurrentTaskIndex$intellij_featuresTrainer()));
                        }
                    }
                    catch (Throwable e) {
                        LessonExecutor $this$thisLogger$iv = this.this$0;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(LessonExecutor.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Step exception: ", e);
                    }
                }
            }, arg_0));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void stepHasBeenCompleted(TaskContextImpl taskContext, TaskInfo taskInfo) {
        boolean bl;
        ThreadingAssertions.assertEventDispatchThread();
        Iterable $this$all$iv = taskContext.getSteps();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                CompletableFuture it = (CompletableFuture)element$iv;
                boolean bl2 = false;
                if (!it.isDone()) return;
                Object t = it.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                if ((Boolean)t == false) return;
                boolean bl3 = true;
                if (bl3) continue;
                return;
            }
            bl = true;
        }
        boolean allStepsAreCompleted = bl;
        if (!allStepsAreCompleted) return;
        if (this.hasBeenStopped) return;
        if (taskInfo.getNextTaskHasBeenScheduled()) {
            return;
        }
        this.clearRestore();
        LessonManager.Companion.getInstance().passExercise();
        if (!Intrinsics.areEqual((Object)taskContext.getPropagateHighlighting(), (Object)false)) {
            if (this.foundComponent == null) {
                PreviousTaskInfo previousTaskInfo = taskInfo.getUserVisibleInfo();
                Component component2 = this.foundComponent = previousTaskInfo != null ? previousTaskInfo.getUi() : null;
            }
            if (this.rehighlightComponent == null) {
                this.rehighlightComponent = taskInfo.getRehighlightComponent();
            }
        }
        Iterator<Integer> iterator = taskInfo.getRemoveAfterDoneMessages().iterator();
        while (iterator.hasNext()) {
            int index = ((Number)iterator.next()).intValue();
            LessonManager.Companion.getInstance().removeMessage(index);
        }
        TaskProperties taskProperties = taskInfo.getTaskProperties();
        if (taskProperties != null) {
            TaskProperties it = taskProperties;
            boolean bl4 = false;
            it.setMessagesNumber(it.getMessagesNumber() - taskInfo.getRemoveAfterDoneMessages().size());
        }
        this.processNextTask(this.currentTaskIndex + 1);
        taskInfo.setNextTaskHasBeenScheduled(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canBeRestored(TaskContextImpl taskContext) {
        boolean bl;
        if (this.hasBeenStopped) return false;
        Iterable $this$any$iv = taskContext.getSteps();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            CompletableFuture it = (CompletableFuture)element$iv;
            boolean bl2 = false;
            if (!it.isCancelled() && !it.isCompletedExceptionally()) {
                if (!it.isDone()) return true;
                if (!((Boolean)it.get()).booleanValue()) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final void processTestActions(TaskContextImpl taskContext) {
        if (TaskTestContext.Companion.getInTestMode() && !((Collection)taskContext.getTestActions()).isEmpty()) {
            LessonManager.Companion.getInstance().getTestActionsExecutor().execute(() -> LessonExecutor.processTestActions$lambda$19(taskContext));
        }
    }

    public final void text(@Language(value="HTML") @NotNull String text2, boolean removeAfterDone, @Nullable TaskTextProperties textProperties) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        TaskInfo taskInfo = this.taskActions.get(this.currentTaskIndex);
        if (removeAfterDone) {
            taskInfo.getRemoveAfterDoneMessages().add(LessonManager.Companion.getInstance().messagesNumber());
        }
        TaskProperties taskProperties = taskInfo.getTaskProperties();
        if (taskProperties != null) {
            TaskProperties it = taskProperties;
            boolean bl = false;
            int n = it.getMessagesNumber();
            it.setMessagesNumber(n + 1);
        }
        boolean hasDetection = false;
        int n = this.taskActions.size();
        for (int i = this.currentTaskIndex; i < n; ++i) {
            TaskProperties taskProperties2 = taskInfo.getTaskProperties();
            boolean bl = taskProperties2 != null ? taskProperties2.getHasDetection() : false;
            if (!bl) continue;
            hasDetection = true;
            break;
        }
        LessonManager.Companion.getInstance().addMessage(text2, !hasDetection, taskInfo.getTaskVisualIndex(), removeAfterDone, textProperties);
    }

    public static /* synthetic */ void text$default(LessonExecutor lessonExecutor, String string, boolean bl, TaskTextProperties taskTextProperties, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            taskTextProperties = null;
        }
        lessonExecutor.text(string, bl, taskTextProperties);
    }

    private final void addAllInactiveMessages() {
        for (TaskInfo taskInfo : this.taskActions) {
            if (taskInfo.getTaskContent() == null) continue;
            List<String> textMessages = LessonExecutorUtil.INSTANCE.textMessages(taskInfo.getTaskContent(), this.project);
            Iterator<String> iterator = textMessages.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Integer n2;
                int index = n++;
                String message = iterator.next();
                LessonManager lessonManager = LessonManager.Companion.getInstance();
                String string = message;
                if (taskInfo.getTaskVisualIndex() != null) {
                    Integer n3;
                    int n4 = ((Number)n3).intValue();
                    String string2 = string;
                    LessonManager lessonManager2 = lessonManager;
                    boolean bl = false;
                    boolean bl2 = index == 0;
                    lessonManager = lessonManager2;
                    string = string2;
                    n2 = bl2 ? n3 : null;
                } else {
                    n2 = null;
                }
                lessonManager.addInactiveMessage(string, n2);
            }
        }
    }

    @NotNull
    public final String getLessonInfoString() {
        return "lesson ID = " + this.lesson.getId() + ", language ID = " + this.lesson.getLanguageId() + ", taskId = " + this.currentTaskIndex;
    }

    private static final void rehighlightFoundComponent$lambda$6(Component $component, AtomicBoolean $condition, Function0 $highlightingFunction) {
        Intrinsics.checkNotNullParameter((Object)$condition, (String)"$condition");
        Component ui = $component;
        while ($condition.get()) {
            if (ui == null || !ui.isShowing() || ui.getBounds().isEmpty()) {
                ui = (Component)$highlightingFunction.invoke();
            }
            Thread.sleep(300L);
        }
    }

    private static final void restoreByTimer$lambda$7(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void applyRestore$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void applyRestore$lambda$10(Function0 $rehighlightComponentFn, CompletableFuture $feature) {
        Intrinsics.checkNotNullParameter((Object)$feature, (String)"$feature");
        $rehighlightComponentFn.invoke();
        $feature.complete(true);
    }

    private static final void checkForRestore$checkFunction$lambda$11(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void checkForRestore$checkFunction(LessonExecutor this$0, Function0<? extends Function0<Unit>> shouldRestore, TaskData $taskData, TaskContextImpl $taskContext) {
        if (this$0.hasBeenStopped) {
            this$0.clearRestore();
            return;
        }
        Function0 function0 = (Function0)shouldRestore.invoke();
        if (function0 == null) {
            return;
        }
        Function0 restoreFunction = function0;
        Function0 restoreIfNeeded2 = (Function0)new Function0<Unit>(this$0, $taskContext, (Function0<Unit>)restoreFunction){
            final /* synthetic */ LessonExecutor this$0;
            final /* synthetic */ TaskContextImpl $taskContext;
            final /* synthetic */ Function0<Unit> $restoreFunction;
            {
                this.this$0 = $receiver;
                this.$taskContext = $taskContext;
                this.$restoreFunction = $restoreFunction;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void this_$iv;
                void modalityState$iv;
                LessonExecutor lessonExecutor = this.this$0;
                ModalityState modalityState = ModalityState.any();
                LessonExecutor lessonExecutor2 = this.this$0;
                TaskContextImpl taskContextImpl = this.$taskContext;
                Function0<Unit> function0 = this.$restoreFunction;
                boolean $i$f$taskInvokeLater = false;
                ActionsKt.invokeLater((ModalityState)modalityState$iv, (Function0)((Function0)new Function0<Unit>((LessonExecutor)this_$iv, lessonExecutor2, taskContextImpl, function0){
                    final /* synthetic */ LessonExecutor this$0$inline_fun;
                    final /* synthetic */ LessonExecutor this$0;
                    final /* synthetic */ TaskContextImpl $taskContext$inlined;
                    final /* synthetic */ Function0 $restoreFunction$inlined;
                    {
                        this.this$0$inline_fun = $receiver;
                        this.this$0 = lessonExecutor;
                        this.$taskContext$inlined = taskContextImpl;
                        this.$restoreFunction$inlined = function0;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            if (!this.this$0$inline_fun.getHasBeenStopped()) {
                                boolean bl = false;
                                if (LessonExecutor.access$canBeRestored(this.this$0, this.$taskContext$inlined)) {
                                    this.$restoreFunction$inlined.invoke();
                                }
                            }
                        }
                        catch (Throwable e) {
                            LessonExecutor $this$thisLogger$iv = this.this$0$inline_fun;
                            boolean $i$f$thisLogger = false;
                            Logger logger = Logger.getInstance(LessonExecutor.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.error(this.this$0$inline_fun.getLessonInfoString(), e);
                        }
                    }
                }));
            }
        };
        if ($taskData.getDelayBeforeRestore() == 0) {
            restoreIfNeeded2.invoke();
        } else {
            new Alarm().addRequest(() -> LessonExecutor.checkForRestore$checkFunction$lambda$11(restoreIfNeeded2), $taskData.getDelayBeforeRestore());
        }
    }

    private static final void chainNextTask$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void processTestActions$lambda$19(TaskContextImpl $taskContext) {
        Intrinsics.checkNotNullParameter((Object)$taskContext, (String)"$taskContext");
        Iterable $this$forEach$iv = $taskContext.getTestActions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Runnable it = (Runnable)element$iv;
            boolean bl = false;
            it.run();
        }
    }

    public static final /* synthetic */ List access$getTaskActions$p(LessonExecutor $this) {
        return $this.taskActions;
    }

    public static final /* synthetic */ void access$processNextTask(LessonExecutor $this, int taskIndex) {
        $this.processNextTask(taskIndex);
    }

    public static final /* synthetic */ void access$processTask(LessonExecutor $this, Function1 taskContent) {
        $this.processTask((Function1<? super TaskContext, Unit>)taskContent);
    }

    public static final /* synthetic */ Editor access$getSelectedEditor(LessonExecutor $this) {
        return $this.getSelectedEditor();
    }

    public static final /* synthetic */ void access$finishRestore(LessonExecutor $this, TaskInfo restoreInfo, int restoreIndex) {
        $this.finishRestore(restoreInfo, restoreIndex);
    }

    public static final /* synthetic */ void access$checkForRestore$checkFunction(LessonExecutor this$0, Function0 shouldRestore, TaskData $taskData, TaskContextImpl $taskContext) {
        LessonExecutor.checkForRestore$checkFunction(this$0, (Function0<? extends Function0<Unit>>)shouldRestore, $taskData, $taskContext);
    }

    public static final /* synthetic */ void access$disposeRecorders(LessonExecutor $this) {
        $this.disposeRecorders();
    }

    public static final /* synthetic */ AtomicBoolean access$getContinueHighlighting$p(LessonExecutor $this) {
        return $this.continueHighlighting;
    }

    public static final /* synthetic */ void access$setContinueHighlighting$p(LessonExecutor $this, AtomicBoolean atomicBoolean) {
        $this.continueHighlighting = atomicBoolean;
    }

    public static final /* synthetic */ void access$setCurrentTaskIndex$p(LessonExecutor $this, int n) {
        $this.currentTaskIndex = n;
    }

    public static final /* synthetic */ void access$processNextTask2(LessonExecutor $this) {
        $this.processNextTask2();
    }

    public static final /* synthetic */ boolean access$canBeRestored(LessonExecutor $this, TaskContextImpl taskContext) {
        return $this.canBeRestored(taskContext);
    }

    public static final /* synthetic */ void access$stepHasBeenCompleted(LessonExecutor $this, TaskContextImpl taskContext, TaskInfo taskInfo) {
        $this.stepHasBeenCompleted(taskContext, taskInfo);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(LessonExecutor.class, "predefinedEditor", "getPredefinedEditor()Lcom/intellij/openapi/editor/Editor;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b$\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BY\u0012\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0019\u0010#\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010$\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010%\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010&\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010'\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010(\u001a\u00020\nH\u00c6\u0003Jb\u0010)\u001a\u00020\u00002\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0002\u0010*J\u0013\u0010+\u001a\u00020\u00062\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020\nH\u00d6\u0001J\t\u0010.\u001a\u00020/H\u00d6\u0001R\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R*\u0010\u0002\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019\u00a8\u00060"}, d2={"Ltraining/dsl/impl/LessonExecutor$TaskData;", "", "shouldRestore", "Lkotlin/Function0;", "", "transparentRestore", "", "highlightPreviousUi", "propagateHighlighting", "checkRestoreByTimer", "", "delayBeforeRestore", "(Lkotlin/jvm/functions/Function0;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Integer;I)V", "getCheckRestoreByTimer", "()Ljava/lang/Integer;", "setCheckRestoreByTimer", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getDelayBeforeRestore", "()I", "setDelayBeforeRestore", "(I)V", "getHighlightPreviousUi", "()Ljava/lang/Boolean;", "setHighlightPreviousUi", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getPropagateHighlighting", "setPropagateHighlighting", "getShouldRestore", "()Lkotlin/jvm/functions/Function0;", "setShouldRestore", "(Lkotlin/jvm/functions/Function0;)V", "getTransparentRestore", "setTransparentRestore", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Lkotlin/jvm/functions/Function0;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Integer;I)Ltraining/dsl/impl/LessonExecutor$TaskData;", "equals", "other", "hashCode", "toString", "", "intellij.featuresTrainer"})
    public static final class TaskData {
        @Nullable
        private Function0<? extends Function0<Unit>> shouldRestore;
        @Nullable
        private Boolean transparentRestore;
        @Nullable
        private Boolean highlightPreviousUi;
        @Nullable
        private Boolean propagateHighlighting;
        @Nullable
        private Integer checkRestoreByTimer;
        private int delayBeforeRestore;

        public TaskData(@Nullable Function0<? extends Function0<Unit>> shouldRestore, @Nullable Boolean transparentRestore, @Nullable Boolean highlightPreviousUi, @Nullable Boolean propagateHighlighting, @Nullable Integer checkRestoreByTimer, int delayBeforeRestore) {
            this.shouldRestore = shouldRestore;
            this.transparentRestore = transparentRestore;
            this.highlightPreviousUi = highlightPreviousUi;
            this.propagateHighlighting = propagateHighlighting;
            this.checkRestoreByTimer = checkRestoreByTimer;
            this.delayBeforeRestore = delayBeforeRestore;
        }

        public /* synthetic */ TaskData(Function0 function0, Boolean bl, Boolean bl2, Boolean bl3, Integer n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                function0 = null;
            }
            if ((n3 & 2) != 0) {
                bl = null;
            }
            if ((n3 & 4) != 0) {
                bl2 = null;
            }
            if ((n3 & 8) != 0) {
                bl3 = null;
            }
            if ((n3 & 0x10) != 0) {
                n = null;
            }
            if ((n3 & 0x20) != 0) {
                n2 = 0;
            }
            this((Function0<? extends Function0<Unit>>)function0, bl, bl2, bl3, n, n2);
        }

        @Nullable
        public final Function0<Function0<Unit>> getShouldRestore() {
            return this.shouldRestore;
        }

        public final void setShouldRestore(@Nullable Function0<? extends Function0<Unit>> function0) {
            this.shouldRestore = function0;
        }

        @Nullable
        public final Boolean getTransparentRestore() {
            return this.transparentRestore;
        }

        public final void setTransparentRestore(@Nullable Boolean bl) {
            this.transparentRestore = bl;
        }

        @Nullable
        public final Boolean getHighlightPreviousUi() {
            return this.highlightPreviousUi;
        }

        public final void setHighlightPreviousUi(@Nullable Boolean bl) {
            this.highlightPreviousUi = bl;
        }

        @Nullable
        public final Boolean getPropagateHighlighting() {
            return this.propagateHighlighting;
        }

        public final void setPropagateHighlighting(@Nullable Boolean bl) {
            this.propagateHighlighting = bl;
        }

        @Nullable
        public final Integer getCheckRestoreByTimer() {
            return this.checkRestoreByTimer;
        }

        public final void setCheckRestoreByTimer(@Nullable Integer n) {
            this.checkRestoreByTimer = n;
        }

        public final int getDelayBeforeRestore() {
            return this.delayBeforeRestore;
        }

        public final void setDelayBeforeRestore(int n) {
            this.delayBeforeRestore = n;
        }

        @Nullable
        public final Function0<Function0<Unit>> component1() {
            return this.shouldRestore;
        }

        @Nullable
        public final Boolean component2() {
            return this.transparentRestore;
        }

        @Nullable
        public final Boolean component3() {
            return this.highlightPreviousUi;
        }

        @Nullable
        public final Boolean component4() {
            return this.propagateHighlighting;
        }

        @Nullable
        public final Integer component5() {
            return this.checkRestoreByTimer;
        }

        public final int component6() {
            return this.delayBeforeRestore;
        }

        @NotNull
        public final TaskData copy(@Nullable Function0<? extends Function0<Unit>> shouldRestore, @Nullable Boolean transparentRestore, @Nullable Boolean highlightPreviousUi, @Nullable Boolean propagateHighlighting, @Nullable Integer checkRestoreByTimer, int delayBeforeRestore) {
            return new TaskData(shouldRestore, transparentRestore, highlightPreviousUi, propagateHighlighting, checkRestoreByTimer, delayBeforeRestore);
        }

        public static /* synthetic */ TaskData copy$default(TaskData taskData, Function0 function0, Boolean bl, Boolean bl2, Boolean bl3, Integer n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                function0 = taskData.shouldRestore;
            }
            if ((n3 & 2) != 0) {
                bl = taskData.transparentRestore;
            }
            if ((n3 & 4) != 0) {
                bl2 = taskData.highlightPreviousUi;
            }
            if ((n3 & 8) != 0) {
                bl3 = taskData.propagateHighlighting;
            }
            if ((n3 & 0x10) != 0) {
                n = taskData.checkRestoreByTimer;
            }
            if ((n3 & 0x20) != 0) {
                n2 = taskData.delayBeforeRestore;
            }
            return taskData.copy(function0, bl, bl2, bl3, n, n2);
        }

        @NotNull
        public String toString() {
            return "TaskData(shouldRestore=" + this.shouldRestore + ", transparentRestore=" + this.transparentRestore + ", highlightPreviousUi=" + this.highlightPreviousUi + ", propagateHighlighting=" + this.propagateHighlighting + ", checkRestoreByTimer=" + this.checkRestoreByTimer + ", delayBeforeRestore=" + this.delayBeforeRestore + ")";
        }

        public int hashCode() {
            int result2 = this.shouldRestore == null ? 0 : this.shouldRestore.hashCode();
            result2 = result2 * 31 + (this.transparentRestore == null ? 0 : ((Object)this.transparentRestore).hashCode());
            result2 = result2 * 31 + (this.highlightPreviousUi == null ? 0 : ((Object)this.highlightPreviousUi).hashCode());
            result2 = result2 * 31 + (this.propagateHighlighting == null ? 0 : ((Object)this.propagateHighlighting).hashCode());
            result2 = result2 * 31 + (this.checkRestoreByTimer == null ? 0 : ((Object)this.checkRestoreByTimer).hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.delayBeforeRestore);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TaskData)) {
                return false;
            }
            TaskData taskData = (TaskData)other;
            if (!Intrinsics.areEqual(this.shouldRestore, taskData.shouldRestore)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.transparentRestore, (Object)taskData.transparentRestore)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.highlightPreviousUi, (Object)taskData.highlightPreviousUi)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.propagateHighlighting, (Object)taskData.propagateHighlighting)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.checkRestoreByTimer, (Object)taskData.checkRestoreByTimer)) {
                return false;
            }
            return this.delayBeforeRestore == taskData.delayBeforeRestore;
        }

        public TaskData() {
            this(null, null, null, null, null, 0, 63, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b8\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u00a6\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0019\u0010\t\u001a\u0015\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n\u00a2\u0006\u0002\b\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0006\u0012\u0012\b\u0002\u0010\u0011\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u000f\u0012\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018\u00a2\u0006\u0002\u0010\u0019J\u000f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0010\u0010@\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010A\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\u000f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u00c6\u0003J\t\u0010C\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010D\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u001c\u0010E\u001a\u0015\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n\u00a2\u0006\u0002\b\fH\u00c6\u0003J\u0010\u0010F\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u00107J\t\u0010G\u001a\u00020\u000fH\u00c6\u0003J\t\u0010H\u001a\u00020\u0006H\u00c6\u0003J\u0013\u0010I\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010J\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003J\u00b9\u0001\u0010K\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u001b\b\u0002\u0010\t\u001a\u0015\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n\u00a2\u0006\u0002\b\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00062\u0012\b\u0002\u0010\u0011\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u00032\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u00c6\u0001\u00a2\u0006\u0002\u0010LJ\u0013\u0010M\u001a\u00020\u000f2\b\u0010N\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010O\u001a\u00020\u0006H\u00d6\u0001J\t\u0010P\u001a\u00020QH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010 \u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010\u0011\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001b\"\u0004\b*\u0010+R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\"\"\u0004\b/\u0010$R$\u0010\t\u001a\u0015\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0015\u0010\r\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u00108\u001a\u0004\b6\u00107R\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010 \u001a\u0004\b9\u0010\u001d\"\u0004\b:\u0010\u001fR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006R"}, d2={"Ltraining/dsl/impl/LessonExecutor$TaskInfo;", "", "content", "Lkotlin/Function0;", "", "restoreIndex", "", "taskProperties", "Ltraining/dsl/impl/TaskProperties;", "taskContent", "Lkotlin/Function1;", "Ltraining/dsl/TaskContext;", "Lkotlin/ExtensionFunctionType;", "taskVisualIndex", "nextTaskHasBeenScheduled", "", "messagesNumberBeforeStart", "rehighlightComponent", "Ljava/awt/Component;", "userVisibleInfo", "Ltraining/dsl/PreviousTaskInfo;", "transparentRestore", "highlightPreviousUi", "removeAfterDoneMessages", "", "(Lkotlin/jvm/functions/Function0;ILtraining/dsl/impl/TaskProperties;Lkotlin/jvm/functions/Function1;Ljava/lang/Integer;ZILkotlin/jvm/functions/Function0;Ltraining/dsl/PreviousTaskInfo;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/List;)V", "getContent", "()Lkotlin/jvm/functions/Function0;", "getHighlightPreviousUi", "()Ljava/lang/Boolean;", "setHighlightPreviousUi", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getMessagesNumberBeforeStart", "()I", "setMessagesNumberBeforeStart", "(I)V", "getNextTaskHasBeenScheduled", "()Z", "setNextTaskHasBeenScheduled", "(Z)V", "getRehighlightComponent", "setRehighlightComponent", "(Lkotlin/jvm/functions/Function0;)V", "getRemoveAfterDoneMessages", "()Ljava/util/List;", "getRestoreIndex", "setRestoreIndex", "getTaskContent", "()Lkotlin/jvm/functions/Function1;", "getTaskProperties", "()Ltraining/dsl/impl/TaskProperties;", "setTaskProperties", "(Ltraining/dsl/impl/TaskProperties;)V", "getTaskVisualIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getTransparentRestore", "setTransparentRestore", "getUserVisibleInfo", "()Ltraining/dsl/PreviousTaskInfo;", "setUserVisibleInfo", "(Ltraining/dsl/PreviousTaskInfo;)V", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Lkotlin/jvm/functions/Function0;ILtraining/dsl/impl/TaskProperties;Lkotlin/jvm/functions/Function1;Ljava/lang/Integer;ZILkotlin/jvm/functions/Function0;Ltraining/dsl/PreviousTaskInfo;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/List;)Ltraining/dsl/impl/LessonExecutor$TaskInfo;", "equals", "other", "hashCode", "toString", "", "intellij.featuresTrainer"})
    private static final class TaskInfo {
        @NotNull
        private final Function0<Unit> content;
        private int restoreIndex;
        @Nullable
        private TaskProperties taskProperties;
        @Nullable
        private final Function1<TaskContext, Unit> taskContent;
        @Nullable
        private final Integer taskVisualIndex;
        private boolean nextTaskHasBeenScheduled;
        private int messagesNumberBeforeStart;
        @Nullable
        private Function0<? extends Component> rehighlightComponent;
        @Nullable
        private PreviousTaskInfo userVisibleInfo;
        @Nullable
        private Boolean transparentRestore;
        @Nullable
        private Boolean highlightPreviousUi;
        @NotNull
        private final List<Integer> removeAfterDoneMessages;

        public TaskInfo(@NotNull Function0<Unit> content, int restoreIndex, @Nullable TaskProperties taskProperties, @Nullable Function1<? super TaskContext, Unit> taskContent, @Nullable Integer taskVisualIndex, boolean nextTaskHasBeenScheduled, int messagesNumberBeforeStart, @Nullable Function0<? extends Component> rehighlightComponent, @Nullable PreviousTaskInfo userVisibleInfo, @Nullable Boolean transparentRestore, @Nullable Boolean highlightPreviousUi, @NotNull List<Integer> removeAfterDoneMessages) {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            Intrinsics.checkNotNullParameter(removeAfterDoneMessages, (String)"removeAfterDoneMessages");
            this.content = content;
            this.restoreIndex = restoreIndex;
            this.taskProperties = taskProperties;
            this.taskContent = taskContent;
            this.taskVisualIndex = taskVisualIndex;
            this.nextTaskHasBeenScheduled = nextTaskHasBeenScheduled;
            this.messagesNumberBeforeStart = messagesNumberBeforeStart;
            this.rehighlightComponent = rehighlightComponent;
            this.userVisibleInfo = userVisibleInfo;
            this.transparentRestore = transparentRestore;
            this.highlightPreviousUi = highlightPreviousUi;
            this.removeAfterDoneMessages = removeAfterDoneMessages;
        }

        public /* synthetic */ TaskInfo(Function0 function0, int n, TaskProperties taskProperties, Function1 function1, Integer n2, boolean bl, int n3, Function0 function02, PreviousTaskInfo previousTaskInfo, Boolean bl2, Boolean bl3, List list2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 0x20) != 0) {
                bl = false;
            }
            if ((n4 & 0x40) != 0) {
                n3 = 0;
            }
            if ((n4 & 0x80) != 0) {
                function02 = null;
            }
            if ((n4 & 0x100) != 0) {
                previousTaskInfo = null;
            }
            if ((n4 & 0x200) != 0) {
                bl2 = null;
            }
            if ((n4 & 0x400) != 0) {
                bl3 = null;
            }
            if ((n4 & 0x800) != 0) {
                list2 = new ArrayList();
            }
            this((Function0<Unit>)function0, n, taskProperties, (Function1<? super TaskContext, Unit>)function1, n2, bl, n3, (Function0<? extends Component>)function02, previousTaskInfo, bl2, bl3, list2);
        }

        @NotNull
        public final Function0<Unit> getContent() {
            return this.content;
        }

        public final int getRestoreIndex() {
            return this.restoreIndex;
        }

        public final void setRestoreIndex(int n) {
            this.restoreIndex = n;
        }

        @Nullable
        public final TaskProperties getTaskProperties() {
            return this.taskProperties;
        }

        public final void setTaskProperties(@Nullable TaskProperties taskProperties) {
            this.taskProperties = taskProperties;
        }

        @Nullable
        public final Function1<TaskContext, Unit> getTaskContent() {
            return this.taskContent;
        }

        @Nullable
        public final Integer getTaskVisualIndex() {
            return this.taskVisualIndex;
        }

        public final boolean getNextTaskHasBeenScheduled() {
            return this.nextTaskHasBeenScheduled;
        }

        public final void setNextTaskHasBeenScheduled(boolean bl) {
            this.nextTaskHasBeenScheduled = bl;
        }

        public final int getMessagesNumberBeforeStart() {
            return this.messagesNumberBeforeStart;
        }

        public final void setMessagesNumberBeforeStart(int n) {
            this.messagesNumberBeforeStart = n;
        }

        @Nullable
        public final Function0<Component> getRehighlightComponent() {
            return this.rehighlightComponent;
        }

        public final void setRehighlightComponent(@Nullable Function0<? extends Component> function0) {
            this.rehighlightComponent = function0;
        }

        @Nullable
        public final PreviousTaskInfo getUserVisibleInfo() {
            return this.userVisibleInfo;
        }

        public final void setUserVisibleInfo(@Nullable PreviousTaskInfo previousTaskInfo) {
            this.userVisibleInfo = previousTaskInfo;
        }

        @Nullable
        public final Boolean getTransparentRestore() {
            return this.transparentRestore;
        }

        public final void setTransparentRestore(@Nullable Boolean bl) {
            this.transparentRestore = bl;
        }

        @Nullable
        public final Boolean getHighlightPreviousUi() {
            return this.highlightPreviousUi;
        }

        public final void setHighlightPreviousUi(@Nullable Boolean bl) {
            this.highlightPreviousUi = bl;
        }

        @NotNull
        public final List<Integer> getRemoveAfterDoneMessages() {
            return this.removeAfterDoneMessages;
        }

        @NotNull
        public final Function0<Unit> component1() {
            return this.content;
        }

        public final int component2() {
            return this.restoreIndex;
        }

        @Nullable
        public final TaskProperties component3() {
            return this.taskProperties;
        }

        @Nullable
        public final Function1<TaskContext, Unit> component4() {
            return this.taskContent;
        }

        @Nullable
        public final Integer component5() {
            return this.taskVisualIndex;
        }

        public final boolean component6() {
            return this.nextTaskHasBeenScheduled;
        }

        public final int component7() {
            return this.messagesNumberBeforeStart;
        }

        @Nullable
        public final Function0<Component> component8() {
            return this.rehighlightComponent;
        }

        @Nullable
        public final PreviousTaskInfo component9() {
            return this.userVisibleInfo;
        }

        @Nullable
        public final Boolean component10() {
            return this.transparentRestore;
        }

        @Nullable
        public final Boolean component11() {
            return this.highlightPreviousUi;
        }

        @NotNull
        public final List<Integer> component12() {
            return this.removeAfterDoneMessages;
        }

        @NotNull
        public final TaskInfo copy(@NotNull Function0<Unit> content, int restoreIndex, @Nullable TaskProperties taskProperties, @Nullable Function1<? super TaskContext, Unit> taskContent, @Nullable Integer taskVisualIndex, boolean nextTaskHasBeenScheduled, int messagesNumberBeforeStart, @Nullable Function0<? extends Component> rehighlightComponent, @Nullable PreviousTaskInfo userVisibleInfo, @Nullable Boolean transparentRestore, @Nullable Boolean highlightPreviousUi, @NotNull List<Integer> removeAfterDoneMessages) {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            Intrinsics.checkNotNullParameter(removeAfterDoneMessages, (String)"removeAfterDoneMessages");
            return new TaskInfo(content, restoreIndex, taskProperties, taskContent, taskVisualIndex, nextTaskHasBeenScheduled, messagesNumberBeforeStart, rehighlightComponent, userVisibleInfo, transparentRestore, highlightPreviousUi, removeAfterDoneMessages);
        }

        public static /* synthetic */ TaskInfo copy$default(TaskInfo taskInfo, Function0 function0, int n, TaskProperties taskProperties, Function1 function1, Integer n2, boolean bl, int n3, Function0 function02, PreviousTaskInfo previousTaskInfo, Boolean bl2, Boolean bl3, List list2, int n4, Object object) {
            if ((n4 & 1) != 0) {
                function0 = taskInfo.content;
            }
            if ((n4 & 2) != 0) {
                n = taskInfo.restoreIndex;
            }
            if ((n4 & 4) != 0) {
                taskProperties = taskInfo.taskProperties;
            }
            if ((n4 & 8) != 0) {
                function1 = taskInfo.taskContent;
            }
            if ((n4 & 0x10) != 0) {
                n2 = taskInfo.taskVisualIndex;
            }
            if ((n4 & 0x20) != 0) {
                bl = taskInfo.nextTaskHasBeenScheduled;
            }
            if ((n4 & 0x40) != 0) {
                n3 = taskInfo.messagesNumberBeforeStart;
            }
            if ((n4 & 0x80) != 0) {
                function02 = taskInfo.rehighlightComponent;
            }
            if ((n4 & 0x100) != 0) {
                previousTaskInfo = taskInfo.userVisibleInfo;
            }
            if ((n4 & 0x200) != 0) {
                bl2 = taskInfo.transparentRestore;
            }
            if ((n4 & 0x400) != 0) {
                bl3 = taskInfo.highlightPreviousUi;
            }
            if ((n4 & 0x800) != 0) {
                list2 = taskInfo.removeAfterDoneMessages;
            }
            return taskInfo.copy(function0, n, taskProperties, function1, n2, bl, n3, function02, previousTaskInfo, bl2, bl3, list2);
        }

        @NotNull
        public String toString() {
            return "TaskInfo(content=" + this.content + ", restoreIndex=" + this.restoreIndex + ", taskProperties=" + this.taskProperties + ", taskContent=" + this.taskContent + ", taskVisualIndex=" + this.taskVisualIndex + ", nextTaskHasBeenScheduled=" + this.nextTaskHasBeenScheduled + ", messagesNumberBeforeStart=" + this.messagesNumberBeforeStart + ", rehighlightComponent=" + this.rehighlightComponent + ", userVisibleInfo=" + this.userVisibleInfo + ", transparentRestore=" + this.transparentRestore + ", highlightPreviousUi=" + this.highlightPreviousUi + ", removeAfterDoneMessages=" + this.removeAfterDoneMessages + ")";
        }

        public int hashCode() {
            int result2 = this.content.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.restoreIndex);
            result2 = result2 * 31 + (this.taskProperties == null ? 0 : this.taskProperties.hashCode());
            result2 = result2 * 31 + (this.taskContent == null ? 0 : this.taskContent.hashCode());
            result2 = result2 * 31 + (this.taskVisualIndex == null ? 0 : ((Object)this.taskVisualIndex).hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.nextTaskHasBeenScheduled);
            result2 = result2 * 31 + Integer.hashCode(this.messagesNumberBeforeStart);
            result2 = result2 * 31 + (this.rehighlightComponent == null ? 0 : this.rehighlightComponent.hashCode());
            result2 = result2 * 31 + (this.userVisibleInfo == null ? 0 : this.userVisibleInfo.hashCode());
            result2 = result2 * 31 + (this.transparentRestore == null ? 0 : ((Object)this.transparentRestore).hashCode());
            result2 = result2 * 31 + (this.highlightPreviousUi == null ? 0 : ((Object)this.highlightPreviousUi).hashCode());
            result2 = result2 * 31 + ((Object)this.removeAfterDoneMessages).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TaskInfo)) {
                return false;
            }
            TaskInfo taskInfo = (TaskInfo)other;
            if (!Intrinsics.areEqual(this.content, taskInfo.content)) {
                return false;
            }
            if (this.restoreIndex != taskInfo.restoreIndex) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.taskProperties, (Object)taskInfo.taskProperties)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.taskContent, taskInfo.taskContent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.taskVisualIndex, (Object)taskInfo.taskVisualIndex)) {
                return false;
            }
            if (this.nextTaskHasBeenScheduled != taskInfo.nextTaskHasBeenScheduled) {
                return false;
            }
            if (this.messagesNumberBeforeStart != taskInfo.messagesNumberBeforeStart) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rehighlightComponent, taskInfo.rehighlightComponent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.userVisibleInfo, (Object)taskInfo.userVisibleInfo)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.transparentRestore, (Object)taskInfo.transparentRestore)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.highlightPreviousUi, (Object)taskInfo.highlightPreviousUi)) {
                return false;
            }
            return Intrinsics.areEqual(this.removeAfterDoneMessages, taskInfo.removeAfterDoneMessages);
        }
    }
}

