/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.authentication.accounts;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.AccountManagerBase;
import com.intellij.collaboration.auth.AccountsRepository;
import com.intellij.collaboration.auth.PasswordSafeCredentialsRepository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccountManager;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabPersistentAccounts;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0014J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gitlab/authentication/accounts/PersistentGitLabAccountManager;", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountManager;", "Lcom/intellij/collaboration/auth/AccountManagerBase;", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccount;", "", "()V", "accountsRepository", "Lcom/intellij/collaboration/auth/AccountsRepository;", "credentialsRepository", "Lcom/intellij/collaboration/auth/PasswordSafeCredentialsRepository;", "dispose", "", "isAccountUnique", "", "server", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "accountName", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabAccountManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabAccountManager.kt\norg/jetbrains/plugins/gitlab/authentication/accounts/PersistentGitLabAccountManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n11#2:38\n43#3,3:39\n2624#4,3:42\n*S KotlinDebug\n*F\n+ 1 GitLabAccountManager.kt\norg/jetbrains/plugins/gitlab/authentication/accounts/PersistentGitLabAccountManager\n*L\n20#1:38\n22#1:39,3\n33#1:42,3\n*E\n"})
public final class PersistentGitLabAccountManager
extends AccountManagerBase<GitLabAccount, String>
implements GitLabAccountManager {
    public PersistentGitLabAccountManager() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitLabAccountManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        super(logger);
    }

    @NotNull
    protected AccountsRepository<GitLabAccount> accountsRepository() {
        boolean $i$f$service = false;
        Class<GitLabPersistentAccounts> serviceClass$iv = GitLabPersistentAccounts.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return (AccountsRepository)object;
    }

    @NotNull
    protected PasswordSafeCredentialsRepository<GitLabAccount, String> credentialsRepository() {
        return new PasswordSafeCredentialsRepository("GitLab", (PasswordSafeCredentialsRepository.CredentialsMapper)PasswordSafeCredentialsRepository.CredentialsMapper.Simple.INSTANCE);
    }

    public void dispose() {
    }

    @Override
    public boolean isAccountUnique(@NotNull GitLabServerPath server, @NotNull String accountName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)accountName, (String)"accountName");
            Iterable $this$none$iv = (Iterable)this.getAccountsState().getValue();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    GitLabAccount account2 = (GitLabAccount)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)account2.getServer(), (Object)server) && Intrinsics.areEqual((Object)account2.getName(), (Object)accountName))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }
}

