/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui;

import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.GitlabIcons;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabCiConfigIconProvider;", "Lcom/intellij/ide/FileIconProvider;", "()V", "GITLAB_SCHEMAS", "", "", "getIcon", "Ljavax/swing/Icon;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "flags", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabCiConfigIconProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabCiConfigIconProvider.kt\norg/jetbrains/plugins/gitlab/ui/GitLabCiConfigIconProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n31#2,2:32\n1747#3,3:34\n*S KotlinDebug\n*F\n+ 1 GitLabCiConfigIconProvider.kt\norg/jetbrains/plugins/gitlab/ui/GitLabCiConfigIconProvider\n*L\n24#1:32,2\n25#1:34,3\n*E\n"})
public final class GitLabCiConfigIconProvider
implements FileIconProvider {
    @NotNull
    private final Set<String> GITLAB_SCHEMAS = SetsKt.setOf((Object)"ci.json");

    @Nullable
    public Icon getIcon(@NotNull VirtualFile file, int flags, @Nullable Project project) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (project == null || !FileTypeRegistry.getInstance().isFileOfType(file, (FileType)YAMLFileType.YML)) {
                return null;
            }
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JsonSchemaService> serviceClass$iv = JsonSchemaService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Collection collection = ((JsonSchemaService)object).getSchemaFilesForFile(file);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSchemaFilesForFile(...)");
            Collection schemaFiles = collection;
            Iterable $this$any$iv = schemaFiles;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!this.GITLAB_SCHEMAS.contains(it.getName())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return GitlabIcons.GitLabLogo;
        }
        return null;
    }
}

