/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.buildScriptClasspathModel;

import com.intellij.gradle.toolingExtension.impl.model.buildScriptClasspathModel.DefaultGradleBuildScriptClasspathModel;
import com.intellij.gradle.toolingExtension.impl.model.buildScriptClasspathModel.GradleBuildScriptClasspathCache;
import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicy;
import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicyCache;
import com.intellij.gradle.toolingExtension.impl.util.collectionUtil.GradleCollections;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ClasspathEntryModel;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.GradleBuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.internal.ClasspathEntryModelImpl;
import org.jetbrains.plugins.gradle.tooling.util.DependencyTraverser;
import org.jetbrains.plugins.gradle.tooling.util.resolve.DependencyResolverImpl;

@ApiStatus.Internal
public class GradleBuildScriptClasspathModelBuilder
extends AbstractModelBuilderService {
    private static final String CLASSPATH_CONFIGURATION_NAME = "classpath";

    public boolean canBuild(String modelName) {
        return GradleBuildScriptClasspathModel.class.getName().equals(modelName);
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        Configuration classpathConfiguration;
        if (modelName == null) {
            GradleBuildScriptClasspathModelBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleBuildScriptClasspathModelBuilder.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GradleBuildScriptClasspathModelBuilder.$$$reportNull$$$0(2);
        }
        DefaultGradleBuildScriptClasspathModel buildScriptClasspath = new DefaultGradleBuildScriptClasspathModel();
        buildScriptClasspath.setGradleHomeDir(project.getGradle().getGradleHomeDir());
        buildScriptClasspath.setGradleVersion(GradleVersion.current().getVersion());
        Project parentProject = project.getParent();
        if (parentProject != null) {
            GradleBuildScriptClasspathModel parentBuildScriptClasspath = GradleBuildScriptClasspathCache.getInstance(context).getBuildScriptClasspathModel(parentProject);
            for (ClasspathEntryModel classpathEntryModel : parentBuildScriptClasspath.getClasspath()) {
                buildScriptClasspath.add(classpathEntryModel);
            }
        }
        if ((classpathConfiguration = (Configuration)project.getBuildscript().getConfigurations().findByName(CLASSPATH_CONFIGURATION_NAME)) != null) {
            GradleDependencyDownloadPolicy dependencyDownloadPolicy = GradleDependencyDownloadPolicyCache.getInstance(context).getDependencyDownloadPolicy(project);
            Collection<ExternalDependency> dependencies = new DependencyResolverImpl(context, project, dependencyDownloadPolicy).resolveDependencies(classpathConfiguration);
            for (ExternalDependency dependency : new DependencyTraverser(dependencies)) {
                if (dependency instanceof ExternalProjectDependency) {
                    ExternalProjectDependency projectDependency = (ExternalProjectDependency)dependency;
                    Collection projectDependencyArtifacts = projectDependency.getProjectDependencyArtifacts();
                    Collection projectDependencyArtifactsSources = projectDependency.getProjectDependencyArtifactsSources();
                    buildScriptClasspath.add(new ClasspathEntryModelImpl(projectDependencyArtifacts, projectDependencyArtifactsSources, Collections.emptySet()));
                    continue;
                }
                if (dependency instanceof ExternalLibraryDependency) {
                    ExternalLibraryDependency libraryDep = (ExternalLibraryDependency)dependency;
                    buildScriptClasspath.add(new ClasspathEntryModelImpl(GradleCollections.createMaybeSingletonList(libraryDep.getFile()), GradleCollections.createMaybeSingletonList(libraryDep.getSource()), GradleCollections.createMaybeSingletonList(libraryDep.getJavadoc())));
                    continue;
                }
                if (dependency instanceof ExternalMultiLibraryDependency) {
                    ExternalMultiLibraryDependency multiLibraryDependency = (ExternalMultiLibraryDependency)dependency;
                    buildScriptClasspath.add(new ClasspathEntryModelImpl(multiLibraryDependency.getFiles(), multiLibraryDependency.getSources(), multiLibraryDependency.getJavadoc()));
                    continue;
                }
                if (!(dependency instanceof FileCollectionDependency)) continue;
                FileCollectionDependency fileCollectionDependency = (FileCollectionDependency)dependency;
                buildScriptClasspath.add(new ClasspathEntryModelImpl(fileCollectionDependency.getFiles(), Collections.emptySet(), Collections.emptySet()));
            }
        }
        GradleBuildScriptClasspathCache.getInstance(context).setBuildScriptClasspathModel(project, buildScriptClasspath);
        return buildScriptClasspath;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        if (modelName == null) {
            GradleBuildScriptClasspathModelBuilder.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GradleBuildScriptClasspathModelBuilder.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GradleBuildScriptClasspathModelBuilder.$$$reportNull$$$0(5);
        }
        if (exception == null) {
            GradleBuildScriptClasspathModelBuilder.$$$reportNull$$$0(6);
        }
        GradleBuildScriptClasspathCache.getInstance(context).markBuildScriptClasspathModelAsError(project);
        context.getMessageReporter().createMessage().withGroup("gradle.buildScriptClasspathModel.group").withKind(Message.Kind.WARNING).withTitle("Project build classpath resolve failure").withText("Unable to resolve additional buildscript classpath dependencies").withException(exception).reportMessage(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/buildScriptClasspathModel/GradleBuildScriptClasspathModelBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildAll";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "reportErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

