/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel;

import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.DefaultGradleDependencyDownloadPolicy;
import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicy;
import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicyCache;
import com.intellij.gradle.toolingExtension.impl.util.GradleIdeaPluginUtil;
import org.gradle.api.Project;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

@ApiStatus.Internal
public class GradleDependencyDownloadPolicyBuilder
extends AbstractModelBuilderService {
    private static final String DOWNLOAD_SOURCES_FORCE_PROPERTY_NAME = "idea.gradle.download.sources.force";
    private static final String DOWNLOAD_SOURCES_PROPERTY_NAME = "idea.gradle.download.sources";

    public boolean canBuild(String modelName) {
        return GradleDependencyDownloadPolicy.class.getName().equals(modelName);
    }

    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        if (modelName == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(2);
        }
        DefaultGradleDependencyDownloadPolicy dependencyDownloadPolicy = new DefaultGradleDependencyDownloadPolicy();
        dependencyDownloadPolicy.setDownloadSources(GradleDependencyDownloadPolicyBuilder.shouldDownloadSources(context, project));
        dependencyDownloadPolicy.setDownloadJavadoc(GradleDependencyDownloadPolicyBuilder.shouldDownloadJavadocs(context, project));
        GradleDependencyDownloadPolicyBuilder.setIdeaPluginDependencyDownloadPolicy(project, dependencyDownloadPolicy);
        GradleDependencyDownloadPolicyCache.getInstance(context).setDependencyDownloadPolicy(project, dependencyDownloadPolicy);
        return dependencyDownloadPolicy;
    }

    private static void setIdeaPluginDependencyDownloadPolicy(@NotNull Project project, @NotNull GradleDependencyDownloadPolicy policy) {
        if (project == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(3);
        }
        if (policy == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(4);
        }
        project.getPlugins().withType(IdeaPlugin.class, plugin -> {
            IdeaModule module = plugin.getModel().getModule();
            module.setDownloadSources(policy.isDownloadSources());
            module.setDownloadJavadoc(policy.isDownloadJavadoc());
        });
    }

    @Nullable
    private static GradleDependencyDownloadPolicy getParentDependencyDownloadPolicy(@NotNull ModelBuilderContext context, @NotNull Project project) {
        Project parentProject;
        if (context == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(5);
        }
        if (project == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(6);
        }
        if ((parentProject = project.getParent()) == null) {
            return null;
        }
        return GradleDependencyDownloadPolicyCache.getInstance(context).getDependencyDownloadPolicy(parentProject);
    }

    private static boolean shouldDownloadSources(@NotNull ModelBuilderContext context, @NotNull Project project) {
        String forcePropertyValue;
        if (context == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(7);
        }
        if (project == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(8);
        }
        if ((forcePropertyValue = System.getProperty(DOWNLOAD_SOURCES_FORCE_PROPERTY_NAME)) != null) {
            return Boolean.parseBoolean(forcePropertyValue);
        }
        IdeaModule ideaModule = GradleIdeaPluginUtil.getIdeaModule(project);
        if (ideaModule != null) {
            return ideaModule.isDownloadSources();
        }
        GradleDependencyDownloadPolicy parentPolicy = GradleDependencyDownloadPolicyBuilder.getParentDependencyDownloadPolicy(context, project);
        if (parentPolicy != null) {
            return parentPolicy.isDownloadSources();
        }
        return Boolean.parseBoolean(System.getProperty(DOWNLOAD_SOURCES_PROPERTY_NAME, "false"));
    }

    private static boolean shouldDownloadJavadocs(@NotNull ModelBuilderContext context, @NotNull Project project) {
        IdeaModule ideaModule;
        if (context == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(9);
        }
        if (project == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(10);
        }
        if ((ideaModule = GradleIdeaPluginUtil.getIdeaModule(project)) != null) {
            return ideaModule.isDownloadJavadoc();
        }
        GradleDependencyDownloadPolicy parentPolicy = GradleDependencyDownloadPolicyBuilder.getParentDependencyDownloadPolicy(context, project);
        if (parentPolicy != null) {
            return parentPolicy.isDownloadJavadoc();
        }
        return false;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        if (modelName == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(11);
        }
        if (project == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(12);
        }
        if (context == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(13);
        }
        if (exception == null) {
            GradleDependencyDownloadPolicyBuilder.$$$reportNull$$$0(14);
        }
        GradleDependencyDownloadPolicyCache.getInstance(context).markDependencyDownloadPolicyAsError(project);
        context.getMessageReporter().createMessage().withGroup("gradle.dependencyDownloadPolicyModel.group").withKind(Message.Kind.ERROR).withTitle("Dependency download policy building failure").withException(exception).reportMessage(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/dependencyDownloadPolicyModel/GradleDependencyDownloadPolicyBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildAll";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setIdeaPluginDependencyDownloadPolicy";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentDependencyDownloadPolicy";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldDownloadSources";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldDownloadJavadocs";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "reportErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

