/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel;

import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.DefaultGradleDependencyDownloadPolicy;
import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicy;
import com.intellij.gradle.toolingExtension.impl.util.GradleProjectUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.Project;
import org.gradle.tooling.model.ProjectIdentifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

@ApiStatus.Internal
public class GradleDependencyDownloadPolicyCache {
    @NotNull
    private final ModelBuilderContext context;
    @NotNull
    private final ConcurrentMap<ProjectIdentifier, GradleDependencyDownloadPolicy> policies;
    @NotNull
    private static final ModelBuilderContext.DataProvider<GradleDependencyDownloadPolicyCache> INSTANCE_PROVIDER = GradleDependencyDownloadPolicyCache::new;

    private GradleDependencyDownloadPolicyCache(@NotNull ModelBuilderContext context) {
        if (context == null) {
            GradleDependencyDownloadPolicyCache.$$$reportNull$$$0(0);
        }
        this.context = context;
        this.policies = new ConcurrentHashMap<ProjectIdentifier, GradleDependencyDownloadPolicy>();
    }

    @NotNull
    public GradleDependencyDownloadPolicy getDependencyDownloadPolicy(@NotNull Project project) {
        ProjectIdentifier projectIdentifier;
        GradleDependencyDownloadPolicy policy;
        if (project == null) {
            GradleDependencyDownloadPolicyCache.$$$reportNull$$$0(1);
        }
        if ((policy = (GradleDependencyDownloadPolicy)this.policies.get(projectIdentifier = GradleProjectUtil.getProjectIdentifier(project))) == null) {
            String projectDisplayName = project.getDisplayName();
            this.context.getMessageReporter().createMessage().withGroup("gradle.dependencyDownloadPolicyModel.cacheGet.group").withTitle("Gradle dependency download policy aren't found").withText("Gradle dependency download policy for " + projectDisplayName + " wasn't collected.").withStackTrace().withKind(Message.Kind.INTERNAL).reportMessage(project);
            return new DefaultGradleDependencyDownloadPolicy();
        }
        GradleDependencyDownloadPolicy gradleDependencyDownloadPolicy = policy;
        if (gradleDependencyDownloadPolicy == null) {
            GradleDependencyDownloadPolicyCache.$$$reportNull$$$0(2);
        }
        return gradleDependencyDownloadPolicy;
    }

    public void setDependencyDownloadPolicy(@NotNull Project project, @NotNull GradleDependencyDownloadPolicy policy) {
        ProjectIdentifier projectIdentifier;
        GradleDependencyDownloadPolicy oldPolicy;
        if (project == null) {
            GradleDependencyDownloadPolicyCache.$$$reportNull$$$0(3);
        }
        if (policy == null) {
            GradleDependencyDownloadPolicyCache.$$$reportNull$$$0(4);
        }
        if ((oldPolicy = this.policies.put(projectIdentifier = GradleProjectUtil.getProjectIdentifier(project), policy)) != null) {
            String projectDisplayName = project.getDisplayName();
            this.context.getMessageReporter().createMessage().withGroup("gradle.dependencyDownloadPolicyModel.cacheSet.group").withTitle("Gradle dependency download policy redefinition").withText("Gradle dependency download policy for " + projectDisplayName + " was already collected.").withStackTrace().withKind(Message.Kind.INTERNAL).reportMessage(project);
        }
    }

    public void markDependencyDownloadPolicyAsError(@NotNull Project project) {
        if (project == null) {
            GradleDependencyDownloadPolicyCache.$$$reportNull$$$0(5);
        }
        ProjectIdentifier projectIdentifier = GradleProjectUtil.getProjectIdentifier(project);
        this.policies.put(projectIdentifier, new DefaultGradleDependencyDownloadPolicy());
    }

    @NotNull
    public static GradleDependencyDownloadPolicyCache getInstance(@NotNull ModelBuilderContext context) {
        if (context == null) {
            GradleDependencyDownloadPolicyCache.$$$reportNull$$$0(6);
        }
        GradleDependencyDownloadPolicyCache gradleDependencyDownloadPolicyCache = (GradleDependencyDownloadPolicyCache)context.getData(INSTANCE_PROVIDER);
        if (gradleDependencyDownloadPolicyCache == null) {
            GradleDependencyDownloadPolicyCache.$$$reportNull$$$0(7);
        }
        return gradleDependencyDownloadPolicyCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/dependencyDownloadPolicyModel/GradleDependencyDownloadPolicyCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/dependencyDownloadPolicyModel/GradleDependencyDownloadPolicyCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyDownloadPolicy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyDownloadPolicy";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDependencyDownloadPolicy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markDependencyDownloadPolicyAsError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

