/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.projectModel;

import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.DefaultGradleSourceSetModel;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.GradleSourceSetCache;
import com.intellij.gradle.toolingExtension.impl.model.taskModel.GradleTaskCache;
import com.intellij.gradle.toolingExtension.impl.util.GradleIdeaPluginUtil;
import com.intellij.gradle.toolingExtension.impl.util.GradleObjectUtil;
import com.intellij.gradle.toolingExtension.impl.util.GradleProjectUtil;
import com.intellij.gradle.toolingExtension.impl.util.GradleTaskUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.Test;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectPreview;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.builder.ProjectExtensionsDataBuilderImpl;

@ApiStatus.Internal
public class ExternalProjectBuilderImpl
extends AbstractModelBuilderService {
    public boolean canBuild(@NotNull String modelName) {
        if (modelName == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(0);
        }
        return ExternalProject.class.getName().equals(modelName) || ExternalProjectPreview.class.getName().equals(modelName);
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        if (modelName == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(3);
        }
        if (Objects.equals(System.getProperty("idea.internal.failEsModelBuilder"), "true")) {
            throw new RuntimeException("Boom!");
        }
        return ExternalProjectBuilderImpl.buildExternalProject(project, context);
    }

    @NotNull
    private static DefaultExternalProject buildExternalProject(@NotNull Project project, @NotNull ModelBuilderContext context) {
        if (project == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(4);
        }
        if (context == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(5);
        }
        String projectPath = project.getPath();
        String projectName = project.getName();
        String projectIdentityPath = GradleObjectUtil.notNull(GradleProjectUtil.getProjectIdentityPath(project), projectPath);
        String ideaModuleName = GradleObjectUtil.notNull(GradleIdeaPluginUtil.getIdeaModuleName(project), projectName);
        DefaultExternalProject externalProject = new DefaultExternalProject();
        externalProject.setExternalSystemId("GRADLE");
        externalProject.setName(projectName);
        externalProject.setQName(":".equals(projectPath) ? projectName : projectPath);
        externalProject.setId(":".equals(projectIdentityPath) ? ideaModuleName : projectIdentityPath);
        externalProject.setPath(projectPath);
        externalProject.setIdentityPath(projectIdentityPath);
        externalProject.setVersion(ExternalProjectBuilderImpl.wrap(project.getVersion()));
        externalProject.setDescription(project.getDescription());
        externalProject.setBuildDir(GradleProjectUtil.getBuildDirectory(project));
        externalProject.setBuildFile(project.getBuildFile());
        externalProject.setGroup(ExternalProjectBuilderImpl.wrap(project.getGroup()));
        externalProject.setProjectDir(project.getProjectDir());
        externalProject.setTasks(ExternalProjectBuilderImpl.getTasks(project, context));
        externalProject.setSourceSetModel(ExternalProjectBuilderImpl.getSourceSetModel(project, context));
        DefaultExternalProject defaultExternalProject = externalProject;
        if (defaultExternalProject == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(6);
        }
        return defaultExternalProject;
    }

    @NotNull
    private static Map<String, DefaultExternalTask> getTasks(@NotNull Project project, @NotNull ModelBuilderContext context) {
        if (project == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(8);
        }
        HashMap<String, DefaultExternalTask> result = new HashMap<String, DefaultExternalTask>();
        GradleTaskCache taskCache = GradleTaskCache.getInstance(context);
        for (Task task : taskCache.getAllTasks(project)) {
            String projectTaskPath;
            String taskName = task.getName();
            DefaultExternalTask externalTask = (DefaultExternalTask)result.get(taskName);
            if (externalTask == null) {
                externalTask = new DefaultExternalTask();
                externalTask.setName(taskName);
                externalTask.setQName(taskName);
                externalTask.setDescription(task.getDescription());
                externalTask.setGroup(GradleObjectUtil.notNull(task.getGroup(), "other"));
                boolean isInternalTest = GradleTaskUtil.getBooleanProperty(task, "idea.internal.test", false);
                boolean isEffectiveTest = "check".equals(taskName) && "verification".equals(task.getGroup());
                boolean isJvmTest = task instanceof Test;
                boolean isAbstractTest = task instanceof AbstractTestTask;
                externalTask.setTest(isJvmTest || isAbstractTest || isInternalTest || isEffectiveTest);
                externalTask.setJvmTest(isJvmTest || isAbstractTest);
                externalTask.setType(ProjectExtensionsDataBuilderImpl.getType(task));
                result.put(externalTask.getName(), externalTask);
            }
            if (!(projectTaskPath = (":".equals(project.getPath()) ? ":" : project.getPath() + ":") + task.getName()).equals(task.getPath())) continue;
            externalTask.setQName(task.getPath());
        }
        HashMap<String, DefaultExternalTask> hashMap = result;
        if (hashMap == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @NotNull
    private static DefaultGradleSourceSetModel getSourceSetModel(@NotNull Project project, @NotNull ModelBuilderContext context) {
        if (project == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(10);
        }
        if (context == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(11);
        }
        DefaultGradleSourceSetModel defaultGradleSourceSetModel = GradleSourceSetCache.getInstance(context).getSourceSetModel(project);
        if (defaultGradleSourceSetModel == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(12);
        }
        return defaultGradleSourceSetModel;
    }

    @NotNull
    private static String wrap(@Nullable Object o) {
        return o instanceof CharSequence ? o.toString() : "";
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        if (modelName == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(13);
        }
        if (project == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(14);
        }
        if (context == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(15);
        }
        if (exception == null) {
            ExternalProjectBuilderImpl.$$$reportNull$$$0(16);
        }
        context.getMessageReporter().createMessage().withGroup("gradle.projectModel.group").withKind(Message.Kind.ERROR).withTitle("Project resolution failure").withText("Unable to resolve additional project configuration").withException(exception).reportMessage(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/projectModel/ExternalProjectBuilderImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/projectModel/ExternalProjectBuilderImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExternalProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceSetModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canBuild";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildAll";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildExternalProject";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTasks";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourceSetModel";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reportErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

