/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.sourceSetModel;

import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.DefaultGradleSourceSetModel;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.GradleSourceSetCache;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.GradleSourceSetGroovyHelper;
import com.intellij.gradle.toolingExtension.impl.util.GradleTaskUtil;
import com.intellij.gradle.toolingExtension.impl.util.collectionUtil.GradleCollectionVisitor;
import com.intellij.gradle.toolingExtension.impl.util.javaPluginUtil.JavaPluginUtil;
import com.intellij.gradle.toolingExtension.util.GradleReflectionUtil;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.GradleSourceSetModel;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

@ApiStatus.Internal
public class GradleSourceSetModelBuilder
extends AbstractModelBuilderService {
    public boolean canBuild(String modelName) {
        return GradleSourceSetModel.class.getName().equals(modelName);
    }

    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        if (modelName == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(2);
        }
        DefaultGradleSourceSetModel sourceSetModel = new DefaultGradleSourceSetModel();
        sourceSetModel.setSourceCompatibility(JavaPluginUtil.getSourceCompatibility(project));
        sourceSetModel.setTargetCompatibility(JavaPluginUtil.getTargetCompatibility(project));
        sourceSetModel.setTaskArtifacts(GradleSourceSetModelBuilder.collectProjectTaskArtifacts(project, context));
        sourceSetModel.setConfigurationArtifacts(GradleSourceSetModelBuilder.collectProjectConfigurationArtifacts(project, context));
        sourceSetModel.setSourceSets(GradleSourceSetGroovyHelper.getSourceSets(project, context));
        sourceSetModel.setAdditionalArtifacts(GradleSourceSetModelBuilder.collectNonSourceSetArtifacts(project, context));
        GradleSourceSetCache.getInstance(context).setSourceSetModel(project, sourceSetModel);
        return sourceSetModel;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        if (modelName == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(5);
        }
        if (exception == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(6);
        }
        GradleSourceSetCache.getInstance(context).markSourceSetModelAsError(project);
        context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.group").withKind(Message.Kind.ERROR).withTitle("Source set model building failure").withException(exception).reportMessage(project);
    }

    @NotNull
    private static List<File> collectProjectTaskArtifacts(final @NotNull Project project, final @NotNull ModelBuilderContext context) {
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(8);
        }
        final ArrayList taskArtifacts = new ArrayList();
        GradleCollectionVisitor.accept(project.getTasks().withType(Jar.class), new GradleCollectionVisitor<Jar>(){

            @Override
            public void visit(Jar element) {
                File archiveFile = GradleTaskUtil.getTaskArchiveFile((AbstractArchiveTask)element);
                if (archiveFile != null) {
                    taskArtifacts.add(archiveFile);
                }
            }

            @Override
            public void onFailure(Jar element, @NotNull Exception exception) {
                if (exception == null) {
                    1.$$$reportNull$$$0(0);
                }
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.projectArtifact.group").withTitle("Jar task configuration error").withText("Cannot resolve artifact file for the project Jar task: " + element.getPath()).withKind(Message.Kind.WARNING).withException(exception).reportMessage(project);
            }

            @Override
            public void visitAfterAccept(Jar element) {
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.projectArtifact.skipped.group").withTitle("Jar task configuration error").withText("Artifact files collecting for project Jar task was finished. Resolution for Jar task " + element.getPath() + " will be skipped.").withKind(Message.Kind.INTERNAL).withStackTrace().reportMessage(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetModelBuilder$1", "onFailure"));
            }
        });
        return new ArrayList<File>(taskArtifacts);
    }

    @NotNull
    private static List<File> collectNonSourceSetArtifacts(final @NotNull Project project, final @NotNull ModelBuilderContext context) {
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(9);
        }
        if (context == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(10);
        }
        final ArrayList<File> additionalArtifacts = new ArrayList<File>();
        GradleCollectionVisitor.accept(project.getTasks().withType(Jar.class), new GradleCollectionVisitor<Jar>(){

            @Override
            public void visit(Jar element) {
                File archiveFile = GradleTaskUtil.getTaskArchiveFile((AbstractArchiveTask)element);
                if (archiveFile != null && (GradleSourceSetModelBuilder.isJarDescendant(element) || GradleSourceSetModelBuilder.containsPotentialClasspathElements((AbstractArchiveTask)element, project))) {
                    additionalArtifacts.add(archiveFile);
                }
            }

            @Override
            public void onFailure(Jar element, @NotNull Exception exception) {
                if (exception == null) {
                    2.$$$reportNull$$$0(0);
                }
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.nonSourceSetArtifact.group").withTitle("Jar task configuration error").withText("Cannot resolve artifact file for the project Jar task: " + element.getPath()).withKind(Message.Kind.WARNING).withException(exception).reportMessage(project);
            }

            @Override
            public void visitAfterAccept(Jar element) {
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.nonSourceSetArtifact.skipped.group").withTitle("Jar task configuration error").withText("Artifact files collecting for project Jar task was finished. Resolution for Jar task " + element.getPath() + " will be skipped.").withKind(Message.Kind.INTERNAL).withStackTrace().reportMessage(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetModelBuilder$2", "onFailure"));
            }
        });
        ArrayList<File> arrayList = additionalArtifacts;
        if (arrayList == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static Map<String, Set<File>> collectProjectConfigurationArtifacts(final @NotNull Project project, final @NotNull ModelBuilderContext context) {
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(12);
        }
        if (context == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(13);
        }
        final HashMap<String, Set<File>> configurationArtifacts = new HashMap<String, Set<File>>();
        GradleCollectionVisitor.accept(project.getConfigurations(), new GradleCollectionVisitor<Configuration>(){

            @Override
            public void visit(Configuration element) {
                PublishArtifactSet artifactSet = element.getArtifacts();
                FileCollection fileCollection = artifactSet.getFiles();
                Set files = fileCollection.getFiles();
                configurationArtifacts.put(element.getName(), new LinkedHashSet(files));
            }

            @Override
            public void onFailure(Configuration element, @NotNull Exception exception) {
                if (exception == null) {
                    3.$$$reportNull$$$0(0);
                }
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.projectConfigurationArtifact.group").withTitle("Project configuration error").withText("Cannot resolve artifact files for project configuration" + element).withKind(Message.Kind.WARNING).withException(exception).reportMessage(project);
            }

            @Override
            public void visitAfterAccept(Configuration element) {
                context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.projectConfigurationArtifact.skipped.group").withTitle("Project configuration error").withText("Artifact files collecting for project configuration was finished. Resolution for configuration " + element + " will be skipped.").withKind(Message.Kind.INTERNAL).withStackTrace().reportMessage(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetModelBuilder$3", "onFailure"));
            }
        });
        HashMap<String, Set<File>> hashMap = configurationArtifacts;
        if (hashMap == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    static void cleanupSharedSourceFolders(Map<String, ExternalSourceSet> map) {
        ExternalSourceSet mainSourceSet = map.get("main");
        GradleSourceSetModelBuilder.cleanupSharedSourceFolders(map, mainSourceSet, null);
        GradleSourceSetModelBuilder.cleanupSharedSourceFolders(map, map.get("test"), mainSourceSet);
    }

    static void cleanupSharedSourceFolders(Map<String, ExternalSourceSet> result, ExternalSourceSet sourceSet, ExternalSourceSet toIgnore) {
        if (sourceSet == null) {
            return;
        }
        for (Map.Entry<String, ExternalSourceSet> sourceSetEntry : result.entrySet()) {
            if (sourceSetEntry.getValue() == sourceSet || sourceSetEntry.getValue() == toIgnore) continue;
            ExternalSourceSet customSourceSet = sourceSetEntry.getValue();
            for (ExternalSystemSourceType sourceType : ExternalSystemSourceType.values()) {
                ExternalSourceDirectorySet customSourceDirectorySet = (ExternalSourceDirectorySet)customSourceSet.getSources().get(sourceType);
                if (customSourceDirectorySet == null) continue;
                for (Map.Entry sourceDirEntry : sourceSet.getSources().entrySet()) {
                    customSourceDirectorySet.getSrcDirs().removeAll(((ExternalSourceDirectorySet)sourceDirEntry.getValue()).getSrcDirs());
                }
            }
        }
    }

    private static boolean isJarDescendant(Jar task) {
        Class<?> type = GradleTaskUtil.getTaskIdentityType((TaskInternal)task);
        return type != null && !type.equals(Jar.class);
    }

    private static boolean containsPotentialClasspathElements(@NotNull AbstractArchiveTask archiveTask, @NotNull Project project) {
        SourceSetContainer sourceSetContainer;
        if (archiveTask == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(15);
        }
        if (project == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(16);
        }
        if ((sourceSetContainer = JavaPluginUtil.getSourceSetContainer(project)) == null || sourceSetContainer.isEmpty()) {
            return true;
        }
        HashSet outputFiles = new HashSet();
        sourceSetContainer.all(ss -> outputFiles.addAll(ss.getOutput().getFiles()));
        for (Object path : GradleSourceSetModelBuilder.getArchiveTaskSourcePaths(archiveTask)) {
            if (GradleSourceSetModelBuilder.isSafeToResolve(path, project) || GradleSourceSetModelBuilder.isResolvableFileCollection(path, project)) {
                for (File f : project.files(new Object[]{path}).getFiles()) {
                    if (outputFiles.contains(f) || !f.isDirectory() && (!f.isFile() || !f.getName().endsWith(".class"))) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    static boolean containsAllSourceSetOutput(@NotNull AbstractArchiveTask archiveTask, @NotNull SourceSet sourceSet) {
        if (archiveTask == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(17);
        }
        if (sourceSet == null) {
            GradleSourceSetModelBuilder.$$$reportNull$$$0(18);
        }
        HashSet outputFiles = new HashSet(sourceSet.getOutput().getFiles());
        Project project = archiveTask.getProject();
        try {
            Set<Object> sourcePaths = GradleSourceSetModelBuilder.getArchiveTaskSourcePaths(archiveTask);
            for (Object path : sourcePaths) {
                if (!GradleSourceSetModelBuilder.isSafeToResolve(path, project) && !GradleSourceSetModelBuilder.isResolvableFileCollection(path, project)) continue;
                outputFiles.removeAll(project.files(new Object[]{path}).getFiles());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return outputFiles.isEmpty();
    }

    private static Set<Object> getArchiveTaskSourcePaths(AbstractArchiveTask archiveTask) {
        try {
            Method mainSpecGetter = AbstractCopyTask.class.getDeclaredMethod("getMainSpec", new Class[0]);
            mainSpecGetter.setAccessible(true);
            Object mainSpec = mainSpecGetter.invoke((Object)archiveTask, new Object[0]);
            Method getSourcePaths = mainSpec.getClass().getMethod("getSourcePaths", new Class[0]);
            Set sourcePaths = (Set)getSourcePaths.invoke(mainSpec, new Object[0]);
            if (sourcePaths != null) {
                return sourcePaths;
            }
            return Collections.emptySet();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            return Collections.emptySet();
        }
    }

    private static boolean isResolvableFileCollection(Object param, Project project) {
        Object object = GradleSourceSetModelBuilder.tryUnpackPresentProvider(param, project);
        if (object instanceof FileCollection) {
            try {
                project.files(new Object[]{object}).getFiles();
                return true;
            }
            catch (Throwable ignored) {
                return false;
            }
        }
        return false;
    }

    private static boolean isSafeToResolve(Object param, Project project) {
        Object object = GradleSourceSetModelBuilder.tryUnpackPresentProvider(param, project);
        boolean isDirectoryOrRegularFile = GradleReflectionUtil.dynamicCheckInstanceOf((Object)object, (String[])new String[]{"org.gradle.api.file.Directory", "org.gradle.api.file.RegularFile"});
        return object instanceof CharSequence || object instanceof File || object instanceof Path || isDirectoryOrRegularFile || object instanceof SourceSetOutput;
    }

    private static Object tryUnpackPresentProvider(Object object, Project project) {
        if (!GradleReflectionUtil.dynamicCheckInstanceOf((Object)object, (String[])new String[]{"org.gradle.api.provider.Provider"})) {
            return object;
        }
        try {
            Class<?> providerClass = object.getClass();
            Method isPresentMethod = providerClass.getMethod("isPresent", new Class[0]);
            Method getterMethod = providerClass.getMethod("get", new Class[0]);
            if (((Boolean)isPresentMethod.invoke(object, new Object[0])).booleanValue()) {
                return getterMethod.invoke(object, new Object[0]);
            }
            return object;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            boolean isCodeException = GradleReflectionUtil.dynamicCheckInstanceOf((Object)cause, (String[])new String[]{"org.gradle.api.InvalidUserCodeException"});
            boolean isDataException = GradleReflectionUtil.dynamicCheckInstanceOf((Object)cause, (String[])new String[]{"org.gradle.api.InvalidUserDataException"});
            if (isCodeException || isDataException) {
                return object;
            }
            String msg = cause.getMessage();
            String className = cause.getClass().getCanonicalName();
            project.getLogger().info("Unable to resolve task source path: {} ({})", (Object)msg, (Object)className);
            return object;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetModelBuilder";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveTask";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetModelBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNonSourceSetArtifacts";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProjectConfigurationArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAll";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportErrorMessage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectProjectTaskArtifacts";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectNonSourceSetArtifacts";
                break;
            }
            case 11: 
            case 14: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectProjectConfigurationArtifacts";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "containsPotentialClasspathElements";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "containsAllSourceSetOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

