/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.taskModel;

import com.intellij.gradle.toolingExtension.impl.model.taskModel.GradleTaskCache;
import com.intellij.gradle.toolingExtension.impl.model.taskModel.GradleTaskModel;
import com.intellij.gradle.toolingExtension.impl.util.GradleResultUtil;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.DefaultTaskContainer;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

@ApiStatus.Internal
public class GradleTaskModelBuilder
extends AbstractModelBuilderService {
    private static final boolean TASKS_REFRESH_REQUIRED = GradleVersionUtil.isCurrentGradleOlderThan((String)"5.0");

    public boolean canBuild(String modelName) {
        return GradleTaskModel.class.getName().equals(modelName);
    }

    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        if (modelName == null) {
            GradleTaskModelBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleTaskModelBuilder.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GradleTaskModelBuilder.$$$reportNull$$$0(2);
        }
        GradleTaskCache taskCache = GradleTaskCache.getInstance(context);
        Set<Task> projectTasks = GradleTaskModelBuilder.collectProjectTasks(project, context);
        taskCache.setProjectTasks(project, projectTasks);
        return new GradleTaskModel(){};
    }

    private static Set<Task> collectProjectTasks(@NotNull Project project, @NotNull ModelBuilderContext context) {
        if (project == null) {
            GradleTaskModelBuilder.$$$reportNull$$$0(3);
        }
        if (context == null) {
            GradleTaskModelBuilder.$$$reportNull$$$0(4);
        }
        try {
            GradleResultUtil.runOrRetryOnce(() -> {
                if (TASKS_REFRESH_REQUIRED) {
                    GradleTaskModelBuilder.refreshProjectTasks(project);
                }
            });
            return GradleResultUtil.runOrRetryOnce(() -> new TreeSet(project.getTasks()));
        }
        catch (Exception exception) {
            context.getMessageReporter().createMessage().withGroup("gradle.taskModel.collecting.group").withTitle("Tasks collecting failure").withText("Tasks for " + project + " cannot be collected due to plugin exception.").withException(exception).withKind(Message.Kind.WARNING).reportMessage(project);
            return Collections.emptySet();
        }
    }

    private static void refreshProjectTasks(@NotNull Project project) {
        TaskContainer tasks;
        if (project == null) {
            GradleTaskModelBuilder.$$$reportNull$$$0(5);
        }
        if ((tasks = project.getTasks()) instanceof DefaultTaskContainer) {
            ((DefaultTaskContainer)tasks).discoverTasks();
            SortedSet taskNames = tasks.getNames();
            for (String taskName : taskNames) {
                tasks.findByName(taskName);
            }
        }
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        if (modelName == null) {
            GradleTaskModelBuilder.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GradleTaskModelBuilder.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GradleTaskModelBuilder.$$$reportNull$$$0(8);
        }
        if (exception == null) {
            GradleTaskModelBuilder.$$$reportNull$$$0(9);
        }
        GradleTaskCache.getInstance(context).markTaskModelAsError(project);
        context.getMessageReporter().createMessage().withGroup("gradle.taskModel.group").withKind(Message.Kind.WARNING).withTitle("Task model building failure").withText("Unable to warm-up Gradle task model").withException(exception).reportMessage(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/taskModel/GradleTaskModelBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildAll";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProjectTasks";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshProjectTasks";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "reportErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

